/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.maintools.bugreport;

import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.FileChooserWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.maintools.bugreport.BaseBugReportPanel;
import com.gridnine.xtrip.common.meta.ui.UiCardsContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CurrencyRate;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.PassengerTypeCategory;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.DiscountProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductDescription;
import com.gridnine.xtrip.common.model.dict.CommissionCategory;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ModelContract;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.support.ContractBugReport;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import javafx.scene.Node;
import javafx.stage.FileChooser;
import org.apache.commons.io.FilenameUtils;

public class BugReportContractPanel
extends BaseBugReportPanel<ContractBugReport> {
    private static final Set<String> OBJECT_IDS = new HashSet<String>(Arrays.asList(SalesPoint.class.getName(), Person.class.getName(), Contract.class.getName(), BlankType.class.getName(), CommissionProperties.class.getName(), FeeProperties.class.getName(), DiscountProperties.class.getName(), CommissionCategory.class.getName(), CurrencyRate.class.getName(), Organization.class.getName(), UniversalProductDescription.class.getName(), PassengerType.class.getName(), PassengerTypeCategory.class.getName(), ModelContract.class.getName()));
    private EntityBoxWidget<BookingFile> bookingFileField;
    private FileChooserWidget tchFileField;

    public BugReportContractPanel(BaseBugReportPanel.BugReportPanelMode mode) {
        super(mode);
        this.createWidgets();
        this.createCards();
    }

    private void createCards() {
        Card \u0441ard = new Card("mainParameters", UiCardsContainer.Style.STATIC, Messages.General_parameters, (Node)this.buildMainParametersContainer());
        this.cards.add(\u0441ard);
        \u0441ard = new Card("additionalParameters", UiCardsContainer.Style.EXPANDED, Messages.Extra_options, (Node)this.buildContractParametersContainer());
        this.cards.add(\u0441ard);
        \u0441ard = new Card("exportedData", UiCardsContainer.Style.COLLAPSED, Messages.Uploading_data, (Node)this.buildTreeParametersContainer());
        this.cards.add(\u0441ard);
        this.getCards().addAll((Collection)this.cards);
    }

    private void createWidgets() {
        this.bookingFileField = new EntityBoxWidget(BookingFile.class, false);
        this.tchFileField = new FileChooserWidget(false);
        this.tchFileField.setMode(this.mode == BaseBugReportPanel.BugReportPanelMode.EDITOR ? FileChooserWidget.ChoosingMode.SAVE_IMMEDIATELY : FileChooserWidget.ChoosingMode.OPEN_SINGLE);
        this.tchFileField.setExtensionFiltersSupplier(() -> Collections.singletonList(new FileChooser.ExtensionFilter(Messages.Files_TKP, new String[]{"*.zip"})));
    }

    private GridContainer buildContractParametersContainer() {
        GridContainer container = new GridContainer(8);
        ArrayList<GridCell> cells = new ArrayList<GridCell>();
        GridCell cell = new GridCell(Messages.Order, this.bookingFileField);
        cell.setColSpan(4);
        cells.add(cell);
        cell = new GridCell(Messages.File_TKP, (Node)this.tchFileField);
        cell.setColSpan(4);
        cells.add(cell);
        container.getCells().addAll(cells);
        return container;
    }

    @Override
    protected Predicate<String> getObjectFilter() {
        return OBJECT_IDS::contains;
    }

    public EntityReference<BookingFile> getBookingFile() {
        return this.bookingFileField != null ? this.bookingFileField.getValue() : null;
    }

    public File getTchFile() {
        return this.tchFileField != null && this.tchFileField.getFiles().size() > 0 ? (File)this.tchFileField.getFiles().get(0) : null;
    }

    @Override
    public void readData(ContractBugReport model) {
        super.readData(model);
        this.bookingFileField.setValue(model.getBooking());
        if (model.getTchXmlNotification() != null) {
            this.tchFileField.setFieldName(FilenameUtils.getName((String)model.getTchXmlNotification().getFileName()));
            this.tchFileField.setContent(model.getTchXmlNotification().getContent());
            File file = new File(FilenameUtils.getName((String)model.getTchXmlNotification().getFileName()));
            this.tchFileField.getFiles().clear();
            this.tchFileField.getFiles().add((Object)file);
        }
    }

    @Override
    public void setReadonly(boolean readonly) {
        super.setReadonly(readonly);
        this.bookingFileField.getViewState().setReadonly(readonly);
        this.tchFileField.getViewState().setReadonly(false);
    }

    @Override
    public void setNotEditable(boolean notEditable) {
        super.setNotEditable(notEditable);
        this.bookingFileField.getViewState().setNotEditable(notEditable);
        this.tchFileField.getViewState().setNotEditable(notEditable);
    }

    @Override
    public void setAclNotEditable(boolean aclNotEditable) {
        super.setAclNotEditable(aclNotEditable);
        this.bookingFileField.getViewState().setAclNotEditable(aclNotEditable);
        this.tchFileField.getViewState().setAclNotEditable(aclNotEditable);
    }
}

