/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.maintools.bugreport;

import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.CheckBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.CustomWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.DateValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.model.custom.restrictions.RestrictionsData;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.maintools.bugreport.BaseBugReportPanel;
import com.gridnine.xtrip.client.fx.standard.restriction.BasicRestrictionsWidget;
import com.gridnine.xtrip.common.meta.ui.UiCardsContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.CurrencyRate;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.PassengerTypeCategory;
import com.gridnine.xtrip.common.model.booking.ProductIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.DiscountProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductDescription;
import com.gridnine.xtrip.common.model.dict.CommissionCategory;
import com.gridnine.xtrip.common.model.helpers.SearchQueryHelper;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ModelContract;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.support.reports.SalesReportBugReport;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.restriction.RestrictionGroup;
import com.gridnine.xtrip.common.restriction.util.RestrictionsUtil;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import javafx.scene.Node;

public class BugReportSalesReportPanel
extends BaseBugReportPanel<SalesReportBugReport> {
    private static final Set<String> OBJECT_IDS = new HashSet<String>(Arrays.asList(SalesPoint.class.getName(), Person.class.getName(), Contract.class.getName(), BlankType.class.getName(), CommissionProperties.class.getName(), FeeProperties.class.getName(), DiscountProperties.class.getName(), CommissionCategory.class.getName(), CurrencyRate.class.getName(), UniversalProductDescription.class.getName(), Organization.class.getName(), PassengerType.class.getName(), PassengerTypeCategory.class.getName(), ModelContract.class.getName()));
    private DateValueWidget startDateField;
    private DateValueWidget endDateField;
    private EntityBoxWidget<Organization> reportSupplierField;
    private EntityBoxWidget<Organization> reportAgencyField;
    private EntityBoxWidget<Organization> reportBlankOwnerField;
    private EntityBoxWidget<SalesPoint> reportSalesPointField;
    private EntityBoxWidget<Organization> reportSubagencyField;
    private CheckBoxWidget reportExcludeVoidedField;
    private CustomWidget<RestrictionsData> additionalRestrictionsField;

    public BugReportSalesReportPanel(BaseBugReportPanel.BugReportPanelMode mode) {
        super(mode);
        this.createWidgets();
        this.createCards();
    }

    private void createCards() {
        Card card = new Card("mainParameters", UiCardsContainer.Style.STATIC, Messages.General_parameters, (Node)this.buildMainParametersContainer());
        this.cards.add(card);
        card = new Card("reportParameters", UiCardsContainer.Style.EXPANDED, Messages.Report_Parameters, (Node)this.buildReportParametersContainer());
        this.cards.add(card);
        card = new Card("additionalParameters", UiCardsContainer.Style.COLLAPSED, Messages.Additional_Report_Parameters, this.additionalRestrictionsField);
        this.cards.add(card);
        card = new Card("exportedData", UiCardsContainer.Style.COLLAPSED, Messages.Uploading_data, (Node)this.buildTreeParametersContainer());
        this.cards.add(card);
        this.getCards().addAll((Collection)this.cards);
    }

    private void createWidgets() {
        this.startDateField = new DateValueWidget(false);
        this.endDateField = new DateValueWidget(false);
        this.reportAgencyField = new EntityBoxWidget(Organization.class, false);
        this.reportAgencyField.setListParametersSupplier(ControllerInterceptorsHelper::getAgencies);
        this.reportSubagencyField = new EntityBoxWidget(Organization.class, false);
        this.reportSubagencyField.setListParametersSupplier(ControllerInterceptorsHelper::getAgencies);
        this.reportSupplierField = new EntityBoxWidget(Organization.class, false);
        this.reportSupplierField.setListParametersSupplier(ControllerInterceptorsHelper::getSuppliers);
        this.reportBlankOwnerField = new EntityBoxWidget(Organization.class, false);
        this.reportBlankOwnerField.setListParametersSupplier(ControllerInterceptorsHelper::getBlankOwners);
        this.reportSalesPointField = new EntityBoxWidget(SalesPoint.class, false);
        this.reportSalesPointField.setListParametersSupplier(ControllerInterceptorsHelper::getSalesPoints);
        this.reportExcludeVoidedField = new CheckBoxWidget(false);
        this.additionalRestrictionsField = new BasicRestrictionsWidget(false);
        ((BasicRestrictionsWidget)this.additionalRestrictionsField).setRestrictionId(ProductIndex.class.getName());
    }

    private GridContainer buildReportParametersContainer() {
        GridContainer container = new GridContainer(8);
        ArrayList<GridCell> cells = new ArrayList<GridCell>();
        GridCell cell = new GridCell(Messages.Start_date2, (Node)this.startDateField);
        cell.setColSpan(4);
        cells.add(cell);
        cell = new GridCell(Messages.Finish_date2, (Node)this.endDateField);
        cell.setColSpan(4);
        cells.add(cell);
        cell = new GridCell(Messages.Supplier, this.reportSupplierField);
        cell.setColSpan(4);
        cells.add(cell);
        cell = new GridCell(Messages.Agency, this.reportAgencyField);
        cell.setColSpan(4);
        cells.add(cell);
        cell = new GridCell(Messages.Dimension_sales_point, this.reportSalesPointField);
        cell.setColSpan(4);
        cells.add(cell);
        cell = new GridCell(Messages.SubAgency, this.reportSubagencyField);
        cell.setColSpan(4);
        cells.add(cell);
        cell = new GridCell(Messages.Letterhead_owner, this.reportBlankOwnerField);
        cell.setColSpan(4);
        cells.add(cell);
        cell = new GridCell(Messages.Exclude_EB, (Node)this.reportExcludeVoidedField);
        cell.setColSpan(4);
        cells.add(cell);
        container.getCells().addAll(cells);
        return container;
    }

    @Override
    protected Predicate<String> getObjectFilter() {
        return OBJECT_IDS::contains;
    }

    public EntityReference<Organization> getReportAgency() {
        return this.reportAgencyField != null ? this.reportAgencyField.getValue() : null;
    }

    public EntityReference<Organization> getReportSubagency() {
        return this.reportSubagencyField != null ? this.reportSubagencyField.getValue() : null;
    }

    public EntityReference<Organization> getReportSupplier() {
        return this.reportSupplierField != null ? this.reportSupplierField.getValue() : null;
    }

    public EntityReference<Organization> getReportBlankOwner() {
        return this.reportBlankOwnerField != null ? this.reportBlankOwnerField.getValue() : null;
    }

    public EntityReference<SalesPoint> getReportSalesPoint() {
        return this.reportSalesPointField != null ? this.reportSalesPointField.getValue() : null;
    }

    public boolean isReportExcludeVoided() {
        return this.reportExcludeVoidedField != null && this.reportExcludeVoidedField.selectedProperty().get();
    }

    public Date getStartDate() {
        return this.startDateField != null ? MiscUtil.clearTime((Date)DateUtils.asDate((LocalDate)this.startDateField.getValue())) : null;
    }

    public Date getEndDate() {
        return this.endDateField != null ? MiscUtil.setDayEndTime((Date)DateUtils.asDate((LocalDate)this.endDateField.getValue())) : null;
    }

    public Collection<RestrictionGroup> getAdditionalRestrictions() {
        RestrictionsData restrictionsData = new RestrictionsData();
        if (this.additionalRestrictionsField != null) {
            this.additionalRestrictionsField.writeData((Object)restrictionsData);
        }
        return restrictionsData.getRestrictions();
    }

    public ReportParameters getReportParametrers() {
        ReportParameters reportParameters = new ReportParameters();
        reportParameters.setAgency(this.getReportAgency());
        reportParameters.setPeriodBegin(this.getStartDate());
        reportParameters.setPeriodEnd(this.getEndDate());
        reportParameters.setSalesPoint(this.getReportSalesPoint());
        reportParameters.setSubagency(this.getReportSubagency());
        reportParameters.setSupplier(this.getReportSupplier());
        reportParameters.setBlankOwner(this.getReportBlankOwner());
        reportParameters.getAdditionalCriterions().addAll(RestrictionsUtil.toQueryFromRestrictionGroups(this.getAdditionalRestrictions(), ProductIndex.class, Collections.emptyList()));
        if (this.isReportExcludeVoided()) {
            reportParameters.getAdditionalCriterions().add(SearchCriterion.ne((String)ProductIndex.Property.status.name(), (Object)ProductStatus.VOID.name()));
        }
        return reportParameters;
    }

    @Override
    public void readData(SalesReportBugReport model) {
        super.readData(model);
        if (model.getReportParameters() != null) {
            this.startDateField.setValue(DateUtils.asLocalDate((Date)model.getReportParameters().getPeriodBegin()));
            this.endDateField.setValue(DateUtils.asLocalDate((Date)model.getReportParameters().getPeriodEnd()));
            this.reportSupplierField.setValue(model.getReportParameters().getSupplier());
            this.reportBlankOwnerField.setValue(model.getReportParameters().getBlankOwner());
            this.reportAgencyField.setValue(model.getReportParameters().getAgency());
            this.reportSubagencyField.setValue(model.getReportParameters().getSubagency());
            this.reportSalesPointField.setValue(model.getReportParameters().getSalesPoint());
            this.reportExcludeVoidedField.setSelected(SearchQueryHelper.isExcludeVoidETickets((Set)model.getReportParameters().getAdditionalCriterions()));
        }
    }

    @Override
    public void setReadonly(boolean readonly) {
        super.setReadonly(readonly);
        this.startDateField.getViewState().setReadonly(readonly);
        this.endDateField.getViewState().setReadonly(readonly);
        this.reportSupplierField.getViewState().setReadonly(readonly);
        this.reportBlankOwnerField.getViewState().setReadonly(readonly);
        this.reportAgencyField.getViewState().setReadonly(readonly);
        this.reportSubagencyField.getViewState().setReadonly(readonly);
        this.reportSalesPointField.getViewState().setReadonly(readonly);
        this.reportExcludeVoidedField.getViewState().setReadonly(readonly);
        this.additionalRestrictionsField.getViewState().setReadonly(readonly);
    }

    @Override
    public void setNotEditable(boolean notEditable) {
        super.setNotEditable(notEditable);
        this.startDateField.getViewState().setNotEditable(notEditable);
        this.endDateField.getViewState().setNotEditable(notEditable);
        this.reportSupplierField.getViewState().setNotEditable(notEditable);
        this.reportBlankOwnerField.getViewState().setNotEditable(notEditable);
        this.reportAgencyField.getViewState().setNotEditable(notEditable);
        this.reportSubagencyField.getViewState().setNotEditable(notEditable);
        this.reportSalesPointField.getViewState().setNotEditable(notEditable);
        this.reportExcludeVoidedField.getViewState().setNotEditable(notEditable);
        this.additionalRestrictionsField.getViewState().setNotEditable(notEditable);
    }

    @Override
    public void setAclNotEditable(boolean aclNotEditable) {
        super.setAclNotEditable(aclNotEditable);
        this.startDateField.getViewState().setAclNotEditable(aclNotEditable);
        this.endDateField.getViewState().setAclNotEditable(aclNotEditable);
        this.reportSupplierField.getViewState().setAclNotEditable(aclNotEditable);
        this.reportBlankOwnerField.getViewState().setAclNotEditable(aclNotEditable);
        this.reportAgencyField.getViewState().setAclNotEditable(aclNotEditable);
        this.reportSubagencyField.getViewState().setAclNotEditable(aclNotEditable);
        this.reportSalesPointField.getViewState().setAclNotEditable(aclNotEditable);
        this.reportExcludeVoidedField.getViewState().setAclNotEditable(aclNotEditable);
        this.additionalRestrictionsField.getViewState().setAclNotEditable(aclNotEditable);
    }
}

