/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.maintools.importtool;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.CardsContainer;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.FileChooserWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.RadioBoxWidget;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.maintools.importtool.ImportConflictAction;
import com.gridnine.xtrip.client.fx.standard.maintools.importtool.ImportExchangeFilesParametes;
import com.gridnine.xtrip.client.fx.standard.maintools.importtool.ImportTask;
import com.gridnine.xtrip.common.meta.ui.UiCardsContainer;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javafx.scene.Node;
import javafx.stage.FileChooser;

public class ImportDialog {
    public static void showDialog() {
        FileChooserWidget fileChooserWidget = new FileChooserWidget(false);
        fileChooserWidget.setMode(FileChooserWidget.ChoosingMode.OPEN_MULTIPLE);
        fileChooserWidget.setExtensionFiltersSupplier(() -> Collections.singletonList(new FileChooser.ExtensionFilter(Messages.Export_files_MOM, new String[]{"*.xml", "*.zip"})));
        RadioBoxWidget<ImportConflictAction> entityAndDictConflRadioBox = ImportDialog.createEntityAndDictRadioBox(true);
        RadioBoxWidget<ImportConflictAction> assetsConflRadioBox = ImportDialog.createAssetRadioBox(true);
        RadioBoxWidget<ImportConflictAction> currentDictElemRadioBox = ImportDialog.createCurrentDictRadioBox(true);
        GridContainer gridContainer = new GridContainer();
        gridContainer.getCells().addAll((Object[])new GridCell[]{new GridCell(Messages.Conflicts_of_entities_and_directories, entityAndDictConflRadioBox), new GridCell(Messages.Conflicts_of_Assets, assetsConflRadioBox), new GridCell(Messages.Current_elements_of_directories_before_import, currentDictElemRadioBox)});
        CardsContainer cardsContainer = new CardsContainer();
        cardsContainer.getCards().add((Object)new Card("files", UiCardsContainer.Style.STATIC, Messages.Dialog_Files, (Node)GridContainer.wrap((Node)fileChooserWidget)));
        cardsContainer.getCards().add((Object)new Card("parameters", UiCardsContainer.Style.COLLAPSED, Messages.Actions_for_import_conflicts, (Node)gridContainer));
        Dialog dialog = new Dialog();
        dialog.setTitle(Messages.Import_parameters).setAutoClose(false).setBody((Node)cardsContainer).addButton(DialogButtonStyle.DECLINE, () -> ((Dialog)dialog).close()).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Import, () -> {
            ArrayList<File> importFiles = new ArrayList<File>((Collection<File>)fileChooserWidget.getFiles());
            if (importFiles.size() == 0) {
                Dialog.info((String)Messages.Must_specify_a_file_to_import);
            } else if (!(((ImportConflictAction)((Object)((Object)entityAndDictConflRadioBox.valueProperty().get()))).equals((Object)ImportConflictAction.ASK) && ((ImportConflictAction)((Object)((Object)assetsConflRadioBox.valueProperty().get()))).equals((Object)ImportConflictAction.ASK) && ((ImportConflictAction)((Object)((Object)currentDictElemRadioBox.valueProperty().get()))).equals((Object)ImportConflictAction.ASK))) {
                StringBuilder stringBuilder = new StringBuilder();
                if (((ImportConflictAction)((Object)((Object)currentDictElemRadioBox.valueProperty().get()))).equals((Object)ImportConflictAction.DELETE)) {
                    stringBuilder.append(Messages.All_directories_will_be_deleted);
                }
                if (((ImportConflictAction)((Object)((Object)assetsConflRadioBox.valueProperty().get()))).equals((Object)ImportConflictAction.CHANGE_ALL)) {
                    stringBuilder.append(Messages.All_Assets_will_be_changed);
                }
                if (((ImportConflictAction)((Object)((Object)entityAndDictConflRadioBox.valueProperty().get()))).equals((Object)ImportConflictAction.CHANGE_ALL)) {
                    stringBuilder.append(Messages.All_conflicting_entities_and_directories_will_be_changed);
                } else if (((ImportConflictAction)((Object)((Object)entityAndDictConflRadioBox.valueProperty().get()))).equals((Object)ImportConflictAction.CHANGE_OLD)) {
                    stringBuilder.append(Messages.All_obsolete_conflicting_entities_and_directories_will_be_changed);
                }
                stringBuilder.append(Messages.Continue);
                Dialog.confirm((String)stringBuilder.toString(), () -> Notifications.get().enqueueAsyncTask((ClientTask)new ImportTask(new ImportExchangeFilesParametes(importFiles, (ImportConflictAction)((Object)((Object)((Object)entityAndDictConflRadioBox.valueProperty().get()))), (ImportConflictAction)((Object)((Object)((Object)assetsConflRadioBox.valueProperty().get()))), (ImportConflictAction)((Object)((Object)((Object)currentDictElemRadioBox.valueProperty().get())))))));
                dialog.close();
            } else {
                Notifications.get().enqueueAsyncTask((ClientTask)new ImportTask(new ImportExchangeFilesParametes(importFiles, (ImportConflictAction)((Object)((Object)entityAndDictConflRadioBox.valueProperty().get())), (ImportConflictAction)((Object)((Object)assetsConflRadioBox.valueProperty().get())), (ImportConflictAction)((Object)((Object)currentDictElemRadioBox.valueProperty().get())))));
                dialog.close();
            }
        }).setOnCloseRequest(() -> ((Dialog)dialog).close()).showGlobal();
    }

    static RadioBoxWidget<ImportConflictAction> createCurrentDictRadioBox(boolean withAsk) {
        RadioBoxWidget currentDictElemRadioBox = new RadioBoxWidget(false);
        if (withAsk) {
            currentDictElemRadioBox.setItemsSupplier(() -> {
                ArrayList<ImportConflictAction> result = new ArrayList<ImportConflictAction>();
                result.add(ImportConflictAction.ASK);
                result.add(ImportConflictAction.DELETE);
                result.add(ImportConflictAction.DO_NOT_DELETE);
                return result;
            });
            currentDictElemRadioBox.valueProperty().set((Object)ImportConflictAction.ASK);
            return currentDictElemRadioBox;
        }
        currentDictElemRadioBox.setItemsSupplier(() -> {
            ArrayList<ImportConflictAction> result = new ArrayList<ImportConflictAction>();
            result.add(ImportConflictAction.DELETE);
            result.add(ImportConflictAction.DO_NOT_DELETE);
            return result;
        });
        currentDictElemRadioBox.valueProperty().set((Object)ImportConflictAction.DO_NOT_DELETE);
        return currentDictElemRadioBox;
    }

    static RadioBoxWidget<ImportConflictAction> createAssetRadioBox(boolean withAsk) {
        if (withAsk) {
            RadioBoxWidget assetsConflRadioBox = new RadioBoxWidget(false);
            assetsConflRadioBox.setItemsSupplier(() -> {
                ArrayList<ImportConflictAction> result = new ArrayList<ImportConflictAction>();
                result.add(ImportConflictAction.ASK);
                result.add(ImportConflictAction.CHANGE_ALL);
                result.add(ImportConflictAction.SKIP_ALL);
                return result;
            });
            assetsConflRadioBox.valueProperty().set((Object)ImportConflictAction.ASK);
            return assetsConflRadioBox;
        }
        RadioBoxWidget assetsConflRadioBox = new RadioBoxWidget(false);
        assetsConflRadioBox.setItemsSupplier(() -> {
            ArrayList<ImportConflictAction> result = new ArrayList<ImportConflictAction>();
            result.add(ImportConflictAction.CHANGE);
            result.add(ImportConflictAction.CHANGE_ALL);
            result.add(ImportConflictAction.SKIP);
            result.add(ImportConflictAction.SKIP_ALL);
            result.add(ImportConflictAction.CANCEL);
            return result;
        });
        assetsConflRadioBox.valueProperty().set((Object)ImportConflictAction.SKIP);
        return assetsConflRadioBox;
    }

    static RadioBoxWidget<ImportConflictAction> createEntityAndDictRadioBox(boolean withAsk) {
        if (withAsk) {
            RadioBoxWidget entityAndDictConflRadioBox = new RadioBoxWidget(false);
            entityAndDictConflRadioBox.setItemsSupplier(() -> {
                ArrayList<ImportConflictAction> result = new ArrayList<ImportConflictAction>();
                result.add(ImportConflictAction.ASK);
                result.add(ImportConflictAction.CHANGE_ALL);
                result.add(ImportConflictAction.CHANGE_OLD);
                result.add(ImportConflictAction.SKIP_ALL);
                return result;
            });
            entityAndDictConflRadioBox.valueProperty().set((Object)ImportConflictAction.ASK);
            return entityAndDictConflRadioBox;
        }
        RadioBoxWidget entityAndDictConflRadioBox = new RadioBoxWidget(false);
        entityAndDictConflRadioBox.setItemsSupplier(() -> {
            ArrayList<ImportConflictAction> result = new ArrayList<ImportConflictAction>();
            result.add(ImportConflictAction.CHANGE);
            result.add(ImportConflictAction.CHANGE_ALL);
            result.add(ImportConflictAction.CHANGE_OLD);
            result.add(ImportConflictAction.SKIP);
            result.add(ImportConflictAction.SKIP_ALL);
            result.add(ImportConflictAction.CANCEL);
            return result;
        });
        entityAndDictConflRadioBox.valueProperty().set((Object)ImportConflictAction.SKIP);
        return entityAndDictConflRadioBox;
    }
}

