/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.maintools.importtool;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.lib.widgets.RadioBoxWidget;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.maintools.importtool.ImportConflictAction;
import com.gridnine.xtrip.client.fx.standard.maintools.importtool.ImportDialog;
import com.gridnine.xtrip.client.fx.standard.maintools.importtool.ImportExchangeFilesParametes;
import com.gridnine.xtrip.common.acl.AclAsset;
import com.gridnine.xtrip.common.fx.rpc.DictQuery;
import com.gridnine.xtrip.common.fx.rpc.DictService;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.fx.rpc.service.AssetService;
import com.gridnine.xtrip.common.meta.DictionaryType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.assets.UserAccount;
import com.gridnine.xtrip.common.model.assets.Workspace;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.security.acl.entry.AclEntry;
import com.gridnine.xtrip.common.security.acl.principal.AclGroup;
import com.gridnine.xtrip.common.security.acl.principal.AclUser;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.ValueHolder;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Duration;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FilenameUtils;
import org.w3c.dom.Element;
import org.xml.sax.SAXParseException;

public class ImportTask
extends ClientTask {
    private float progress = 0.0f;
    private float step = 100.0f;
    private int importedElementCount = 0;
    private int elementCount = 0;
    private final CyclicBarrier barrier = new CyclicBarrier(2);
    private ImportConflictAction entityChoose;
    private ImportConflictAction dictChoose;
    private ImportConflictAction assetChoose;
    private final ImportConflictAction dictElemRadioBox;
    private final List<File> files = new ArrayList<File>();

    public ImportTask(ImportExchangeFilesParametes importParameters) {
        this.files.addAll(importParameters.getImportFiles());
        if (importParameters.getImportFiles().size() != 0) {
            this.step /= (float)importParameters.getImportFiles().size();
        }
        this.dictElemRadioBox = importParameters.getCurrentDictElemAction();
        this.entityChoose = importParameters.getEntityAndDictConflictAction();
        this.dictChoose = importParameters.getEntityAndDictConflictAction();
        this.assetChoose = importParameters.getAssetsConflisctAction();
    }

    protected String getTitle() {
        return Messages.Import_data;
    }

    protected void execute() throws Exception {
        LocalTime startTime = LocalTime.now(ZoneId.systemDefault());
        ValueHolder conflictAction = new ValueHolder((Object)this.dictElemRadioBox);
        HashMap<String, Boolean> deletedDicts = new HashMap<String, Boolean>();
        for (File file : this.files) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            try {
                this.importEntries(file, deletedDicts, (ValueHolder<ImportConflictAction>)conflictAction);
            }
            catch (Exception e) {
                throw Xeption.forDeveloper((String)"file {0} import error", (Object[])new Object[]{file});
            }
        }
        LocalTime endTime = LocalTime.now(ZoneId.systemDefault());
        Duration duration = Duration.between(startTime, endTime);
        this.addMessages(new Message[]{SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"Imported {0} from {1} objects during {2}.", (Object[])new Object[]{Integer.toString(this.importedElementCount), Integer.toString(this.elementCount), this.formatDuration(duration)})});
    }

    private String formatDuration(Duration duration) {
        long seconds = duration.getSeconds();
        long absSeconds = Math.abs(seconds);
        String positive = String.format("%d:%02d:%02d", absSeconds / 3600L, absSeconds % 3600L / 60L, absSeconds % 60L);
        return seconds < 0L ? "-" + positive : positive;
    }

    private void importEntries(File file, Map<String, Boolean> deletedDicts, ValueHolder<ImportConflictAction> conflictAction) throws Exception {
        if (FilenameUtils.getExtension((String)file.getAbsolutePath()).equals("xml")) {
            this.importXML(file, deletedDicts, conflictAction);
        } else {
            this.importZIP(file, deletedDicts, conflictAction);
        }
    }

    private void importXML(File file, Map<String, Boolean> deletedDicts, ValueHolder<ImportConflictAction> conflictAction) throws Exception {
        Element root;
        String message = Messages.Importing_the_file + file;
        try (BufferedInputStream strm = new BufferedInputStream(new FileInputStream(file));){
            root = DocumentBuilderHelper.parse((InputStream)strm).getDocumentElement();
        }
        Element[] elements = XmlUtil.getElements((Element)root, (String)"object");
        root.getOwnerDocument().setDocumentURI(file.toURI().toString());
        float subStep = this.step / (float)elements.length;
        int importedElements = 0;
        for (Element elm : elements) {
            this.checkDictionary(elm, deletedDicts, conflictAction);
            boolean imported = this.importEntry(elm, deletedDicts);
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            this.progress += subStep;
            if (imported) {
                ++importedElements;
                ++this.importedElementCount;
            }
            this.setProgress((byte)this.progress, message);
            ++this.elementCount;
        }
        if (elements.length == 0) {
            this.setProgress((byte)this.progress, Messages.File + file.getName() + Messages.Imported);
            this.addMessages(new Message[]{SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)(Messages.Task_File + file.getName() + " " + Messages.Not_Imported), (Object[])new Object[0])});
            return;
        }
        if (importedElements < elements.length) {
            this.setProgress((byte)this.progress, Messages.File + file.getName() + Messages.Imported);
            this.addMessages(new Message[]{SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)(Messages.Task_File + file.getName() + " " + Messages.Not_fully_imported), (Object[])new Object[]{importedElements, elements.length})});
            return;
        }
        this.setProgress((byte)this.progress, Messages.File + file.getName() + Messages.Imported);
        this.addMessages(new Message[]{SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)(Messages.Task_File + file.getName() + " " + Messages.Imported), (Object[])new Object[0])});
    }

    private void importZIP(File file, Map<String, Boolean> deletedDicts, ValueHolder<ImportConflictAction> conflictAction) throws Exception {
        int entryCount;
        String message = Messages.Importing_the_file + file;
        try (ZipFile zipFile = new ZipFile(file);){
            entryCount = zipFile.size();
        }
        try {
            var7_8 = null;
            try (ZipInputStream strm = new ZipInputStream(new FileInputStream(file));){
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                this.step /= (float)entryCount;
                while (strm.getNextEntry() != null) {
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    IoUtil.copyStream((InputStream)strm, (OutputStream)baos, (int)256);
                    byte[] arr = baos.toByteArray();
                    if (arr.length == 0) continue;
                    Element rootElm = DocumentBuilderHelper.parse((InputStream)new ByteArrayInputStream(arr)).getDocumentElement();
                    Element[] objects = XmlUtil.getElements((Element)rootElm, (String)"object");
                    float subStep = 1.0f;
                    if (objects.length > 0) {
                        subStep = this.step / (float)objects.length;
                    }
                    for (Element elm : objects) {
                        if (Thread.interrupted()) {
                            throw new InterruptedException();
                        }
                        this.checkDictionary(elm, deletedDicts, conflictAction);
                        boolean imported = this.importEntry(elm, deletedDicts);
                        this.progress += subStep;
                        if (imported) {
                            ++this.importedElementCount;
                        }
                        this.setProgress((byte)this.progress, message);
                        ++this.elementCount;
                    }
                }
                this.setProgress((byte)this.progress, Messages.Task_File + file.getName() + Messages.Imported);
                this.addMessages(new Message[]{SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)("File " + file.getName() + " imported."), (Object[])new Object[0])});
            }
            catch (Throwable throwable) {
                var7_8 = throwable;
                throw throwable;
            }
        }
        catch (BrokenBarrierException bbe) {
            this.assetChoose = ImportConflictAction.CANCEL;
            this.addMessages(new Message[]{MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)"Import critical error", (Throwable)bbe, (Object[])new Object[0])});
        }
        catch (SAXParseException parseException) {
            this.assetChoose = ImportConflictAction.CANCEL;
            String mess = parseException.getMessage();
            if (mess.equals("Content is not allowed in prolog.")) {
                mess = Messages.Content_is_not_allowed;
            }
            this.addMessages(new Message[]{SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)mess, (Object[])new Object[0])});
            this.addMessages(new Message[]{MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.getSAXParsingError(parseException.getLineNumber(), parseException.getColumnNumber(), parseException.getMessage()), (Throwable)parseException, (Object[])new Object[0])});
        }
    }

    private String getEntityId(Element elm) throws Exception {
        String clsName = elm.getAttribute("class");
        if (clsName == null) {
            return null;
        }
        if (EntityContainer.class.getName().equals(clsName)) {
            return XHelper.readString((Element)elm, (String)"entityType");
        }
        return clsName;
    }

    private void checkDictionary(Element elm, Map<String, Boolean> deletedDicts, ValueHolder<ImportConflictAction> conflictAction) throws Exception {
        String id = this.getEntityId(elm);
        if (id == null) {
            id = "";
        }
        DictionaryType type = (DictionaryType)MetaRegistry.get().getDictionaries().get(id);
        if (!deletedDicts.getOrDefault(id, Boolean.FALSE).booleanValue() && type != null) {
            Class cls = XSHelper.getClass((String)type.getId());
            DictQuery dictQuery = new DictQuery();
            dictQuery.setLimit(1);
            if (!((DictService)RpcServiceManager.get().getService(DictService.class)).search(ServiceInvocationContext.get(), cls, dictQuery).isEmpty()) {
                switch ((ImportConflictAction)((Object)conflictAction.getValue())) {
                    case DELETE: {
                        if (deletedDicts.getOrDefault(id, Boolean.FALSE).booleanValue()) break;
                        this.deleteDictionary(id);
                        deletedDicts.put(id, true);
                        this.barrier.await();
                        break;
                    }
                    case ASK: {
                        String id2 = id;
                        FxUtil.waitForFxThread(() -> {
                            RadioBoxWidget<ImportConflictAction> dictOptions = ImportDialog.createCurrentDictRadioBox(false);
                            new Dialog().setTitle(Messages.Matching_dictionaries).setBody(dictOptions).addButton(DialogButtonStyle.ACCEPT_REGULAR, () -> {
                                try {
                                    if (((ImportConflictAction)((Object)((Object)((Object)dictOptions.valueProperty().get())))).equals((Object)ImportConflictAction.DELETE)) {
                                        conflictAction.setValue((Object)ImportConflictAction.DELETE);
                                        if (!deletedDicts.getOrDefault(id2, Boolean.FALSE).booleanValue()) {
                                            this.deleteDictionary(id2);
                                            deletedDicts.put(id2, true);
                                        } else {
                                            this.barrier.await();
                                        }
                                    } else {
                                        conflictAction.setValue((Object)ImportConflictAction.DO_NOT_DELETE);
                                        this.barrier.await();
                                    }
                                }
                                catch (InterruptedException | BrokenBarrierException e) {
                                    this.assetChoose = ImportConflictAction.CANCEL;
                                    this.addMessages(new Message[]{MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)"Import critical error", (Throwable)e, (Object[])new Object[0])});
                                }
                            }).setOnCloseRequest(() -> {
                                this.assetChoose = ImportConflictAction.CANCEL;
                                try {
                                    this.barrier.await();
                                }
                                catch (Exception e) {
                                    ErrorHandler.handle((Throwable)e);
                                }
                            }).showGlobal();
                        });
                        this.barrier.await();
                        break;
                    }
                }
            }
        }
    }

    private void deleteDictionary(String id) {
        Notifications.get().submitTask(() -> {
            DictionaryType type = (DictionaryType)MetaRegistry.get().getDictionaries().get(id);
            Class cls = XSHelper.getClass((String)type.getId());
            DictService dictService = (DictService)RpcServiceManager.get().getService(DictService.class);
            ServiceInvocationContext sic = ServiceInvocationContext.get();
            try {
                dictService.deleteAll(sic, cls);
            }
            catch (Exception e) {
                this.addMessages(new Message[]{MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)"Unable to delete dictionary: {0}", (Throwable)e, (Object[])new Object[]{cls.getName()})});
            }
            try {
                this.barrier.await();
            }
            catch (InterruptedException | BrokenBarrierException e) {
                this.assetChoose = ImportConflictAction.CANCEL;
                this.addMessages(new Message[]{MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)"Import critical error", (Throwable)e, (Object[])new Object[0])});
            }
        }, Messages.Notifications_delete_data);
    }

    private boolean importEntry(Element elm, Map<String, Boolean> deletedDicts) throws Exception {
        String uid = XHelper.readString((Element)elm, (String)"uid");
        String clsName = elm.getAttribute("class");
        if (clsName == null) {
            this.addMessages(new Message[]{SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)("Unknown object: " + uid), (Object[])new Object[0])});
            return false;
        }
        Class cls = XSHelper.getClass((String)clsName);
        if (EntityContainer.class.equals((Object)cls)) {
            return this.importEntity(elm);
        }
        if (BaseDictionary.class.isAssignableFrom(cls)) {
            return this.importDictionary(elm, deletedDicts);
        }
        if (BaseAsset.class.isAssignableFrom(cls)) {
            return this.importAsset(elm);
        }
        this.addMessages(new Message[]{SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)("Unknown object: " + uid), (Object[])new Object[0])});
        return false;
    }

    private boolean importEntity(Element elm) throws Exception {
        AtomicBoolean importResult;
        block23: {
            importResult = new AtomicBoolean(false);
            String uid = null;
            try {
                EntityContainer etcOld;
                String typeClass = XHelper.readString((Element)elm, (String)"entityType");
                Class cls = XSHelper.getClass((String)typeClass);
                EntityContainer etc = (EntityContainer)EntityContainer.class.getConstructor(Class.class).newInstance(cls);
                Element revision = XmlUtil.getElement((Element)elm, (String)"revision");
                if (revision != null) {
                    elm.removeChild(revision);
                }
                if (TextUtil.isBlank((String)typeClass) || etc == null) {
                    return importResult.get();
                }
                etc.fromXML(elm);
                uid = etc.getUid();
                if (TextUtil.isBlank((String)etc.getUid())) {
                    etc.setUid(UUID.randomUUID().toString());
                }
                ServiceInvocationContext sic = ServiceInvocationContext.get();
                EntityService entityService = (EntityService)RpcServiceManager.get().getService(EntityService.class);
                if (TextUtil.isBlank((String)etc.getCreatedBy())) {
                    etc.setCreatedBy(sic.getUser());
                }
                if (TextUtil.isBlank((String)etc.getModifiedBy())) {
                    etc.setModifiedBy(sic.getUser());
                }
                if (TextUtil.isBlank((String)etc.getVersionInfo().getCreatedBy())) {
                    etc.getVersionInfo().setCreatedBy(sic.getUser());
                }
                if (TextUtil.isBlank((String)etc.getVersionInfo().getModifiedBy())) {
                    etc.getVersionInfo().setModifiedBy(sic.getUser());
                }
                if (etc.getCreated() == null) {
                    etc.setCreated(new Date());
                }
                if (etc.getModified() == null) {
                    etc.setModified(etc.getCreated());
                }
                if ((etcOld = entityService.load(sic, etc.toReference())) != null) {
                    switch (this.entityChoose) {
                        case ASK: {
                            this.askConflictEntityOptions(elm, (EntityContainer<? extends BaseEntity>)etcOld, (EntityContainer<? extends BaseEntity>)etc, importResult, sic, entityService);
                            this.barrier.await();
                            break block23;
                        }
                        case CHANGE: {
                            this.entityChoose = ImportConflictAction.ASK;
                            etc.getVersionInfo().setDataSource("fx-import-tool");
                            entityService.save(sic, etc, null, true);
                            importResult.set(true);
                            break block23;
                        }
                        case CHANGE_ALL: {
                            this.entityChoose = ImportConflictAction.CHANGE_ALL;
                            etc.getVersionInfo().setDataSource("fx-import-tool");
                            entityService.save(sic, etc, null, true);
                            importResult.set(true);
                            break block23;
                        }
                        case CHANGE_OLD: {
                            this.entityChoose = ImportConflictAction.CHANGE_OLD;
                            if (MiscUtil.compare((Date)etc.getModified(), (Date)etcOld.getModified(), (boolean)true) >= 1) {
                                etc.getVersionInfo().setDataSource("fx-import-tool");
                                entityService.save(sic, etc, null, true);
                                importResult.set(true);
                            }
                            break block23;
                        }
                        case SKIP: {
                            this.entityChoose = ImportConflictAction.ASK;
                            break block23;
                        }
                        case SKIP_ALL: {
                            return false;
                        }
                        default: {
                            throw new InterruptedException();
                        }
                    }
                }
                etc.setVersionsCount(1);
                etc.getVersionInfo().setVersionNumber(0);
                etc.getVersionInfo().setDataSource("fx-import-tool");
                entityService.save(sic, etc, null, true);
                importResult.set(true);
            }
            catch (InterruptedException ie) {
                throw ie;
            }
            catch (BrokenBarrierException bbe) {
                this.assetChoose = ImportConflictAction.CANCEL;
                this.addMessages(new Message[]{MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)"Import critical error", (Throwable)bbe, (Object[])new Object[0])});
            }
            catch (Exception e) {
                this.addMessages(new Message[]{MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)("Object " + elm.getAttribute("class") + ' ' + uid + " import failed!"), (Throwable)e, (Object[])new Object[0])});
            }
        }
        return importResult.get();
    }

    private boolean importDictionary(Element elm, Map<String, Boolean> deletedDicts) throws Exception {
        AtomicBoolean importResult;
        block20: {
            importResult = new AtomicBoolean(false);
            String uid = null;
            try {
                BaseDictionary oldDict;
                Class cls = XSHelper.getClass((String)elm.getAttribute("class"));
                BaseDictionary dictionary = (BaseDictionary)cls.newInstance();
                Element revision = XmlUtil.getElement((Element)elm, (String)"revision");
                if (revision != null) {
                    elm.removeChild(revision);
                }
                dictionary.fromXML(elm);
                uid = dictionary.getUid();
                if (TextUtil.isBlank((String)dictionary.getUid())) {
                    dictionary.setUid(UUID.randomUUID().toString());
                }
                ServiceInvocationContext sic = ServiceInvocationContext.get();
                DictService dictService = (DictService)RpcServiceManager.get().getService(DictService.class);
                if (TextUtil.isBlank((String)dictionary.getCreatedBy())) {
                    dictionary.setCreatedBy(sic.getUser());
                }
                if (TextUtil.isBlank((String)dictionary.getModifiedBy())) {
                    dictionary.setModifiedBy(sic.getUser());
                }
                if (dictionary.getCreated() == null) {
                    dictionary.setCreated(new Date());
                }
                if (dictionary.getModified() == null) {
                    dictionary.setModified(dictionary.getCreated());
                }
                BaseDictionary baseDictionary = oldDict = deletedDicts.getOrDefault(this.getEntityId(elm), Boolean.FALSE) == false ? dictService.load(sic, dictionary.toReference()) : null;
                if (oldDict != null) {
                    switch (this.dictChoose) {
                        case ASK: {
                            this.askConflictDictOptions(elm, oldDict, dictionary, importResult, sic, dictService);
                            this.barrier.await();
                            break block20;
                        }
                        case CHANGE: {
                            this.dictChoose = ImportConflictAction.ASK;
                            dictionary.setUid(oldDict.getUid());
                            dictService.save(sic, dictionary);
                            importResult.set(true);
                            break block20;
                        }
                        case CHANGE_ALL: {
                            this.dictChoose = ImportConflictAction.CHANGE_ALL;
                            dictionary.setUid(oldDict.getUid());
                            dictService.save(sic, dictionary);
                            importResult.set(true);
                            break block20;
                        }
                        case CHANGE_OLD: {
                            this.dictChoose = ImportConflictAction.CHANGE_OLD;
                            if (MiscUtil.compare((Date)dictionary.getModified(), (Date)oldDict.getModified(), (boolean)true) >= 1) {
                                dictionary.setUid(oldDict.getUid());
                                dictService.save(sic, dictionary);
                                importResult.set(true);
                            }
                            break block20;
                        }
                        case SKIP: {
                            this.dictChoose = ImportConflictAction.ASK;
                            break block20;
                        }
                        case SKIP_ALL: {
                            return false;
                        }
                        default: {
                            throw new InterruptedException();
                        }
                    }
                }
                dictService.save(sic, dictionary);
                importResult.set(true);
            }
            catch (InterruptedException ie) {
                throw ie;
            }
            catch (BrokenBarrierException bbe) {
                this.assetChoose = ImportConflictAction.CANCEL;
                this.addMessages(new Message[]{MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)"Import critical error", (Throwable)bbe, (Object[])new Object[0])});
            }
            catch (Exception e) {
                this.addMessages(new Message[]{MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)("Object " + elm.getAttribute("class") + ' ' + uid + " import failed!"), (Throwable)e, (Object[])new Object[0])});
            }
        }
        return importResult.get();
    }

    private boolean importAsset(Element elm) throws Exception {
        AtomicBoolean importResult;
        block25: {
            importResult = new AtomicBoolean(false);
            String uid = null;
            try {
                BaseAsset oldAsset;
                Class cls = XSHelper.getClass((String)elm.getAttribute("class"));
                BaseAsset asset = (BaseAsset)cls.newInstance();
                Element revision = XmlUtil.getElement((Element)elm, (String)"revision");
                if (revision != null) {
                    elm.removeChild(revision);
                }
                asset.fromXML(elm);
                uid = asset.getUid();
                if (TextUtil.isBlank((String)asset.getUid())) {
                    asset.setUid(UUID.randomUUID().toString());
                }
                ServiceInvocationContext sic = ServiceInvocationContext.get();
                AssetService assetService = (AssetService)RpcServiceManager.get().getService(AssetService.class);
                SearchQuery query = new SearchQuery();
                if (cls.getName().equals(Workspace.class.getName())) {
                    query.getCriteria().getCriterions().add(SearchCriterion.eq((String)Workspace.Property.owner.name(), (Object)((Workspace)asset).getOwner()));
                } else if (cls.getName().equals(UserAccount.class.getName())) {
                    query.getCriteria().getCriterions().add(SearchCriterion.eq((String)UserAccount.Property.loginName.name(), (Object)((UserAccount)asset).getLoginName()));
                } else if (cls.getName().equals(AclGroup.class.getName())) {
                    query.getCriteria().getCriterions().add(SearchCriterion.eq((String)AclGroup.Property.id.name(), (Object)((AclGroup)asset).getId()));
                } else if (cls.getName().equals(AclUser.class.getName())) {
                    query.getCriteria().getCriterions().add(SearchCriterion.eq((String)AclUser.Property.id.name(), (Object)((AclUser)asset).getId()));
                } else if (cls.getName().equals(AclEntry.class.getName())) {
                    query.getCriteria().getCriterions().add(SearchCriterion.eq((String)AclEntry.Property.principalId.name(), (Object)((AclEntry)asset).getPrincipalId()));
                    query.getCriteria().getCriterions().add(SearchCriterion.eq((String)AclEntry.Property.resourceId.name(), (Object)((AclEntry)asset).getResourceId()));
                } else if (!cls.getName().equals(AclAsset.class.getName())) {
                    throw new Exception("Unknows asset" + cls.getName());
                }
                List data = assetService.search(sic, cls, query).getData();
                if (!data.isEmpty() && (oldAsset = (BaseAsset)data.get(0)) != null) {
                    asset.setUid(oldAsset.getUid());
                    switch (this.assetChoose) {
                        case ASK: {
                            this.askConflictAssetOptions(elm, oldAsset, asset, importResult, sic, assetService);
                            this.barrier.await();
                            break block25;
                        }
                        case CHANGE: {
                            this.dictChoose = ImportConflictAction.ASK;
                            asset.setUid(oldAsset.getUid());
                            assetService.save(sic, asset);
                            importResult.set(true);
                            break block25;
                        }
                        case CHANGE_ALL: {
                            this.dictChoose = ImportConflictAction.CHANGE_ALL;
                            asset.setUid(oldAsset.getUid());
                            assetService.save(sic, asset);
                            importResult.set(true);
                            break block25;
                        }
                        case SKIP: {
                            this.dictChoose = ImportConflictAction.ASK;
                            break block25;
                        }
                        case SKIP_ALL: {
                            return false;
                        }
                        default: {
                            throw new InterruptedException();
                        }
                    }
                }
                assetService.save(sic, asset);
                importResult.set(true);
            }
            catch (InterruptedException ie) {
                throw ie;
            }
            catch (BrokenBarrierException bbe) {
                this.assetChoose = ImportConflictAction.CANCEL;
                this.addMessages(new Message[]{MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)"Import critical error", (Throwable)bbe, (Object[])new Object[0])});
            }
            catch (Exception e) {
                this.addMessages(new Message[]{MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)("Object " + elm.getAttribute("class") + ' ' + uid + " import failed!"), (Throwable)e, (Object[])new Object[0])});
            }
        }
        return importResult.get();
    }

    private void askConflictEntityOptions(Element elm, EntityContainer<? extends BaseEntity> etcOld, EntityContainer<? extends BaseEntity> etc, AtomicBoolean importResult, ServiceInvocationContext sic, EntityService entityService) throws Exception {
        FxUtil.waitForFxThread(() -> {
            RadioBoxWidget<ImportConflictAction> options = ImportDialog.createEntityAndDictRadioBox(false);
            new Dialog().setTitle(Messages.Conflict_of_import).setMessage(String.format("%s : %s (uid: %s) %s", etcOld.getEntityType().getSimpleName(), etcOld.toReference(), etcOld.getUid(), Messages.Task_already_exists)).setBody(options).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Select, () -> {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 18[CASE]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.getAnalysis(Method.java:520)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:351)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }).setOnCloseRequest(() -> {
                this.entityChoose = ImportConflictAction.CANCEL;
                try {
                    this.barrier.await();
                }
                catch (Exception e) {
                    ErrorHandler.handle((Throwable)e);
                }
            }).showGlobal();
        });
    }

    private void askConflictDictOptions(Element elm, BaseDictionary dictOld, BaseDictionary dict, AtomicBoolean importResult, ServiceInvocationContext sic, DictService dictService) throws Exception {
        FxUtil.waitForFxThread(() -> {
            RadioBoxWidget<ImportConflictAction> options = ImportDialog.createEntityAndDictRadioBox(false);
            new Dialog().setTitle(Messages.Conflict_of_import).setMessage(String.format("%s : %s (code: %s) %s", dictOld.getClass().getSimpleName(), dictOld.toReference(), dictOld.getCode(), Messages.Task_already_exists)).setBody(options).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Select, () -> {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 18[CASE]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.getAnalysis(Method.java:520)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:351)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }).setOnCloseRequest(() -> {
                this.dictChoose = ImportConflictAction.CANCEL;
                try {
                    this.barrier.await();
                }
                catch (Exception e) {
                    ErrorHandler.handle((Throwable)e);
                }
            }).showGlobal();
        });
    }

    private void askConflictAssetOptions(Element elm, BaseAsset assetOld, BaseAsset asset, AtomicBoolean importResult, ServiceInvocationContext sic, AssetService assetService) throws Exception {
        FxUtil.waitForFxThread(() -> {
            RadioBoxWidget<ImportConflictAction> options = ImportDialog.createEntityAndDictRadioBox(false);
            new Dialog().setTitle(Messages.Conflict_of_import).setMessage(asset.getClass().getSimpleName() + " : " + asset.getUid() + " " + Messages.Task_already_exists).setBody(options).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Select, () -> {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 14[CASE]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.getAnalysis(Method.java:520)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:351)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }).setOnCloseRequest(() -> {
                this.assetChoose = ImportConflictAction.CANCEL;
                try {
                    this.barrier.await();
                }
                catch (Exception e) {
                    ErrorHandler.handle((Throwable)e);
                }
            }).showGlobal();
        });
    }
}

