/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.notifications;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.entity.RootEntityHandler;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconShape;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconShapes;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.DateValueWidget;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.model.system.EventNotificationSpace;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.EventNotification;
import com.gridnine.xtrip.common.model.system.EventNotificationRecipient;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.value.ObservableObjectValue;
import javafx.scene.Node;

public final class EventNotificationTool {
    public static void install(DateValueWidget widget, Configurator configurator) {
        if (!Prefetched.getData().isNotificationsEnabled()) {
            return;
        }
        widget.setActionHandler((IconShape)StandardIconShapes.BELL, Messages.NotificationTool_tooltip, node -> {
            EntityReference ref = null;
            RootEntityPane rep = RootEntityPane.lookup((Node)widget);
            if (rep != null && rep.getData() != null && rep.getData().getContainer() != null) {
                ref = rep.getData().getContainer().toReference();
                EntityReference<?> nestedRef = configurator.getNestedEntityReference();
                if (nestedRef != null) {
                    ref = new NestedEntityReference(ref, nestedRef.getUid(), nestedRef.getType(), nestedRef.getCaption());
                }
            }
            EventNotificationTool.showCreateDialog((Node)widget, LocalDateTime.of(widget.getValue(), LocalTime.NOON), configurator.getTitle(), configurator.getText(), ref);
        }, (BooleanExpression)Bindings.isNotNull((ObservableObjectValue)widget.valueProperty()));
    }

    public static void showCreateDialog(Node dialogOwner, LocalDateTime eventDate, String title, String text, EntityReference<?> ref) {
        EventNotification notification = new EventNotification();
        notification.setEventDate(DateUtils.asDate((LocalDateTime)eventDate));
        LocalDateTime date = eventDate.minusMonths(1L);
        if (!date.isAfter(LocalDateTime.now())) {
            date = LocalDateTime.now().plusDays(1L);
        }
        notification.setAlarmDate(DateUtils.asDate((LocalDateTime)date));
        notification.setTitle(title);
        notification.setText(text);
        notification.setActive(true);
        notification.setEntityReference(ref);
        EventNotificationRecipient recipient = new EventNotificationRecipient();
        recipient.setLogin(ServiceInvocationContext.get().getUser());
        recipient.setProfile(Prefetched.getData().getCurrentAgentData().getAgent());
        if (recipient.getProfile() != null) {
            recipient.setName(recipient.getProfile().getCaption());
        }
        notification.getRecipients().add(recipient);
        EventNotificationTool.showDialog(notification, dialogOwner);
    }

    private static void showDialog(EventNotification notification, Node dialogOwner) {
        RootEntityHandler handler = RootEntityHandler.forEntityClass(EventNotification.class);
        ViewController controller = handler.createEditorController(false);
        DataTransferPackage dtp = new DataTransferPackage(EntityContainer.create((BaseEntity)notification));
        controller.readData((Object)dtp);
        Dialog dialog = new Dialog();
        dialog.setTitle(Messages.NotificationTool_ttitle).setBody(((EventNotificationSpace)controller.getView()).getMainTile().getFullNode()).setAutoClose(false).setExpandToParent(true).setOnCloseRequest(() -> ((Dialog)dialog).close()).addButton(DialogButtonStyle.DECLINE, () -> ((Dialog)dialog).close()).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.NotificationTool_schedule, () -> {
            ArrayList messages = new ArrayList();
            controller.validateData(messages);
            dialog.setValidationMessages(false, messages);
            if (MessagesHelper.hasErrorMessage(messages)) {
                return;
            }
            controller.writeData((Object)dtp);
            dialog.close();
            Notifications.get().submitTask(() -> {
                dtp.getContainer().getVersionInfo().setDataSource("fx-client");
                ((EntityService)RpcServiceManager.get().getService(EntityService.class)).save(ServiceInvocationContext.get(), dtp.getContainer(), null, true);
                Notifications.get().showFlashNotification(Messages.NotificationTool_scheduled);
                EventBus.get().publishAsync((Event)new EntityModificationEvent(null, new EntityModification(dtp.getContainer().toReference(), EntityModification.ModificationType.CHANGE)));
            }, Messages.NotificationTool_processing);
        }).show(dialogOwner);
    }

    private EventNotificationTool() {
    }

    public static interface Configurator {
        public String getTitle();

        public String getText();

        public EntityReference<?> getNestedEntityReference();
    }
}

