/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.notifications;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextAreaWidget;
import com.gridnine.xtrip.client.fx.core.registry.basic.AppStartHook;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.standard.jenkins.JenkinsUpdateMassageHolderClient;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.StandardFxService;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.rest.jenkins.UserMessage;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javafx.scene.Node;

public class EventNotificationsUpdateMomHook
implements AppStartHook {
    public double getWeight() {
        return 150.0;
    }

    public String getId() {
        return "event-notification-update-mom";
    }

    public void execute() {
        try {
            long period = 30000L;
            long delay = 10000L;
            Notifications.get().getScheduler().scheduleWithFixedDelay(this::processNotifications, delay, period, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
        }
    }

    private synchronized void processNotifications() {
        try {
            UserMessage jenkinsUpdateMassage = ((StandardFxService)RpcServiceManager.get().getService(StandardFxService.class)).findJenkinsUpdateMassage(ServiceInvocationContext.get());
            JenkinsUpdateMassageHolderClient jenkinsUpdateMassageHolderClient = JenkinsUpdateMassageHolderClient.get();
            if (jenkinsUpdateMassage != null && jenkinsUpdateMassageHolderClient.getMessage() == null || jenkinsUpdateMassage != null && jenkinsUpdateMassageHolderClient.getMessage() != null && !jenkinsUpdateMassageHolderClient.getMessage().getUid().equals(jenkinsUpdateMassage.getUid())) {
                jenkinsUpdateMassageHolderClient.setMessage(jenkinsUpdateMassage);
                Duration between = Duration.between(LocalDateTime.now(), jenkinsUpdateMassageHolderClient.getMessage().getDateUpdate());
                if (between.toMinutes() < 0L) {
                    return;
                }
                Dialog dialog = new Dialog();
                dialog.setTitle(Messages.Notification).setBody(EventNotificationsUpdateMomHook.buildPane(jenkinsUpdateMassage.getMessageKey(), between.toMinutes())).setAutoClose(false).addButton(DialogButtonStyle.ACCEPT_CONTINUE, Messages.Close, () -> ((Dialog)dialog).close());
                FxUtil.submitToFxThread(() -> ((Dialog)dialog).showGlobal());
            }
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
        }
    }

    private static Node buildPane(String notification, long time) {
        String text = String.format(L10n.find(Messages.class, (Locale)LocaleHelper.getCurrentLocale(), (String)notification, (Object[])new Object[0]), time);
        TextAreaWidget widget = new TextAreaWidget(true);
        widget.setValue(text);
        widget.setMaxHeight(30.0);
        return widget;
    }
}

