/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.parsers;

import com.gridnine.xtrip.client.fx.core.entity.EntityIndexHandler;
import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.entity.RootEntityHandler;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListPane;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListPaneConfiguration;
import com.gridnine.xtrip.client.fx.core.util.MultiSupplier;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.parsers.model.BaseExchangeDocument;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.control.SelectionMode;

class ExchangeDocumentsListPane
extends IndexListPane<BaseExchangeDocument, EntityIndex<BaseExchangeDocument>> {
    private static MultiSupplier<IndexListPaneConfiguration<BaseExchangeDocument, EntityIndex<BaseExchangeDocument>>> createSupplier(List<Class<? extends BaseExchangeDocument>> classes, final int limit) {
        class Entry {
            final EntityIndexHandler<?, ?> handler;
            IndexListPaneConfiguration<BaseExchangeDocument, EntityIndex<BaseExchangeDocument>> config;

            Entry(EntityIndexHandler<?, ?> hdlr) {
                this.handler = hdlr;
            }

            IndexListPaneConfiguration<BaseExchangeDocument, EntityIndex<BaseExchangeDocument>> getConfig() {
                if (this.config == null) {
                    IndexListParameters params = this.handler.createListParameters();
                    this.config = new IndexListPaneConfiguration(params.getIndexType());
                    this.config.setSelectionMode(SelectionMode.MULTIPLE);
                    this.config.setPatternSearchEnabled(true);
                    this.config.setActionsEnabled(true);
                    this.config.setLimit(limit);
                    this.config.applyParameters(params);
                }
                return this.config;
            }
        }
        final ArrayList<Entry> entries = new ArrayList<Entry>();
        for (Class<? extends BaseExchangeDocument> cls : classes) {
            RootEntityHandler handler = RootEntityHandler.forEntityClass(cls);
            if (handler == null) continue;
            entries.add(new Entry(EntityIndexHandler.forIndexClass((Class)handler.getStandardIndexClass())));
        }
        entries.sort((entry1, entry2) -> EntityIndexHandler.format(entry1.handler).compareTo(EntityIndexHandler.format(entry2.handler)));
        return new MultiSupplier<IndexListPaneConfiguration<BaseExchangeDocument, EntityIndex<BaseExchangeDocument>>>(){

            public String getDisplayName(int idx) {
                return EntityIndexHandler.format(((Entry)entries.get((int)idx)).handler);
            }

            public IndexListPaneConfiguration<BaseExchangeDocument, EntityIndex<BaseExchangeDocument>> get(int idx) {
                return ((Entry)entries.get(idx)).getConfig();
            }

            public int count() {
                return entries.size();
            }
        };
    }

    protected void handleModificationEvent(EntityModificationEvent evt) {
        super.handleModificationEvent(evt);
        for (EntityModification mod : evt.getModifications()) {
            if (!MetaRegistryHelper.isAssignableFrom((EntityType)MetaRegistryHelper.getEntityType((String)BookingFile.class.getName()), (EntityType)MetaRegistryHelper.getEntityType((String)mod.getReference().getType().getName()))) continue;
            this.reloadData();
            return;
        }
    }

    ExchangeDocumentsListPane(ObservableMutex mutex, List<Class<? extends BaseExchangeDocument>> classes, int limit) {
        super(mutex, ExchangeDocumentsListPane.createSupplier(classes, limit));
    }
}

