/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.parsers;

import com.gridnine.xtrip.client.fx.core.acl.FxAclUtil;
import com.gridnine.xtrip.client.fx.core.activity.ActivityHandler;
import com.gridnine.xtrip.client.fx.core.activity.ActivityState;
import com.gridnine.xtrip.client.fx.core.activity.NavToolable;
import com.gridnine.xtrip.client.fx.core.activity.NavigationParameters;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.core.registry.RegistryItem;
import com.gridnine.xtrip.client.fx.core.ui.navigation.NavTool;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.Serializer;
import com.gridnine.xtrip.client.fx.standard.parsers.ExchangeDocumentsListPane;
import com.gridnine.xtrip.client.fx.standard.parsers.ParsersManagerNavToolData;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.parsers.model.BaseExchangeDocument;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ParsersManagerActivityHandler
extends ActivityHandler<ExchangeDocumentsListPane, ParsersManagerNavToolData>
implements NavToolable<ExchangeDocumentsListPane, ParsersManagerNavToolData> {
    private static String ID = "parsers-manager-activity-handler";

    public static ParsersManagerActivityHandler get() {
        return (ParsersManagerActivityHandler)ParsersManagerActivityHandler.forId((String)ID);
    }

    public static void register(ClientRegistry registry) {
        if (!registry.allOf(TYPE).containsKey(ID)) {
            registry.register((RegistryItem)new ParsersManagerActivityHandler());
        }
    }

    public static List<Class<? extends BaseExchangeDocument>> getDocumentClasses() throws Exception {
        ArrayList<Class<? extends BaseExchangeDocument>> result = new ArrayList<Class<? extends BaseExchangeDocument>>();
        for (Object ett : MetaRegistry.get().getEntities().values()) {
            try {
                Class clazz = XSHelper.getClass((String)ett.getId());
                if (!BaseExchangeDocument.class.isAssignableFrom(clazz)) continue;
                result.add(clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {
                ErrorHandler.handle((Throwable)classNotFoundException);
            }
        }
        HashMap<String, AclQuery> map = new HashMap<String, AclQuery>();
        for (Class clazz : result) {
            map.put(clazz.getName(), AclQuery.AclQueryBuilder.get().entry(StandardRestrictionResourceOperations.VIEW.getId(), clazz.getName()).build());
        }
        Set grantedIds = FxAclUtil.applyACL(map);
        result.removeIf(aClass -> !grantedIds.contains(aClass.getName()));
        return result;
    }

    private ParsersManagerActivityHandler() {
    }

    public String getId() {
        return ID;
    }

    public void update(ActivityState<ExchangeDocumentsListPane, ParsersManagerNavToolData> state, NavigationParameters<ParsersManagerNavToolData> parameters) {
        state.titleProperty().set((Object)parameters.getTitle());
        state.descriptionProperty().set((Object)parameters.getDescription());
        state.setParameters(parameters.getParameters());
    }

    protected ExchangeDocumentsListPane createView(ActivityState<ExchangeDocumentsListPane, ParsersManagerNavToolData> state) throws Exception {
        Predicate<Class> classesFilter = state.getParameters() == null ? cls -> true : cls -> !((ParsersManagerNavToolData)state.getParameters()).getHiddenDocumentClasses().contains(cls.getName());
        ExchangeDocumentsListPane result = new ExchangeDocumentsListPane(state.getMutex(), ParsersManagerActivityHandler.getDocumentClasses().stream().filter(classesFilter).collect(Collectors.toList()), ((ParsersManagerNavToolData)state.getParameters()).getLimit());
        EventBus.get().subscribe(EntityModificationEvent.TYPE, result.getModificationEventHandler());
        return result;
    }

    protected Serializer<ParsersManagerNavToolData> getSerializer() {
        return ParsersManagerNavToolData.SERIALIZER;
    }

    protected void saveChanges(ActivityState<ExchangeDocumentsListPane, ParsersManagerNavToolData> state) throws Exception {
    }

    public boolean isSupported(NavTool<?> tool) {
        return false;
    }
}

