/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.parsers;

import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.CardAction;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.ui.navigation.NavToolEditor;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.parsers.ExchangeDocumentClassesPane;
import com.gridnine.xtrip.client.fx.standard.parsers.ParsersManagerActivityHandler;
import com.gridnine.xtrip.client.fx.standard.parsers.ParsersManagerNavToolData;
import com.gridnine.xtrip.common.fx.assets.FxWorkspaceItem;
import com.gridnine.xtrip.common.meta.ui.UiCardsContainer;
import com.gridnine.xtrip.common.parsers.model.BaseExchangeDocument;
import java.util.Collections;
import java.util.List;
import javafx.scene.Node;

class ParsersManagerNavToolEditor
implements NavToolEditor {
    private final Card<ExchangeDocumentClassesPane> content = new Card("classe-names", UiCardsContainer.Style.EXPANDED, Messages.Parsers_manager_editor_title, (Node)new ExchangeDocumentClassesPane());

    ParsersManagerNavToolEditor() {
        this.content.getActions().add((Object)new CardAction<ExchangeDocumentClassesPane>(){

            public boolean isEnabled(Card<ExchangeDocumentClassesPane> card) {
                return true;
            }

            public double getWeight() {
                return 10.0;
            }

            public String getName(Card<ExchangeDocumentClassesPane> card) {
                return Messages.Parsers_manager_show_all;
            }

            public String getDescription(Card<ExchangeDocumentClassesPane> card) {
                return null;
            }

            public void execute(Card<ExchangeDocumentClassesPane> card, boolean alt) {
                ((ExchangeDocumentClassesPane)card.getContent()).setAll(true);
            }
        });
        this.content.getActions().add((Object)new CardAction<ExchangeDocumentClassesPane>(){

            public boolean isEnabled(Card<ExchangeDocumentClassesPane> card) {
                return true;
            }

            public double getWeight() {
                return 20.0;
            }

            public String getName(Card<ExchangeDocumentClassesPane> card) {
                return Messages.Parsers_manager_hide_all;
            }

            public String getDescription(Card<ExchangeDocumentClassesPane> card) {
                return null;
            }

            public void execute(Card<ExchangeDocumentClassesPane> card, boolean alt) {
                ((ExchangeDocumentClassesPane)card.getContent()).setAll(false);
            }
        });
        Notifications.get().submitTask(() -> {
            List<Class<? extends BaseExchangeDocument>> classes = ParsersManagerActivityHandler.getDocumentClasses();
            FxUtil.submitToFxThread(() -> ((ExchangeDocumentClassesPane)this.content.getContent()).populate(classes));
        }, Messages.Parsers_manager_load_document_classes);
    }

    public Card<ExchangeDocumentClassesPane> getContent() {
        return this.content;
    }

    public boolean isDataChanged() {
        return ((ExchangeDocumentClassesPane)this.content.getContent()).isDataChanged();
    }

    public void readData(FxWorkspaceItem item) {
        try {
            ParsersManagerNavToolData data = (ParsersManagerNavToolData)ParsersManagerNavToolData.SERIALIZER.deserialize(item.getParameters());
            if (data != null) {
                ((ExchangeDocumentClassesPane)this.content.getContent()).readData(data.getHiddenDocumentClasses());
            } else {
                ((ExchangeDocumentClassesPane)this.content.getContent()).readData(Collections.emptySet());
            }
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
            ((ExchangeDocumentClassesPane)this.content.getContent()).readData(Collections.emptySet());
        }
    }

    public void writeData(FxWorkspaceItem item) {
        try {
            ParsersManagerNavToolData data = (ParsersManagerNavToolData)ParsersManagerNavToolData.SERIALIZER.deserialize(item.getParameters());
            if (data == null) {
                data = new ParsersManagerNavToolData();
            }
            ((ExchangeDocumentClassesPane)this.content.getContent()).writeData(data.getHiddenDocumentClasses());
            item.setParameters(ParsersManagerNavToolData.SERIALIZER.serialize((Object)data));
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
        }
    }
}

