/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.parsers;

import com.gridnine.xtrip.client.fx.core.devtools.api.DevTool;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevToolItem;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.RadioBoxWidget;
import com.gridnine.xtrip.client.fx.core.ui.navigation.NavTool;
import com.gridnine.xtrip.client.fx.core.ui.navigation.NavToolEditor;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.parsers.ParsersManagerNavToolData;
import com.gridnine.xtrip.common.fx.assets.FxWorkspaceItem;
import com.gridnine.xtrip.common.meta.ui.UiCardsContainer;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;

public class ParsersManagerNavToolParametersEditor
extends StackPane
implements NavToolEditor,
DevTool {
    private static final List<Integer> limits = Arrays.asList(50, 100, 150, 200, 500);
    private GridCell<RadioBoxWidget<Integer>> indexLimitCell;
    private FxWorkspaceItem workspaceItem;

    ParsersManagerNavToolParametersEditor() {
        this.createGUI();
    }

    private void createGUI() {
        Pane editorPane = this.createEditorPane();
        this.getChildren().setAll((Object[])new Node[]{editorPane});
    }

    private Pane createEditorPane() {
        this.indexLimitCell = new GridCell(Messages.Elements_per_page, (Node)new RadioBoxWidget(false));
        ((RadioBoxWidget)this.indexLimitCell.getPayload()).setItemsSupplier(() -> limits);
        GridContainer editorPane = new GridContainer(2);
        editorPane.getCells().add(this.indexLimitCell);
        return editorPane;
    }

    public Card<Node> getContent() {
        return new Card("displayParameters", UiCardsContainer.Style.STATIC, Messages.Display_Options, (Node)this);
    }

    public boolean isDataChanged() {
        if (this.workspaceItem == null) {
            return false;
        }
        NavTool tool = NavTool.forId((String)this.workspaceItem.getToolId());
        try {
            ParsersManagerNavToolData data = (ParsersManagerNavToolData)tool.cleanParameters(tool.getSerializer().deserialize(this.workspaceItem.getParameters()));
            if (data != null && !MiscUtil.equals((Object)data.getLimit(), (Object)((RadioBoxWidget)this.indexLimitCell.getPayload()).getValue())) {
                return true;
            }
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
        }
        return false;
    }

    public void readData(FxWorkspaceItem item) {
        this.workspaceItem = item;
        ((RadioBoxWidget)this.indexLimitCell.getPayload()).setValue(null);
        NavTool tool = NavTool.forId((String)item.getToolId());
        try {
            ParsersManagerNavToolData data = (ParsersManagerNavToolData)tool.cleanParameters(tool.getSerializer().deserialize(item.getParameters()));
            if (data != null) {
                int limit = data.getLimit();
                ((RadioBoxWidget)this.indexLimitCell.getPayload()).setValue((Object)limit);
            }
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
        }
    }

    public void writeData(FxWorkspaceItem item) {
        NavTool tool = NavTool.forId((String)item.getToolId());
        try {
            ParsersManagerNavToolData data;
            ParsersManagerNavToolData parsersManagerNavToolData = data = item.getParameters() != null ? (ParsersManagerNavToolData)tool.cleanParameters(tool.getSerializer().deserialize(item.getParameters())) : (ParsersManagerNavToolData)tool.createParameters();
            if (data != null) {
                Integer indexLimit = (Integer)((RadioBoxWidget)this.indexLimitCell.getPayload()).getValue();
                if (indexLimit == null || indexLimit <= 0) {
                    indexLimit = 100;
                }
                data.setLimit(indexLimit);
                item.setParameters(tool.getSerializer().serialize((Object)data));
            }
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
        }
    }

    public DevToolItem asDevToolItem() {
        return new DevToolItem(){

            public Collection<?> getSubItems() {
                return Collections.singletonList(ParsersManagerNavToolParametersEditor.this.indexLimitCell);
            }

            public String getInfo() {
                return ((Object)((Object)ParsersManagerNavToolParametersEditor.this)).getClass().getSimpleName();
            }
        };
    }
}

