/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.person.handlers;

import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.model.profile.PersonEmploymentVM;
import com.gridnine.xtrip.client.fx.model.profile.PersonMainPanelVM;
import com.gridnine.xtrip.client.fx.standard.person.handlers.BasePersonTileHelperTest;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.Gender;
import com.gridnine.xtrip.common.model.dict.PersonPositionReference;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.profile.PersonType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import org.junit.Assert;

public class PersonGeneralTileHelperTest
extends BasePersonTileHelperTest<PersonMainPanelVM, Person> {
    @Override
    public void testToVM() {
        try {
            Method[] methods;
            PersonMainPanelVM full = new PersonMainPanelVM();
            Person model = new Person();
            this.fillModel(model);
            Class<?> helper = Class.forName("com.gridnine.xtrip.client.fx.standard.entity.handlers.person.PersonGeneralTileHelper");
            block8: for (Method m : methods = helper.getDeclaredMethods()) {
                switch (m.getName()) {
                    case "toVM": {
                        m.setAccessible(true);
                        m.invoke(helper, model, full);
                        continue block8;
                    }
                }
            }
            Assert.assertEquals((Object)full.getGeneral().getCode(), (Object)model.getCode());
            Assert.assertEquals((Object)full.getGeneral().getFirstName().getStringValue(), (Object)model.getFirstName().getStringValue());
            Assert.assertEquals((Object)full.getGeneral().getLastName().getStringValue(), (Object)model.getLastName().getStringValue());
            Assert.assertEquals((Object)full.getGeneral().getMiddleName().getStringValue(), (Object)model.getMiddleName().getStringValue());
            Assert.assertEquals((Object)full.getGeneral().getGender().name(), (Object)model.getGender().name());
            Assert.assertEquals((long)full.getGeneral().getTypes().size(), (long)model.getTypes().size());
            Iterator fullTypeIterator = full.getGeneral().getTypes().iterator();
            model.getTypes().forEach(type -> {
                if (fullTypeIterator.hasNext()) {
                    Assert.assertEquals((Object)((PersonType)fullTypeIterator.next()).name(), (Object)type.name());
                } else {
                    Assert.assertTrue((boolean)false);
                }
            });
            Iterator fullEmployments = full.getEmployments().iterator();
            model.getEmployments().forEach(emp -> {
                if (fullEmployments.hasNext()) {
                    PersonEmploymentVM next = (PersonEmploymentVM)fullEmployments.next();
                    BasePersonTileHelperTest.assertEntityReference((EntityReference<? extends BaseEntity>)next.getOrganization(), (EntityReference<? extends BaseEntity>)emp.getOrganization());
                    Assert.assertEquals((Object)next.getDepartmentSuffix(), (Object)emp.getDepartmentSuffix());
                    BasePersonTileHelperTest.assertDictReferences((DictionaryReference<? extends BaseDictionary>)next.getPosition(), (DictionaryReference<? extends BaseDictionary>)emp.getPosition());
                    BasePersonTileHelperTest.assertDates(emp.getOpened(), next.getOpened());
                    BasePersonTileHelperTest.assertDates(emp.getClosed(), next.getClosed());
                    Assert.assertEquals((Object)next.isAuthorized(), (Object)emp.isAuthorized());
                    Assert.assertEquals((Object)next.isMainEmployment(), (Object)emp.isMainEmployment());
                }
            });
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            Assert.assertTrue((boolean)false);
        }
    }

    @Override
    public void testFromVM() {
        try {
            Method[] methods;
            PersonMainPanelVM full = new PersonMainPanelVM();
            Person model = new Person();
            this.fillVM(full);
            Class<?> helper = Class.forName("com.gridnine.xtrip.client.fx.standard.entity.handlers.person.PersonGeneralTileHelper");
            block8: for (Method m : methods = helper.getDeclaredMethods()) {
                switch (m.getName()) {
                    case "fromVM": {
                        m.setAccessible(true);
                        m.invoke(helper, full, model);
                        continue block8;
                    }
                }
            }
            Assert.assertEquals((Object)full.getGeneral().getCode(), (Object)model.getCode());
            Assert.assertEquals((Object)full.getGeneral().getFirstName().getStringValue(), (Object)model.getFirstName().getStringValue());
            Assert.assertEquals((Object)full.getGeneral().getLastName().getStringValue(), (Object)model.getLastName().getStringValue());
            Assert.assertEquals((Object)full.getGeneral().getMiddleName().getStringValue(), (Object)model.getMiddleName().getStringValue());
            Assert.assertEquals((Object)full.getGeneral().getGender().name(), (Object)model.getGender().name());
            Assert.assertEquals((long)full.getGeneral().getTypes().size(), (long)model.getTypes().size());
            HashSet types = new HashSet();
            full.getGeneral().getTypes().forEach(type -> types.add(type));
            Iterator fullTypeIterator = types.iterator();
            model.getTypes().forEach(type -> {
                if (fullTypeIterator.hasNext()) {
                    PersonType next = (PersonType)fullTypeIterator.next();
                    Assert.assertEquals((Object)next.name(), (Object)type.name());
                } else {
                    Assert.assertTrue((boolean)false);
                }
            });
            Iterator fullEmployments = full.getEmployments().iterator();
            model.getEmployments().forEach(emp -> {
                if (fullEmployments.hasNext()) {
                    PersonEmploymentVM next = (PersonEmploymentVM)fullEmployments.next();
                    BasePersonTileHelperTest.assertEntityReference((EntityReference<? extends BaseEntity>)next.getOrganization(), (EntityReference<? extends BaseEntity>)emp.getOrganization());
                    Assert.assertEquals((Object)next.getDepartmentSuffix(), (Object)emp.getDepartmentSuffix());
                    BasePersonTileHelperTest.assertDictReferences((DictionaryReference<? extends BaseDictionary>)next.getPosition(), (DictionaryReference<? extends BaseDictionary>)emp.getPosition());
                    BasePersonTileHelperTest.assertDates(emp.getOpened(), next.getOpened());
                    BasePersonTileHelperTest.assertDates(emp.getClosed(), next.getClosed());
                    Assert.assertEquals((Object)next.isAuthorized(), (Object)emp.isAuthorized());
                    Assert.assertEquals((Object)next.isMainEmployment(), (Object)emp.isMainEmployment());
                }
            });
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            Assert.assertTrue((boolean)false);
        }
    }

    @Override
    protected void fillVM(PersonMainPanelVM full) {
        full.getGeneral().setCode("TestCode001");
        L10nString firstName = new L10nString();
        firstName.setStringValue("||en__||TestFirstName");
        L10nString lastName = new L10nString();
        lastName.setStringValue("||en__||TestLastName");
        L10nString middleName = new L10nString();
        middleName.setStringValue("||en__||TestMiddleName");
        full.getGeneral().setFirstName(firstName);
        full.getGeneral().setLastName(lastName);
        full.getGeneral().setMiddleName(middleName);
        full.getGeneral().setGender(Gender.MALE);
        full.getGeneral().getTypes().add(PersonType.AGENT);
        full.getGeneral().getTypes().add(PersonType.MANAGER);
        full.getGeneral().getTypes().add(PersonType.PASSENGER);
        PersonEmploymentVM emp = new PersonEmploymentVM();
        emp.setOrganization(new EntityReference());
        emp.setDepartmentSuffix("TestDepartment001");
        emp.setPosition((DictionaryReference)new PersonPositionReference());
        emp.setOpened(DateUtils.asLocalDate((Date)new Date()));
        emp.setClosed(DateUtils.asLocalDate((Date)new Date()));
        emp.setAuthorized(true);
        emp.setMainEmployment(true);
        full.getEmployments().add(emp);
    }

    @Override
    protected void fillModel(Person model) {
        model.setCode("TestCode001");
        model.getFirstName().setStringValue("||en__||TestFirstName");
        model.getLastName().setStringValue("||en__||TestLastName");
        model.getMiddleName().setStringValue("||en__||TestMiddleName");
        model.setGender(Gender.MALE);
        model.getTypes().add(PersonType.AGENT);
        model.getTypes().add(PersonType.MANAGER);
        model.getTypes().add(PersonType.PASSENGER);
        PersonEmployment emp = new PersonEmployment();
        emp.setOrganization(new EntityReference());
        emp.setDepartmentSuffix("TestDepartment001");
        emp.setPosition((DictionaryReference)new PersonPositionReference());
        emp.setOpened(new Date());
        emp.setClosed(new Date());
        emp.setAuthorized(true);
        emp.setMainEmployment(true);
        model.getEmployments().add(emp);
    }
}

