/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.person.handlers;

import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.model.profile.PersonPassportVM;
import com.gridnine.xtrip.client.fx.model.profile.PersonPassportsMainPanelVM;
import com.gridnine.xtrip.client.fx.standard.person.handlers.BasePersonTileHelperTest;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CountryReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.Gender;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.util.Streams;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import org.junit.Assert;

public class PersonPassportsTileHelperTest
extends BasePersonTileHelperTest<PersonPassportsMainPanelVM, Person> {
    @Override
    public void testToVM() {
        try {
            PersonPassportsMainPanelVM full = new PersonPassportsMainPanelVM();
            Person model = new Person();
            this.fillModel(model);
            Class<?> helper = Class.forName("com.gridnine.xtrip.client.fx.standard.entity.handlers.person.PersonPassportsTileHelper");
            Method method = (Method)Streams.single(Arrays.stream(helper.getDeclaredMethods()).filter(m -> m.getName().equals("toVM") && Arrays.equals(m.getParameterTypes(), new Class[]{Person.class, PersonPassportsMainPanelVM.class})));
            method.setAccessible(true);
            method.invoke(helper, model, full);
            Assert.assertEquals((long)model.getPassports().size(), (long)full.getPassports().size());
            Iterator fullIterator = full.getPassports().iterator();
            model.getPassports().forEach(passport -> {
                if (fullIterator.hasNext()) {
                    PersonPassportVM panelVM = (PersonPassportVM)fullIterator.next();
                    Assert.assertEquals((Object)panelVM.getFirstNameLatin(), (Object)passport.getFirstName());
                    Assert.assertEquals((Object)panelVM.getLastNameLatin(), (Object)passport.getLastName());
                    Assert.assertEquals((Object)panelVM.getMiddleNameLatin(), (Object)passport.getMiddleName());
                    Assert.assertEquals((Object)panelVM.getGender().name(), (Object)passport.getGender().name());
                    BasePersonTileHelperTest.assertDates(panelVM.getBirthDate(), passport.getBirthday());
                    Assert.assertEquals((Object)panelVM.getPlaceOfBirth(), (Object)passport.getBirthPlace());
                    Assert.assertEquals((Object)panelVM.getType().name(), (Object)passport.getType().name());
                    Assert.assertEquals((Object)panelVM.getNumber(), (Object)passport.getNumber());
                    BasePersonTileHelperTest.assertDates(panelVM.getExpired(), passport.getExpired());
                    BasePersonTileHelperTest.assertDictReferences((DictionaryReference<? extends BaseDictionary>)panelVM.getCitizenship(), (DictionaryReference<? extends BaseDictionary>)passport.getCitizenship());
                    BasePersonTileHelperTest.assertDictReferences((DictionaryReference<? extends BaseDictionary>)panelVM.getIssueCounty(), (DictionaryReference<? extends BaseDictionary>)passport.getOriginCountry());
                    BasePersonTileHelperTest.assertDates(panelVM.getIssueDate(), passport.getIssued());
                    Assert.assertEquals((Object)panelVM.getIssueOrganization(), (Object)passport.getIssueOrganization());
                } else {
                    Assert.assertTrue((boolean)false);
                }
            });
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            Assert.assertTrue((boolean)false);
        }
    }

    @Override
    public void testFromVM() {
        try {
            PersonPassportsMainPanelVM full = new PersonPassportsMainPanelVM();
            Person model = new Person();
            this.fillVM(full);
            Class<?> helper = Class.forName("com.gridnine.xtrip.client.fx.standard.entity.handlers.person.PersonPassportsTileHelper");
            Method method = (Method)Streams.single(Arrays.stream(helper.getDeclaredMethods()).filter(m -> m.getName().equals("fromVM") && Arrays.equals(m.getParameterTypes(), new Class[]{PersonPassportsMainPanelVM.class, Person.class})));
            method.setAccessible(true);
            method.invoke(helper, full, model);
            Assert.assertEquals((long)model.getPassports().size(), (long)full.getPassports().size());
            Iterator fullIterator = full.getPassports().iterator();
            model.getPassports().forEach(passport -> {
                if (fullIterator.hasNext()) {
                    PersonPassportVM panelVM = (PersonPassportVM)fullIterator.next();
                    Assert.assertEquals((Object)panelVM.getFirstNameLatin(), (Object)passport.getFirstName());
                    Assert.assertEquals((Object)panelVM.getLastNameLatin(), (Object)passport.getLastName());
                    Assert.assertEquals((Object)panelVM.getMiddleNameLatin(), (Object)passport.getMiddleName());
                    Assert.assertEquals((Object)panelVM.getGender().name(), (Object)passport.getGender().name());
                    BasePersonTileHelperTest.assertDates(panelVM.getBirthDate(), passport.getBirthday());
                    Assert.assertEquals((Object)panelVM.getPlaceOfBirth(), (Object)passport.getBirthPlace());
                    Assert.assertEquals((Object)panelVM.getType().name(), (Object)passport.getType().name());
                    Assert.assertEquals((Object)panelVM.getNumber(), (Object)passport.getNumber());
                    BasePersonTileHelperTest.assertDates(panelVM.getExpired(), passport.getExpired());
                    BasePersonTileHelperTest.assertDictReferences((DictionaryReference<? extends BaseDictionary>)panelVM.getCitizenship(), (DictionaryReference<? extends BaseDictionary>)passport.getCitizenship());
                    BasePersonTileHelperTest.assertDictReferences((DictionaryReference<? extends BaseDictionary>)panelVM.getIssueCounty(), (DictionaryReference<? extends BaseDictionary>)passport.getOriginCountry());
                    BasePersonTileHelperTest.assertDates(panelVM.getIssueDate(), passport.getIssued());
                    Assert.assertEquals((Object)panelVM.getIssueOrganization(), (Object)passport.getIssueOrganization());
                } else {
                    Assert.assertTrue((boolean)false);
                }
            });
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            Assert.assertTrue((boolean)false);
        }
    }

    @Override
    protected void fillVM(PersonPassportsMainPanelVM full) {
        PersonPassportVM fullVM = new PersonPassportVM();
        fullVM.setLastNameLatin("TestLastNameOne");
        fullVM.setFirstNameLatin("TestFirstNameOne");
        fullVM.setMiddleNameLatin("TestMiddleNameOne");
        fullVM.setGender(Gender.FEMALE);
        fullVM.setBirthDate(DateUtils.asLocalDate((Date)new Date()));
        fullVM.setPlaceOfBirth("TestBirthPlace001");
        fullVM.setType(PassportType.INTERNAL);
        fullVM.setNumber("TestNumber001");
        fullVM.setExpired(DateUtils.asLocalDate((Date)new Date()));
        fullVM.setCitizenship((DictionaryReference)new CountryReference());
        fullVM.setIssueCounty((DictionaryReference)new CountryReference());
        fullVM.setIssueDate(DateUtils.asLocalDate((Date)new Date()));
        fullVM.setIssueOrganization("TestIssueOrganization001");
        full.getPassports().add(fullVM);
    }

    @Override
    protected void fillModel(Person model) {
        Passport passport = new Passport();
        passport.setLastName("TestLastNameTwo");
        passport.setFirstName("TestFirstNameTwo");
        passport.setMiddleName("TestMiddleNameTwo");
        passport.setGender(Gender.MALE);
        passport.setBirthday(new Date());
        passport.setBirthPlace("TestBirthPlace002");
        passport.setType(PassportType.BIRTHDAY_NOTIFICATION);
        passport.setNumber("TestNumber002");
        passport.setExpired(new Date());
        passport.setCitizenship((DictionaryReference)new CountryReference());
        passport.setOriginCountry((DictionaryReference)new CountryReference());
        passport.setIssued(new Date());
        passport.setIssueOrganization("TestIssueOrganization002");
        model.getPassports().add(passport);
    }
}

