/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.prefetched;

import com.gridnine.xtrip.client.fx.core.assets.AssetModification;
import com.gridnine.xtrip.client.fx.core.assets.AssetModificationEvent;
import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.service.GlobalSettingsService;
import com.gridnine.xtrip.client.fx.core.settings.SettingsModificationEvent;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.standard.prefetched.PrefetchedHelper;
import com.gridnine.xtrip.common.fx.model.AgentData;
import com.gridnine.xtrip.common.fx.model.PrefetchedData;
import com.gridnine.xtrip.common.fx.model.UniversalProductDescriptionData;
import com.gridnine.xtrip.common.fx.rpc.StandardFxService;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductDescription;
import com.gridnine.xtrip.common.model.rules.standard.UniversalProductRuleEnvironment;
import com.gridnine.xtrip.common.model.rules.standard.nomenclatures.UniversalProductNomenclatureRulesEnvironment;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.security.acl.principal.AclUser;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public final class Prefetched {
    static PrefetchedData data = new PrefetchedData();
    private static final Consumer<EntityModificationEvent> ENTITY_LISTENER;
    private static final Consumer<AssetModificationEvent> ASSET_LISTENER;
    private static final Consumer<SettingsModificationEvent> SETTINGS_LISTENER;
    private static final UniversalProductRuleEnvironment UNIVERSAL_PRODUCT_RULES_ENVIRONMENT;
    private static final UniversalProductNomenclatureRulesEnvironment UNIVERSAL_PRODUCT_NOMENCLATURE_RULES_ENVIRONMENT;

    private static void initiateReload() {
        FxUtil.submitToFxThread(() -> Notifications.get().submitTask(Prefetched::load, Messages.General_Data_loading1));
    }

    public static PrefetchedData getData() {
        return data;
    }

    public static void load() throws Exception {
        PrefetchedHelper.AgentDataInfo agentDataInfo = PrefetchedHelper.getAgentDataInfo();
        data = ((StandardFxService)RpcServiceManager.get().getService(StandardFxService.class)).getPrefetchedData(ServiceInvocationContext.get(), agentDataInfo.getAgencyUid(), agentDataInfo.getSalesPointUid(), agentDataInfo.getCashUid(), agentDataInfo.getCashRegisterUid(), agentDataInfo.getCashRegisterWorkplaceUid());
        Prefetched.updateUniversalProductRules();
    }

    static GlobalSettingsService createSettings() {
        return new GlobalSettingsService(){

            public String getDefaultCurrency() {
                return data.getEquivalentCurrency();
            }

            public boolean isRestrictedTextSearch() {
                return data.isRestrictedTextSearch();
            }

            public List<String> getPreferredCurrencies() {
                return data.getPreferredCurrencies();
            }
        };
    }

    private static void updateUniversalProductRules() {
        ArrayList<EntityReference> ruleSupportingRefs = new ArrayList<EntityReference>();
        ArrayList<EntityContainer> ruleSupportingCtrs = new ArrayList<EntityContainer>();
        ArrayList<EntityReference> allRefs = new ArrayList<EntityReference>();
        ArrayList<EntityContainer> allCtrs = new ArrayList<EntityContainer>();
        for (UniversalProductDescriptionData upData : data.getUniversalProductDescriptionData()) {
            EntityContainer ctr = EntityContainer.create((BaseEntity)upData.getData(), (String)upData.getReference().getUid());
            allRefs.add(upData.getReference());
            allCtrs.add(ctr);
            if (!upData.getData().isRulesSupported()) continue;
            ruleSupportingRefs.add(upData.getReference());
            ruleSupportingCtrs.add(ctr);
        }
        UNIVERSAL_PRODUCT_RULES_ENVIRONMENT.deleteInactualTargets(ruleSupportingRefs);
        for (EntityContainer ctr : ruleSupportingCtrs) {
            UNIVERSAL_PRODUCT_RULES_ENVIRONMENT.updateRuleEnvironment(ctr);
        }
        UNIVERSAL_PRODUCT_NOMENCLATURE_RULES_ENVIRONMENT.deleteInactualTargets(allRefs);
        UNIVERSAL_PRODUCT_NOMENCLATURE_RULES_ENVIRONMENT.initializeEnvironment(allCtrs);
    }

    private Prefetched() {
    }

    static {
        UNIVERSAL_PRODUCT_RULES_ENVIRONMENT = new UniversalProductRuleEnvironment();
        UNIVERSAL_PRODUCT_NOMENCLATURE_RULES_ENVIRONMENT = new UniversalProductNomenclatureRulesEnvironment();
        ENTITY_LISTENER = evt -> {
            AgentData agentData = data.getCurrentAgentData();
            Set triggersClassNames = data.getReloadTriggersClassNames();
            HashSet<String> interestingUids = new HashSet<String>();
            if (agentData.getAgent() != null) {
                interestingUids.add(agentData.getAgent().getUid());
            }
            if (agentData.getAgency() != null) {
                interestingUids.add(agentData.getAgency().getUid());
            }
            if (agentData.getSubagency() != null) {
                interestingUids.add(agentData.getSubagency().getUid());
            }
            if (agentData.getSalesPoint() != null) {
                interestingUids.add(agentData.getSalesPoint().getUid());
            }
            for (EntityModification mod : evt.getModifications()) {
                if (mod.getReference() == null || !interestingUids.contains(mod.getReference().getUid()) && !mod.getReference().getType().isAssignableFrom(UniversalProductDescription.class) && !triggersClassNames.contains(mod.getReference().getType().getName())) continue;
                Prefetched.initiateReload();
                return;
            }
        };
        ASSET_LISTENER = evt -> {
            for (AssetModification modification : evt.getModifications()) {
                if (!(modification.getAsset() instanceof AclUser) || !TextUtil.isSame((String)((AclUser)modification.getAsset()).getId(), (String)ServiceInvocationContext.get().getUser())) continue;
                Prefetched.initiateReload();
                return;
            }
        };
        SETTINGS_LISTENER = evt -> Prefetched.initiateReload();
        EventBus.get().subscribe(EntityModificationEvent.TYPE, ENTITY_LISTENER);
        EventBus.get().subscribe(AssetModificationEvent.TYPE, ASSET_LISTENER);
        EventBus.get().subscribe(SettingsModificationEvent.TYPE, SETTINGS_LISTENER);
    }
}

