/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.processing;

import com.gridnine.xtrip.client.fx.standard.processing.FileProcessor;
import com.gridnine.xtrip.common.fx.rpc.ExchangeFilesService;
import com.gridnine.xtrip.common.parsers.model.ExchangeDocumentRegistrationResult;
import com.gridnine.xtrip.common.parsers.model.ExchangeDocumentRegistrationResultType;
import com.gridnine.xtrip.common.parsers.model.ExchangeFile;
import com.gridnine.xtrip.common.parsers.register.ExchageDocumentResource;
import com.gridnine.xtrip.common.parsers.register.ExchageDocumentResourceProvider;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseExchangeFileProcessor<E extends ExchageDocumentResource>
implements FileProcessor {
    protected final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private ExchageDocumentResourceProvider<E> resourceProvider;

    protected abstract ExchageDocumentResourceProvider<E> createResourceProvider();

    @Override
    public void process() {
        List resources;
        try {
            resources = this.getResourceProvider().getResources();
        }
        catch (Exception e) {
            this.log.error("unable to get resources list", (Throwable)e);
            return;
        }
        if (resources.isEmpty()) {
            return;
        }
        ExchangeFilesService service = null;
        ServiceInvocationContext ctx = ServiceInvocationContext.get();
        try {
            service = (ExchangeFilesService)RpcServiceManager.get().getService(ExchangeFilesService.class);
        }
        catch (Exception e) {
            this.log.error("failed retrieving exchange service", (Throwable)e);
            return;
        }
        for (ExchageDocumentResource resource : resources) {
            if (this.isGeneralProblemExists()) {
                this.log.info("general problem exists, skipping processing");
                return;
            }
            try {
                ExchangeDocumentRegistrationResult result = this.process(service, ctx, resource);
                if (result.getResultType() == ExchangeDocumentRegistrationResultType.OK) {
                    this.getResourceProvider().moveTo(resource, "processed");
                    this.log.debug("resources processed " + resource.getName());
                    continue;
                }
                if (result.getResultType() == ExchangeDocumentRegistrationResultType.IGNORE) {
                    String folderName = TextUtil.isBlank((String)result.getFolderName()) ? "ignored" : result.getFolderName();
                    this.getResourceProvider().moveTo(resource, folderName);
                    this.log.debug("resources ignored " + resource.getName());
                    continue;
                }
                this.log.error("failed processing resources " + resource.getName());
                try {
                    this.getResourceProvider().moveTo(resource, "error");
                }
                catch (Exception e1) {
                    this.log.error("unable to move resource to error folder", (Throwable)e1);
                }
            }
            catch (Throwable e) {
                this.log.error("failed processing resources " + resource.getName(), e);
                try {
                    this.getResourceProvider().moveTo(resource, "error");
                }
                catch (Exception e1) {
                    this.log.error("unable to move resource to error folder", (Throwable)e1);
                }
            }
        }
    }

    protected ExchangeDocumentRegistrationResult process(ExchangeFilesService service, ServiceInvocationContext ctx, E resource) throws Throwable {
        ExchangeFile exch = new ExchangeFile();
        exch.setType(this.getFileType());
        exch.setCreated(resource.getLastModified());
        exch.setLocation(resource.getName());
        exch.setContent(this.getResourceProvider().getContent(resource));
        return service.registerExchangeFile(ctx, exch);
    }

    protected boolean isGeneralProblemExists() {
        return false;
    }

    protected ExchageDocumentResourceProvider<E> getResourceProvider() {
        if (this.resourceProvider == null) {
            this.resourceProvider = this.createResourceProvider();
        }
        return this.resourceProvider;
    }
}

