/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.processing;

import com.gridnine.xtrip.client.fx.core.registry.basic.AppStartHook;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.ClientSettings;
import com.gridnine.xtrip.client.fx.standard.processing.FileProcessor;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessingAppStartHook
implements AppStartHook {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public String getId() {
        return "processing-scheduler";
    }

    public double getWeight() {
        return 100.0;
    }

    public void execute() {
        ClientSettings cfg = ClientSettings.get();
        String enabledStr = cfg.getProperty("import.enabled", "true");
        boolean enabled = true;
        if (enabledStr != null) {
            enabled = Boolean.parseBoolean(enabledStr);
        }
        if (!enabled) {
            this.log.debug("Process files task diactivated");
            return;
        }
        String periodStr = cfg.getProperty("import.period", null);
        long period = -1L;
        if (!TextUtil.isBlank((String)periodStr)) {
            periodStr = periodStr.trim();
            try {
                period = Long.parseLong(periodStr) * 1000L;
                this.log.info("task period is " + periodStr);
            }
            catch (Exception e) {
                this.log.error("error reading task period value from config, using default 15 sec", (Throwable)e);
                period = 15000L;
            }
        } else {
            period = 15000L;
            this.log.info("task period value is undefined in config, using default 15 sec");
        }
        long delay = -1L;
        String delayStr = cfg.getProperty("import.delay", null);
        if (!TextUtil.isBlank((String)delayStr)) {
            delayStr = delayStr.trim();
            try {
                delay = Long.parseLong(delayStr) * 1000L;
                this.log.info("task delay is " + delayStr);
            }
            catch (Exception e) {
                this.log.error("error reading task delay value from config, using default 15 sec", (Throwable)e);
                delay = period;
            }
        } else {
            delay = period;
            this.log.info("task delay value is undefined in config, using default 15 sec");
        }
        Notifications.get().getScheduler().scheduleWithFixedDelay(this::process, delay, period, TimeUnit.MILLISECONDS);
        this.log.debug("Process files task activated");
    }

    private synchronized void process() {
        for (FileProcessor processor : FileProcessor.getAllProcessors()) {
            try {
                processor.process();
            }
            catch (Throwable t) {
                this.log.error("an unexpected error has occurred: " + t.getMessage(), t);
            }
        }
    }
}

