/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.renderer;

import com.gridnine.xtrip.client.fx.core.entity.EntityIndexHandler;
import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SimpleSuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.widgets.DateTimeValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.NodeRenderer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.PriceValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.Suppliers;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.DictBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.NestedEntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.BooleanValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.model.system.ValidatorValuePair;
import com.gridnine.xtrip.client.fx.standard.custom.ValidatorEntityBoxWidget;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CommonProductIndex;
import com.gridnine.xtrip.common.model.booking.TchCreditCardAccompanyingDocumentType;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductDescription;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProvider;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.HotelTariffType;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.profile.BaseProfile;
import com.gridnine.xtrip.common.model.profile.Branch;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.Holding;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.BaseFileDocument;
import com.gridnine.xtrip.common.model.system.PaymentType;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.function.Supplier;
import javafx.scene.Node;

public enum StandardNodeRenderer implements NodeRenderer
{
    TEXTFIELD{

        public Node createNode(boolean readonly) {
            return new TextFieldWidget(readonly);
        }

        public Object getValue(Node node) {
            return node != null ? ((TextFieldWidget)node).getValue() : null;
        }

        public void setValue(Node node, Object value) {
            ((TextFieldWidget)node).setValue((String)value);
        }

        public void setReadonly(boolean readonly, Node node) {
            ((TextFieldWidget)node).getViewState().setReadonly(readonly);
        }

        @Override
        public String serializeValue(Object value) {
            return (String)value;
        }
    }
    ,
    ENTITYBOX_PRODUCT{

        public Node createNode(boolean readonly) {
            NestedEntityBoxWidget node = new NestedEntityBoxWidget(BookingFile.class, BaseProduct.class, readonly);
            node.setListParametersSupplier(() -> EntityIndexHandler.forId((String)CommonProductIndex.class.getName()).createListParameters());
            node.setNestedReferenceBuilder(item -> new NestedEntityReference(item.getSource(), item.getNavigationKey(), BaseProduct.class, String.format("%s %s (%s)", ((CommonProductIndex)item).getProductType() != null ? ((CommonProductIndex)item).getProductType() : "?", ((CommonProductIndex)item).getFirstSystemNumber() != null ? ((CommonProductIndex)item).getFirstSystemNumber() : "?", ((CommonProductIndex)item).getStatus() != null ? ((CommonProductIndex)item).getStatus() : "?")));
            return node;
        }

        public Object getValue(Node node) {
            return node != null ? ((NestedEntityBoxWidget)node).getValue() : null;
        }

        public void setValue(Node node, Object value) {
            ((NestedEntityBoxWidget)node).setValue((EntityReference)((NestedEntityReference)value));
        }

        public void setReadonly(boolean readonly, Node node) {
            ((NestedEntityBoxWidget)node).getViewState().setReadonly(readonly);
        }

        @Override
        public String serializeValue(Object value) {
            return null;
        }

        @Override
        public <P extends BaseProfile> void setListParametersSupplier(Node node, Supplier<IndexListParameters<P, ?>> value) {
        }
    }
    ,
    ENTITYBOX_FINANCE_DOCUMENT{

        public Node createNode(boolean readonly) {
            EntityBoxWidget node = new EntityBoxWidget(FinanceDocument.class, readonly);
            return node;
        }

        public Object getValue(Node node) {
            return node != null ? ((EntityBoxWidget)node).getValue() : null;
        }

        public void setValue(Node node, Object value) {
            ((EntityBoxWidget)node).setValue((EntityReference)value);
        }

        public void setReadonly(boolean readonly, Node node) {
            ((EntityBoxWidget)node).getViewState().setReadonly(readonly);
        }

        @Override
        public String serializeValue(Object value) {
            return null;
        }

        @Override
        public <P extends BaseProfile> void setListParametersSupplier(Node node, Supplier<IndexListParameters<P, ?>> value) {
        }
    }
    ,
    ENTITYBOX_DOCUMENT{

        public Node createNode(boolean readonly) {
            EntityBoxWidget node = new EntityBoxWidget(BaseFileDocument.class, readonly);
            return node;
        }

        public Object getValue(Node node) {
            return node != null ? ((EntityBoxWidget)node).getValue() : null;
        }

        public void setValue(Node node, Object value) {
            ((EntityBoxWidget)node).setValue((EntityReference)value);
        }

        public void setReadonly(boolean readonly, Node node) {
            ((EntityBoxWidget)node).getViewState().setReadonly(readonly);
        }

        @Override
        public String serializeValue(Object value) {
            return null;
        }

        @Override
        public <P extends BaseProfile> void setListParametersSupplier(Node node, Supplier<IndexListParameters<P, ?>> value) {
        }
    }
    ,
    ENTITYBOX_PERSON{

        public Node createNode(boolean readonly) {
            return new EntityBoxWidget(Person.class, readonly);
        }

        public Object getValue(Node node) {
            return node != null ? ((EntityBoxWidget)node).getValue() : null;
        }

        public void setValue(Node node, Object value) {
            ((EntityBoxWidget)node).setValue((EntityReference)value);
        }

        public void setReadonly(boolean readonly, Node node) {
            ((EntityBoxWidget)node).getViewState().setReadonly(readonly);
        }

        @Override
        public String serializeValue(Object value) {
            return ((EntityReference)value).getUid();
        }

        @Override
        public <P extends BaseProfile> void setListParametersSupplier(Node node, Supplier<IndexListParameters<P, ?>> value) {
            ((EntityBoxWidget)node).setListParametersSupplier(value);
        }
    }
    ,
    ENTITYBOX_ORGANIZATION{

        public Node createNode(boolean readonly) {
            return new EntityBoxWidget(Organization.class, readonly);
        }

        public Object getValue(Node node) {
            return node != null ? ((EntityBoxWidget)node).getValue() : null;
        }

        public void setValue(Node node, Object value) {
            ((EntityBoxWidget)node).setValue((EntityReference)value);
        }

        public void setReadonly(boolean readonly, Node node) {
            ((EntityBoxWidget)node).getViewState().setReadonly(readonly);
        }

        @Override
        public String serializeValue(Object value) {
            return ((EntityReference)value).getUid();
        }

        @Override
        public <P extends BaseProfile> void setListParametersSupplier(Node node, Supplier<IndexListParameters<P, ?>> value) {
            ((EntityBoxWidget)node).setListParametersSupplier(value);
        }
    }
    ,
    ENTITYBOX_HOLDING{

        public Node createNode(boolean readonly) {
            return new EntityBoxWidget(Holding.class, readonly);
        }

        public Object getValue(Node node) {
            return node != null ? ((EntityBoxWidget)node).getValue() : null;
        }

        public void setValue(Node node, Object value) {
            ((EntityBoxWidget)node).setValue((EntityReference)value);
        }

        public void setReadonly(boolean readonly, Node node) {
            ((EntityBoxWidget)node).getViewState().setReadonly(readonly);
        }

        @Override
        public String serializeValue(Object value) {
            return ((EntityReference)value).getUid();
        }

        @Override
        public <P extends BaseProfile> void setListParametersSupplier(Node node, Supplier<IndexListParameters<P, ?>> value) {
            ((EntityBoxWidget)node).setListParametersSupplier(value);
        }
    }
    ,
    ENTITYBOX_VALIDATOR{

        public Node createNode(boolean readonly) {
            return new ValidatorEntityBoxWidget(readonly);
        }

        public Object getValue(Node node) {
            return node != null ? ((ValidatorEntityBoxWidget)node).getValidatorCode() : null;
        }

        public void setValue(Node node, Object value) {
            ((ValidatorEntityBoxWidget)node).readData((ValidatorValuePair)value);
        }

        public void setReadonly(boolean readonly, Node node) {
            ((ValidatorEntityBoxWidget)node).getViewState().setReadonly(readonly);
        }

        @Override
        public String serializeValue(Object value) {
            return (String)value;
        }
    }
    ,
    ENTITYBOX_BRANCH{

        public Node createNode(boolean readonly) {
            return new EntityBoxWidget(Branch.class, readonly);
        }

        public Object getValue(Node node) {
            return node != null ? ((EntityBoxWidget)node).getValue() : null;
        }

        public void setValue(Node node, Object value) {
            ((EntityBoxWidget)node).setValue((EntityReference)value);
        }

        public void setReadonly(boolean readonly, Node node) {
            ((EntityBoxWidget)node).getViewState().setReadonly(readonly);
        }

        @Override
        public String serializeValue(Object value) {
            return ((EntityReference)value).getUid();
        }

        @Override
        public <P extends BaseProfile> void setListParametersSupplier(Node node, Supplier<IndexListParameters<P, ?>> value) {
            ((EntityBoxWidget)node).setListParametersSupplier(value);
        }
    }
    ,
    ENTITYBOX_SALES_POINT{

        public Node createNode(boolean readonly) {
            return new EntityBoxWidget(SalesPoint.class, readonly);
        }

        public Object getValue(Node node) {
            return node != null ? ((EntityBoxWidget)node).getValue() : null;
        }

        public void setValue(Node node, Object value) {
            ((EntityBoxWidget)node).setValue((EntityReference)value);
        }

        public void setReadonly(boolean readonly, Node node) {
            ((EntityBoxWidget)node).getViewState().setReadonly(readonly);
        }

        @Override
        public String serializeValue(Object value) {
            return ((EntityReference)value).getUid();
        }

        @Override
        public <P extends BaseProfile> void setListParametersSupplier(Node node, Supplier<IndexListParameters<P, ?>> value) {
            ((EntityBoxWidget)node).setListParametersSupplier(value);
        }
    }
    ,
    ENTITYBOX_CONTRACT{

        public Node createNode(boolean readonly) {
            return new EntityBoxWidget(Contract.class, readonly);
        }

        public Object getValue(Node node) {
            return node != null ? ((EntityBoxWidget)node).getValue() : null;
        }

        public void setValue(Node node, Object value) {
            ((EntityBoxWidget)node).setValue((EntityReference)value);
        }

        public void setReadonly(boolean readonly, Node node) {
            ((EntityBoxWidget)node).getViewState().setReadonly(readonly);
        }

        @Override
        public String serializeValue(Object value) {
            return ((EntityReference)value).getUid();
        }

        @Override
        public <P extends BaseProfile> void setListParametersSupplier(Node node, Supplier<IndexListParameters<P, ?>> value) {
            ((EntityBoxWidget)node).setListParametersSupplier(value);
        }
    }
    ,
    ENTITYBOX_UNIVERSAL_PRODUCT_DESCRIPTION{

        public Node createNode(boolean readonly) {
            return new EntityBoxWidget(UniversalProductDescription.class, readonly);
        }

        public Object getValue(Node node) {
            return node != null ? ((EntityBoxWidget)node).getValue() : null;
        }

        public void setValue(Node node, Object value) {
            ((EntityBoxWidget)node).setValue((EntityReference)value);
        }

        public void setReadonly(boolean readonly, Node node) {
            ((EntityBoxWidget)node).getViewState().setReadonly(readonly);
        }

        @Override
        public String serializeValue(Object value) {
            return ((EntityReference)value).getUid();
        }

        @Override
        public <P extends BaseProfile> void setListParametersSupplier(Node node, Supplier<IndexListParameters<P, ?>> value) {
            ((EntityBoxWidget)node).setListParametersSupplier(value);
        }
    }
    ,
    ENUMBOX_TCH_ACC_DOC{

        public Node createNode(boolean readonly) {
            ComboBoxWidget comboBoxWidget = new ComboBoxWidget(readonly);
            comboBoxWidget.setItemsSupplier(Suppliers.createEnumSupplier(TchCreditCardAccompanyingDocumentType.class));
            comboBoxWidget.setSuggestionsHandler((SuggestionsHandler)new SimpleSuggestionsHandler(comboBoxWidget.getConverter(), () -> (List)comboBoxWidget.getItemsSupplier().get(), comboBoxWidget.isSortItems()));
            return comboBoxWidget;
        }

        public Object getValue(Node node) {
            return node != null ? ((ComboBoxWidget)node).getValue() : null;
        }

        public void setValue(Node node, Object value) {
            ((ComboBoxWidget)node).setValue((Object)((TchCreditCardAccompanyingDocumentType)value));
        }

        public void setReadonly(boolean readonly, Node node) {
            ((ComboBoxWidget)node).getViewState().setReadonly(readonly);
        }

        @Override
        public String serializeValue(Object value) {
            return ((TchCreditCardAccompanyingDocumentType)value).name();
        }
    }
    ,
    BOOLEAN{

        public Node createNode(boolean readonly) {
            return new BooleanValueWidget(false, readonly);
        }

        public Object getValue(Node node) {
            return node != null ? Boolean.valueOf(((BooleanValueWidget)node).getValue()) : null;
        }

        public void setValue(Node node, Object value) {
            Boolean aBoolean = (Boolean)value;
            if (value != null) {
                ((BooleanValueWidget)node).setValue(aBoolean.booleanValue());
            }
        }

        public void setReadonly(boolean readonly, Node node) {
            ((BooleanValueWidget)node).getViewState().setReadonly(readonly);
        }

        @Override
        public String serializeValue(Object value) {
            return value.toString();
        }
    }
    ,
    BOOLEAN_COMPACT{

        public Node createNode(boolean readonly) {
            return new BooleanValueWidget(true, readonly);
        }

        public Object getValue(Node node) {
            return node != null ? Boolean.valueOf(((BooleanValueWidget)node).getValue()) : null;
        }

        public void setValue(Node node, Object value) {
            Boolean aBoolean = (Boolean)value;
            if (value != null) {
                ((BooleanValueWidget)node).setValue(aBoolean.booleanValue());
            }
        }

        public void setReadonly(boolean readonly, Node node) {
            ((BooleanValueWidget)node).getViewState().setReadonly(readonly);
        }

        @Override
        public String serializeValue(Object value) {
            return value.toString();
        }
    }
    ,
    PRICE{

        public Node createNode(boolean readonly) {
            return new PriceValueWidget(readonly);
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return ((PriceValueWidget)node).valueProperty().get();
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            ((PriceValueWidget)node).valueProperty().set((Object)((BigDecimal)value));
        }

        public void setReadonly(boolean readonly, Node node) {
            ((PriceValueWidget)node).getViewState().setReadonly(readonly);
        }

        @Override
        public String serializeValue(Object value) {
            return value.toString();
        }
    }
    ,
    DATETIME{

        public Node createNode(boolean readonly) {
            return new DateTimeValueWidget(readonly);
        }

        public Object getValue(Node node) {
            return node != null ? ((DateTimeValueWidget)node).getValue() : null;
        }

        public void setValue(Node node, Object value) {
            ((DateTimeValueWidget)node).setValue((LocalDateTime)value);
        }

        public void setReadonly(boolean readonly, Node node) {
            ((DateTimeValueWidget)node).getViewState().setReadonly(readonly);
        }

        @Override
        public String serializeValue(Object value) {
            return value.toString();
        }
    }
    ,
    ENUMBOX_MCO_CATEGORY{

        public Node createNode(boolean readonly) {
            ComboBoxWidget comboBoxWidget = new ComboBoxWidget(readonly);
            comboBoxWidget.setItemsSupplier(Suppliers.createEnumSupplier(MCOCategory.class));
            comboBoxWidget.setSuggestionsHandler((SuggestionsHandler)new SimpleSuggestionsHandler(comboBoxWidget.getConverter(), () -> (List)comboBoxWidget.getItemsSupplier().get(), comboBoxWidget.isSortItems()));
            return comboBoxWidget;
        }

        public Object getValue(Node node) {
            return node != null ? ((ComboBoxWidget)node).getValue() : null;
        }

        public void setValue(Node node, Object value) {
            ((ComboBoxWidget)node).setValue((Object)((MCOCategory)value));
        }

        public void setReadonly(boolean readonly, Node node) {
            ((ComboBoxWidget)node).getViewState().setReadonly(readonly);
        }

        @Override
        public String serializeValue(Object value) {
            return ((MCOCategory)value).name();
        }
    }
    ,
    ENUMBOX_TARIFF_TYPE{

        public Node createNode(boolean readonly) {
            ComboBoxWidget comboBoxWidget = new ComboBoxWidget(readonly);
            comboBoxWidget.setItemsSupplier(Suppliers.createEnumSupplier(TariffType.class));
            comboBoxWidget.setSuggestionsHandler((SuggestionsHandler)new SimpleSuggestionsHandler(comboBoxWidget.getConverter(), () -> (List)comboBoxWidget.getItemsSupplier().get(), comboBoxWidget.isSortItems()));
            return comboBoxWidget;
        }

        public Object getValue(Node node) {
            return node != null ? ((ComboBoxWidget)node).getValue() : null;
        }

        public void setValue(Node node, Object value) {
            ((ComboBoxWidget)node).setValue((Object)((TariffType)value));
        }

        public void setReadonly(boolean readonly, Node node) {
            ((ComboBoxWidget)node).getViewState().setReadonly(readonly);
        }

        @Override
        public String serializeValue(Object value) {
            return ((TariffType)value).name();
        }
    }
    ,
    ENUMBOX_HOTEL_TARIFF_TYPE{

        public Node createNode(boolean readonly) {
            ComboBoxWidget comboBoxWidget = new ComboBoxWidget(readonly);
            comboBoxWidget.setItemsSupplier(Suppliers.createEnumSupplier(HotelTariffType.class));
            comboBoxWidget.setSuggestionsHandler((SuggestionsHandler)new SimpleSuggestionsHandler(comboBoxWidget.getConverter(), () -> (List)comboBoxWidget.getItemsSupplier().get(), comboBoxWidget.isSortItems()));
            return comboBoxWidget;
        }

        public Object getValue(Node node) {
            return node != null ? ((ComboBoxWidget)node).getValue() : null;
        }

        public void setValue(Node node, Object value) {
            ((ComboBoxWidget)node).setValue((Object)((HotelTariffType)value));
        }

        public void setReadonly(boolean readonly, Node node) {
            ((ComboBoxWidget)node).getViewState().setReadonly(readonly);
        }

        @Override
        public String serializeValue(Object value) {
            return ((TariffType)value).name();
        }
    }
    ,
    ENUMBOX_HOTEL_PROVIDER{

        public Node createNode(boolean readonly) {
            ComboBoxWidget comboBoxWidget = new ComboBoxWidget(readonly);
            comboBoxWidget.setItemsSupplier(Suppliers.createEnumSupplier(HotelProvider.class));
            comboBoxWidget.setSuggestionsHandler((SuggestionsHandler)new SimpleSuggestionsHandler(comboBoxWidget.getConverter(), () -> (List)comboBoxWidget.getItemsSupplier().get(), comboBoxWidget.isSortItems()));
            return comboBoxWidget;
        }

        public Object getValue(Node node) {
            return node != null ? ((ComboBoxWidget)node).getValue() : null;
        }

        public void setValue(Node node, Object value) {
            ((ComboBoxWidget)node).setValue((Object)((HotelProvider)value));
        }

        public void setReadonly(boolean readonly, Node node) {
            ((ComboBoxWidget)node).getViewState().setReadonly(readonly);
        }

        @Override
        public String serializeValue(Object value) {
            return ((HotelProvider)value).name();
        }
    }
    ,
    ENUMBOX_TICKET_TYPE{

        public Node createNode(boolean readonly) {
            ComboBoxWidget comboBoxWidget = new ComboBoxWidget(readonly);
            comboBoxWidget.setItemsSupplier(Suppliers.createEnumSupplier(TicketType.class));
            comboBoxWidget.setSuggestionsHandler((SuggestionsHandler)new SimpleSuggestionsHandler(comboBoxWidget.getConverter(), () -> (List)comboBoxWidget.getItemsSupplier().get(), comboBoxWidget.isSortItems()));
            return comboBoxWidget;
        }

        public Object getValue(Node node) {
            return node != null ? ((ComboBoxWidget)node).getValue() : null;
        }

        public void setValue(Node node, Object value) {
            ((ComboBoxWidget)node).setValue((Object)((TicketType)value));
        }

        public void setReadonly(boolean readonly, Node node) {
            ((ComboBoxWidget)node).getViewState().setReadonly(readonly);
        }

        @Override
        public String serializeValue(Object value) {
            return ((TicketType)value).name();
        }
    }
    ,
    ENUMBOX_BLANK_TYPE{

        public Node createNode(boolean readonly) {
            DictBoxWidget dictBoxWidget = new DictBoxWidget(BlankType.class, readonly);
            return dictBoxWidget;
        }

        public Object getValue(Node node) {
            return node != null ? ((DictBoxWidget)node).getValue() : null;
        }

        public void setValue(Node node, Object value) {
            ((DictBoxWidget)node).setValue((DictionaryReference)value);
        }

        public void setReadonly(boolean readonly, Node node) {
            ((DictBoxWidget)node).getViewState().setReadonly(readonly);
        }

        @Override
        public String serializeValue(Object value) {
            return ((DictionaryReference)value).getCode();
        }
    }
    ,
    ENUMBOX_PAYMENT_TYPE{

        public Node createNode(boolean readonly) {
            ComboBoxWidget comboBoxWidget = new ComboBoxWidget(readonly);
            comboBoxWidget.setItemsSupplier(Suppliers.createEnumSupplier(PaymentType.class));
            comboBoxWidget.setSuggestionsHandler((SuggestionsHandler)new SimpleSuggestionsHandler(comboBoxWidget.getConverter(), () -> (List)comboBoxWidget.getItemsSupplier().get(), comboBoxWidget.isSortItems()));
            return comboBoxWidget;
        }

        public Object getValue(Node node) {
            return node != null ? ((ComboBoxWidget)node).getValue() : null;
        }

        public void setValue(Node node, Object value) {
            ((ComboBoxWidget)node).setValue((Object)((PaymentType)value));
        }

        public void setReadonly(boolean readonly, Node node) {
            ((ComboBoxWidget)node).getViewState().setReadonly(readonly);
        }

        @Override
        public String serializeValue(Object value) {
            return ((PaymentType)value).name();
        }

        @Override
        public <T> void setItemSupplier(Node node, Supplier<List<T>> value) {
            ((ComboBoxWidget)node).setItemsSupplier(value);
        }
    };


    public abstract String serializeValue(Object var1);

    public <P extends BaseProfile> void setListParametersSupplier(Node node, Supplier<IndexListParameters<P, ?>> value) {
        throw new RuntimeException("Not implemented");
    }

    public <T> void setItemSupplier(Node node, Supplier<List<T>> value) {
        throw new RuntimeException("Not implemented");
    }
}

