/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.renderer;

import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SimpleSuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.widgets.DateTimeValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.DateValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.DoubleValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.FloatValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.IntValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.LongValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.PriceValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.Suppliers;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.CurrencyValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.DictBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.LocaleValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.pair.PairWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.pair.PairWidgetHandler;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.BooleanValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ValuesWidget;
import com.gridnine.xtrip.client.fx.core.property.ValueRendererRegistryItem;
import com.gridnine.xtrip.client.fx.standard.renderer.StubWidget;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.util.Pair;
import com.gridnine.xtrip.common.value.renderer.StandardValueRendererCategory;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javafx.scene.Node;

public enum StandardValueRenderers implements ValueRendererRegistryItem
{
    NULL{

        public String getCategoryId() {
            return StandardValueRendererCategory.NULL.name();
        }

        public Node createNode(Class<?> type) {
            StubWidget node = new StubWidget();
            return node;
        }

        public Object getValue(Node node) {
            return null;
        }

        public void setValue(Node node, Object value) {
        }

        public void setEditable(Node node, boolean editable) {
        }

        public boolean isValueEmpty(Node node) {
            return true;
        }
    }
    ,
    BOOLEAN{

        public String getCategoryId() {
            return StandardValueRendererCategory.BOOLEAN.name();
        }

        public Node createNode(Class<?> type) {
            BooleanValueWidget node = new BooleanValueWidget(true, false);
            return node;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return ((BooleanValueWidget)node).getValue();
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            ((BooleanValueWidget)node).setValue(value != null ? (Boolean)value : false);
        }

        public void setEditable(Node node, boolean editable) {
            if (node == null) {
                return;
            }
            ((BooleanValueWidget)node).getViewState().setReadonly(!editable);
        }

        public boolean isValueEmpty(Node node) {
            return node == null;
        }
    }
    ,
    STRING{

        public String getCategoryId() {
            return StandardValueRendererCategory.STRING.name();
        }

        public Node createNode(Class<?> type) {
            TextFieldWidget node = new TextFieldWidget(false);
            return node;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return ((TextFieldWidget)node).getValue();
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            ((TextFieldWidget)node).setValue(value != null ? (String)value : null);
        }

        public void setEditable(Node node, boolean editable) {
            if (node == null) {
                return;
            }
            ((TextFieldWidget)node).getViewState().setReadonly(!editable);
        }

        public boolean isValueEmpty(Node node) {
            if (node == null) {
                return true;
            }
            return ((TextFieldWidget)node).getValue() == null;
        }
    }
    ,
    STRING_LIST{

        public String getCategoryId() {
            return StandardValueRendererCategory.STRING_LIST.name();
        }

        public Node createNode(Class<?> type) {
            TextFieldWidget node = new TextFieldWidget(false);
            return node;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return ((TextFieldWidget)node).getValue() != null ? Collections.singletonList(((TextFieldWidget)node).getValue()) : Collections.emptyList();
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            ((TextFieldWidget)node).setValue(value != null && ((List)value).size() > 0 ? (String)((List)value).get(0) : null);
        }

        public void setEditable(Node node, boolean editable) {
            if (node == null) {
                return;
            }
            ((TextFieldWidget)node).getViewState().setReadonly(!editable);
        }

        public boolean isValueEmpty(Node node) {
            if (node == null) {
                return true;
            }
            return ((TextFieldWidget)node).getValue() == null;
        }
    }
    ,
    BIG_DECIMAL{

        public String getCategoryId() {
            return StandardValueRendererCategory.BIG_DECIMAL.name();
        }

        public Node createNode(Class<?> type) {
            PriceValueWidget node = new PriceValueWidget(false);
            return node;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return ((PriceValueWidget)node).getValue();
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            ((PriceValueWidget)node).setValue((Number)(value != null ? (BigDecimal)value : null));
        }

        public void setEditable(Node node, boolean editable) {
            if (node == null) {
                return;
            }
            ((PriceValueWidget)node).getViewState().setReadonly(!editable);
        }

        public boolean isValueEmpty(Node node) {
            if (node == null) {
                return true;
            }
            return ((PriceValueWidget)node).getValue() == null;
        }
    }
    ,
    BIG_DECIMAL_INTERVAL{

        public String getCategoryId() {
            return StandardValueRendererCategory.BIG_DECIMAL_INTERVAL.name();
        }

        public Node createNode(Class<?> type) {
            PairWidget node = new PairWidget(PairWidgetHandler.PRICE, false);
            return node;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return new Pair(((PairWidget)node).getFirstValue(), ((PairWidget)node).getSecondValue());
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            ((PairWidget)node).setFirstValue(value != null ? (BigDecimal)((Pair)value).getFirst() : null);
            ((PairWidget)node).setSecondValue(value != null ? (BigDecimal)((Pair)value).getLast() : null);
        }

        public void setEditable(Node node, boolean editable) {
            if (node == null) {
                return;
            }
            ((PairWidget)node).getViewState().setReadonly(!editable);
        }

        public boolean isValueEmpty(Node node) {
            if (node == null) {
                return true;
            }
            return ((PairWidget)node).getFirstValue() == null && ((PairWidget)node).getSecondValue() == null;
        }
    }
    ,
    DOUBLE{

        public String getCategoryId() {
            return StandardValueRendererCategory.DOUBLE.name();
        }

        public Node createNode(Class<?> type) {
            DoubleValueWidget node = new DoubleValueWidget(false);
            return node;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return ((DoubleValueWidget)node).getValue();
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            ((DoubleValueWidget)node).setValue((Number)(value != null ? (Double)value : null));
        }

        public void setEditable(Node node, boolean editable) {
            if (node == null) {
                return;
            }
            ((DoubleValueWidget)node).getViewState().setReadonly(!editable);
        }

        public boolean isValueEmpty(Node node) {
            if (node == null) {
                return true;
            }
            return ((DoubleValueWidget)node).getValue() == null;
        }
    }
    ,
    DOUBLE_INTERVAL{

        public String getCategoryId() {
            return StandardValueRendererCategory.DOUBLE_INTERVAL.name();
        }

        public Node createNode(Class<?> type) {
            PairWidget node = new PairWidget(PairWidgetHandler.DOUBLE, false);
            return node;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return new Pair(((PairWidget)node).getFirstValue(), ((PairWidget)node).getSecondValue());
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            ((PairWidget)node).setFirstValue(value != null ? (Double)((Pair)value).getFirst() : null);
            ((PairWidget)node).setSecondValue(value != null ? (Double)((Pair)value).getLast() : null);
        }

        public void setEditable(Node node, boolean editable) {
            if (node == null) {
                return;
            }
            ((PairWidget)node).getViewState().setReadonly(!editable);
        }

        public boolean isValueEmpty(Node node) {
            if (node == null) {
                return true;
            }
            return ((PairWidget)node).getFirstValue() == null && ((PairWidget)node).getSecondValue() == null;
        }
    }
    ,
    FLOAT{

        public String getCategoryId() {
            return StandardValueRendererCategory.FLOAT.name();
        }

        public Node createNode(Class<?> type) {
            FloatValueWidget node = new FloatValueWidget(false);
            return node;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return ((FloatValueWidget)node).getValue();
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            ((FloatValueWidget)node).setValue((Number)(value != null ? (Float)value : null));
        }

        public void setEditable(Node node, boolean editable) {
            if (node == null) {
                return;
            }
            ((FloatValueWidget)node).getViewState().setReadonly(!editable);
        }

        public boolean isValueEmpty(Node node) {
            if (node == null) {
                return true;
            }
            return ((FloatValueWidget)node).getValue() == null;
        }
    }
    ,
    FLOAT_INTERVAL{

        public String getCategoryId() {
            return StandardValueRendererCategory.FLOAT_INTERVAL.name();
        }

        public Node createNode(Class<?> type) {
            PairWidget node = new PairWidget(PairWidgetHandler.FLOAT, false);
            return node;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return new Pair(((PairWidget)node).getFirstValue(), ((PairWidget)node).getSecondValue());
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            ((PairWidget)node).setFirstValue(value != null ? (Float)((Pair)value).getFirst() : null);
            ((PairWidget)node).setSecondValue(value != null ? (Float)((Pair)value).getLast() : null);
        }

        public void setEditable(Node node, boolean editable) {
            if (node == null) {
                return;
            }
            ((PairWidget)node).getViewState().setReadonly(!editable);
        }

        public boolean isValueEmpty(Node node) {
            if (node == null) {
                return true;
            }
            return ((PairWidget)node).getFirstValue() == null && ((PairWidget)node).getSecondValue() == null;
        }
    }
    ,
    LONG{

        public String getCategoryId() {
            return StandardValueRendererCategory.LONG.name();
        }

        public Node createNode(Class<?> type) {
            LongValueWidget node = new LongValueWidget(false);
            return node;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return ((LongValueWidget)node).getValue();
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            ((LongValueWidget)node).setValue((Number)(value != null ? (Long)value : null));
        }

        public void setEditable(Node node, boolean editable) {
            if (node == null) {
                return;
            }
            ((LongValueWidget)node).getViewState().setReadonly(!editable);
        }

        public boolean isValueEmpty(Node node) {
            if (node == null) {
                return true;
            }
            return ((LongValueWidget)node).getValue() == null;
        }
    }
    ,
    LONG_INTERVAL{

        public String getCategoryId() {
            return StandardValueRendererCategory.LONG_INTERVAL.name();
        }

        public Node createNode(Class<?> type) {
            PairWidget node = new PairWidget(PairWidgetHandler.LONG, false);
            return node;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return new Pair(((PairWidget)node).getFirstValue(), ((PairWidget)node).getSecondValue());
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            ((PairWidget)node).setFirstValue(value != null ? (Long)((Pair)value).getFirst() : null);
            ((PairWidget)node).setSecondValue(value != null ? (Long)((Pair)value).getLast() : null);
        }

        public void setEditable(Node node, boolean editable) {
            if (node == null) {
                return;
            }
            ((PairWidget)node).getViewState().setReadonly(!editable);
        }

        public boolean isValueEmpty(Node node) {
            if (node == null) {
                return true;
            }
            return ((PairWidget)node).getFirstValue() == null && ((PairWidget)node).getSecondValue() == null;
        }
    }
    ,
    INTEGER{

        public String getCategoryId() {
            return StandardValueRendererCategory.INTEGER.name();
        }

        public Node createNode(Class<?> type) {
            IntValueWidget node = new IntValueWidget(false);
            return node;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return ((IntValueWidget)node).getValue();
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            ((IntValueWidget)node).setValue((Number)(value != null ? (Integer)value : null));
        }

        public void setEditable(Node node, boolean editable) {
            if (node == null) {
                return;
            }
            ((IntValueWidget)node).getViewState().setReadonly(!editable);
        }

        public boolean isValueEmpty(Node node) {
            if (node == null) {
                return true;
            }
            return ((IntValueWidget)node).getValue() == null;
        }
    }
    ,
    INTEGER_INTERVAL{

        public String getCategoryId() {
            return StandardValueRendererCategory.INTEGER_INTERVAL.name();
        }

        public Node createNode(Class<?> type) {
            PairWidget node = new PairWidget(PairWidgetHandler.INT, false);
            return node;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return new Pair(((PairWidget)node).getFirstValue(), ((PairWidget)node).getSecondValue());
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            ((PairWidget)node).setFirstValue(value != null ? (Integer)((Pair)value).getFirst() : null);
            ((PairWidget)node).setSecondValue(value != null ? (Integer)((Pair)value).getLast() : null);
        }

        public void setEditable(Node node, boolean editable) {
            if (node == null) {
                return;
            }
            ((PairWidget)node).getViewState().setReadonly(!editable);
        }

        public boolean isValueEmpty(Node node) {
            if (node == null) {
                return true;
            }
            return ((PairWidget)node).getFirstValue() == null && ((PairWidget)node).getSecondValue() == null;
        }
    }
    ,
    SHORT{

        public String getCategoryId() {
            return StandardValueRendererCategory.SHORT.name();
        }

        public Node createNode(Class<?> type) {
            IntValueWidget node = new IntValueWidget(false);
            return node;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return ((IntValueWidget)node).getValue() != null ? Short.valueOf((short)((Integer)((IntValueWidget)node).getValue()).intValue()) : null;
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            ((IntValueWidget)node).setValue(value != null ? Integer.valueOf(((Short)value).intValue()) : null);
        }

        public void setEditable(Node node, boolean editable) {
            if (node == null) {
                return;
            }
            ((IntValueWidget)node).getViewState().setReadonly(!editable);
        }

        public boolean isValueEmpty(Node node) {
            if (node == null) {
                return true;
            }
            return ((IntValueWidget)node).getValue() == null;
        }
    }
    ,
    SHORT_INTERVAL{

        public String getCategoryId() {
            return StandardValueRendererCategory.SHORT_INTERVAL.name();
        }

        public Node createNode(Class<?> type) {
            PairWidget node = new PairWidget(PairWidgetHandler.INT, false);
            return node;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return new Pair((Object)(((PairWidget)node).getFirstValue() != null ? Short.valueOf((short)((Integer)((PairWidget)node).getFirstValue()).intValue()) : null), ((PairWidget)node).getSecondValue() != null ? Short.valueOf((short)((Integer)((PairWidget)node).getSecondValue()).intValue()) : null);
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            ((PairWidget)node).setFirstValue(value != null ? Integer.valueOf(((Short)((Pair)value).getFirst()).intValue()) : null);
            ((PairWidget)node).setSecondValue(value != null ? Integer.valueOf(((Short)((Pair)value).getLast()).intValue()) : null);
        }

        public void setEditable(Node node, boolean editable) {
            if (node == null) {
                return;
            }
            ((PairWidget)node).getViewState().setReadonly(!editable);
        }

        public boolean isValueEmpty(Node node) {
            if (node == null) {
                return true;
            }
            return ((PairWidget)node).getFirstValue() == null && ((PairWidget)node).getSecondValue() == null;
        }
    }
    ,
    BYTE{

        public String getCategoryId() {
            return StandardValueRendererCategory.BYTE.name();
        }

        public Node createNode(Class<?> type) {
            IntValueWidget node = new IntValueWidget(false);
            return node;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return ((IntValueWidget)node).getValue() != null ? Byte.valueOf((byte)((Integer)((IntValueWidget)node).getValue()).intValue()) : null;
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            ((IntValueWidget)node).setValue(value != null ? Integer.valueOf(((Byte)value).intValue()) : null);
        }

        public void setEditable(Node node, boolean editable) {
            if (node == null) {
                return;
            }
            ((IntValueWidget)node).getViewState().setReadonly(!editable);
        }

        public boolean isValueEmpty(Node node) {
            if (node == null) {
                return true;
            }
            return ((IntValueWidget)node).getValue() == null;
        }
    }
    ,
    BYTE_INTERVAL{

        public String getCategoryId() {
            return StandardValueRendererCategory.BYTE_INTERVAL.name();
        }

        public Node createNode(Class<?> type) {
            PairWidget node = new PairWidget(PairWidgetHandler.INT, false);
            return node;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return new Pair((Object)(((PairWidget)node).getFirstValue() != null ? Byte.valueOf((byte)((Integer)((PairWidget)node).getFirstValue()).intValue()) : null), ((PairWidget)node).getSecondValue() != null ? Byte.valueOf((byte)((Integer)((PairWidget)node).getSecondValue()).intValue()) : null);
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            ((PairWidget)node).setFirstValue(value != null ? Integer.valueOf(((Byte)((Pair)value).getFirst()).intValue()) : null);
            ((PairWidget)node).setSecondValue(value != null ? Integer.valueOf(((Byte)((Pair)value).getLast()).intValue()) : null);
        }

        public void setEditable(Node node, boolean editable) {
            if (node == null) {
                return;
            }
            ((PairWidget)node).getViewState().setReadonly(!editable);
        }

        public boolean isValueEmpty(Node node) {
            if (node == null) {
                return true;
            }
            return ((PairWidget)node).getFirstValue() == null && ((PairWidget)node).getSecondValue() == null;
        }
    }
    ,
    CURRENCY{

        public String getCategoryId() {
            return StandardValueRendererCategory.CURRENCY.name();
        }

        public Node createNode(Class<?> type) {
            CurrencyValueWidget node = new CurrencyValueWidget(false);
            return node;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return ((CurrencyValueWidget)node).getValue();
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            ((CurrencyValueWidget)node).setValue(value != null ? (String)value : null);
        }

        public void setEditable(Node node, boolean editable) {
            if (node == null) {
                return;
            }
            ((CurrencyValueWidget)node).getViewState().setReadonly(!editable);
        }

        public boolean isValueEmpty(Node node) {
            if (node == null) {
                return true;
            }
            return ((CurrencyValueWidget)node).getValue() == null;
        }
    }
    ,
    CURRENCY_LIST{

        public String getCategoryId() {
            return StandardValueRendererCategory.CURRENCY_LIST.name();
        }

        public Node createNode(Class<?> type) {
            CurrencyValueWidget node = new CurrencyValueWidget(false);
            return node;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return ((CurrencyValueWidget)node).getValue() != null ? Collections.singletonList(((CurrencyValueWidget)node).getValue()) : Collections.emptyList();
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            ((CurrencyValueWidget)node).setValue(value != null && ((List)value).size() > 0 ? (String)((List)value).get(0) : null);
        }

        public void setEditable(Node node, boolean editable) {
            if (node == null) {
                return;
            }
            ((CurrencyValueWidget)node).getViewState().setReadonly(!editable);
        }

        public boolean isValueEmpty(Node node) {
            if (node == null) {
                return true;
            }
            return ((CurrencyValueWidget)node).getValue() == null;
        }
    }
    ,
    LOCALE{

        public String getCategoryId() {
            return StandardValueRendererCategory.LOCALE.name();
        }

        public Node createNode(Class<?> type) {
            LocaleValueWidget node = new LocaleValueWidget(false);
            return node;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return ((LocaleValueWidget)node).getValue();
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            ((LocaleValueWidget)node).setValue(value != null ? (Locale)value : null);
        }

        public void setEditable(Node node, boolean editable) {
            if (node == null) {
                return;
            }
            ((LocaleValueWidget)node).getViewState().setReadonly(!editable);
        }

        public boolean isValueEmpty(Node node) {
            if (node == null) {
                return true;
            }
            return ((LocaleValueWidget)node).getValue() == null;
        }
    }
    ,
    LOCALE_LIST{

        public String getCategoryId() {
            return StandardValueRendererCategory.LOCALE_LIST.name();
        }

        public Node createNode(Class<?> type) {
            LocaleValueWidget node = new LocaleValueWidget(false);
            return node;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return ((LocaleValueWidget)node).getValue() != null ? Collections.singletonList(((LocaleValueWidget)node).getValue()) : Collections.emptyList();
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            ((LocaleValueWidget)node).setValue(value != null && ((List)value).size() > 0 ? (Locale)((List)value).get(0) : null);
        }

        public void setEditable(Node node, boolean editable) {
            if (node == null) {
                return;
            }
            ((LocaleValueWidget)node).getViewState().setReadonly(!editable);
        }

        public boolean isValueEmpty(Node node) {
            if (node == null) {
                return true;
            }
            return ((LocaleValueWidget)node).getValue() == null;
        }
    }
    ,
    ENUM{

        public String getCategoryId() {
            return StandardValueRendererCategory.ENUM.name();
        }

        public Node createNode(Class<?> type) {
            if (!Enum.class.isAssignableFrom(type)) {
                return null;
            }
            ComboBoxWidget node = new ComboBoxWidget(false);
            node.setItemsSupplier(Suppliers.createEnumSupplier(type));
            node.setSuggestionsHandler((SuggestionsHandler)new SimpleSuggestionsHandler(node.getConverter(), node.getItemsSupplier(), node.isSortItems()));
            return node;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return ((ComboBoxWidget)node).getValue();
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            ((ComboBoxWidget)node).setValue((Object)(value != null ? (Enum)value : null));
        }

        public void setEditable(Node node, boolean editable) {
            if (node == null) {
                return;
            }
            ((ComboBoxWidget)node).getViewState().setReadonly(!editable);
        }

        public boolean isValueEmpty(Node node) {
            if (node == null) {
                return true;
            }
            return ((ComboBoxWidget)node).getValue() == null;
        }
    }
    ,
    ENUM_LIST{

        public String getCategoryId() {
            return StandardValueRendererCategory.ENUM_LIST.name();
        }

        public Node createNode(Class<?> type) {
            if (!Enum.class.isAssignableFrom(type)) {
                return null;
            }
            ValuesWidget node = new ValuesWidget(false);
            node.setItemsSupplier(Suppliers.createEnumSupplier(type));
            return node;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return new ArrayList(((ValuesWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            ((ValuesWidget)node).getValues().addAll((Collection)(value != null ? (List)value : Collections.emptyList()));
        }

        public void setEditable(Node node, boolean editable) {
            if (node == null) {
                return;
            }
            ((ValuesWidget)node).getViewState().setReadonly(!editable);
        }

        public boolean isValueEmpty(Node node) {
            if (node == null) {
                return true;
            }
            return ((ValuesWidget)node).getValues().size() == 0;
        }
    }
    ,
    ENTITY{

        public String getCategoryId() {
            return StandardValueRendererCategory.ENTITY.name();
        }

        public Node createNode(Class<?> type) {
            if (!BaseEntity.class.isAssignableFrom(type)) {
                return null;
            }
            EntityBoxWidget node = new EntityBoxWidget(type, false);
            return node;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return ((EntityBoxWidget)node).getValue();
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            ((EntityBoxWidget)node).setValue(value != null ? (EntityReference)value : null);
        }

        public void setEditable(Node node, boolean editable) {
            if (node == null) {
                return;
            }
            ((EntityBoxWidget)node).getViewState().setReadonly(!editable);
        }

        public boolean isValueEmpty(Node node) {
            if (node == null) {
                return true;
            }
            return ((EntityBoxWidget)node).getValue() == null;
        }
    }
    ,
    ENTITY_LIST{

        public String getCategoryId() {
            return StandardValueRendererCategory.ENTITY_LIST.name();
        }

        public Node createNode(Class<?> type) {
            if (!BaseEntity.class.isAssignableFrom(type)) {
                return null;
            }
            EntityBoxWidget node = new EntityBoxWidget(type, false);
            return node;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return ((EntityBoxWidget)node).getValue() != null ? Collections.singletonList(((EntityBoxWidget)node).getValue()) : Collections.emptyList();
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            ((EntityBoxWidget)node).setValue(value != null && ((List)value).size() > 0 ? (EntityReference)((List)value).get(0) : null);
        }

        public void setEditable(Node node, boolean editable) {
            if (node == null) {
                return;
            }
            ((EntityBoxWidget)node).getViewState().setReadonly(!editable);
        }

        public boolean isValueEmpty(Node node) {
            if (node == null) {
                return true;
            }
            return ((EntityBoxWidget)node).getValue() == null;
        }
    }
    ,
    DICTIONARY{

        public String getCategoryId() {
            return StandardValueRendererCategory.DICTIONARY.name();
        }

        public Node createNode(Class<?> type) {
            if (!BaseEntity.class.isAssignableFrom(type)) {
                return null;
            }
            DictBoxWidget node = new DictBoxWidget(type, false);
            return node;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return ((DictBoxWidget)node).getValue();
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            ((DictBoxWidget)node).setValue(value != null ? (DictionaryReference)value : null);
        }

        public void setEditable(Node node, boolean editable) {
            if (node == null) {
                return;
            }
            ((DictBoxWidget)node).getViewState().setReadonly(!editable);
        }

        public boolean isValueEmpty(Node node) {
            if (node == null) {
                return true;
            }
            return ((DictBoxWidget)node).getValue() == null;
        }
    }
    ,
    DICTIONARY_LIST{

        public String getCategoryId() {
            return StandardValueRendererCategory.DICTIONARY_LIST.name();
        }

        public Node createNode(Class<?> type) {
            if (!BaseEntity.class.isAssignableFrom(type)) {
                return null;
            }
            DictBoxWidget node = new DictBoxWidget(type, false);
            return node;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return ((DictBoxWidget)node).getValue() != null ? Collections.singletonList(((DictBoxWidget)node).getValue()) : Collections.emptyList();
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            ((DictBoxWidget)node).setValue(value != null && ((List)value).size() > 0 ? (DictionaryReference)((List)value).get(0) : null);
        }

        public void setEditable(Node node, boolean editable) {
            if (node == null) {
                return;
            }
            ((DictBoxWidget)node).getViewState().setReadonly(!editable);
        }

        public boolean isValueEmpty(Node node) {
            if (node == null) {
                return true;
            }
            return ((DictBoxWidget)node).getValue() == null;
        }
    }
    ,
    DATE{

        public String getCategoryId() {
            return StandardValueRendererCategory.DATE.name();
        }

        public Node createNode(Class<?> type) {
            DateValueWidget node = new DateValueWidget(false);
            return node;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return ((DateValueWidget)node).getValue();
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            ((DateValueWidget)node).setValue(value != null ? (LocalDate)value : null);
        }

        public void setEditable(Node node, boolean editable) {
            if (node == null) {
                return;
            }
            ((DateValueWidget)node).getViewState().setReadonly(!editable);
        }

        public boolean isValueEmpty(Node node) {
            if (node == null) {
                return true;
            }
            return ((DateValueWidget)node).getValue() == null;
        }
    }
    ,
    DATE_INTERVAL{

        public String getCategoryId() {
            return StandardValueRendererCategory.DATE_INTERVAL.name();
        }

        public Node createNode(Class<?> type) {
            PairWidget node = new PairWidget(PairWidgetHandler.DATE, false);
            return node;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return new Pair(((PairWidget)node).getFirstValue(), ((PairWidget)node).getSecondValue());
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            ((PairWidget)node).setFirstValue(value != null ? (LocalDate)((Pair)value).getFirst() : null);
            ((PairWidget)node).setSecondValue(value != null ? (LocalDate)((Pair)value).getLast() : null);
        }

        public void setEditable(Node node, boolean editable) {
            if (node == null) {
                return;
            }
            ((PairWidget)node).getViewState().setReadonly(!editable);
        }

        public boolean isValueEmpty(Node node) {
            if (node == null) {
                return true;
            }
            return ((PairWidget)node).getFirstValue() == null && ((PairWidget)node).getSecondValue() == null;
        }
    }
    ,
    DATE_TIME{

        public String getCategoryId() {
            return StandardValueRendererCategory.DATE_TIME.name();
        }

        public Node createNode(Class<?> type) {
            DateTimeValueWidget node = new DateTimeValueWidget(false);
            return node;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return ((DateTimeValueWidget)node).getValue();
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            ((DateTimeValueWidget)node).setValue(value != null ? (LocalDateTime)value : null);
        }

        public void setEditable(Node node, boolean editable) {
            if (node == null) {
                return;
            }
            ((DateTimeValueWidget)node).getViewState().setReadonly(!editable);
        }

        public boolean isValueEmpty(Node node) {
            if (node == null) {
                return true;
            }
            return ((DateTimeValueWidget)node).getValue() == null;
        }
    }
    ,
    DATE_TIME_INTERVAL{

        public String getCategoryId() {
            return StandardValueRendererCategory.DATE_TIME_INTERVAL.name();
        }

        public Node createNode(Class<?> type) {
            PairWidget node = new PairWidget(PairWidgetHandler.DATE_TIME, false);
            return node;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return new Pair(((PairWidget)node).getFirstValue(), ((PairWidget)node).getSecondValue());
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            ((PairWidget)node).setFirstValue(value != null ? (LocalDateTime)((Pair)value).getFirst() : null);
            ((PairWidget)node).setSecondValue(value != null ? (LocalDateTime)((Pair)value).getLast() : null);
        }

        public void setEditable(Node node, boolean editable) {
            if (node == null) {
                return;
            }
            ((PairWidget)node).getViewState().setReadonly(!editable);
        }

        public boolean isValueEmpty(Node node) {
            if (node == null) {
                return true;
            }
            return ((PairWidget)node).getFirstValue() == null && ((PairWidget)node).getSecondValue() == null;
        }
    };

}

