/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.rules;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.CardsContainer;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.CheckBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.FileChooserWidget;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.rules.ExchangeRulesHelper;
import com.gridnine.xtrip.client.fx.standard.rules.FullRulesWidget;
import com.gridnine.xtrip.client.fx.standard.rules.RuleSettingsWrapper;
import com.gridnine.xtrip.common.fx.rpc.RulesExportProperties;
import com.gridnine.xtrip.common.meta.ui.UiCardsContainer;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.XCloneModelHelper;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.stage.FileChooser;

public class ExportRulesDialog {
    private final FileChooserWidget fileChooserWidget = new FileChooserWidget(false);
    private final CheckBoxWidget exportSelectedWidget;
    private final CheckBoxWidget exportInTchFormatWidget;
    private final CheckBoxWidget excludeActionsWidget;

    public ExportRulesDialog() {
        this.fileChooserWidget.setMode(FileChooserWidget.ChoosingMode.SAVE);
        this.fileChooserWidget.setExtensionFiltersSupplier(() -> Collections.singletonList(new FileChooser.ExtensionFilter(Messages.MOM_Rule_Files, new String[]{"*.zip"})));
        this.exportSelectedWidget = new CheckBoxWidget(false);
        this.exportSelectedWidget.setText(Messages.Export_only_selected_rules);
        this.exportInTchFormatWidget = new CheckBoxWidget(false);
        this.exportInTchFormatWidget.setText(Messages.Export_in_TKP_Format);
        this.excludeActionsWidget = new CheckBoxWidget(false);
        this.excludeActionsWidget.setText(Messages.Exclude_Actions);
    }

    public void showDialog(Control source, FullRulesWidget fullRulesWidget) {
        GridContainer gridContainer = new GridContainer();
        ArrayList<GridCell> cells = new ArrayList<GridCell>();
        GridCell cell = new GridCell((Node)this.exportSelectedWidget);
        cells.add(cell);
        cell = new GridCell((Node)this.exportInTchFormatWidget);
        cells.add(cell);
        cell = new GridCell((Node)this.excludeActionsWidget);
        cells.add(cell);
        gridContainer.getCells().addAll(cells);
        CardsContainer cardsContainer = new CardsContainer();
        cardsContainer.getCards().add((Object)new Card("file", UiCardsContainer.Style.STATIC, Messages.File, (Node)GridContainer.wrap((Node)this.fileChooserWidget)));
        cardsContainer.getCards().add((Object)new Card("parameters", UiCardsContainer.Style.STATIC, Messages.Settings, (Node)gridContainer));
        if (fullRulesWidget.getSelectedRules().isEmpty()) {
            this.exportSelectedWidget.setDisable(true);
            this.exportSelectedWidget.setSelected(false);
        }
        Dialog dialog = new Dialog();
        dialog.setTitle(Messages.Export_Parameters).setAutoClose(false).setBody((Node)cardsContainer).addButton(DialogButtonStyle.DECLINE, Messages.Cancel, () -> ((Dialog)dialog).close()).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.To_Export, () -> {
            ArrayList importFiles = new ArrayList(this.fileChooserWidget.getFiles());
            if (importFiles.size() == 0) {
                Dialog.info((String)Messages.Must_specify_a_file_to_export);
            } else {
                ObservableList<RuleSettingsWrapper> wrappers = this.exportSelectedWidget.isSelected() ? fullRulesWidget.getSelectedRules() : fullRulesWidget.getData();
                List rs = wrappers.stream().map(item -> item.getSource()).collect(Collectors.toList());
                RuleSet exportedRules = new RuleSet();
                boolean excludeActions = this.excludeActionsWidget.isSelected();
                for (RuleSettings rst : rs) {
                    RuleSettings rs2 = new RuleSettings();
                    try {
                        XCloneModelHelper.copy((BaseEntity)rst, (BaseEntity)rs2, (boolean)false);
                    }
                    catch (Exception e) {
                        ErrorHandler.handle((Throwable)e);
                    }
                    if (excludeActions) {
                        rs2.getResults().clear();
                    }
                    exportedRules.getRules().add(rs2);
                }
                RulesExportProperties properties = new RulesExportProperties(exportedRules, this.exportInTchFormatWidget.isSelected());
                ExchangeRulesHelper.exportRulesOnServer((File)this.fileChooserWidget.getFiles().get(0), properties);
                dialog.close();
            }
        }).setOnCloseRequest(() -> ((Dialog)dialog).close()).show((Node)source);
    }
}

