/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.rules;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.CardsContainer;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.FileChooserWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.RadioBoxWidget;
import com.gridnine.xtrip.client.fx.core.tasks.StandardNotifications;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.rules.ExchangeRulesHelper;
import com.gridnine.xtrip.client.fx.standard.rules.FullRulesWidget;
import com.gridnine.xtrip.common.fx.rpc.RulesImportProperties;
import com.gridnine.xtrip.common.meta.ui.UiCardsContainer;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.stage.FileChooser;
import javafx.util.StringConverter;

public class ImportRulesDialog {
    private final FileChooserWidget fileChooserWidget = new FileChooserWidget(false);
    RadioBoxWidget<RulesImportProperties.ImportType> importTypeRadioBox;
    RadioBoxWidget<RulesImportProperties.ConflictAction> conflictActionRadioBox;

    public ImportRulesDialog() {
        this.fileChooserWidget.setMode(FileChooserWidget.ChoosingMode.OPEN_SINGLE);
        this.fileChooserWidget.setExtensionFiltersSupplier(() -> Collections.singletonList(new FileChooser.ExtensionFilter(Messages.MOM_Rule_Files, new String[]{"*.xml", "*.zip", ".tch"})));
        this.importTypeRadioBox = this.createImportTypeRadioBox();
        this.conflictActionRadioBox = this.createConflictActionRadioBox();
        this.importTypeRadioBox.valueProperty().addListener((obj, o, n) -> {
            if (n == RulesImportProperties.ImportType.MERGE_MANUAL) {
                this.conflictActionRadioBox.setDisable(false);
                this.conflictActionRadioBox.setValue((Object)RulesImportProperties.ConflictAction.SUBSTITUTE);
            } else {
                this.conflictActionRadioBox.setDisable(true);
                this.conflictActionRadioBox.setValue(null);
            }
        });
        this.conflictActionRadioBox.setDisable(true);
        this.conflictActionRadioBox.setValue(null);
    }

    public void showDialog(Control source, FullRulesWidget fullRulesWidget) {
        GridContainer gridContainer = new GridContainer();
        ArrayList<GridCell> cells = new ArrayList<GridCell>();
        GridCell cell = new GridCell(Messages.Interaction_with_current_rules, this.importTypeRadioBox);
        cell.setColSpan(3);
        cells.add(cell);
        cell = new GridCell(Messages.Actions_for_import_conflicts, this.conflictActionRadioBox);
        cell.setColSpan(3);
        cells.add(cell);
        gridContainer.getCells().addAll(cells);
        CardsContainer cardsContainer = new CardsContainer();
        cardsContainer.getCards().add((Object)new Card("file", UiCardsContainer.Style.STATIC, Messages.File, (Node)GridContainer.wrap((Node)this.fileChooserWidget)));
        cardsContainer.getCards().add((Object)new Card("parameters", UiCardsContainer.Style.STATIC, Messages.Settings, (Node)gridContainer));
        Dialog stubProcessingDialog = new Dialog();
        Runnable closeStub = () -> stubProcessingDialog.close();
        Dialog dialog = new Dialog();
        dialog.setTitle(Messages.Import_parameters).setAutoClose(false).setBody((Node)cardsContainer).addButton(DialogButtonStyle.DECLINE, Messages.Cancel, () -> ((Dialog)dialog).close()).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Import, () -> {
            ArrayList importFiles = new ArrayList(this.fileChooserWidget.getFiles());
            if (importFiles.size() == 0) {
                Dialog.info((String)Messages.Must_specify_a_file_to_import);
            } else {
                ArrayList<Message> messages = new ArrayList<Message>();
                MiscUtil.Pair<RulesImportProperties.FileType, byte[]> inputData = ExchangeRulesHelper.getContent((List<File>)this.fileChooserWidget.getFiles(), messages);
                boolean showStub = true;
                if (inputData != null) {
                    RulesImportProperties.FileType fileType = (RulesImportProperties.FileType)inputData.getFirst();
                    byte[] content = (byte[])inputData.getSecond();
                    RuleSet ruleSet = new RuleSet();
                    fullRulesWidget.getData().forEach(rule -> ruleSet.getRules().add(rule.getSource()));
                    RulesImportProperties options = new RulesImportProperties(content, ((File)this.fileChooserWidget.getFiles().get(0)).getName(), ruleSet, fileType, (RulesImportProperties.ImportType)this.importTypeRadioBox.getValue(), (RulesImportProperties.ConflictAction)this.conflictActionRadioBox.getValue());
                    if (this.importTypeRadioBox.getValue() != RulesImportProperties.ImportType.MERGE_MANUAL || this.conflictActionRadioBox.getValue() != RulesImportProperties.ConflictAction.ASK) {
                        ExchangeRulesHelper.importRulesOnServer(options, fullRulesWidget, closeStub);
                    } else {
                        showStub = false;
                        StandardNotifications.NOT_IMPLEMENTED.show(null);
                    }
                }
                dialog.close();
                if (showStub) {
                    GridContainer stubGridContainer = new GridContainer();
                    ArrayList<GridCell> stubCells = new ArrayList<GridCell>();
                    GridCell cell = new GridCell((Node)new Label(Messages.Importing_rules));
                    stubCells.add(cell);
                    stubGridContainer.getCells().addAll(stubCells);
                    stubProcessingDialog.setTitle(Messages.Import_Rules).setAutoClose(false).setBody((Node)stubGridContainer).show((Node)source);
                }
            }
        }).setOnCloseRequest(() -> ((Dialog)dialog).close()).show((Node)source);
    }

    private RadioBoxWidget<RulesImportProperties.ImportType> createImportTypeRadioBox() {
        RadioBoxWidget result = new RadioBoxWidget(false);
        result.setItemsSupplier(() -> Arrays.asList(RulesImportProperties.ImportType.values()));
        result.valueProperty().set((Object)RulesImportProperties.ImportType.SUBSTITUTE);
        result.setConverter((StringConverter)new StringConverter<RulesImportProperties.ImportType>(){

            public String toString(RulesImportProperties.ImportType object) {
                if (object == null) {
                    return UiUtil.NULL_TEXT;
                }
                switch (object) {
                    case MERGE_MANUAL: {
                        return Messages.Manually_merge;
                    }
                    case SUBSTITUTE: {
                        return Messages.Replace_existing_rules_with_new;
                    }
                    case MERGE_TCH: {
                        return Messages.Merge_according_to_the_TCH_logic;
                    }
                }
                return UiUtil.NULL_TEXT;
            }

            public RulesImportProperties.ImportType fromString(String string) {
                return null;
            }
        });
        return result;
    }

    private RadioBoxWidget<RulesImportProperties.ConflictAction> createConflictActionRadioBox() {
        RadioBoxWidget result = new RadioBoxWidget(false);
        result.setItemsSupplier(() -> Arrays.asList(RulesImportProperties.ConflictAction.values()));
        result.valueProperty().set((Object)RulesImportProperties.ConflictAction.SUBSTITUTE);
        result.setConverter((StringConverter)new StringConverter<RulesImportProperties.ConflictAction>(){

            public String toString(RulesImportProperties.ConflictAction object) {
                if (object == null) {
                    return UiUtil.NULL_TEXT;
                }
                switch (object) {
                    case SUBSTITUTE: {
                        return Messages.Action_Replace;
                    }
                    case ADD: {
                        return Messages.Action_Add;
                    }
                    case SKIP: {
                        return Messages.Action_Miss;
                    }
                    case ASK: {
                        return Messages.Ask;
                    }
                }
                return UiUtil.NULL_TEXT;
            }

            public RulesImportProperties.ConflictAction fromString(String string) {
                return null;
            }
        });
        return result;
    }
}

