/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.rules;

import com.gridnine.xtrip.client.fx.core.devtools.api.DevTool;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevToolItem;
import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SimpleSuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.widgets.NodeRenderer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.RendererWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableRowEvent;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.ComboBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.ExpandableColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.RendererWidgetColumn;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.HasValue;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.rules.BaseRulesTablePane;
import com.gridnine.xtrip.client.fx.standard.rules.RulesEditorExpandableColumn;
import com.gridnine.xtrip.client.fx.standard.rules.renderers.RuleActionRenderer;
import com.gridnine.xtrip.client.fx.standard.rules.renderers.RulesCustomProperties;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.rules.RuleFilteringCategory;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.RulesEnvironment;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.beans.InvalidationListener;
import javafx.scene.Node;
import javafx.util.StringConverter;

class RuleActionsPane
extends BaseRulesTablePane
implements DevTool {
    private static final String FIELD_ACTION_ID = "action";
    private static final String FIELD_TYPE_ID = "type";
    private static final String FIELD_VALUE_ID = "value";
    private static final String EXPANDABLE_ID = "expandable";
    private static final Double COLUMN_WIDTH = 30.0;
    private TableWidgetController<TableWidget<RuleResultWrapper>, RuleResultWrapper> controller;
    private RuleTarget target;
    private RuleFilteringCategory category;
    private final Supplier<List<RuleAction>> actionsSupplier;
    private boolean isFieldValueVisisble = true;
    private static final StringConverter<RuleAction> actionConverter = new StringConverter<RuleAction>(){

        public String toString(RuleAction object) {
            return object == null ? UiUtil.NULL_TEXT : object.getDisplayName();
        }

        public RuleAction fromString(String string) {
            return null;
        }
    };

    RuleActionsPane(Function<RuleTarget, Collection<RuleAction>> supplier, RulesCustomProperties customProperties) {
        this.isFieldValueVisisble = customProperties.isFieldValueVisisble();
        this.actionsSupplier = () -> {
            if (this.target == null) {
                return Collections.emptyList();
            }
            Stream<Object> stream = ((Collection)supplier.apply(this.target)).stream();
            if (this.category != null) {
                Set set = RulesEnvironment.get().getActions(this.category).stream().map(RuleAction::getId).collect(Collectors.toSet());
                stream = stream.filter(action -> set.contains(action.getId()));
            }
            return stream.sorted(Comparator.comparing(RuleAction::getDisplayName)).collect(Collectors.toList());
        };
        final TableWidget widget = new TableWidget(false);
        widget.setPlaceholder(Messages.No_action_specified);
        widget.setItemsProvider(RuleResultWrapper::new);
        widget.setControlButtonsAvailability(ControlsPane.ADD_REMOVE_REORDERING);
        widget.setColumns(this.createTableColumns());
        widget.setOnRowsAction(event -> this.provideRowListeners((TableWidget<RuleResultWrapper>)widget, (TableRowEvent)event));
        this.controller = new TableWidgetController<TableWidget<RuleResultWrapper>, RuleResultWrapper>(){

            public TableWidget<RuleResultWrapper> getView() {
                return widget;
            }
        };
        this.getChildren().add((Object)widget);
    }

    void readData(RuleSettings model) {
        this.target = model.getTarget();
        this.category = model.getFilteringCategory();
        this.controller.readData(this.wrapRuleResults(model.getResults()));
    }

    void writeData(RuleSettings model) {
        List<RuleResultWrapper> wrappers = this.wrapRuleResults(model.getResults());
        this.controller.writeData(wrappers);
        model.getResults().clear();
        model.getResults().addAll(wrappers.stream().map(rrw -> rrw.toResult()).filter(res -> res.getAction() != null && (!res.getAction().hasValue() || res.getValue() != null)).collect(Collectors.toList()));
    }

    void setReadonly(boolean value) {
        this.controller.setReadonly(value);
    }

    private List<TableWidgetColumn<RuleResultWrapper, ?>> createTableColumns() {
        ArrayList columns = new ArrayList();
        ComboBoxWidgetColumn column1 = new ComboBoxWidgetColumn(rr -> rr.getAction(), (rr, value) -> rr.setAction(value));
        column1.setId(FIELD_ACTION_ID);
        column1.setCaption(Messages.Method_of_calculation);
        column1.setPrefWidth(COLUMN_WIDTH);
        column1.setItemsSupplier(this.actionsSupplier);
        column1.setConverter(actionConverter);
        column1.setSuggestionsHandler((SuggestionsHandler)new SimpleSuggestionsHandler(column1.getConverter(), column1.getItemsSupplier(), column1.isSortItems()));
        columns.add((TableWidgetColumn<RuleResultWrapper, ?>)column1);
        RendererWidgetColumn column2 = new RendererWidgetColumn(rr -> rr.getValue(), (rr, value) -> rr.setValue(value));
        column2.setId(FIELD_TYPE_ID);
        column2.setCaption(Messages.Type);
        columns.add((TableWidgetColumn<RuleResultWrapper, ?>)column2);
        RendererWidgetColumn column3 = new RendererWidgetColumn(rr -> rr.getSecondValue(), (rr, value) -> rr.setSecondValue(value));
        column3.setId(FIELD_VALUE_ID);
        column3.setCaption(Messages.Value_text);
        columns.add((TableWidgetColumn<RuleResultWrapper, ?>)column3);
        RulesEditorExpandableColumn column4 = new RulesEditorExpandableColumn(r -> r.getAction(), () -> this.createExpandableViewController());
        column4.setId(EXPANDABLE_ID);
        columns.add((TableWidgetColumn<RuleResultWrapper, ?>)column4);
        if (this.isFieldValueVisisble) {
            column2.setPrefWidth(COLUMN_WIDTH);
        } else {
            column2.setHidden(true);
            column4.setHidden(true);
        }
        return columns;
    }

    private void provideRowListeners(TableWidget<RuleResultWrapper> widget, TableRowEvent event) {
        if (event.getTarget() == widget && event.getEventType() == TableRowEvent.ROW_ADD) {
            int row = event.getRowIndex();
            ComboBoxWidget node1 = (ComboBoxWidget)widget.getColumn(FIELD_ACTION_ID).getWidget(row);
            RendererWidget node2 = (RendererWidget)widget.getColumn(FIELD_TYPE_ID).getWidget(row);
            RendererWidget node3 = (RendererWidget)widget.getColumn(FIELD_VALUE_ID).getWidget(row);
            ExpandableColumn.ViewHolder node4 = (ExpandableColumn.ViewHolder)widget.getColumn(EXPANDABLE_ID).getWidget(row);
            RuleActionRenderer node3renderer = RuleActionsPane.findRenderer((RuleAction)node1.getValue());
            node3.setRenderer(node3renderer.createValueRenderer(null));
            TableWidget<?> actionTable = node3renderer.getActionTable(node3.getValueNode());
            ((BaseRulesTablePane.InnerTableView)node4.getView()).setInnerTable(actionTable);
            node4.visibilityProperty().set(actionTable != null);
            this.refreshRowData((ComboBoxWidget<RuleAction>)node1, node2, node3, (ExpandableColumn.ViewHolder<BaseRulesTablePane.InnerTableView>)node4, (RuleAction)node1.getValue());
            node1.valueProperty().addListener((obj, old, value) -> {
                node2.setValue(null);
                node3.setValue(null);
                this.refreshRowData((ComboBoxWidget<RuleAction>)node1, node2, node3, (ExpandableColumn.ViewHolder<BaseRulesTablePane.InnerTableView>)node4, (RuleAction)value);
            });
        }
    }

    private void refreshRowData(ComboBoxWidget<RuleAction> node1, RendererWidget node2, RendererWidget node3, ExpandableColumn.ViewHolder<BaseRulesTablePane.InnerTableView> node4, RuleAction value) {
        RuleActionRenderer renderer = RuleActionsPane.findRenderer(value);
        node2.setRenderer((NodeRenderer)renderer);
        node3.setRenderer(renderer.createValueRenderer(null));
        this.linkNodes(renderer, node2, node3);
        TableWidget<?> aTable = renderer.getActionTable(node3.getValueNode());
        ((BaseRulesTablePane.InnerTableView)node4.getView()).setInnerTable(aTable);
        node4.visibilityProperty().set(aTable != null);
    }

    private void linkNodes(RuleActionRenderer renderer, RendererWidget targetNode, RendererWidget valueNode) {
        Node entityWidget;
        InvalidationListener targetListener = obj -> Notifications.get().submitTask(() -> {
            if (targetNode.getValueNode() instanceof HasValue && ((HasValue)targetNode.getValueNode()).valueProperty().getValue() != null && ((HasValue)targetNode.getValueNode()).valueProperty().getValue() instanceof EntityReference) {
                this.loadTarget(renderer, (HasValue)targetNode.getValueNode(), valueNode);
            }
        }, Messages.Loading_settings);
        if (targetNode.getValueNode() instanceof HasValue && (entityWidget = targetNode.getValueNode()) instanceof EntityBoxWidget) {
            HasValue targetWidget = (HasValue)entityWidget;
            targetWidget.valueProperty().addListener(targetListener);
            targetListener.invalidated(null);
        }
    }

    private void loadTarget(RuleActionRenderer renderer, HasValue<EntityReference<?>> targetWidget, RendererWidget valueNode) throws Exception {
        ServiceInvocationContext sic = ServiceInvocationContext.get();
        EntityService entityService = (EntityService)RpcServiceManager.get().getService(EntityService.class);
        EntityReference ref = (EntityReference)targetWidget.valueProperty().getValue();
        EntityContainer ctr = ref == null ? null : entityService.loadBypassingAcl(sic, ref);
        FxUtil.waitForFxThread(() -> {
            if (!MiscUtil.equals((Object)ref, (Object)targetWidget.valueProperty().getValue())) {
                return;
            }
            valueNode.setRenderer(renderer.createValueRenderer(ctr));
        });
    }

    private List<RuleResultWrapper> wrapRuleResults(List<RuleResult> results) {
        List<RuleResultWrapper> wrappers = results.stream().map(rr -> new RuleResultWrapper((RuleResult)rr)).collect(Collectors.toList());
        return wrappers;
    }

    public DevToolItem asDevToolItem() {
        return new DevToolItem(){

            public Collection<?> getSubItems() {
                return Collections.singleton(RuleActionsPane.this.controller.getView());
            }

            public String getInfo() {
                return ((Object)((Object)RuleActionsPane.this)).getClass().getSimpleName();
            }
        };
    }

    public static class RuleResultWrapper
    extends RuleResult {
        private static final long serialVersionUID = 8377326175567792165L;
        private Object secondValue;

        public RuleResultWrapper() {
        }

        public RuleResultWrapper(RuleResult rr) {
            this.setAction(rr.getAction());
            this.setValue(rr.getValue());
            this.setSecondValue(rr.getValue());
        }

        public Object getSecondValue() {
            return this.secondValue;
        }

        public void setSecondValue(Object value) {
            this.secondValue = value;
        }

        public RuleResult toResult() {
            RuleResult rr = new RuleResult();
            rr.setAction(this.getAction());
            RuleActionRenderer renderer = BaseRulesTablePane.findRenderer(this.getAction());
            Object value = renderer.joinValues(this.getValue(), this.getSecondValue());
            rr.setValue(value);
            return rr;
        }
    }
}

