/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.rules;

import com.gridnine.xtrip.client.fx.core.devtools.api.DevTool;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevToolItem;
import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SimpleSuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.widgets.NodeRenderer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.RendererWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableRowEvent;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.ComboBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.ExpandableColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.RendererWidgetColumn;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.rules.BaseRulesTablePane;
import com.gridnine.xtrip.client.fx.standard.rules.RulesEditorExpandableColumn;
import com.gridnine.xtrip.client.fx.standard.rules.renderers.RuleValueRenderer;
import com.gridnine.xtrip.common.rules.RuleFilteringCategory;
import com.gridnine.xtrip.common.rules.RuleRestriction;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.RulesEnvironment;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.util.StringConverter;

class RuleRestrictionsPane
extends BaseRulesTablePane
implements DevTool {
    private static final String PROPERTY_ID = "property";
    private static final String CONDITION_ID = "condition";
    private static final String VALUE_ID = "value";
    private static final String EXPANDABLE_ID = "expandable";
    private static final Double COLUMN_WIDTH = 30.0;
    private TableWidgetController<TableWidget<RuleRestriction>, RuleRestriction> controller;
    private RuleTarget target;
    private RuleFilteringCategory category;
    private final Supplier<List<RuleProperty>> propertySupplier = () -> {
        if (this.target == null) {
            return Collections.emptyList();
        }
        RulesEnvironment re = RulesEnvironment.get();
        Stream<Object> stream = re.getProperties(this.target).stream();
        if (this.category != null) {
            Set set = re.getProperties(this.category).stream().map(RuleProperty::getId).collect(Collectors.toSet());
            stream = stream.filter(prop -> set.contains(prop.getId()));
        }
        return stream.sorted((p1, p2) -> p1.getDisplayName().compareTo(p2.getDisplayName())).collect(Collectors.toList());
    };
    private static final StringConverter<RuleProperty> propertyConverter = new StringConverter<RuleProperty>(){

        public String toString(RuleProperty object) {
            return object == null ? UiUtil.NULL_TEXT : object.getDisplayName();
        }

        public RuleProperty fromString(String string) {
            return null;
        }
    };
    private static final StringConverter<RuleCondition> conditionConverter = new StringConverter<RuleCondition>(){

        public String toString(RuleCondition object) {
            return object == null ? UiUtil.NULL_TEXT : object.getDisplayName();
        }

        public RuleCondition fromString(String string) {
            return null;
        }
    };

    RuleRestrictionsPane() {
        final TableWidget widget = new TableWidget(false);
        widget.setPlaceholder(Messages.No_conditions_specified);
        widget.setItemsProvider(() -> new RuleRestriction());
        widget.setControlButtonsAvailability(ControlsPane.ADD_REMOVE_REORDERING);
        widget.setColumns(this.createTableColumns());
        widget.setOnRowsAction(event -> this.provideRowListeners((TableWidget<RuleRestriction>)widget, (TableRowEvent)event));
        this.controller = new TableWidgetController<TableWidget<RuleRestriction>, RuleRestriction>(){

            public TableWidget<RuleRestriction> getView() {
                return widget;
            }

            public void writeData(Collection<RuleRestriction> model) {
                super.writeData(model);
                for (RuleRestriction restriction : model) {
                    RuleValueRenderer renderer = RuleRestrictionsPane.this.findRenderer(restriction.getProperty(), restriction.getCondition());
                    Object value = renderer.joinValues(restriction.getCondition(), restriction.getValue());
                    restriction.setValue(value);
                }
            }
        };
        this.getChildren().add((Object)widget);
    }

    void readData(RuleSettings model) {
        this.target = model.getTarget();
        this.category = model.getFilteringCategory();
        this.controller.readData((Collection)model.getRestrictions());
    }

    void writeData(RuleSettings model) {
        this.controller.writeData((Collection)model.getRestrictions());
    }

    void setReadonly(boolean value) {
        this.controller.setReadonly(value);
    }

    private List<TableWidgetColumn<RuleRestriction, ?>> createTableColumns() {
        ArrayList columns = new ArrayList();
        ComboBoxWidgetColumn column1 = new ComboBoxWidgetColumn(rr -> rr.getProperty(), (rr, value) -> rr.setProperty(value));
        column1.setId(PROPERTY_ID);
        column1.setCaption(Messages.Property);
        column1.setPrefWidth(COLUMN_WIDTH);
        column1.setItemsSupplier(this.propertySupplier);
        column1.setConverter(propertyConverter);
        column1.setSuggestionsHandler((SuggestionsHandler)new SimpleSuggestionsHandler(column1.getConverter(), column1.getItemsSupplier(), column1.isSortItems()));
        columns.add((TableWidgetColumn<RuleRestriction, ?>)column1);
        ComboBoxWidgetColumn column2 = new ComboBoxWidgetColumn(rr -> rr.getCondition(), (rr, value) -> rr.setCondition(value));
        column2.setId(CONDITION_ID);
        column2.setCaption(Messages.Condition);
        column2.setPrefWidth(COLUMN_WIDTH);
        column2.setConverter(conditionConverter);
        columns.add((TableWidgetColumn<RuleRestriction, ?>)column2);
        RendererWidgetColumn column3 = new RendererWidgetColumn(rr -> rr.getValue(), (rr, value) -> rr.setValue(value));
        column3.setId(VALUE_ID);
        column3.setCaption(Messages.Value_text);
        columns.add((TableWidgetColumn<RuleRestriction, ?>)column3);
        RulesEditorExpandableColumn column4 = new RulesEditorExpandableColumn(r -> r.getProperty(), () -> this.createExpandableViewController());
        column4.setId(EXPANDABLE_ID);
        columns.add((TableWidgetColumn<RuleRestriction, ?>)column4);
        return columns;
    }

    private void provideRowListeners(TableWidget<RuleRestriction> widget, TableRowEvent event) {
        if (event.getTarget() == widget && event.getEventType() == TableRowEvent.ROW_ADD) {
            int row = event.getRowIndex();
            ComboBoxWidget node1 = (ComboBoxWidget)widget.getColumn(PROPERTY_ID).getWidget(row);
            ComboBoxWidget node2 = (ComboBoxWidget)widget.getColumn(CONDITION_ID).getWidget(row);
            RendererWidget node3 = (RendererWidget)widget.getColumn(VALUE_ID).getWidget(row);
            ExpandableColumn.ViewHolder node4 = (ExpandableColumn.ViewHolder)widget.getColumn(EXPANDABLE_ID).getWidget(row);
            RuleValueRenderer node3renderer = this.findRenderer((RuleProperty)node1.getValue(), (RuleCondition)node2.getValue());
            node2.setLive(true);
            this.updateConditionNode((ComboBoxWidget<RuleCondition>)node2, node3renderer.getFixedCondition(), (RuleProperty)node1.getValue());
            node3.setRenderer((NodeRenderer)node3renderer);
            TableWidget<?> propTable = node3renderer.getPropertiesTable(node3.getValueNode());
            ((BaseRulesTablePane.InnerTableView)node4.getView()).setInnerTable(propTable);
            node4.visibilityProperty().set(propTable != null);
            node2.valueProperty().addListener((obj, old, value) -> {
                if (value == null) {
                    node3.setValue(null);
                }
                node3.setRenderer((NodeRenderer)this.findRenderer((RuleProperty)node1.getValue(), (RuleCondition)node2.getValue()));
            });
            node1.valueProperty().addListener((obj, old, value) -> {
                RuleValueRenderer renderer = this.findRenderer((RuleProperty)value, (RuleCondition)node2.getValue());
                node3.setValue(null);
                node3.setRenderer((NodeRenderer)renderer);
                this.updateConditionNode((ComboBoxWidget<RuleCondition>)node2, renderer.getFixedCondition(), (RuleProperty)value);
                TableWidget<?> pTable = renderer.getPropertiesTable(node3.getValueNode());
                ((BaseRulesTablePane.InnerTableView)node4.getView()).setInnerTable(pTable);
                node4.visibilityProperty().set(pTable != null);
            });
        }
    }

    private void updateConditionNode(ComboBoxWidget<RuleCondition> node, RuleCondition fixedCondition, RuleProperty ruleProperty) {
        if (fixedCondition != null) {
            node.setValue((Object)fixedCondition);
            node.getViewState().setNotEditable(true);
            return;
        }
        node.getViewState().setNotEditable(false);
        RulesEnvironment re = RulesEnvironment.get();
        if (ruleProperty == null || !re.getConditions(ruleProperty).contains(node.getValue())) {
            node.setValue(null);
        }
        node.setItemsSupplier(() -> {
            if (ruleProperty == null) {
                node.setValue(null);
                return Collections.emptyList();
            }
            List conditions = re.getConditions(ruleProperty).stream().sorted((p1, p2) -> p1.getDisplayName().compareTo(p2.getDisplayName())).collect(Collectors.toList());
            return conditions;
        });
    }

    public DevToolItem asDevToolItem() {
        return new DevToolItem(){

            public Collection<?> getSubItems() {
                return Collections.singleton(RuleRestrictionsPane.this.controller.getView());
            }

            public String getInfo() {
                return ((Object)((Object)RuleRestrictionsPane.this)).getClass().getSimpleName();
            }
        };
    }
}

