/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.rules;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.editor.EditingMode;
import com.gridnine.xtrip.client.fx.core.lib.components.menu.CustomMenuItem;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.CardsContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextAreaWidget;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.rules.RuleActionsPane;
import com.gridnine.xtrip.client.fx.standard.rules.RuleParametersHandler;
import com.gridnine.xtrip.client.fx.standard.rules.RuleRestrictionsPane;
import com.gridnine.xtrip.client.fx.standard.rules.renderers.RulesCustomProperties;
import com.gridnine.xtrip.common.meta.ui.UiCardsContainer;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.xml.XSUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import javafx.scene.Node;

public class RuleSettingsDialog
extends CardsContainer {
    private final RuleParametersHandler<Node> parametersHandler;
    private final RuleRestrictionsPane restrictionsPane = new RuleRestrictionsPane();
    private final RuleActionsPane actionsPane;
    private final Card<TextAreaWidget> remarksCard = new Card("remarks", UiCardsContainer.Style.COLLAPSED, Messages.Comment, (Node)new TextAreaWidget(false));

    static void view(Node owner, RuleParametersHandler<?> parametersHandler, Function<RuleTarget, Collection<RuleAction>> actionsSupplier, RuleSettings data, RulesCustomProperties customProperties) {
        RuleSettingsDialog.show(owner, parametersHandler, actionsSupplier, EditingMode.VIEW, data, null, customProperties);
    }

    public static void edit(Node owner, RuleParametersHandler<?> parametersHandler, Function<RuleTarget, Collection<RuleAction>> actionsSupplier, RuleSettings data, Runnable applyCallback, boolean newRule, RulesCustomProperties customProperties) {
        RuleSettingsDialog.show(owner, parametersHandler, actionsSupplier, newRule ? EditingMode.CREATE : EditingMode.EDIT, data, applyCallback, customProperties);
    }

    private static void show(Node owner, RuleParametersHandler<?> parametersHandler, Function<RuleTarget, Collection<RuleAction>> actionsSupplier, EditingMode mode, RuleSettings data, Runnable callback, RulesCustomProperties customProperties) {
        RuleSettingsDialog pane = new RuleSettingsDialog(parametersHandler, actionsSupplier, (RulesCustomProperties)MiscUtil.guarded((Object)customProperties, (Object)new RulesCustomProperties()));
        if (customProperties != null) {
            pane.getProperties().put((Object)RulesCustomProperties.PROPS_KEY, (Object)customProperties);
            customProperties.set("target", data.getTarget());
        }
        pane.setReadonly(mode == EditingMode.VIEW);
        pane.readData(data);
        String title = "";
        switch (mode) {
            case CREATE: {
                title = Messages.Adding_a_Rule;
                break;
            }
            case EDIT: {
                title = Messages.Editing_a_Rule;
                break;
            }
            case VIEW: {
                title = Messages.View_rule;
                break;
            }
        }
        if (data.getTarget() != null) {
            String displayName = data.getTarget().getDisplayName();
            title = title + Messages.dlya + (TextUtil.isBlank((String)displayName) ? data.getTarget().getId() : displayName);
        }
        Dialog dialog = new Dialog();
        dialog.setTitle(title).setBody((Node)pane).setExpandToParent(true);
        if (mode != EditingMode.VIEW) {
            dialog.addButton(DialogButtonStyle.DECLINE, Messages.Cancel).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Dialog_save, () -> {
                pane.writeData(data);
                callback.run();
            });
        } else {
            dialog.addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Close);
        }
        dialog.setAdminToolsSupplier(() -> {
            CustomMenuItem item = new CustomMenuItem("Rule Technical Data");
            item.setOnAction(evt -> {
                try {
                    RuleSettings dataCopy = (RuleSettings)XCloneHelper.clone((XCloneable)data);
                    pane.writeData(dataCopy);
                    Dialog.message((Node)owner, (String)"Rule XML Data", (String)XSUtil.toString((XSSerializable)dataCopy));
                }
                catch (Exception e) {
                    ErrorHandler.handle((Throwable)e);
                }
            });
            return Collections.singletonList(item);
        });
        dialog.show(owner);
    }

    private RuleSettingsDialog(RuleParametersHandler<?> handler, Function<RuleTarget, Collection<RuleAction>> actionsSupplier, RulesCustomProperties customProperties) {
        this.parametersHandler = handler;
        this.actionsPane = new RuleActionsPane(actionsSupplier, customProperties);
        this.getCards().setAll((Object[])new Card[]{new Card("parameters", UiCardsContainer.Style.EXPANDED, Messages.Parameters, this.parametersHandler.createNode()), new Card("restrictions", UiCardsContainer.Style.EXPANDED, Messages.Conditions, (Node)this.restrictionsPane), new Card("actions", UiCardsContainer.Style.EXPANDED, Messages.Actions, (Node)this.actionsPane), this.remarksCard});
    }

    private void readData(RuleSettings model) {
        this.parametersHandler.readData(model, ((Card)this.getCards().get(0)).getContent());
        this.restrictionsPane.readData(model);
        this.actionsPane.readData(model);
        ((TextAreaWidget)this.remarksCard.getContent()).setValue(model.getRemarks());
        if (this.remarksCard.isCollapsed() && !TextUtil.isBlank((String)model.getRemarks())) {
            this.remarksCard.setCollapsed(false);
        }
    }

    private void writeData(RuleSettings model) {
        this.parametersHandler.writeData(model, ((Card)this.getCards().get(0)).getContent());
        this.restrictionsPane.writeData(model);
        this.actionsPane.writeData(model);
        model.setRemarks(((TextAreaWidget)this.remarksCard.getContent()).getValue());
    }

    private void setReadonly(boolean value) {
        this.parametersHandler.setReadonly(value, ((Card)this.getCards().get(0)).getContent());
        this.restrictionsPane.setReadonly(value);
        this.actionsPane.setReadonly(value);
        ((TextAreaWidget)this.remarksCard.getContent()).getViewState().setReadonly(value);
    }
}

