/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.rules;

import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.rules.renderers.RuleActionRenderer;
import com.gridnine.xtrip.client.fx.standard.rules.renderers.RuleValueRenderer;
import com.gridnine.xtrip.client.fx.standard.rules.renderers.RuleValueRendererFactory;
import com.gridnine.xtrip.common.model.rules.standard.RuleResultValue;
import com.gridnine.xtrip.common.model.rules.standard.ValueTypes;
import com.gridnine.xtrip.common.rules.RuleRestriction;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.util.Identity;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.TrieMap;
import java.time.LocalDate;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Pattern;

public class RuleSettingsWrapper
implements Identity {
    private static final Object STUB = new Object();
    private final RuleSettings source;
    private int index;
    private final TrieMap<Object> fullText = new TrieMap();
    private String name;
    private LocalDate beginDate;
    private LocalDate endDate;
    private String description;
    private static final Pattern SPLIT_PATTERN = Pattern.compile("[^a-zA-Z\u0430-\u044f\u0410-\u042f_0-9]");

    public RuleSettingsWrapper(RuleSettings rs, int idx) {
        this.source = rs;
        this.index = idx;
        this.rebuild();
    }

    public String getUid() {
        return this.source.getUid();
    }

    public void setUid(String value) {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof RuleSettingsWrapper)) {
            return false;
        }
        return this.source.equals((Object)((RuleSettingsWrapper)obj).source);
    }

    public int hashCode() {
        return this.source.hashCode();
    }

    public void rebuild() {
        String targetName;
        RuleTarget target = this.source.getTarget();
        this.name = this.source.getName();
        if (TextUtil.isBlank((String)this.name)) {
            this.name = target == null ? Messages.Not_specified : (TextUtil.isBlank((String)(targetName = target.getDisplayName())) ? target.getId() : targetName);
        } else if (target != null) {
            targetName = target.getDisplayName();
            this.name = this.name + " [" + (TextUtil.isBlank((String)targetName) ? target.getId() : targetName) + ']';
        }
        this.aggregate(this.name);
        this.beginDate = DateUtils.asLocalDate((Date)this.source.getPeriodBegin());
        this.endDate = DateUtils.asLocalDate((Date)this.source.getPeriodEnd());
        StringBuilder descriptionBuf = new StringBuilder("<html>");
        if (!this.source.getRestrictions().isEmpty()) {
            descriptionBuf.append("<b>").append(Messages.Rule_description_if).append("</b> ");
        }
        boolean first = true;
        for (RuleRestriction rr : this.source.getRestrictions()) {
            if (first) {
                first = false;
            } else {
                descriptionBuf.append("<br><b>").append(Messages.Rule_description_and).append("</b> ");
            }
            RuleProperty property = rr.getProperty();
            RuleCondition condition = rr.getCondition();
            if (property == null || condition == null) {
                descriptionBuf.append(Messages.Unfilled_Condition);
                continue;
            }
            if (ValueTypes.YES_NO.name().equals(property.getRendererId())) {
                StringBuilder buf = new StringBuilder();
                property.buildInfo(buf, condition, rr.getValue());
                String str2 = buf.toString();
                descriptionBuf.append(str2);
                this.aggregate(str2);
                continue;
            }
            if (!condition.hasRightSide()) {
                descriptionBuf.append(property.getDisplayName()).append(": ").append(condition.getDisplayName());
                this.aggregate(property.getDisplayName());
                this.aggregate(condition.getDisplayName());
                continue;
            }
            RuleValueRendererFactory factory = RuleValueRendererFactory.forId(property.getId());
            RuleValueRenderer renderer = factory != null ? factory.createRenderer(condition) : RuleValueRenderer.forId(property.getRendererId());
            if (renderer == null) {
                descriptionBuf.append(String.format("no renderer with ID %s found for property %s", property.getRendererId(), property.getId()));
                continue;
            }
            renderer.buildRestrictionsInfo(str -> {
                descriptionBuf.append((String)str);
                this.aggregate((String)str);
            }, rr);
        }
        if (!this.source.getRestrictions().isEmpty() && !this.source.getResults().isEmpty()) {
            descriptionBuf.append("<br><b>").append(Messages.Rule_description_then).append("</b> ");
        }
        first = true;
        for (RuleRestriction rr : this.source.getResults()) {
            RuleAction action;
            String str3;
            RuleResultValue ruleResultValue;
            if (first) {
                first = false;
            } else {
                descriptionBuf.append("<br><b>").append(Messages.Rule_description_and).append("</b> ");
            }
            if (rr.getValue() != null && rr.getValue() instanceof RuleResultValue && (ruleResultValue = (RuleResultValue)rr.getValue()).getTarget() != null && !TextUtil.isBlank((String)(str3 = ruleResultValue.getTarget().getCaption()))) {
                descriptionBuf.append(str3).append(" ");
                this.aggregate(str3);
            }
            if ((action = rr.getAction()) == null) {
                descriptionBuf.append(Messages.Unfilled_Action);
                continue;
            }
            RuleActionRenderer renderer = RuleActionRenderer.forId(action.getRendererId());
            if (renderer == null) {
                descriptionBuf.append(String.format("no renderer with ID %s found for action %s", action.getRendererId(), action.getId()));
                continue;
            }
            renderer.buildResultsInfo(str -> {
                descriptionBuf.append((String)str);
                this.aggregate((String)str);
            }, rr);
        }
        this.description = descriptionBuf.toString();
    }

    private void aggregate(String str) {
        if (str == null) {
            return;
        }
        for (String part : SPLIT_PATTERN.split(str)) {
            if ((part = part.trim().toLowerCase(Locale.ROOT)).isEmpty()) continue;
            this.fullText.put(part, STUB);
        }
    }

    public RuleSettings getSource() {
        return this.source;
    }

    int getIndex() {
        return this.index;
    }

    void setIndex(int value) {
        this.index = value;
    }

    String getName() {
        return this.name;
    }

    LocalDate getBeginDate() {
        return this.beginDate;
    }

    LocalDate getEndDate() {
        return this.endDate;
    }

    String getDescription() {
        return this.description;
    }

    boolean matches(String pattern) {
        if (TextUtil.isBlank((String)pattern)) {
            return false;
        }
        for (String str : SPLIT_PATTERN.split(pattern)) {
            if (TextUtil.isBlank((String)str) || this.fullText.search(str).hasNext()) continue;
            return false;
        }
        return true;
    }
}

