/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.rules;

import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.registry.basic.Renderer;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.rules.RuleSettingsWrapper;
import javafx.scene.control.TableColumn;

enum RulesColumn {
    NUMBER{

        @Override
        protected String getDisplayName() {
            return Messages.Rule_Number;
        }

        @Override
        protected Object getValue(RuleSettingsWrapper item) {
            return String.valueOf(item.getIndex() + 1);
        }

        @Override
        protected Double getSize() {
            return 70.0;
        }
    }
    ,
    NAME{

        @Override
        protected String getDisplayName() {
            return Messages.Name;
        }

        @Override
        protected Object getValue(RuleSettingsWrapper item) {
            return item.getName();
        }

        @Override
        protected Double getMinSize() {
            return 100.0;
        }
    }
    ,
    BEGIN_DATE{

        @Override
        protected String getDisplayName() {
            return Messages.Beginning;
        }

        @Override
        protected Object getValue(RuleSettingsWrapper item) {
            return item.getBeginDate();
        }

        @Override
        protected Renderer getRenderer() {
            return StandardRenderers.DATE;
        }

        @Override
        protected Double getSize() {
            return 180.0;
        }
    }
    ,
    END_DATE{

        @Override
        protected String getDisplayName() {
            return Messages.Ending;
        }

        @Override
        protected Object getValue(RuleSettingsWrapper item) {
            return item.getEndDate();
        }

        @Override
        protected Renderer getRenderer() {
            return StandardRenderers.DATE;
        }

        @Override
        protected Double getSize() {
            return 180.0;
        }
    }
    ,
    DESCRIPTION{

        @Override
        protected String getDisplayName() {
            return Messages.Conditions_and_actions;
        }

        @Override
        protected Object getValue(RuleSettingsWrapper item) {
            return item.getDescription();
        }

        @Override
        protected Double getMinSize() {
            return 100.0;
        }
    };


    protected abstract String getDisplayName();

    protected abstract Object getValue(RuleSettingsWrapper var1);

    final TableColumn<RuleSettingsWrapper, Object> createColumn() {
        TableColumnSettings settings = new TableColumnSettings();
        settings.setId(this.name());
        settings.setDisplayName(this.getDisplayName());
        settings.setSortable(false);
        settings.setPrefWidth(this.getSize());
        settings.setRenderer(this.getRenderer());
        TableColumn result = settings.createColumn(this::getValue);
        Double minSize = this.getMinSize();
        if (minSize != null) {
            result.setMinWidth(minSize.doubleValue());
        }
        return result;
    }

    protected Renderer getRenderer() {
        return StandardRenderers.GENERIC;
    }

    protected Double getSize() {
        return null;
    }

    protected Double getMinSize() {
        return null;
    }
}

