/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.rules;

import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.Tile;
import com.gridnine.xtrip.client.fx.core.lib.widgets.CustomWidget;
import com.gridnine.xtrip.client.fx.standard.rules.FullRulesWidget;
import com.gridnine.xtrip.client.fx.standard.rules.GridCellTools;
import com.gridnine.xtrip.client.fx.standard.rules.RuleSettingsWrapper;
import com.gridnine.xtrip.client.fx.standard.rules.RulesViewConfiguration;
import com.gridnine.xtrip.client.fx.standard.rules.Tools;
import com.gridnine.xtrip.common.rules.RuleSet;
import java.util.ArrayList;
import java.util.Arrays;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;

public final class RulesWidgetHelper {
    public static void initTile(Tile<Node, CustomWidget<RuleSet>> tile, RulesViewConfiguration config) {
        if (!(tile.getFullNode() instanceof FullRulesWidget)) {
            throw new IllegalArgumentException();
        }
        final Tile<Node, CustomWidget<RuleSet>> rulesTile = tile;
        RulesWidgetHelper.initWidget((FullRulesWidget)rulesTile.getFullNode(), config);
        rulesTile.expandedProperty().addListener(src -> RulesWidgetHelper.populateTools((Tile<Node, FullRulesWidget>)rulesTile));
        ((FullRulesWidget)rulesTile.getFullNode()).getViewState().stateProperty().addListener((s, o, n) -> tile.revalidateActions());
        ((FullRulesWidget)rulesTile.getFullNode()).getSelectedRules().addListener(src -> tile.revalidateActions());
        RulesWidgetHelper.populateTools(rulesTile);
        rulesTile.expandedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    return;
                }
                rulesTile.expandedProperty().removeListener((ChangeListener)this);
                FullRulesWidget widget = (FullRulesWidget)rulesTile.getFullNode();
                if (widget.getData().isEmpty()) {
                    return;
                }
                widget.selectRule(((RuleSettingsWrapper)widget.getData().get(0)).getUid());
            }
        });
    }

    public static void initGridCell(GridCell<CustomWidget<RuleSet>> cell, RulesViewConfiguration config) {
        if (!(cell.getPayload() instanceof FullRulesWidget)) {
            throw new IllegalArgumentException();
        }
        FullRulesWidget widget = (FullRulesWidget)cell.getPayload();
        RulesWidgetHelper.initWidget(widget, config);
        widget.getViewState().stateProperty().addListener((s, o, n) -> cell.revalidateActions());
        widget.getSelectedRules().addListener(src -> cell.revalidateActions());
        RulesWidgetHelper.populateTools(cell);
    }

    public static void initWidget(FullRulesWidget widget, RulesViewConfiguration config) {
        widget.init(config);
    }

    private static void populateTools(Tile<Node, FullRulesWidget> rulesTile) {
        if (rulesTile.isExpanded()) {
            ArrayList actions = new ArrayList(Tools.values().length);
            Arrays.stream(Tools.values()).filter(tool -> tool.isAvailable(rulesTile)).forEach(actions::add);
            rulesTile.getActions().setAll(actions);
        } else {
            rulesTile.getActions().clear();
        }
    }

    private static void populateTools(GridCell<FullRulesWidget> rulesCell) {
        rulesCell.getActions().setAll(Arrays.asList(GridCellTools.values()));
    }

    private RulesWidgetHelper() {
    }

    static FullRulesWidget getWidget(GridCell<Node> cell) {
        return (FullRulesWidget)cell.getPayload();
    }
}

