/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.rules;

import com.gridnine.xtrip.client.fx.core.lib.components.QuickHelp;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.widgets.CheckBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.DateValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.client.fx.core.util.ValueHolder;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.rules.RuleSettingsWrapper;
import com.gridnine.xtrip.client.fx.standard.rules.RulesFilter;
import com.gridnine.xtrip.client.fx.standard.rules.RulesViewConfiguration;
import com.gridnine.xtrip.common.fx.rpc.StandardFxService;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.Properties;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.TextUtil;
import java.time.LocalDate;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;

public enum StandardFilters implements RulesFilter
{
    TEXT{

        @Override
        public Predicate<RuleSettingsWrapper> build(RulesViewConfiguration configuration, List<GridCell<?>> cells, Runnable runnable) {
            TextFieldWidget widget = new TextFieldWidget(false);
            ValueHolder pattern = new ValueHolder(null);
            widget.valueProperty().addListener((s, o, n) -> {
                String value = widget.getValue();
                if (value != null) {
                    value = (value = value.trim()).isEmpty() ? null : value.toLowerCase(Locale.ROOT);
                }
                pattern.set((Object)value);
            });
            cells.add(new GridCell(Messages.Search, (Node)widget));
            widget.addEventHandler(KeyEvent.KEY_RELEASED, event -> {
                if (event.getCode() == KeyCode.ENTER) {
                    runnable.run();
                }
            });
            return ruleSettings -> {
                if (pattern.get() == null) {
                    return true;
                }
                return ruleSettings.matches((String)pattern.get());
            };
        }
    }
    ,
    FROM{

        @Override
        public Predicate<RuleSettingsWrapper> build(RulesViewConfiguration configuration, List<GridCell<?>> cells, Runnable runnable) {
            DateValueWidget widget = new DateValueWidget(false);
            cells.add(new GridCell(Messages.Start_application, (Node)widget));
            widget.addEventHandler(KeyEvent.KEY_RELEASED, event -> {
                if (event.getCode() == KeyCode.ENTER) {
                    runnable.run();
                }
            });
            return ruleSettings -> {
                LocalDate value = widget.getValue();
                if (value == null) {
                    return true;
                }
                LocalDate date = ruleSettings.getBeginDate();
                if (date == null) {
                    return false;
                }
                return !date.isBefore(value);
            };
        }
    }
    ,
    TO{

        @Override
        public Predicate<RuleSettingsWrapper> build(RulesViewConfiguration configuration, List<GridCell<?>> cells, Runnable runnable) {
            DateValueWidget widget = new DateValueWidget(false);
            cells.add(new GridCell(Messages.End_application, (Node)widget));
            widget.addEventHandler(KeyEvent.KEY_RELEASED, event -> {
                if (event.getCode() == KeyCode.ENTER) {
                    runnable.run();
                }
            });
            return ruleSettings -> {
                LocalDate value = widget.getValue();
                if (value == null) {
                    return true;
                }
                LocalDate date = ruleSettings.getEndDate();
                if (date == null) {
                    return false;
                }
                return !date.isAfter(value);
            };
        }
    }
    ,
    VALIDATING_CARRIER{

        @Override
        public Predicate<RuleSettingsWrapper> build(RulesViewConfiguration configuration, List<GridCell<?>> cells, Runnable runnable) {
            TextFieldWidget widget = new TextFieldWidget(false);
            CheckBoxWidget appWidget = new CheckBoxWidget(false);
            appWidget.setSelected(false);
            HashSet codes = new HashSet();
            widget.valueProperty().addListener((s, o, n) -> {
                String value = widget.getValue();
                if (TextUtil.isBlank((String)value)) {
                    codes.clear();
                    return;
                }
                Notifications.get().submitTask(() -> {
                    Airline airline = ((StandardFxService)RpcServiceManager.get().getService(StandardFxService.class)).findAirline(ServiceInvocationContext.get(), value);
                    FxUtil.submitToFxThread(() -> {
                        codes.clear();
                        codes.add(value.trim().toLowerCase(Locale.ROOT));
                        if (airline != null) {
                            codes.add(airline.getCode().toLowerCase(Locale.ROOT));
                            codes.add(airline.getAirlineNumber().toLowerCase(Locale.ROOT));
                            for (String code : airline.getCodeVariants().values()) {
                                codes.add(code.toLowerCase(Locale.ROOT));
                            }
                        }
                    });
                }, ObservableMutex.lookup((Node)widget));
            });
            widget.addEventHandler(KeyEvent.KEY_RELEASED, event -> {
                if (event.getCode() == KeyCode.ENTER) {
                    runnable.run();
                }
            });
            cells.add(new GridCell(Messages.Validating_carrier, (Node)widget));
            GridCell appCell = new GridCell(Messages.Applied_rules, (Node)appWidget);
            appCell.setHelp(() -> new QuickHelp(Messages.Applied_rules_help));
            cells.add(appCell);
            return ruleSettings -> {
                if (codes.isEmpty()) {
                    return true;
                }
                List restrictions = ruleSettings.getSource().getRestrictions().stream().filter(r -> r.getValue() != null).filter(r -> r.getCondition() != null).filter(r -> r.getProperty() == Properties.CARRIERS || r.getProperty() == Properties.CARRIER_NUMBER).collect(Collectors.toList());
                if (restrictions.isEmpty()) {
                    return appWidget.isSelected();
                }
                List include = restrictions.stream().filter(r -> !r.getCondition().equals(Conditions.EXCLUDE)).map(r -> r.getValue().toString().replaceAll("[\\[\\]]", "").toLowerCase(Locale.ROOT)).collect(Collectors.toList());
                List exclude = restrictions.stream().filter(r -> r.getCondition().equals(Conditions.EXCLUDE)).map(r -> r.getValue().toString().replaceAll("[\\[\\]]", "").toLowerCase(Locale.ROOT)).collect(Collectors.toList());
                if (!codes.stream().anyMatch(c -> include.isEmpty() || include.contains(c))) return false;
                if (!codes.stream().noneMatch(exclude::contains)) return false;
                return true;
            };
        }
    }
    ,
    ACTUAL_ONLY{

        @Override
        public Predicate<RuleSettingsWrapper> build(RulesViewConfiguration configuration, List<GridCell<?>> cells, Runnable runnable) {
            CheckBoxWidget widget = new CheckBoxWidget(false);
            widget.setSelected(true);
            cells.add(new GridCell(Messages.Actual_rules, (Node)widget));
            return ruleSettings -> {
                if (!widget.isSelected()) {
                    return true;
                }
                LocalDate now = LocalDate.now();
                LocalDate beginDate = ruleSettings.getBeginDate();
                if (beginDate != null && now.isBefore(beginDate)) {
                    return false;
                }
                LocalDate endDate = ruleSettings.getEndDate();
                return endDate == null || !now.isAfter(endDate);
            };
        }
    };

}

