/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.rules;

import com.gridnine.xtrip.client.fx.core.lib.container.tiles.Tile;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.TileAction;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.rules.ExportRulesDialog;
import com.gridnine.xtrip.client.fx.standard.rules.FullRulesWidget;
import com.gridnine.xtrip.client.fx.standard.rules.ImportRulesDialog;
import com.gridnine.xtrip.client.fx.standard.rules.RuleSettingsWrapper;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.layout.Region;

enum Tools implements TileAction<Node, FullRulesWidget>
{
    EDIT{

        public String getName(Tile<Node, FullRulesWidget> tile) {
            return ((FullRulesWidget)tile.getFullNode()).getViewState().isImmutable() ? Messages.Look : Messages.Edit;
        }

        public String getDescription(Tile<Node, FullRulesWidget> tile) {
            return Messages.Edit_selected_rule;
        }

        @Override
        boolean isAvailable(Tile<Node, FullRulesWidget> tile) {
            return tile.isExpanded();
        }

        public boolean isEnabled(Tile<Node, FullRulesWidget> tile) {
            return ((FullRulesWidget)tile.getFullNode()).getSelectedRules().size() == 1;
        }

        public void execute(Control source, Tile<Node, FullRulesWidget> tile, boolean alt) {
            ((FullRulesWidget)tile.getFullNode()).viewOrEdit((RuleSettingsWrapper)((FullRulesWidget)tile.getFullNode()).getSelectedRules().get(0));
        }
    }
    ,
    ADD{

        public String getName(Tile<Node, FullRulesWidget> tile) {
            return Messages.Dialog_add;
        }

        public String getDescription(Tile<Node, FullRulesWidget> tile) {
            return Messages.Add_new_rule;
        }

        @Override
        boolean isAvailable(Tile<Node, FullRulesWidget> tile) {
            return tile.isExpanded();
        }

        public boolean isEnabled(Tile<Node, FullRulesWidget> tile) {
            return !((FullRulesWidget)tile.getFullNode()).getViewState().isImmutable();
        }

        public void execute(Control source, Tile<Node, FullRulesWidget> tile, boolean alt) {
            ((FullRulesWidget)tile.getFullNode()).addRule((Region)source, ((FullRulesWidget)tile.getFullNode()).getSelectedRules().size() != 1 ? null : (RuleSettingsWrapper)((FullRulesWidget)tile.getFullNode()).getSelectedRules().get(0));
        }
    }
    ,
    REMOVE{

        public String getName(Tile<Node, FullRulesWidget> tile) {
            return Messages.Delete;
        }

        public String getDescription(Tile<Node, FullRulesWidget> tile) {
            return Messages.Delete_selected_rules;
        }

        @Override
        boolean isAvailable(Tile<Node, FullRulesWidget> tile) {
            return tile.isExpanded();
        }

        public boolean isEnabled(Tile<Node, FullRulesWidget> tile) {
            return !((FullRulesWidget)tile.getFullNode()).getViewState().isImmutable() && !((FullRulesWidget)tile.getFullNode()).getSelectedRules().isEmpty();
        }

        public void execute(Control source, Tile<Node, FullRulesWidget> tile, boolean alt) {
            ((FullRulesWidget)tile.getFullNode()).removeRules((List<RuleSettingsWrapper>)((FullRulesWidget)tile.getFullNode()).getSelectedRules());
        }
    }
    ,
    CLONE{

        public String getName(Tile<Node, FullRulesWidget> tile) {
            return Messages.Copy;
        }

        public String getDescription(Tile<Node, FullRulesWidget> tile) {
            return Messages.Add_a_new_rule_based_on_the_selected;
        }

        @Override
        boolean isAvailable(Tile<Node, FullRulesWidget> tile) {
            return tile.isExpanded();
        }

        public boolean isEnabled(Tile<Node, FullRulesWidget> tile) {
            return !((FullRulesWidget)tile.getFullNode()).getViewState().isImmutable() && ((FullRulesWidget)tile.getFullNode()).getSelectedRules().size() == 1;
        }

        public void execute(Control source, Tile<Node, FullRulesWidget> tile, boolean alt) {
            ((FullRulesWidget)tile.getFullNode()).cloneRule((RuleSettingsWrapper)((FullRulesWidget)tile.getFullNode()).getSelectedRules().get(0));
        }
    }
    ,
    MOVE_UP{

        public String getName(Tile<Node, FullRulesWidget> tile) {
            return Messages.Up;
        }

        public String getDescription(Tile<Node, FullRulesWidget> tile) {
            return Messages.Move_Up_one_position;
        }

        @Override
        boolean isAvailable(Tile<Node, FullRulesWidget> tile) {
            return tile.isExpanded();
        }

        public boolean isEnabled(Tile<Node, FullRulesWidget> tile) {
            if (((FullRulesWidget)tile.getFullNode()).getSelectedRules().size() != 1) {
                return false;
            }
            return !((FullRulesWidget)tile.getFullNode()).getViewState().isImmutable() && ((FullRulesWidget)tile.getFullNode()).isMoveUpAvailable((RuleSettingsWrapper)((FullRulesWidget)tile.getFullNode()).getSelectedRules().get(0));
        }

        public void execute(Control source, Tile<Node, FullRulesWidget> tile, boolean alt) {
            ((FullRulesWidget)tile.getFullNode()).moveUp((RuleSettingsWrapper)((FullRulesWidget)tile.getFullNode()).getSelectedRules().get(0));
        }
    }
    ,
    MOVE_DOWN{

        public String getName(Tile<Node, FullRulesWidget> tile) {
            return Messages.Down;
        }

        public String getDescription(Tile<Node, FullRulesWidget> tile) {
            return Messages.Move_Down_one_position;
        }

        @Override
        boolean isAvailable(Tile<Node, FullRulesWidget> tile) {
            return tile.isExpanded();
        }

        public boolean isEnabled(Tile<Node, FullRulesWidget> tile) {
            if (((FullRulesWidget)tile.getFullNode()).getSelectedRules().size() != 1) {
                return false;
            }
            return !((FullRulesWidget)tile.getFullNode()).getViewState().isImmutable() && ((FullRulesWidget)tile.getFullNode()).isMoveDownAvailable((RuleSettingsWrapper)((FullRulesWidget)tile.getFullNode()).getSelectedRules().get(0));
        }

        public void execute(Control source, Tile<Node, FullRulesWidget> tile, boolean alt) {
            ((FullRulesWidget)tile.getFullNode()).moveDown((RuleSettingsWrapper)((FullRulesWidget)tile.getFullNode()).getSelectedRules().get(0));
        }
    }
    ,
    MOVE{

        public String getName(Tile<Node, FullRulesWidget> tile) {
            return Messages.Move;
        }

        public String getDescription(Tile<Node, FullRulesWidget> tile) {
            return Messages.Move_to_the_specified_position;
        }

        @Override
        boolean isAvailable(Tile<Node, FullRulesWidget> tile) {
            return tile.isExpanded();
        }

        public boolean isEnabled(Tile<Node, FullRulesWidget> tile) {
            return !((FullRulesWidget)tile.getFullNode()).getViewState().isImmutable() && ((FullRulesWidget)tile.getFullNode()).getSelectedRules().size() == 1;
        }

        public void execute(Control source, Tile<Node, FullRulesWidget> tile, boolean alt) {
            ((FullRulesWidget)tile.getFullNode()).move((Region)source, (RuleSettingsWrapper)((FullRulesWidget)tile.getFullNode()).getSelectedRules().get(0));
        }
    }
    ,
    IMPORT{

        public String getName(Tile<Node, FullRulesWidget> tile) {
            return Messages.To_Import;
        }

        public String getDescription(Tile<Node, FullRulesWidget> tile) {
            return Messages.Import_rules;
        }

        @Override
        boolean isAvailable(Tile<Node, FullRulesWidget> tile) {
            return tile.isExpanded();
        }

        public boolean isEnabled(Tile<Node, FullRulesWidget> tile) {
            return !((FullRulesWidget)tile.getFullNode()).getViewState().isImmutable();
        }

        public void execute(Control source, Tile<Node, FullRulesWidget> tile, boolean alt) {
            ImportRulesDialog dialog = new ImportRulesDialog();
            dialog.showDialog(source, (FullRulesWidget)tile.getFullNode());
        }
    }
    ,
    EXPORT{

        public String getName(Tile<Node, FullRulesWidget> tile) {
            return Messages.Export;
        }

        public String getDescription(Tile<Node, FullRulesWidget> tile) {
            return Messages.Export_rules;
        }

        @Override
        boolean isAvailable(Tile<Node, FullRulesWidget> tile) {
            return tile.isExpanded();
        }

        public boolean isEnabled(Tile<Node, FullRulesWidget> tile) {
            return !((FullRulesWidget)tile.getFullNode()).getData().isEmpty();
        }

        public void execute(Control source, Tile<Node, FullRulesWidget> tile, boolean alt) {
            ExportRulesDialog dialog = new ExportRulesDialog();
            dialog.showDialog(source, (FullRulesWidget)tile.getFullNode());
        }
    };


    public double getWeight() {
        return this.ordinal();
    }

    abstract boolean isAvailable(Tile<Node, FullRulesWidget> var1);
}

