/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.rules.renderers;

import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.TextWidgetColumn;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.rules.renderers.RuleValueRenderer;
import com.gridnine.xtrip.client.fx.standard.rules.renderers.StandardRuleValueRenderers;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.RouteSegmentsRestriction;
import com.gridnine.xtrip.common.model.rules.standard.ValueTypes;
import com.gridnine.xtrip.common.rules.RuleRestriction;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javafx.scene.Node;

public class RouteSegmentsValueRenderer
implements RuleValueRenderer {
    public String getId() {
        return ValueTypes.ROUTE_SEGMENTS_RESTRICTION.name();
    }

    public Node createNode(boolean readonly) {
        Node node = StandardRuleValueRenderers.NULL.createNode(readonly);
        node.setUserData((Object)new RouteSegmentsTable(readonly));
        return node;
    }

    public RouteSegmentsTable getPropertiesTable(Node node) {
        return (RouteSegmentsTable)((Object)node.getUserData());
    }

    public Object getValue(final Node node) {
        RouteSegmentsTable table = this.getPropertiesTable(node);
        if (table == null) {
            return null;
        }
        ArrayList rows = new ArrayList();
        TableWidgetController<RouteSegmentsTable, RouteSegmentsRow> controller = new TableWidgetController<RouteSegmentsTable, RouteSegmentsRow>(){

            public RouteSegmentsTable getView() {
                return RouteSegmentsValueRenderer.this.getPropertiesTable(node);
            }
        };
        controller.writeData(rows);
        RouteSegmentsRestriction restriction = new RouteSegmentsRestriction();
        for (RouteSegmentsRow patterns : rows) {
            RouteSegmentsRestriction.ComplexSegmentRestriction element = new RouteSegmentsRestriction.ComplexSegmentRestriction();
            element.fromPatterns(patterns.routes, patterns.marketingCarriers, patterns.operatingCarriers, patterns.flightNumbers, patterns.segmentsCount);
            restriction.getRestrictions().add(element);
        }
        return restriction;
    }

    public void setValue(final Node node, Object value) {
        if (value == null) {
            return;
        }
        RouteSegmentsRestriction restriction = (RouteSegmentsRestriction)value;
        ArrayList<RouteSegmentsRow> rows = new ArrayList<RouteSegmentsRow>();
        for (RouteSegmentsRestriction.ComplexSegmentRestriction element : restriction.getRestrictions()) {
            RouteSegmentsRow row = new RouteSegmentsRow();
            row.segmentsCount = element.getSegmentsCountPattern();
            row.routes = element.getRouteRestriction();
            row.marketingCarriers = element.getMarketingCarriersPattern();
            row.operatingCarriers = element.getOperatingCarriersPattern();
            row.flightNumbers = element.getFlightNumbersPattern();
            rows.add(row);
        }
        TableWidgetController<RouteSegmentsTable, RouteSegmentsRow> controller = new TableWidgetController<RouteSegmentsTable, RouteSegmentsRow>(){

            public RouteSegmentsTable getView() {
                return RouteSegmentsValueRenderer.this.getPropertiesTable(node);
            }
        };
        controller.readData(rows);
    }

    @Override
    public RuleCondition getFixedCondition() {
        return Conditions.CONTAINS_ONLY;
    }

    @Override
    public boolean isValueEmpty(Node node) {
        RouteSegmentsTable table = this.getPropertiesTable(node);
        return table == null || table.getRowsCount() <= 0;
    }

    @Override
    public void buildRestrictionsInfo(Consumer<String> out, RuleRestriction ruleRestriction) {
        StringBuilder buf = new StringBuilder();
        RouteSegmentsRestriction value = (RouteSegmentsRestriction)ruleRestriction.getValue();
        value.buildInfo(buf);
        out.accept(buf.toString());
    }

    public void setReadonly(boolean readonly, Node node) {
        this.getPropertiesTable(node).getViewState().setReadonly(readonly);
    }

    class RouteSegmentsTable
    extends TableWidget<RouteSegmentsRow> {
        RouteSegmentsTable(boolean readonly) {
            super(readonly);
            this.setItemsProvider(() -> new RouteSegmentsRow());
            this.getViewState().setNotEditable(false);
            this.setColumns(this.createColumns());
        }

        private List<TableWidgetColumn<RouteSegmentsRow, ?>> createColumns() {
            ArrayList tableColumns = new ArrayList();
            TextWidgetColumn column1 = new TextWidgetColumn(c -> c.segmentsCount, (c, v) -> {
                c.segmentsCount = v;
            });
            column1.setId("SEGMENTS_COUNT");
            column1.setCaption(Messages.Segments_Count);
            column1.setPrefWidth(Double.valueOf(19.0));
            tableColumns.add((TableWidgetColumn<RouteSegmentsRow, ?>)column1);
            TextWidgetColumn column2 = new TextWidgetColumn(c -> c.routes, (c, v) -> {
                c.routes = v;
            });
            column2.setId("ROUTE");
            column2.setCaption(Messages.Route);
            column2.setPrefWidth(Double.valueOf(19.0));
            tableColumns.add((TableWidgetColumn<RouteSegmentsRow, ?>)column2);
            TextWidgetColumn column3 = new TextWidgetColumn(c -> c.marketingCarriers, (c, v) -> {
                c.marketingCarriers = v;
            });
            column3.setId("MARKETING_CARRIERS");
            column3.setCaption(Messages.Marketing_carrier);
            column3.setPrefWidth(Double.valueOf(19.0));
            tableColumns.add((TableWidgetColumn<RouteSegmentsRow, ?>)column3);
            TextWidgetColumn column4 = new TextWidgetColumn(c -> c.operatingCarriers, (c, v) -> {
                c.operatingCarriers = v;
            });
            column4.setId("OPERATING_CARRIERS");
            column4.setCaption(Messages.Operating_carrier);
            column4.setPrefWidth(Double.valueOf(19.0));
            tableColumns.add((TableWidgetColumn<RouteSegmentsRow, ?>)column4);
            TextWidgetColumn column5 = new TextWidgetColumn(c -> c.flightNumbers, (c, v) -> {
                c.flightNumbers = v;
            });
            column5.setId("FLIGHT_NUMBERS");
            column5.setCaption(Messages.Flight_Numbers);
            tableColumns.add((TableWidgetColumn<RouteSegmentsRow, ?>)column5);
            return tableColumns;
        }
    }

    class RouteSegmentsRow {
        String segmentsCount;
        String routes;
        String marketingCarriers;
        String operatingCarriers;
        String flightNumbers;

        RouteSegmentsRow() {
        }
    }
}

