/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.rules.renderers;

import com.gridnine.xtrip.client.fx.core.lib.widgets.NodeRenderer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.RateMoneyValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.HasViewState;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.rules.renderers.FopCommissionNodeRenderer;
import com.gridnine.xtrip.client.fx.standard.rules.renderers.RuleActionRenderer;
import com.gridnine.xtrip.client.fx.standard.rules.renderers.RulesCustomProperties;
import com.gridnine.xtrip.client.fx.standard.rules.renderers.ServiceCommissionRenderer;
import com.gridnine.xtrip.client.fx.standard.rules.renderers.StandardRuleResultValueRenderer;
import com.gridnine.xtrip.client.fx.standard.rules.renderers.StandardRuleValueRenderers;
import com.gridnine.xtrip.common.fx.rpc.DictItem;
import com.gridnine.xtrip.common.fx.rpc.DictQuery;
import com.gridnine.xtrip.common.fx.rpc.DictService;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.ProductDateData;
import com.gridnine.xtrip.common.model.booking.ProductPeriodType;
import com.gridnine.xtrip.common.model.booking.TripartitePublicFareDiscount;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.DiscountProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeProperties;
import com.gridnine.xtrip.common.model.dict.FeeRemarkTemplate;
import com.gridnine.xtrip.common.model.finance.FinanceDocumentData;
import com.gridnine.xtrip.common.model.profile.TripartiteContractSubtype;
import com.gridnine.xtrip.common.model.rules.standard.Actions;
import com.gridnine.xtrip.common.model.rules.standard.RuleResultValue;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.SabreRemarkResult;
import com.gridnine.xtrip.common.model.rules.standard.SabreSynchronizationAdditionalTargets;
import com.gridnine.xtrip.common.model.rules.standard.ServiceClassCommissionsRuleResultValue;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.RateMoney;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javafx.scene.Node;
import javafx.scene.layout.StackPane;

public enum StandardRuleActionRenderers implements RuleActionRenderer
{
    NULL{

        public Node createNode(boolean readonly) {
            StackPane node = new StackPane();
            node.getStyleClass().add((Object)"stub-widget");
            return node;
        }

        public Object getValue(Node node) {
            return null;
        }

        public void setValue(Node node, Object value) {
        }

        @Override
        public Object joinValues(Object target, Object value) {
            return null;
        }

        @Override
        public void writeData(RuleResult model, Node node) {
        }

        @Override
        public void setReadonly(boolean readonly, Node node) {
        }

        @Override
        public void buildResultsInfo(Consumer<String> out, Object value) {
            out.accept(((RuleResult)value).getAction().getDisplayName());
        }
    }
    ,
    YES_NO{

        public Node createNode(boolean readonly) {
            return NULL.createNode(readonly);
        }

        @Override
        public <T extends BaseCommissionProperties> NodeRenderer createValueRenderer(EntityContainer<T> targetValue) {
            return StandardRuleResultValueRenderer.SIMPLE_BOOLEAN;
        }

        public Object getValue(Node node) {
            RuleResultValue resultValue = new RuleResultValue();
            resultValue.setTarget(null);
            return resultValue;
        }

        public void setValue(Node node, Object value) {
        }

        @Override
        public Object joinValues(Object target, Object value) {
            return value;
        }

        @Override
        public void setReadonly(boolean readonly, Node node) {
            NULL.setReadonly(readonly, node);
        }

        @Override
        public void buildResultsInfo(Consumer<String> out, Object value) {
            RuleResult ruleResult = (RuleResult)value;
            String strValue = ruleResult.getValue() == null ? UiUtil.NULL_TEXT : ((Boolean)ruleResult.getValue() != false ? Messages.Yes : Messages.No);
            out.accept(ruleResult.getAction().getDisplayName() + ": " + strValue);
        }
    }
    ,
    ADDITIONAL_SERVICE_CATEGORY{

        public Node createNode(boolean readonly) {
            return NULL.createNode(readonly);
        }

        @Override
        public <T extends BaseCommissionProperties> NodeRenderer createValueRenderer(EntityContainer<T> targetValue) {
            return StandardRuleValueRenderers.ADDITIONAL_SERVICE_CATEGORY;
        }

        public Object getValue(Node node) {
            RuleResultValue resultValue = new RuleResultValue();
            resultValue.setTarget(null);
            return resultValue;
        }

        public void setValue(Node node, Object value) {
        }

        @Override
        public Object joinValues(Object target, Object value) {
            return value;
        }

        @Override
        public void setReadonly(boolean readonly, Node node) {
            NULL.setReadonly(readonly, node);
        }

        @Override
        public void buildResultsInfo(Consumer<String> out, Object value) {
            RuleResult ruleResult = (RuleResult)value;
            StringBuilder sb = new StringBuilder();
            ruleResult.getAction().buildInfo(sb, ruleResult.getValue());
            out.accept(sb.toString());
        }
    }
    ,
    SIMPLE_COMMISSION{

        public Node createNode(boolean readonly) {
            EntityBoxWidget widget = new EntityBoxWidget(CommissionProperties.class, readonly);
            widget.setFieldName("\u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u043a\u043e\u043c\u0438\u0441\u0441\u0438\u0438");
            widget.setListParametersSupplier(() -> {
                RulesCustomProperties properties = RulesCustomProperties.lookup((Node)widget);
                RuleTarget target = (RuleTarget)properties.get("target");
                return ControllerInterceptorsHelper.getCommissions(target);
            });
            return widget;
        }

        @Override
        public <T extends BaseCommissionProperties> NodeRenderer createValueRenderer(EntityContainer<T> targetValue) {
            if (targetValue == null || targetValue.getEntity() == null) {
                return NULL;
            }
            if (((BaseCommissionProperties)targetValue.getEntity()).isRate()) {
                return StandardRuleResultValueRenderer.SIMPLE_PERCENT;
            }
            return StandardRuleResultValueRenderer.SIMPLE_PRICE;
        }

        public Object getValue(Node node) {
            RuleResultValue resultValue = new RuleResultValue();
            resultValue.setTarget(((EntityBoxWidget)node).getValue());
            return resultValue;
        }

        @Override
        public Object joinValues(Object target, Object value) {
            if (value == null) {
                return target;
            }
            RuleResultValue rrValue = (RuleResultValue)target;
            EntityReference prop = rrValue.getTarget();
            RuleResultValue ruleResult = (RuleResultValue)value;
            ruleResult.setTarget(prop);
            return ruleResult;
        }

        public void setValue(Node node, Object value) {
            RuleResultValue ruleResultValue = (RuleResultValue)value;
            EntityReference target = value == null ? null : ruleResultValue.getTarget();
            ((EntityBoxWidget)node).setValue(target);
        }

        @Override
        public void buildResultsInfo(Consumer<String> out, Object value) {
            String strValue;
            RuleResult ruleResult = (RuleResult)value;
            if (ruleResult.getValue() == null) {
                strValue = UiUtil.NULL_TEXT;
            } else {
                RuleResultValue rrv = (RuleResultValue)ruleResult.getValue();
                strValue = LocaleManager.get().getCurrentLocaleData().getPriceFormat().format(rrv.getValue()) + ' ' + rrv.getCurrencyCode();
            }
            out.accept(ruleResult.getAction().getDisplayName() + ": " + strValue);
        }
    }
    ,
    SIMPLE_DISCOUNT{

        public Node createNode(boolean readonly) {
            EntityBoxWidget widget = new EntityBoxWidget(DiscountProperties.class, readonly);
            widget.setFieldName("\u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0441\u043a\u0438\u0434\u043a\u0438");
            widget.setListParametersSupplier(ControllerInterceptorsHelper::getDiscounts);
            return widget;
        }

        @Override
        public <T extends BaseCommissionProperties> NodeRenderer createValueRenderer(EntityContainer<T> targetValue) {
            return SIMPLE_COMMISSION.createValueRenderer(targetValue);
        }

        public Object getValue(Node node) {
            RuleResultValue resultValue = new RuleResultValue();
            resultValue.setTarget(((EntityBoxWidget)node).getValue());
            return resultValue;
        }

        public void setValue(Node node, Object value) {
            RuleResultValue ruleResultValue = (RuleResultValue)value;
            EntityReference target = value == null ? null : ruleResultValue.getTarget();
            ((EntityBoxWidget)node).setValue(target);
        }

        @Override
        public Object joinValues(Object target, Object value) {
            if (value == null) {
                return target;
            }
            RuleResultValue rrValue = (RuleResultValue)target;
            EntityReference prop = rrValue.getTarget();
            RuleResultValue ruleResult = (RuleResultValue)value;
            ruleResult.setTarget(prop);
            return ruleResult;
        }

        @Override
        public void buildResultsInfo(Consumer<String> out, Object value) {
            SIMPLE_COMMISSION.buildResultsInfo(out, value);
        }
    }
    ,
    SIMPLE_FEE{

        public Node createNode(boolean readonly) {
            EntityBoxWidget widget = new EntityBoxWidget(FeeProperties.class, readonly);
            widget.setFieldName("\u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0441\u0431\u043e\u0440\u0430");
            widget.setListParametersSupplier(() -> {
                RulesCustomProperties properties = RulesCustomProperties.lookup((Node)widget);
                RuleTarget target = (RuleTarget)properties.get("target");
                return ControllerInterceptorsHelper.getFees(target);
            });
            return widget;
        }

        @Override
        public <T extends BaseCommissionProperties> NodeRenderer createValueRenderer(EntityContainer<T> targetValue) {
            return SIMPLE_COMMISSION.createValueRenderer(targetValue);
        }

        public Object getValue(Node node) {
            RuleResultValue resultValue = new RuleResultValue();
            resultValue.setTarget(((EntityBoxWidget)node).getValue());
            return resultValue;
        }

        public void setValue(Node node, Object value) {
            RuleResultValue ruleResultValue = (RuleResultValue)value;
            EntityReference target = value == null ? null : ruleResultValue.getTarget();
            ((EntityBoxWidget)node).setValue(target);
        }

        @Override
        public Object joinValues(Object target, Object value) {
            if (value == null) {
                return target;
            }
            RuleResultValue rrValue = (RuleResultValue)target;
            EntityReference prop = rrValue.getTarget();
            RuleResultValue ruleResult = (RuleResultValue)value;
            ruleResult.setTarget(prop);
            return ruleResult;
        }

        @Override
        public void buildResultsInfo(Consumer<String> out, Object value) {
            SIMPLE_COMMISSION.buildResultsInfo(out, value);
        }
    }
    ,
    PAYMENT_FEE{

        public Node createNode(boolean readonly) {
            EntityBoxWidget widget = new EntityBoxWidget(PaymentFeeProperties.class, readonly);
            widget.setFieldName("\u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0441\u0431\u043e\u0440\u0430 \u0437\u0430 \u043e\u043f\u043b\u0430\u0442\u0443");
            widget.setListParametersSupplier(ControllerInterceptorsHelper::getPaymentFees);
            return widget;
        }

        @Override
        public <T extends BaseCommissionProperties> NodeRenderer createValueRenderer(EntityContainer<T> targetValue) {
            return SIMPLE_COMMISSION.createValueRenderer(targetValue);
        }

        public Object getValue(Node node) {
            RuleResultValue resultValue = new RuleResultValue();
            resultValue.setTarget(((EntityBoxWidget)node).getValue());
            return resultValue;
        }

        public void setValue(Node node, Object value) {
            RuleResultValue ruleResultValue = (RuleResultValue)value;
            EntityReference target = value == null ? null : ruleResultValue.getTarget();
            ((EntityBoxWidget)node).setValue(target);
        }

        @Override
        public Object joinValues(Object target, Object value) {
            if (value == null) {
                return target;
            }
            RuleResultValue targetValue = (RuleResultValue)target;
            EntityReference prop = targetValue.getTarget();
            RuleResultValue ruleResult = (RuleResultValue)value;
            ruleResult.setTarget(prop);
            return ruleResult;
        }

        @Override
        public void buildResultsInfo(Consumer<String> out, Object value) {
            SIMPLE_COMMISSION.buildResultsInfo(out, value);
        }
    }
    ,
    PAYMENT_TYPES_LIST{

        public Node createNode(boolean readonly) {
            return NULL.createNode(readonly);
        }

        @Override
        public <T extends BaseCommissionProperties> NodeRenderer createValueRenderer(EntityContainer<T> targetValue) {
            return StandardRuleResultValueRenderer.PAYMENTS_TYPES;
        }

        public Object getValue(Node node) {
            RuleResultValue resultValue = new RuleResultValue();
            resultValue.setTarget(null);
            return resultValue;
        }

        public void setValue(Node node, Object value) {
        }

        @Override
        public Object joinValues(Object target, Object value) {
            return value;
        }

        @Override
        public void setReadonly(boolean readonly, Node node) {
            NULL.setReadonly(readonly, node);
        }
    }
    ,
    FOP_COMMISSION{

        public Node createNode(boolean readonly) {
            EntityBoxWidget widget = new EntityBoxWidget(CommissionProperties.class, readonly);
            widget.setFieldName(Actions.FOP_COMMISSION.getDisplayName());
            widget.setListParametersSupplier(() -> {
                RulesCustomProperties properties = RulesCustomProperties.lookup((Node)widget);
                RuleTarget target = (RuleTarget)properties.get("target");
                return ControllerInterceptorsHelper.getCommissions(target);
            });
            return widget;
        }

        @Override
        public <T extends BaseCommissionProperties> NodeRenderer createValueRenderer(EntityContainer<T> targetValue) {
            return FopCommissionNodeRenderer.getInstance();
        }

        @Override
        public TableWidget<?> getActionTable(Node node) {
            return FopCommissionNodeRenderer.getInstance().getActionTable(node);
        }

        public Object getValue(Node node) {
            RuleResultValue resultValue = new RuleResultValue();
            resultValue.setTarget(((EntityBoxWidget)node).getValue());
            return resultValue;
        }

        public void setValue(Node node, Object value) {
            RuleResultValue ruleResultValue = (RuleResultValue)value;
            EntityReference target = value == null ? null : ruleResultValue.getTarget();
            ((EntityBoxWidget)node).setValue(target);
        }

        @Override
        public Object joinValues(Object target, Object value) {
            RuleResultValue rrValue = (RuleResultValue)value;
            RuleResultValue targetValue = (RuleResultValue)target;
            if (rrValue != null) {
                rrValue.setTarget(target == null ? null : targetValue.getTarget());
            }
            return rrValue;
        }

        @Override
        public void buildResultsInfo(Consumer<String> out, Object value) {
            if (value != null) {
                StringBuilder sb = new StringBuilder();
                RuleResultValue rrValue = (RuleResultValue)((RuleResult)value).getValue();
                EntityReference ref = rrValue.getTarget();
                sb.append(ref != null && !TextUtil.isBlank((String)ref.getCaption()) ? ref.getCaption() : "???").append(' ').append(RulesHelper.getTchCommissionInfo((Object)rrValue.getFopValues()));
                out.accept(sb.toString());
            }
        }
    }
    ,
    FOP_FEE{

        public Node createNode(boolean readonly) {
            EntityBoxWidget widget = new EntityBoxWidget(FeeProperties.class, readonly);
            widget.setFieldName(Actions.FOP_FEE.getDisplayName());
            widget.setListParametersSupplier(() -> {
                RulesCustomProperties properties = RulesCustomProperties.lookup((Node)widget);
                RuleTarget target = (RuleTarget)properties.get("target");
                return ControllerInterceptorsHelper.getFees(target);
            });
            return widget;
        }

        @Override
        public <T extends BaseCommissionProperties> NodeRenderer createValueRenderer(EntityContainer<T> targetValue) {
            return FOP_COMMISSION.createValueRenderer(targetValue);
        }

        @Override
        public TableWidget<?> getActionTable(Node node) {
            return FOP_COMMISSION.getActionTable(node);
        }

        public Object getValue(Node node) {
            return FOP_COMMISSION.getValue(node);
        }

        public void setValue(Node node, Object value) {
            FOP_COMMISSION.setValue(node, value);
        }

        @Override
        public Object joinValues(Object target, Object value) {
            return FOP_COMMISSION.joinValues(target, value);
        }

        @Override
        public void buildResultsInfo(Consumer<String> out, Object value) {
            FOP_COMMISSION.buildResultsInfo(out, value);
        }
    }
    ,
    FOP_DISCOUNT{

        public Node createNode(boolean readonly) {
            EntityBoxWidget widget = new EntityBoxWidget(DiscountProperties.class, readonly);
            widget.setFieldName(Actions.FOP_DISCOUNT.getDisplayName());
            widget.setListParametersSupplier(ControllerInterceptorsHelper::getDiscounts);
            return widget;
        }

        @Override
        public <T extends BaseCommissionProperties> NodeRenderer createValueRenderer(EntityContainer<T> targetValue) {
            return FOP_COMMISSION.createValueRenderer(targetValue);
        }

        @Override
        public TableWidget<?> getActionTable(Node node) {
            return FOP_COMMISSION.getActionTable(node);
        }

        public Object getValue(Node node) {
            return FOP_COMMISSION.getValue(node);
        }

        public void setValue(Node node, Object value) {
            FOP_COMMISSION.setValue(node, value);
        }

        @Override
        public Object joinValues(Object target, Object value) {
            return FOP_COMMISSION.joinValues(target, value);
        }

        @Override
        public void buildResultsInfo(Consumer<String> out, Object value) {
            FOP_COMMISSION.buildResultsInfo(out, value);
        }
    }
    ,
    SERVICE_CLASS_COMMISSION{

        public Node createNode(boolean readonly) {
            EntityBoxWidget widget = new EntityBoxWidget(CommissionProperties.class, readonly);
            widget.setFieldName(Actions.SERVICE_CLASS_COMMISSION.getDisplayName());
            return widget;
        }

        @Override
        public <T extends BaseCommissionProperties> NodeRenderer createValueRenderer(EntityContainer<T> targetValue) {
            return ServiceCommissionRenderer.getInstance();
        }

        @Override
        public TableWidget<?> getActionTable(Node node) {
            return ServiceCommissionRenderer.getInstance().getServiceTable(node);
        }

        public Object getValue(Node node) {
            ServiceClassCommissionsRuleResultValue resultValue = new ServiceClassCommissionsRuleResultValue();
            resultValue.setTarget(((EntityBoxWidget)node).getValue());
            return resultValue;
        }

        public void setValue(Node node, Object value) {
            ServiceClassCommissionsRuleResultValue ruleResultValue = (ServiceClassCommissionsRuleResultValue)value;
            EntityReference target = value == null ? null : ruleResultValue.getTarget();
            ((EntityBoxWidget)node).setValue(target);
        }

        @Override
        public Object joinValues(Object target, Object value) {
            ServiceClassCommissionsRuleResultValue rrValue = (ServiceClassCommissionsRuleResultValue)value;
            ServiceClassCommissionsRuleResultValue targetValue = (ServiceClassCommissionsRuleResultValue)target;
            if (rrValue != null) {
                rrValue.setTarget(target == null ? null : targetValue.getTarget());
            }
            return rrValue;
        }

        @Override
        public void buildResultsInfo(Consumer<String> out, Object value) {
            RuleResult ruleResult = (RuleResult)value;
            StringBuilder sb = new StringBuilder();
            ServiceClassCommissionsRuleResultValue commissionsRuleResultValue = (ServiceClassCommissionsRuleResultValue)ruleResult.getValue();
            sb.append("\u041a\u043e\u043c\u0438\u0441\u0441\u0438\u044f ").append(commissionsRuleResultValue.getCommissionType()).append(" \u0438\u0437 ");
            for (ServiceClassCommissionsRuleResultValue.ServiceClassCommissionValue val : commissionsRuleResultValue.getValues()) {
                sb.append(val.getValue() == null ? "?" : val.getValue()).append(" ").append(commissionsRuleResultValue.getCurrencyCode()).append(" (").append(val.getServiceClassCodes() == null ? "?" : val.getServiceClassCodes()).append("); ");
            }
            out.accept(sb.toString());
        }
    }
    ,
    NUMBER{

        public Node createNode(boolean readonly) {
            return NULL.createNode(readonly);
        }

        @Override
        public <T extends BaseCommissionProperties> NodeRenderer createValueRenderer(EntityContainer<T> targetValue) {
            return StandardRuleResultValueRenderer.SIMPLE_DOUBLE;
        }

        public Object getValue(Node node) {
            RuleResultValue resultValue = new RuleResultValue();
            resultValue.setTarget(null);
            return resultValue;
        }

        public void setValue(Node node, Object value) {
        }

        @Override
        public Object joinValues(Object target, Object value) {
            return value;
        }

        @Override
        public void setReadonly(boolean readonly, Node node) {
            NULL.setReadonly(readonly, node);
        }

        @Override
        public void buildResultsInfo(Consumer<String> out, Object value) {
            RuleResult ruleResult = (RuleResult)value;
            String strValue = ruleResult.getValue() == null ? UiUtil.NULL_TEXT : ruleResult.getValue().toString();
            out.accept(ruleResult.getAction().getDisplayName() + ": " + strValue);
        }
    }
    ,
    PRICE{

        public Node createNode(boolean readonly) {
            return NULL.createNode(readonly);
        }

        @Override
        public <T extends BaseCommissionProperties> NodeRenderer createValueRenderer(EntityContainer<T> targetValue) {
            return StandardRuleResultValueRenderer.SIMPLE_PRICE;
        }

        public Object getValue(Node node) {
            RuleResultValue resultValue = new RuleResultValue();
            resultValue.setTarget(null);
            return resultValue;
        }

        public void setValue(Node node, Object value) {
        }

        @Override
        public Object joinValues(Object target, Object value) {
            RuleResultValue rrValue = (RuleResultValue)value;
            Object[] pair = new Object[]{rrValue.getValue(), rrValue.getCurrencyCode()};
            return pair;
        }

        @Override
        public void setReadonly(boolean readonly, Node node) {
            NULL.setReadonly(readonly, node);
        }

        @Override
        public void buildResultsInfo(Consumer<String> out, Object value) {
            String strValue;
            RuleResult ruleResult = (RuleResult)value;
            if (ruleResult.getValue() == null) {
                strValue = UiUtil.NULL_TEXT;
            } else {
                Object[] pair = (Object[])ruleResult.getValue();
                LocaleManager lm = LocaleManager.get();
                DecimalFormat decimalFormat = lm.getLocaleData(lm.getCurrentLocale()).getPriceFormat();
                strValue = decimalFormat.format(pair[0]) + " " + pair[1];
            }
            out.accept(ruleResult.getAction().getDisplayName() + ": " + strValue);
        }
    }
    ,
    AGENCY{

        public Node createNode(boolean readonly) {
            return NULL.createNode(readonly);
        }

        public Object getValue(Node node) {
            RuleResultValue resultValue = new RuleResultValue();
            resultValue.setTarget(null);
            return resultValue;
        }

        public void setValue(Node node, Object value) {
        }

        @Override
        public Object joinValues(Object target, Object value) {
            return value;
        }

        @Override
        public <T extends BaseCommissionProperties> NodeRenderer createValueRenderer(EntityContainer<T> targetValue) {
            return StandardRuleValueRenderers.AGENCY;
        }

        @Override
        public void setReadonly(boolean readonly, Node node) {
            NULL.setReadonly(readonly, node);
        }
    }
    ,
    STRING{

        public Node createNode(boolean readonly) {
            return NULL.createNode(readonly);
        }

        @Override
        public <T extends BaseCommissionProperties> NodeRenderer createValueRenderer(EntityContainer<T> targetValue) {
            return StandardRuleResultValueRenderer.SIMPLE_TEXT;
        }

        public Object getValue(Node node) {
            RuleResultValue resultValue = new RuleResultValue();
            resultValue.setTarget(null);
            return resultValue;
        }

        public void setValue(Node node, Object value) {
        }

        @Override
        public Object joinValues(Object target, Object value) {
            return value;
        }

        @Override
        public void setReadonly(boolean readonly, Node node) {
            NULL.setReadonly(readonly, node);
        }

        @Override
        public void buildResultsInfo(Consumer<String> out, Object value) {
            RuleResult ruleResult = (RuleResult)value;
            String strValue = ruleResult.getValue() == null ? UiUtil.NULL_TEXT : ruleResult.getValue().toString();
            out.accept(ruleResult.getAction().getDisplayName() + ": " + strValue);
        }
    }
    ,
    STRING_LIST{

        public Node createNode(boolean readonly) {
            return NULL.createNode(readonly);
        }

        @Override
        public <T extends BaseCommissionProperties> NodeRenderer createValueRenderer(EntityContainer<T> targetValue) {
            return StandardRuleResultValueRenderer.STRING_LIST;
        }

        public Object getValue(Node node) {
            RuleResultValue resultValue = new RuleResultValue();
            resultValue.setTarget(null);
            return resultValue;
        }

        public void setValue(Node node, Object value) {
        }

        @Override
        public Object joinValues(Object target, Object value) {
            return value;
        }

        @Override
        public void setReadonly(boolean readonly, Node node) {
            NULL.setReadonly(readonly, node);
        }

        @Override
        public void buildResultsInfo(Consumer<String> out, Object value) {
            RuleResult ruleResult = (RuleResult)value;
            String strValue = ruleResult.getValue() == null ? UiUtil.NULL_TEXT : ruleResult.getValue().toString();
            out.accept(ruleResult.getAction().getDisplayName() + ": " + strValue);
        }
    }
    ,
    MULTILINGUAL_STRING{

        public Node createNode(boolean readonly) {
            return NULL.createNode(readonly);
        }

        @Override
        public <T extends BaseCommissionProperties> NodeRenderer createValueRenderer(EntityContainer<T> targetValue) {
            return StandardRuleResultValueRenderer.MULTILINGUAL_ENTITY_BOX;
        }

        public Object getValue(Node node) {
            RuleResultValue resultValue = new RuleResultValue();
            resultValue.setTarget(null);
            return resultValue;
        }

        public void setValue(Node node, Object value) {
        }

        @Override
        public Object joinValues(Object target, Object value) {
            return value;
        }

        @Override
        public void setReadonly(boolean readonly, Node node) {
            NULL.setReadonly(readonly, node);
        }

        @Override
        public void buildResultsInfo(Consumer<String> out, Object value) {
            RuleResult ruleResult = (RuleResult)value;
            String strValue = ruleResult.getValue() == null ? UiUtil.NULL_TEXT : ruleResult.getValue().toString();
            out.accept(ruleResult.getAction().getDisplayName() + ": " + strValue);
        }
    }
    ,
    L10N_TEXT{

        public Node createNode(boolean readonly) {
            return NULL.createNode(readonly);
        }

        @Override
        public <T extends BaseCommissionProperties> NodeRenderer createValueRenderer(EntityContainer<T> targetValue) {
            return StandardRuleResultValueRenderer.L10N_TEXT;
        }

        public Object getValue(Node node) {
            RuleResultValue resultValue = new RuleResultValue();
            resultValue.setTarget(null);
            return resultValue;
        }

        public void setValue(Node node, Object value) {
        }

        @Override
        public Object joinValues(Object target, Object value) {
            return value;
        }

        @Override
        public void setReadonly(boolean readonly, Node node) {
            NULL.setReadonly(readonly, node);
        }

        @Override
        public void buildResultsInfo(Consumer<String> out, Object value) {
            RuleResult ruleResult = (RuleResult)value;
            String strValue = ruleResult.getValue() == null ? UiUtil.NULL_TEXT : ruleResult.getValue().toString();
            out.accept(ruleResult.getAction().getDisplayName() + ": " + strValue);
        }
    }
    ,
    CALCULATION_INDICATOR{

        public Node createNode(boolean readonly) {
            return NULL.createNode(readonly);
        }

        @Override
        public <T extends BaseCommissionProperties> NodeRenderer createValueRenderer(EntityContainer<T> targetValue) {
            return StandardRuleResultValueRenderer.CALCULATION_INDICATOR_TYPE;
        }

        public Object getValue(Node node) {
            RuleResultValue resultValue = new RuleResultValue();
            resultValue.setTarget(null);
            return resultValue;
        }

        public void setValue(Node node, Object value) {
        }

        @Override
        public Object joinValues(Object target, Object value) {
            return value;
        }

        @Override
        public void setReadonly(boolean readonly, Node node) {
            NULL.setReadonly(readonly, node);
        }
    }
    ,
    ROUNDING_MODE{

        public Node createNode(boolean readonly) {
            return NULL.createNode(readonly);
        }

        @Override
        public <T extends BaseCommissionProperties> NodeRenderer createValueRenderer(EntityContainer<T> targetValue) {
            return StandardRuleResultValueRenderer.ROUNDING_MODE;
        }

        public Object getValue(Node node) {
            RuleResultValue resultValue = new RuleResultValue();
            resultValue.setTarget(null);
            return resultValue;
        }

        public void setValue(Node node, Object value) {
        }

        @Override
        public Object joinValues(Object target, Object value) {
            return value;
        }

        @Override
        public void setReadonly(boolean readonly, Node node) {
            NULL.setReadonly(readonly, node);
        }
    }
    ,
    ROUNDING_VALUE{

        public Node createNode(boolean readonly) {
            return NULL.createNode(readonly);
        }

        @Override
        public <T extends BaseCommissionProperties> NodeRenderer createValueRenderer(EntityContainer<T> targetValue) {
            return StandardRuleResultValueRenderer.ROUNDING_VALUE;
        }

        public Object getValue(Node node) {
            RuleResultValue resultValue = new RuleResultValue();
            resultValue.setTarget(null);
            return resultValue;
        }

        public void setValue(Node node, Object value) {
        }

        @Override
        public Object joinValues(Object target, Object value) {
            return value;
        }

        @Override
        public void setReadonly(boolean readonly, Node node) {
            NULL.setReadonly(readonly, node);
        }
    }
    ,
    FISCAL_SELL_TYPE{

        public Node createNode(boolean readonly) {
            return NULL.createNode(readonly);
        }

        @Override
        public <T extends BaseCommissionProperties> NodeRenderer createValueRenderer(EntityContainer<T> targetValue) {
            return StandardRuleResultValueRenderer.FISCAL_SELL_TYPE;
        }

        public Object getValue(Node node) {
            RuleResultValue resultValue = new RuleResultValue();
            resultValue.setTarget(null);
            return resultValue;
        }

        public void setValue(Node node, Object value) {
        }

        @Override
        public Object joinValues(Object target, Object value) {
            return value;
        }

        @Override
        public void setReadonly(boolean readonly, Node node) {
            NULL.setReadonly(readonly, node);
        }

        @Override
        public void buildResultsInfo(Consumer<String> out, Object value) {
            RuleResult ruleResult = (RuleResult)value;
            String strValue = ruleResult.getValue() == null ? UiUtil.NULL_TEXT : ruleResult.getValue().toString();
            out.accept(ruleResult.getAction().getDisplayName() + ": " + strValue);
        }
    }
    ,
    SINGLE_PASSENGER_TYPE{

        public Node createNode(boolean readonly) {
            return NULL.createNode(readonly);
        }

        @Override
        public <T extends BaseCommissionProperties> NodeRenderer createValueRenderer(EntityContainer<T> targetValue) {
            return StandardRuleResultValueRenderer.SINGLE_PASSENGER_TYPE;
        }

        public Object getValue(Node node) {
            RuleResultValue resultValue = new RuleResultValue();
            resultValue.setTarget(null);
            return resultValue;
        }

        public void setValue(Node node, Object value) {
        }

        @Override
        public Object joinValues(Object target, Object value) {
            return value;
        }

        @Override
        public void setReadonly(boolean readonly, Node node) {
            NULL.setReadonly(readonly, node);
        }
    }
    ,
    TRIPARTITE_PUBLIC_FARE_DISCOUNT{

        public Node createNode(boolean readonly) {
            return new RateMoneyValueWidget(readonly);
        }

        @Override
        public <T extends BaseCommissionProperties> NodeRenderer createValueRenderer(EntityContainer<T> targetValue) {
            return StandardRuleResultValueRenderer.TICKET_DESIGNATOR;
        }

        public Object getValue(Node node) {
            TripartitePublicFareDiscount result = new TripartitePublicFareDiscount();
            RateMoney rm = ((RateMoneyValueWidget)node).getValue();
            if (rm != null) {
                if (rm.getRate() != null) {
                    result.setValue(BigDecimal.valueOf(Math.round(rm.getRate())));
                    result.setRate(true);
                } else if (rm.getMoney() != null) {
                    result.setValue(rm.getMoney().getValue());
                    result.setCurrency(rm.getMoney().getCurrency());
                }
            }
            return result;
        }

        public void setValue(Node node, Object value) {
            TripartitePublicFareDiscount discount = (TripartitePublicFareDiscount)value;
            RateMoneyValueWidget widget = (RateMoneyValueWidget)node;
            if (discount != null) {
                RateMoney rm = new RateMoney();
                if (discount.isRate()) {
                    rm.setRate(Double.valueOf(discount.getValue().doubleValue()));
                } else {
                    Money money = new Money();
                    money.setValue(discount.getValue());
                    money.setCurrency(discount.getCurrency());
                    rm.setMoney(money);
                }
                widget.setValue(rm);
            } else {
                widget.setValue(null);
            }
        }

        @Override
        public Object joinValues(Object target, Object value) {
            TripartitePublicFareDiscount discount = (TripartitePublicFareDiscount)target;
            TripartitePublicFareDiscount designator = (TripartitePublicFareDiscount)value;
            discount.setTicketDesignator(designator.getTicketDesignator());
            return discount;
        }
    }
    ,
    COMMISSION_PROPERTIES{

        public Node createNode(boolean readonly) {
            return NULL.createNode(readonly);
        }

        @Override
        public <T extends BaseCommissionProperties> NodeRenderer createValueRenderer(EntityContainer<T> targetValue) {
            return StandardRuleResultValueRenderer.COMMISSION_PROPERTIES_ENTITY_BOX;
        }

        public Object getValue(Node node) {
            return null;
        }

        public void setValue(Node node, Object value) {
        }

        @Override
        public Object joinValues(Object target, Object value) {
            return value;
        }

        @Override
        public void setReadonly(boolean readonly, Node node) {
            NULL.setReadonly(readonly, node);
        }
    }
    ,
    SABRE_REMARK{

        public Node createNode(boolean readonly) {
            ComboBoxWidget widget = new ComboBoxWidget(readonly);
            widget.setAsync(true);
            widget.setItemsSupplier(() -> {
                ArrayList<String> list = new ArrayList<String>();
                try {
                    DictQuery query = this.getDictListParameters((ComboBoxWidget<String>)widget);
                    for (DictItem item : ((DictService)RpcServiceManager.get().getService(DictService.class)).search(ServiceInvocationContext.get(), FeeRemarkTemplate.class, query)) {
                        list.add((String)item.getFields().get("template"));
                    }
                }
                catch (Exception e) {
                    ErrorHandler.handle((Throwable)e);
                }
                return list;
            });
            return widget;
        }

        private DictQuery getDictListParameters(ComboBoxWidget<String> widget) {
            RulesCustomProperties properties = RulesCustomProperties.lookup(widget);
            DictQuery query = new DictQuery();
            query.getFields().add(FeeRemarkTemplate.Property.template.name());
            if (properties == null) {
                return query;
            }
            if (properties.get("tripartiteContract") != null) {
                TripartiteContractSubtype subType = (TripartiteContractSubtype)((Supplier)properties.get("tripartiteContract")).get();
                String sabreSynchTarget = SabreSynchronizationAdditionalTargets.TRIPARTITE_AVIA.getDisplayName();
                if (TripartiteContractSubtype.HOTEL_BRAND.equals((Object)subType) || TripartiteContractSubtype.HOTEL_CHAIN.equals((Object)subType) || TripartiteContractSubtype.HOTEL_GLOBAL.equals((Object)subType)) {
                    sabreSynchTarget = SabreSynchronizationAdditionalTargets.TRIPARTITE_HOTEL.getDisplayName();
                } else if (TripartiteContractSubtype.CARS_BRAND.equals((Object)subType) || TripartiteContractSubtype.CARS_GLOBAL.equals((Object)subType)) {
                    sabreSynchTarget = SabreSynchronizationAdditionalTargets.TRIPARTITE_CAR.getDisplayName();
                }
                query.getCriterions().add(new DictQuery.SearchCriterion(FeeRemarkTemplate.Property.appliedTo.name(), new Object[]{sabreSynchTarget}));
            } else {
                RuleTarget target = (RuleTarget)properties.get("target");
                query.getCriterions().add(new DictQuery.SearchCriterion(FeeRemarkTemplate.Property.appliedTo.name(), new Object[]{target.getDisplayName()}));
            }
            return query;
        }

        @Override
        public <T extends BaseCommissionProperties> NodeRenderer createValueRenderer(EntityContainer<T> targetValue) {
            return new NodeRenderer(){

                public Node createNode(boolean readonly) {
                    return StandardRuleResultValueRenderer.PRICE_CURRENCY_PERCENT.createNode(readonly);
                }

                public Object getValue(Node node) {
                    return StandardRuleResultValueRenderer.PRICE_CURRENCY_PERCENT.getValue(node);
                }

                public void setValue(Node node, Object value) {
                    SabreRemarkResult sabreRemarkResult = (SabreRemarkResult)value;
                    if (sabreRemarkResult != null) {
                        RateMoney rm = new RateMoney();
                        if ("%".equals(sabreRemarkResult.getCurrencyCode())) {
                            rm.setRate(sabreRemarkResult.getValue() == null ? null : Double.valueOf(sabreRemarkResult.getValue().doubleValue()));
                        } else {
                            Money money = new Money();
                            money.setValue(sabreRemarkResult.getValue());
                            money.setCurrency(sabreRemarkResult.getCurrencyCode());
                            rm.setMoney(money);
                        }
                        StandardRuleResultValueRenderer.PRICE_CURRENCY_PERCENT.setValue(node, rm);
                    }
                }

                public void setReadonly(boolean readonly, Node node) {
                    StandardRuleResultValueRenderer.PRICE_CURRENCY_PERCENT.setReadonly(readonly, node);
                }
            };
        }

        public Object getValue(Node node) {
            SabreRemarkResult resultValue = new SabreRemarkResult();
            ComboBoxWidget widget = (ComboBoxWidget)node;
            if (widget != null && widget.getValue() != null) {
                resultValue.setTemplate((String)widget.getValue());
            }
            return resultValue;
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            SabreRemarkResult sabreRemarkResult = (SabreRemarkResult)value;
            ComboBoxWidget widget = (ComboBoxWidget)node;
            if (sabreRemarkResult == null || sabreRemarkResult.getTemplate() == null) {
                widget.setValue(null);
                return;
            }
            widget.setValue((Object)sabreRemarkResult.getTemplate());
        }

        @Override
        public Object joinValues(Object target, Object value) {
            SabreRemarkResult sabreResult = (SabreRemarkResult)target;
            if (value != null) {
                RateMoney rm = (RateMoney)value;
                if (rm.getRate() != null) {
                    sabreResult.setValue(BigDecimal.valueOf(rm.getRate()));
                    sabreResult.setCurrencyCode("%");
                } else if (rm.getMoney() != null) {
                    sabreResult.setValue(rm.getMoney().getValue());
                    sabreResult.setCurrencyCode(rm.getMoney().getCurrency());
                }
            }
            return sabreResult;
        }

        @Override
        public void buildResultsInfo(Consumer<String> out, Object value) {
            RuleResult ruleResult = (RuleResult)value;
            StringBuilder builder = new StringBuilder();
            RulesHelper.buildRemarkInfo((StringBuilder)builder, (SabreRemarkResult)((SabreRemarkResult)ruleResult.getValue()));
            out.accept(builder.toString());
        }
    }
    ,
    SABRE_REMARK_NO_ARGS{

        public Node createNode(boolean readonly) {
            return SABRE_REMARK.createNode(readonly);
        }

        @Override
        public <T extends BaseCommissionProperties> NodeRenderer createValueRenderer(EntityContainer<T> targetValue) {
            return NULL.createValueRenderer(targetValue);
        }

        public Object getValue(Node node) {
            return SABRE_REMARK.getValue(node);
        }

        public void setValue(Node node, Object value) {
            SABRE_REMARK.setValue(node, value);
        }

        @Override
        public Object joinValues(Object target, Object value) {
            return target;
        }

        @Override
        public void buildResultsInfo(Consumer<String> out, Object value) {
            SABRE_REMARK.buildResultsInfo(out, value);
        }
    }
    ,
    HOTEL_PROVIDER_LIST{

        public Node createNode(boolean readonly) {
            return NULL.createNode(readonly);
        }

        @Override
        public <T extends BaseCommissionProperties> NodeRenderer createValueRenderer(EntityContainer<T> targetValue) {
            return StandardRuleResultValueRenderer.HOTEL_PROVIDER_LIST;
        }

        public Object getValue(Node node) {
            RuleResultValue resultValue = new RuleResultValue();
            resultValue.setTarget(null);
            return resultValue;
        }

        public void setValue(Node node, Object value) {
        }

        @Override
        public Object joinValues(Object target, Object value) {
            return value;
        }

        @Override
        public void setReadonly(boolean readonly, Node node) {
            NULL.setReadonly(readonly, node);
        }

        @Override
        public void buildResultsInfo(Consumer<String> out, Object value) {
            RuleResult ruleResult = (RuleResult)value;
            String strValue = ruleResult.getValue() == null ? UiUtil.NULL_TEXT : ruleResult.getValue().toString();
            out.accept(ruleResult.getAction().getDisplayName() + ": " + strValue);
        }
    }
    ,
    HOTEL_PROVIDER_ORDERED_LIST{

        public Node createNode(boolean readonly) {
            return NULL.createNode(readonly);
        }

        @Override
        public <T extends BaseCommissionProperties> NodeRenderer createValueRenderer(EntityContainer<T> targetValue) {
            return StandardRuleResultValueRenderer.HOTEL_PROVIDER_ORDERED_LIST;
        }

        public Object getValue(Node node) {
            RuleResultValue resultValue = new RuleResultValue();
            resultValue.setTarget(null);
            return resultValue;
        }

        public void setValue(Node node, Object value) {
        }

        @Override
        public Object joinValues(Object target, Object value) {
            return value;
        }

        @Override
        public void setReadonly(boolean readonly, Node node) {
            NULL.setReadonly(readonly, node);
        }

        @Override
        public void buildResultsInfo(Consumer<String> out, Object value) {
            RuleResult ruleResult = (RuleResult)value;
            String strValue = ruleResult.getValue() == null ? UiUtil.NULL_TEXT : ruleResult.getValue().toString();
            out.accept(ruleResult.getAction().getDisplayName() + ": " + strValue);
        }
    }
    ,
    HOTEL_PROVIDER_OR_SUBPROVIDER_LIST{

        public Node createNode(boolean readonly) {
            return NULL.createNode(readonly);
        }

        @Override
        public <T extends BaseCommissionProperties> NodeRenderer createValueRenderer(EntityContainer<T> targetValue) {
            return StandardRuleResultValueRenderer.HOTEL_PROVIDER_OR_SUBPROVIDER_LIST;
        }

        public Object getValue(Node node) {
            RuleResultValue resultValue = new RuleResultValue();
            resultValue.setTarget(null);
            return resultValue;
        }

        public void setValue(Node node, Object value) {
        }

        @Override
        public Object joinValues(Object target, Object value) {
            return value;
        }

        @Override
        public void setReadonly(boolean readonly, Node node) {
            NULL.setReadonly(readonly, node);
        }

        @Override
        public void buildResultsInfo(Consumer<String> out, Object value) {
            RuleResult ruleResult = (RuleResult)value;
            String strValue = ruleResult.getValue() == null ? UiUtil.NULL_TEXT : ruleResult.getValue().toString();
            out.accept(ruleResult.getAction().getDisplayName() + ": " + strValue);
        }
    }
    ,
    HOTEL_PREFERRED_PROVIDER_OR_SUBPROVIDER_LIST{

        public Node createNode(boolean readonly) {
            return NULL.createNode(readonly);
        }

        @Override
        public <T extends BaseCommissionProperties> NodeRenderer createValueRenderer(EntityContainer<T> targetValue) {
            return StandardRuleResultValueRenderer.HOTEL_PREFERRED_PROVIDER_OR_SUBPROVIDER_LIST;
        }

        public Object getValue(Node node) {
            RuleResultValue resultValue = new RuleResultValue();
            resultValue.setTarget(null);
            return resultValue;
        }

        public void setValue(Node node, Object value) {
        }

        @Override
        public Object joinValues(Object target, Object value) {
            return value;
        }

        @Override
        public void setReadonly(boolean readonly, Node node) {
            NULL.setReadonly(readonly, node);
        }

        @Override
        public void buildResultsInfo(Consumer<String> out, Object value) {
            RuleResult ruleResult = (RuleResult)value;
            String strValue = ruleResult.getValue() == null ? UiUtil.NULL_TEXT : ruleResult.getValue().toString();
            out.accept(ruleResult.getAction().getDisplayName() + ": " + strValue);
        }
    }
    ,
    HOTEL_PREFERRED_PRIORITY_LIST{

        public Node createNode(boolean readonly) {
            return NULL.createNode(readonly);
        }

        public Object getValue(Node node) {
            RuleResultValue resultValue = new RuleResultValue();
            resultValue.setTarget(null);
            return resultValue;
        }

        public void setValue(Node node, Object value) {
        }

        @Override
        public Object joinValues(Object target, Object value) {
            return value;
        }

        @Override
        public <T extends BaseCommissionProperties> NodeRenderer createValueRenderer(EntityContainer<T> targetValue) {
            return StandardRuleResultValueRenderer.HOTEL_PREFERRED_PRIORITY_LIST;
        }

        @Override
        public void buildResultsInfo(Consumer<String> out, Object value) {
            RuleResult ruleResult = (RuleResult)value;
            String strValue = ruleResult.getValue() == null ? UiUtil.NULL_TEXT : ruleResult.getValue().toString();
            out.accept(ruleResult.getAction().getDisplayName() + ": " + strValue);
        }

        @Override
        public void setReadonly(boolean readonly, Node node) {
            NULL.setReadonly(readonly, node);
        }
    }
    ,
    SHIPMENT_CATEGORY{

        public Node createNode(boolean readonly) {
            return NULL.createNode(readonly);
        }

        public Object getValue(Node node) {
            RuleResultValue resultValue = new RuleResultValue();
            resultValue.setTarget(null);
            return resultValue;
        }

        public void setValue(Node node, Object value) {
        }

        @Override
        public Object joinValues(Object target, Object value) {
            return value;
        }

        @Override
        public void setReadonly(boolean readonly, Node node) {
            NULL.setReadonly(readonly, node);
        }

        @Override
        public <T extends BaseCommissionProperties> NodeRenderer createValueRenderer(EntityContainer<T> targetValue) {
            return StandardRuleResultValueRenderer.SHIPMENT_CATEGORY;
        }

        @Override
        public void buildResultsInfo(Consumer<String> out, Object value) {
            RuleResult ruleResult = (RuleResult)value;
            String strValue = ruleResult.getValue() == null ? UiUtil.NULL_TEXT : ruleResult.getValue().toString();
            out.accept(ruleResult.getAction().getDisplayName() + ": " + strValue);
        }
    }
    ,
    FINANCE_DOCUMENT_DATA{

        public Node createNode(boolean readonly) {
            return NULL.createNode(readonly);
        }

        public Object getValue(Node node) {
            RuleResultValue resultValue = new RuleResultValue();
            resultValue.setTarget(null);
            return resultValue;
        }

        public void setValue(Node node, Object value) {
        }

        @Override
        public Object joinValues(Object target, Object value) {
            return value;
        }

        @Override
        public void setReadonly(boolean readonly, Node node) {
            NULL.setReadonly(readonly, node);
        }

        @Override
        public <T extends BaseCommissionProperties> NodeRenderer createValueRenderer(EntityContainer<T> targetValue) {
            return StandardRuleResultValueRenderer.FINANCE_DOCUMENT_DATA;
        }

        @Override
        public void buildResultsInfo(Consumer<String> out, Object value) {
            RuleResult ruleResult = (RuleResult)value;
            String strValue = Optional.ofNullable((FinanceDocumentData)ruleResult.getValue()).map(FinanceDocumentData::getType).map(FinanceDocumentType::toString).orElse(UiUtil.NULL_TEXT);
            out.accept(ruleResult.getAction().getDisplayName() + ": " + strValue);
        }
    }
    ,
    INVOICE_PREPAYMENT_DATA{

        public Node createNode(boolean readonly) {
            return NULL.createNode(readonly);
        }

        public Object getValue(Node node) {
            RuleResultValue resultValue = new RuleResultValue();
            resultValue.setTarget(null);
            return resultValue;
        }

        public void setValue(Node node, Object value) {
        }

        @Override
        public Object joinValues(Object target, Object value) {
            return value;
        }

        @Override
        public void setReadonly(boolean readonly, Node node) {
            NULL.setReadonly(readonly, node);
        }

        @Override
        public <T extends BaseCommissionProperties> NodeRenderer createValueRenderer(EntityContainer<T> targetValue) {
            return StandardRuleResultValueRenderer.INVOICE_PREPAYMENT_DATA;
        }

        @Override
        public void buildResultsInfo(Consumer<String> out, Object value) {
            RuleResult ruleResult = (RuleResult)value;
            String strValue = Optional.ofNullable((FinanceDocumentData)ruleResult.getValue()).map(FinanceDocumentData::getType).map(FinanceDocumentType::toString).orElse(UiUtil.NULL_TEXT);
            out.accept(ruleResult.getAction().getDisplayName() + ": " + strValue);
        }
    }
    ,
    PRODUCT_DATE_DATA{

        public Node createNode(boolean readonly) {
            return NULL.createNode(readonly);
        }

        public Object getValue(Node node) {
            RuleResultValue resultValue = new RuleResultValue();
            resultValue.setTarget(null);
            return resultValue;
        }

        public void setValue(Node node, Object value) {
        }

        @Override
        public Object joinValues(Object target, Object value) {
            return value;
        }

        @Override
        public void setReadonly(boolean readonly, Node node) {
            NULL.setReadonly(readonly, node);
        }

        @Override
        public <T extends BaseCommissionProperties> NodeRenderer createValueRenderer(EntityContainer<T> targetValue) {
            return StandardRuleResultValueRenderer.PRODUCT_DATE_DATA;
        }

        @Override
        public void buildResultsInfo(Consumer<String> out, Object value) {
            String strValue;
            RuleResult ruleResult = (RuleResult)value;
            if (ruleResult.getValue() == null) {
                strValue = UiUtil.NULL_TEXT;
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                ProductDateData productDateData = (ProductDateData)ruleResult.getValue();
                stringBuilder.append(productDateData.getProductDateType());
                if (productDateData.getProductPeriodData() != null && productDateData.getProductPeriodData().getProductPeriodType() != null) {
                    stringBuilder.append(" (");
                    if (ProductPeriodType.EVERY_N_DAYS_OF_MONTH == productDateData.getProductPeriodData().getProductPeriodType()) {
                        stringBuilder.append(L10n.replace((String)Messages.EveryNDaysOfMonth, (Object[])new Object[]{productDateData.getIntervalValue()}));
                    } else {
                        stringBuilder.append(productDateData.getProductPeriodData().getProductPeriodType());
                        if (productDateData.getStartWeekDay() != null) {
                            stringBuilder.append(" / ");
                            stringBuilder.append(productDateData.getStartWeekDay());
                        }
                    }
                    if (productDateData.getProductPeriodData().isUseAsShipmentPeriod()) {
                        stringBuilder.append(" / ");
                        stringBuilder.append(Messages.UseAsShipmentPeriod);
                    }
                    stringBuilder.append(")");
                }
                if (productDateData.getDateCorrection() != null && productDateData.getDateCorrection().getValue() != 0) {
                    stringBuilder.append(" ");
                    stringBuilder.append(String.format("%+d", productDateData.getDateCorrection().getValue()));
                    stringBuilder.append(" ");
                    stringBuilder.append(productDateData.getDateCorrection().getUnit());
                }
                strValue = stringBuilder.toString();
            }
            out.accept(ruleResult.getAction().getDisplayName() + ": " + strValue);
        }
    }
    ,
    PAYMENT_TYPE{

        public Node createNode(boolean readonly) {
            return NULL.createNode(readonly);
        }

        public Object getValue(Node node) {
            RuleResultValue resultValue = new RuleResultValue();
            resultValue.setTarget(null);
            return resultValue;
        }

        public void setValue(Node node, Object value) {
        }

        @Override
        public Object joinValues(Object target, Object value) {
            return value;
        }

        @Override
        public void setReadonly(boolean readonly, Node node) {
            NULL.setReadonly(readonly, node);
        }

        @Override
        public <T extends BaseCommissionProperties> NodeRenderer createValueRenderer(EntityContainer<T> targetValue) {
            return StandardRuleResultValueRenderer.PAYMENT_TYPE;
        }

        @Override
        public void buildResultsInfo(Consumer<String> out, Object value) {
            RuleResult ruleResult = (RuleResult)value;
            String strValue = ruleResult.getValue() == null ? UiUtil.NULL_TEXT : ruleResult.getValue().toString();
            out.accept(ruleResult.getAction().getDisplayName() + ": " + strValue);
        }
    }
    ,
    ALL_PERSONS{

        public Node createNode(boolean readonly) {
            return NULL.createNode(readonly);
        }

        public Object getValue(Node node) {
            RuleResultValue resultValue = new RuleResultValue();
            resultValue.setTarget(null);
            return resultValue;
        }

        public void setValue(Node node, Object value) {
        }

        @Override
        public <T extends BaseCommissionProperties> NodeRenderer createValueRenderer(EntityContainer<T> targetValue) {
            return StandardRuleResultValueRenderer.ALL_PERSONS;
        }

        @Override
        public Object joinValues(Object target, Object value) {
            return value;
        }

        @Override
        public void setReadonly(boolean readonly, Node node) {
            NULL.setReadonly(readonly, node);
        }

        @Override
        public void buildResultsInfo(Consumer<String> out, Object value) {
            RuleResult ruleResult = (RuleResult)value;
            String strValue = ruleResult.getValue() == null ? UiUtil.NULL_TEXT : ruleResult.getValue().toString();
            out.accept(ruleResult.getAction().getDisplayName() + ": " + strValue);
        }
    }
    ,
    SUPPLIER{

        public Node createNode(boolean readonly) {
            return NULL.createNode(readonly);
        }

        public Object getValue(Node node) {
            RuleResultValue resultValue = new RuleResultValue();
            resultValue.setTarget(null);
            return resultValue;
        }

        public void setValue(Node node, Object value) {
        }

        @Override
        public <T extends BaseCommissionProperties> NodeRenderer createValueRenderer(EntityContainer<T> targetValue) {
            return StandardRuleResultValueRenderer.SUPPLIER;
        }

        @Override
        public Object joinValues(Object target, Object value) {
            return value;
        }

        @Override
        public void setReadonly(boolean readonly, Node node) {
            NULL.setReadonly(readonly, node);
        }

        @Override
        public void buildResultsInfo(Consumer<String> out, Object value) {
            RuleResult ruleResult = (RuleResult)value;
            String strValue = ruleResult.getValue() == null ? UiUtil.NULL_TEXT : ruleResult.getValue().toString();
            out.accept(ruleResult.getAction().getDisplayName() + ": " + strValue);
        }
    }
    ,
    NOMENCLATURE{

        public Node createNode(boolean readonly) {
            return NULL.createNode(readonly);
        }

        public Object getValue(Node node) {
            RuleResultValue resultValue = new RuleResultValue();
            resultValue.setTarget(null);
            return resultValue;
        }

        public void setValue(Node node, Object value) {
        }

        @Override
        public Object joinValues(Object target, Object value) {
            return value;
        }

        @Override
        public void setReadonly(boolean readonly, Node node) {
            NULL.setReadonly(readonly, node);
        }

        @Override
        public <T extends BaseCommissionProperties> NodeRenderer createValueRenderer(EntityContainer<T> targetValue) {
            return StandardRuleResultValueRenderer.NOMENCLATURE;
        }
    }
    ,
    TAXES_NOMENCLATURE{

        public Node createNode(boolean readonly) {
            return NULL.createNode(readonly);
        }

        public Object getValue(Node node) {
            RuleResultValue resultValue = new RuleResultValue();
            resultValue.setTarget(null);
            return resultValue;
        }

        public void setValue(Node node, Object value) {
        }

        @Override
        public void setReadonly(boolean readonly, Node node) {
            NULL.setReadonly(readonly, node);
        }

        @Override
        public Object joinValues(Object target, Object value) {
            return value;
        }

        @Override
        public <T extends BaseCommissionProperties> NodeRenderer createValueRenderer(EntityContainer<T> targetValue) {
            return StandardRuleResultValueRenderer.TAXES_NOMENCLATURE;
        }
    }
    ,
    TAXES_WITH_VAT_RATE_NOMENCLATURE{

        public Node createNode(boolean readonly) {
            return NULL.createNode(readonly);
        }

        public Object getValue(Node node) {
            RuleResultValue resultValue = new RuleResultValue();
            resultValue.setTarget(null);
            return resultValue;
        }

        public void setValue(Node node, Object value) {
        }

        @Override
        public void setReadonly(boolean readonly, Node node) {
            NULL.setReadonly(readonly, node);
        }

        @Override
        public Object joinValues(Object target, Object value) {
            return value;
        }

        @Override
        public <T extends BaseCommissionProperties> NodeRenderer createValueRenderer(EntityContainer<T> targetValue) {
            return StandardRuleResultValueRenderer.TAXES_WITH_VAT_RATE_NOMENCLATURE;
        }
    }
    ,
    ADD_SERVICE_TYPE_NOMENCLATURE{

        public Node createNode(boolean readonly) {
            return NULL.createNode(readonly);
        }

        public Object getValue(Node node) {
            RuleResultValue resultValue = new RuleResultValue();
            resultValue.setTarget(null);
            return resultValue;
        }

        public void setValue(Node node, Object value) {
        }

        @Override
        public void setReadonly(boolean readonly, Node node) {
            NULL.setReadonly(readonly, node);
        }

        @Override
        public Object joinValues(Object target, Object value) {
            return value;
        }

        @Override
        public <T extends BaseCommissionProperties> NodeRenderer createValueRenderer(EntityContainer<T> targetValue) {
            return StandardRuleResultValueRenderer.ADD_SERVICE_TYPE_NOMENCLATURE;
        }
    }
    ,
    CATEGORY_FEE_NOMENCLATURE{

        public Node createNode(boolean readonly) {
            return NULL.createNode(readonly);
        }

        public Object getValue(Node node) {
            RuleResultValue resultValue = new RuleResultValue();
            resultValue.setTarget(null);
            return resultValue;
        }

        public void setValue(Node node, Object value) {
        }

        @Override
        public void setReadonly(boolean readonly, Node node) {
            NULL.setReadonly(readonly, node);
        }

        @Override
        public Object joinValues(Object target, Object value) {
            return value;
        }

        @Override
        public <T extends BaseCommissionProperties> NodeRenderer createValueRenderer(EntityContainer<T> targetValue) {
            return StandardRuleResultValueRenderer.CATEGORY_FEE_NOMENCLATURE;
        }
    }
    ,
    BLANK_OWNER{

        public Node createNode(boolean readonly) {
            return NULL.createNode(readonly);
        }

        public Object getValue(Node node) {
            RuleResultValue resultValue = new RuleResultValue();
            resultValue.setTarget(null);
            return resultValue;
        }

        public void setValue(Node node, Object value) {
        }

        @Override
        public <T extends BaseCommissionProperties> NodeRenderer createValueRenderer(EntityContainer<T> targetValue) {
            return StandardRuleResultValueRenderer.BLANK_OWNER;
        }

        @Override
        public Object joinValues(Object target, Object value) {
            return value;
        }

        @Override
        public void setReadonly(boolean readonly, Node node) {
            NULL.setReadonly(readonly, node);
        }

        @Override
        public void buildResultsInfo(Consumer<String> out, Object value) {
            RuleResult ruleResult = (RuleResult)value;
            String strValue = ruleResult.getValue() == null ? UiUtil.NULL_TEXT : ruleResult.getValue().toString();
            out.accept(ruleResult.getAction().getDisplayName() + ": " + strValue);
        }
    }
    ,
    FISCAL_RECEIPT_CATEGORY{

        public Node createNode(boolean readonly) {
            return NULL.createNode(readonly);
        }

        public Object getValue(Node node) {
            RuleResultValue resultValue = new RuleResultValue();
            resultValue.setTarget(null);
            return resultValue;
        }

        public void setValue(Node node, Object value) {
        }

        @Override
        public Object joinValues(Object target, Object value) {
            return value;
        }

        @Override
        public void setReadonly(boolean readonly, Node node) {
            NULL.setReadonly(readonly, node);
        }

        @Override
        public <T extends BaseCommissionProperties> NodeRenderer createValueRenderer(EntityContainer<T> targetValue) {
            return StandardRuleResultValueRenderer.FISCAL_RECEIPT_CATEGORY;
        }

        @Override
        public void buildResultsInfo(Consumer<String> out, Object value) {
            RuleResult ruleResult = (RuleResult)value;
            String strValue = ruleResult.getValue() == null ? UiUtil.NULL_TEXT : ruleResult.getValue().toString();
            out.accept(ruleResult.getAction().getDisplayName() + ": " + strValue);
        }
    }
    ,
    MCO_CATEGORIES{

        public Node createNode(boolean readonly) {
            return NULL.createNode(readonly);
        }

        @Override
        public <T extends BaseCommissionProperties> NodeRenderer createValueRenderer(EntityContainer<T> targetValue) {
            return StandardRuleResultValueRenderer.MCO_CATEGORIES;
        }

        public Object getValue(Node node) {
            RuleResultValue resultValue = new RuleResultValue();
            resultValue.setTarget(null);
            return resultValue;
        }

        public void setValue(Node node, Object value) {
        }

        @Override
        public Object joinValues(Object target, Object value) {
            return value;
        }

        @Override
        public void setReadonly(boolean readonly, Node node) {
            NULL.setReadonly(readonly, node);
        }
    }
    ,
    PAYER{

        public Node createNode(boolean readonly) {
            return NULL.createNode(readonly);
        }

        public Object getValue(Node node) {
            RuleResultValue resultValue = new RuleResultValue();
            resultValue.setTarget(null);
            return resultValue;
        }

        public void setValue(Node node, Object value) {
        }

        @Override
        public <T extends BaseCommissionProperties> NodeRenderer createValueRenderer(EntityContainer<T> targetValue) {
            return StandardRuleResultValueRenderer.PAYER;
        }

        @Override
        public Object joinValues(Object target, Object value) {
            return value;
        }

        @Override
        public void setReadonly(boolean readonly, Node node) {
            NULL.setReadonly(readonly, node);
        }

        @Override
        public void buildResultsInfo(Consumer<String> out, Object value) {
            RuleResult ruleResult = (RuleResult)value;
            String strValue = ruleResult.getValue() == null ? UiUtil.NULL_TEXT : ruleResult.getValue().toString();
            out.accept(ruleResult.getAction().getDisplayName() + ": " + strValue);
        }
    }
    ,
    MONEY{

        public Node createNode(boolean readonly) {
            return NULL.createNode(readonly);
        }

        @Override
        public <T extends BaseCommissionProperties> NodeRenderer createValueRenderer(EntityContainer<T> targetValue) {
            return StandardRuleValueRenderers.MONEY;
        }

        public Object getValue(Node node) {
            RuleResultValue resultValue = new RuleResultValue();
            resultValue.setTarget(null);
            return resultValue;
        }

        public void setValue(Node node, Object value) {
        }

        @Override
        public Object joinValues(Object target, Object value) {
            return value;
        }

        @Override
        public void setReadonly(boolean readonly, Node node) {
            NULL.setReadonly(readonly, node);
        }
    }
    ,
    TIME_LIMIT_TYPE{

        public Node createNode(boolean readonly) {
            return NULL.createNode(readonly);
        }

        @Override
        public <T extends BaseCommissionProperties> NodeRenderer createValueRenderer(EntityContainer<T> targetValue) {
            return StandardRuleValueRenderers.TIME_LIMIT_TYPE;
        }

        public Object getValue(Node node) {
            return null;
        }

        public void setValue(Node node, Object value) {
        }

        @Override
        public Object joinValues(Object target, Object value) {
            return value;
        }

        @Override
        public void setReadonly(boolean readonly, Node node) {
            NULL.setReadonly(readonly, node);
        }
    }
    ,
    STRING_MAP{

        public Node createNode(boolean readonly) {
            return NULL.createNode(readonly);
        }

        @Override
        public <T extends BaseCommissionProperties> NodeRenderer createValueRenderer(EntityContainer<T> targetValue) {
            return StandardRuleValueRenderers.STRING_MAP;
        }

        public Object getValue(Node node) {
            return null;
        }

        public void setValue(Node node, Object value) {
        }

        @Override
        public Object joinValues(Object target, Object value) {
            return value;
        }

        @Override
        public void setReadonly(boolean readonly, Node node) {
            NULL.setReadonly(readonly, node);
        }
    }
    ,
    INTEGER_LIST{

        public Node createNode(boolean readonly) {
            return NULL.createNode(readonly);
        }

        @Override
        public <T extends BaseCommissionProperties> NodeRenderer createValueRenderer(EntityContainer<T> targetValue) {
            return StandardRuleResultValueRenderer.INTEGER_LIST;
        }

        public Object getValue(Node node) {
            return null;
        }

        public void setValue(Node node, Object value) {
        }

        @Override
        public Object joinValues(Object target, Object value) {
            return value;
        }

        @Override
        public void setReadonly(boolean readonly, Node node) {
            NULL.setReadonly(readonly, node);
        }
    }
    ,
    SELECT_TRANSLITERATION{

        public Node createNode(boolean readonly) {
            return NULL.createNode(readonly);
        }

        public Object getValue(Node node) {
            return null;
        }

        public void setValue(Node node, Object value) {
        }

        @Override
        public void setReadonly(boolean readonly, Node node) {
            NULL.setReadonly(readonly, node);
        }

        @Override
        public Object joinValues(Object target, Object value) {
            return value;
        }

        @Override
        public <T extends BaseCommissionProperties> NodeRenderer createValueRenderer(EntityContainer<T> targetValue) {
            return StandardRuleValueRenderers.SELECT_TRANSLITERATION;
        }
    }
    ,
    HOTEL_VENDOR_CONTRACT{

        public Node createNode(boolean readonly) {
            return NULL.createNode(readonly);
        }

        public Object getValue(Node node) {
            RuleResultValue resultValue = new RuleResultValue();
            resultValue.setTarget(null);
            return resultValue;
        }

        public void setValue(Node node, Object value) {
        }

        @Override
        public <T extends BaseCommissionProperties> NodeRenderer createValueRenderer(EntityContainer<T> targetValue) {
            return StandardRuleResultValueRenderer.HOTEL_VENDOR_CONTRACT;
        }

        @Override
        public Object joinValues(Object target, Object value) {
            return value;
        }

        @Override
        public void setReadonly(boolean readonly, Node node) {
            NULL.setReadonly(readonly, node);
        }

        @Override
        public void buildResultsInfo(Consumer<String> out, Object value) {
            RuleResult ruleResult = (RuleResult)value;
            String strValue = ruleResult.getValue() == null ? UiUtil.NULL_TEXT : ruleResult.getValue().toString();
            out.accept(ruleResult.getAction().getDisplayName() + ": " + strValue);
        }
    }
    ,
    CONFIRMATION_REQUIRED{

        public Node createNode(boolean readonly) {
            TextFieldWidget text = (TextFieldWidget)StandardRuleResultValueRenderer.SIMPLE_TEXT.createNode(true);
            text.setValue(Messages.ConfirmationRequired);
            return text;
        }

        @Override
        public <T extends BaseCommissionProperties> NodeRenderer createValueRenderer(EntityContainer<T> targetValue) {
            return NULL;
        }

        public Object getValue(Node node) {
            RuleResultValue resultValue = new RuleResultValue();
            resultValue.setTarget(null);
            return resultValue;
        }

        public void setValue(Node node, Object value) {
        }

        @Override
        public Object joinValues(Object target, Object value) {
            return value;
        }

        @Override
        public void setReadonly(boolean readonly, Node node) {
            NULL.setReadonly(true, node);
        }

        @Override
        public void buildResultsInfo(Consumer<String> out, Object value) {
            RuleResult ruleResult = (RuleResult)value;
            String strValue = Messages.ConfirmationRequired;
            out.accept(ruleResult.getAction().getDisplayName() + ". " + strValue);
        }
    }
    ,
    CONFIRMATION_REQUIRED_VALUED{

        public Node createNode(boolean readonly) {
            TextFieldWidget text = (TextFieldWidget)StandardRuleResultValueRenderer.SIMPLE_TEXT.createNode(true);
            text.setValue(Messages.ConfirmationRequired);
            return text;
        }

        @Override
        public <T extends BaseCommissionProperties> NodeRenderer createValueRenderer(EntityContainer<T> targetValue) {
            return StandardRuleResultValueRenderer.STRING_LIST;
        }

        public Object getValue(Node node) {
            RuleResultValue resultValue = new RuleResultValue();
            resultValue.setTarget(null);
            return resultValue;
        }

        public void setValue(Node node, Object value) {
        }

        @Override
        public Object joinValues(Object target, Object value) {
            return value;
        }

        @Override
        public void setReadonly(boolean readonly, Node node) {
            NULL.setReadonly(true, node);
        }

        @Override
        public void buildResultsInfo(Consumer<String> out, Object value) {
            RuleResult ruleResult = (RuleResult)value;
            String val = ruleResult.getValue() == null ? null : String.join((CharSequence)", ", (Collection)ruleResult.getValue());
            String strValue = Messages.ConfirmationRequired;
            strValue = TextUtil.nonBlank((String)val) ? ": " + val + ". " + strValue : ". " + strValue;
            out.accept(ruleResult.getAction().getDisplayName() + strValue);
        }
    };


    public String getId() {
        return this.name();
    }

    public void setReadonly(boolean readonly, Node node) {
        ((HasViewState)node).getViewState().setReadonly(readonly);
    }

    @Override
    public <T extends BaseCommissionProperties> NodeRenderer createValueRenderer(EntityContainer<T> targetValue) {
        return NULL;
    }

    @Override
    public void buildResultsInfo(Consumer<String> out, Object value) {
        RuleResult ruleResult = (RuleResult)value;
        StringBuilder sb = new StringBuilder();
        ruleResult.getAction().buildInfo(sb, ruleResult.getValue());
        out.accept(sb.toString());
    }
}

