/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.rules.renderers;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.IntValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.NodeRenderer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.PriceValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.Suppliers;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.PopupWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.multi.MultiEntityWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.util.HasValue;
import com.gridnine.xtrip.client.fx.core.util.HasValues;
import com.gridnine.xtrip.client.fx.core.util.HasViewState;
import com.gridnine.xtrip.client.fx.standard.rules.renderers.StandardRuleActionRenderers;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.rules.l10n.Messages;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyAuthorizationParameters;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyAuthorizationStepParameters;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyAuthorizationUnitParameters;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyMatchType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.Predicates;
import java.math.BigDecimal;
import java.util.List;
import java.util.function.Predicate;
import javafx.collections.ObservableList;
import javafx.scene.Node;

public enum TravelPolicyRuleResultValueRenderer implements NodeRenderer
{
    TRAVEL_POLICY_MATCH_TYPE{

        public Node createNode(boolean readonly) {
            ComboBoxWidget widget = new ComboBoxWidget(readonly);
            widget.setItemsSupplier(Suppliers.createEnumSupplier(TravelPolicyMatchType.class, (Predicate)Predicates.not(arg_0 -> TravelPolicyMatchType.RECOMMENDED.equals(arg_0))));
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return ((ComboBoxWidget)node).getValue();
        }

        public void setValue(Node node, Object value) {
            if (value == null) {
                return;
            }
            ((ComboBoxWidget)node).setValue((Object)((TravelPolicyMatchType)value));
        }

        public void setReadonly(boolean readonly, Node node) {
            ((HasViewState)node).getViewState().setReadonly(readonly);
        }
    }
    ,
    TRAVEL_POLICY_AUTHORIZATION_PARAMETERS{
        private static final String WIDGET_VALUE_PROPERTY_KEY = "WIDGET_VALUE_PROPERTY_KEY";

        public Node createNode(boolean readonly) {
            PopupWidget popupWidget = new PopupWidget();
            popupWidget.getViewState().setReadonly(readonly);
            popupWidget.setActionText(L10n.get((String)Messages.TravelPolicyActions_AUTHORIZATION_PARAMETERS_ACTION_TEXT));
            popupWidget.setFieldName(L10n.get((String)Messages.TravelPolicyActions_AUTHORIZATION_PARAMETERS_FIELD_NAME));
            GridContainer container = new GridContainer(1);
            container.setAdaptive(true);
            IntValueWidget node = new IntValueWidget(readonly);
            node.setId("timeLimit");
            GridCell cell = new GridCell(L10n.get((String)Messages.TravelPolicyActions_AUTHORIZATION_PARAMETERS_TIME_LIMIT), (Node)node);
            container.getCells().add((Object)cell);
            node = new PriceValueWidget(readonly);
            node.setId("priceLimitPercent");
            cell = new GridCell(L10n.get((String)Messages.TravelPolicyActions_AUTHORIZATION_PARAMETERS_PRICE_LIMIT_PERCENT), (Node)node);
            container.getCells().add((Object)cell);
            node = new MultiEntityWidget(Person.class, readonly);
            node.setId("person");
            cell = new GridCell(L10n.get((String)Messages.TravelPolicyActions_AUTHORIZATION_PARAMETERS_PERSON), (Node)node);
            container.getCells().add((Object)cell);
            popupWidget.setView((Node)container);
            popupWidget.setDialogConfigurator(d -> {
                d.setAutoClose(false);
                popupWidget.setDialogCloseHandler(() -> this.tryClose((PopupWidget<GridContainer>)popupWidget, (Dialog)d));
                d.setOnCloseRequest(() -> this.tryClose((PopupWidget<GridContainer>)popupWidget, (Dialog)d));
            });
            return popupWidget;
        }

        private void tryClose(PopupWidget<GridContainer> popupWidget, Dialog d) {
            TravelPolicyAuthorizationParameters value = this.readValue(popupWidget);
            if (popupWidget.getViewState().isReadonly()) {
                d.close();
                return;
            }
            if (MiscUtil.guarded((Integer)value.getTimeLimit()) <= 0) {
                d.addValidationMessages(false, new Message[]{MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)L10n.get((String)Messages.TravelPolicyAuthorization_EmptyTimeLimit), (Object[])new Object[0])});
            } else {
                d.close();
            }
        }

        private TravelPolicyAuthorizationParameters readValue(PopupWidget<GridContainer> popupWidget) {
            TravelPolicyAuthorizationParameters value = (TravelPolicyAuthorizationParameters)popupWidget.getProperties().get((Object)WIDGET_VALUE_PROPERTY_KEY);
            if (value == null) {
                value = new TravelPolicyAuthorizationParameters();
                popupWidget.getProperties().put((Object)WIDGET_VALUE_PROPERTY_KEY, (Object)value);
            }
            ObservableList cells = ((GridContainer)popupWidget.getView()).getCells();
            value.setTimeLimit((Integer)cells.stream().map(GridCell::getPayload).filter(c -> "timeLimit".equals(c.getId())).findFirst().map(n -> (Integer)((HasValue)n).valueProperty().get()).orElse(null));
            value.setPriceLimitPercent((BigDecimal)cells.stream().map(GridCell::getPayload).filter(c -> "priceLimitPercent".equals(c.getId())).findFirst().map(n -> (BigDecimal)((HasValue)n).valueProperty().get()).orElse(null));
            List steps = value.getSteps();
            while (steps.size() > 1) {
                steps.remove(value.getSteps().size() - 1);
            }
            List persons = cells.stream().map(GridCell::getPayload).filter(c -> "person".equals(c.getId())).findFirst().map(n -> ((HasValues)n).getValues()).orElse(null);
            if (persons != null && !persons.isEmpty()) {
                if (steps.isEmpty()) {
                    steps.add(new TravelPolicyAuthorizationStepParameters());
                }
                TravelPolicyAuthorizationStepParameters step = (TravelPolicyAuthorizationStepParameters)steps.get(0);
                step.getPersons().clear();
                step.getPersons().addAll(persons);
            } else {
                steps.clear();
            }
            return value;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return node.getProperties().get((Object)WIDGET_VALUE_PROPERTY_KEY);
        }

        public void setValue(Node node, Object value) {
            if (node == null || value == null) {
                return;
            }
            node.getProperties().put((Object)WIDGET_VALUE_PROPERTY_KEY, value);
            TravelPolicyAuthorizationParameters params = (TravelPolicyAuthorizationParameters)value;
            PopupWidget popupWidget = (PopupWidget)node;
            ObservableList cells = ((GridContainer)popupWidget.getView()).getCells();
            cells.stream().map(GridCell::getPayload).filter(c -> "timeLimit".equals(c.getId())).findFirst().ifPresent(n -> ((HasValue)n).valueProperty().set((Object)params.getTimeLimit()));
            cells.stream().map(GridCell::getPayload).filter(c -> "priceLimitPercent".equals(c.getId())).findFirst().ifPresent(n -> ((HasValue)n).valueProperty().set((Object)params.getPriceLimitPercent()));
            if (params.getSteps().size() == 1 && ((TravelPolicyAuthorizationStepParameters)params.getSteps().get(0)).getPersons().size() > 0) {
                ((TravelPolicyAuthorizationStepParameters)params.getSteps().get(0)).getPersons().forEach(person -> cells.stream().map(GridCell::getPayload).filter(c -> "person".equals(c.getId())).findFirst().ifPresent(n -> ((HasValues)n).getValues().add(person)));
            }
        }

        public void setReadonly(boolean readonly, Node node) {
            ((HasViewState)node).getViewState().setReadonly(readonly);
        }
    }
    ,
    TRAVEL_POLICY_AUTHORIZATION_UNIT_PARAMETERS{
        private static final String WIDGET_VALUE_PROPERTY_KEY = "WIDGET_VALUE_PROPERTY_KEY";

        public Node createNode(boolean readonly) {
            PopupWidget popupWidget = new PopupWidget();
            popupWidget.getViewState().setReadonly(readonly);
            popupWidget.setActionText(L10n.get((String)Messages.TravelPolicyActions_AUTHORIZATION_PARAMETERS_ACTION_TEXT));
            popupWidget.setFieldName(L10n.get((String)Messages.TravelPolicyActions_AUTHORIZATION_PARAMETERS_FIELD_NAME));
            GridContainer container = new GridContainer(1);
            container.setAdaptive(true);
            IntValueWidget node = new IntValueWidget(readonly);
            node.setId("timeLimit");
            GridCell cell = new GridCell(L10n.get((String)Messages.TravelPolicyActions_AUTHORIZATION_PARAMETERS_TIME_LIMIT), (Node)node);
            container.getCells().add((Object)cell);
            node = new PriceValueWidget(readonly);
            node.setId("priceLimitPercent");
            cell = new GridCell(L10n.get((String)Messages.TravelPolicyActions_AUTHORIZATION_PARAMETERS_PRICE_LIMIT_PERCENT), (Node)node);
            container.getCells().add((Object)cell);
            node = new MultiEntityWidget(Person.class, readonly);
            node.setId("person");
            cell = new GridCell(L10n.get((String)Messages.TravelPolicyActions_AUTHORIZATION_PARAMETERS_PERSON), (Node)node);
            container.getCells().add((Object)cell);
            popupWidget.setView((Node)container);
            popupWidget.setDialogConfigurator(d -> {
                d.setAutoClose(false);
                popupWidget.setDialogCloseHandler(() -> this.tryClose((PopupWidget<GridContainer>)popupWidget, (Dialog)d));
                d.setOnCloseRequest(() -> this.tryClose((PopupWidget<GridContainer>)popupWidget, (Dialog)d));
            });
            return popupWidget;
        }

        private void tryClose(PopupWidget<GridContainer> popupWidget, Dialog d) {
            TravelPolicyAuthorizationUnitParameters value = this.readValue(popupWidget);
            if (popupWidget.getViewState().isReadonly()) {
                d.close();
                return;
            }
            if (MiscUtil.guarded((Integer)value.getTimeLimit()) <= 0) {
                d.addValidationMessages(false, new Message[]{MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)L10n.get((String)Messages.TravelPolicyAuthorization_EmptyTimeLimit), (Object[])new Object[0])});
            } else {
                d.close();
            }
        }

        private TravelPolicyAuthorizationUnitParameters readValue(PopupWidget<GridContainer> popupWidget) {
            TravelPolicyAuthorizationUnitParameters value = (TravelPolicyAuthorizationUnitParameters)popupWidget.getProperties().get((Object)WIDGET_VALUE_PROPERTY_KEY);
            if (value == null) {
                value = new TravelPolicyAuthorizationUnitParameters();
                popupWidget.getProperties().put((Object)WIDGET_VALUE_PROPERTY_KEY, (Object)value);
            }
            ObservableList cells = ((GridContainer)popupWidget.getView()).getCells();
            value.setTimeLimit((Integer)cells.stream().map(GridCell::getPayload).filter(c -> "timeLimit".equals(c.getId())).findFirst().map(n -> (Integer)((HasValue)n).valueProperty().get()).orElse(null));
            value.setPriceLimitPercent((BigDecimal)cells.stream().map(GridCell::getPayload).filter(c -> "priceLimitPercent".equals(c.getId())).findFirst().map(n -> (BigDecimal)((HasValue)n).valueProperty().get()).orElse(null));
            List persons = cells.stream().map(GridCell::getPayload).filter(c -> "person".equals(c.getId())).findFirst().map(n -> ((HasValues)n).getValues()).orElse(null);
            if (persons != null && !persons.isEmpty()) {
                value.getPersons().clear();
                value.getPersons().addAll(persons);
            }
            return value;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return node.getProperties().get((Object)WIDGET_VALUE_PROPERTY_KEY);
        }

        public void setValue(Node node, Object value) {
            if (node == null || value == null) {
                return;
            }
            node.getProperties().put((Object)WIDGET_VALUE_PROPERTY_KEY, value);
            TravelPolicyAuthorizationUnitParameters params = (TravelPolicyAuthorizationUnitParameters)value;
            PopupWidget popupWidget = (PopupWidget)node;
            ObservableList cells = ((GridContainer)popupWidget.getView()).getCells();
            cells.stream().map(GridCell::getPayload).filter(c -> "timeLimit".equals(c.getId())).findFirst().ifPresent(n -> ((HasValue)n).valueProperty().set((Object)params.getTimeLimit()));
            cells.stream().map(GridCell::getPayload).filter(c -> "priceLimitPercent".equals(c.getId())).findFirst().ifPresent(n -> ((HasValue)n).valueProperty().set((Object)params.getPriceLimitPercent()));
            if (params.getPersons().size() > 0) {
                params.getPersons().forEach(person -> cells.stream().map(GridCell::getPayload).filter(c -> "person".equals(c.getId())).findFirst().ifPresent(n -> ((HasValues)n).getValues().add(person)));
            }
        }

        public void setReadonly(boolean readonly, Node node) {
            ((HasViewState)node).getViewState().setReadonly(readonly);
        }
    }
    ,
    TRUE{

        public Node createNode(boolean readonly) {
            return StandardRuleActionRenderers.NULL.createNode(readonly);
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return Boolean.TRUE;
        }

        public void setValue(Node node, Object value) {
        }

        public void setReadonly(boolean readonly, Node node) {
        }
    };

}

