/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.rules.renderers;

import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.widgets.NodeRenderer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.RendererWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.Suppliers;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.DictBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.MoneyValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.ComboBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.RendererWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.TextWidgetColumn;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.standard.rules.renderers.RuleValueRenderer;
import com.gridnine.xtrip.client.fx.standard.rules.renderers.StandardRuleValueRenderers;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.model.booking.PassengerTypeCategory;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.rules.l10n.Messages;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.TravelSubjectTotalPriceRestrictions;
import com.gridnine.xtrip.common.model.rules.standard.ValueTypes;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.rules.RuleRestriction;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.util.Predicates;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.scene.Node;
import javafx.util.StringConverter;

public class TravelSubjectTotalPriceValueRenderer
implements RuleValueRenderer {
    protected static final String DISABLED_CELL_STYLE = "xtrip-cell-disabled";
    private static final StringConverter<RuleCondition> conditionConverter = new StringConverter<RuleCondition>(){

        public String toString(RuleCondition object) {
            return object == null ? UiUtil.NULL_TEXT : object.getDisplayName();
        }

        public RuleCondition fromString(String string) {
            return null;
        }
    };

    public String getId() {
        return ValueTypes.TRAVEL_SUBJECT_TOTAL_PRICE.name();
    }

    public Node createNode(boolean readonly) {
        Node node = StandardRuleValueRenderers.NULL.createNode(readonly);
        node.setUserData((Object)new TotalPriceTable());
        return node;
    }

    @Override
    public RuleCondition getFixedCondition() {
        return Conditions.EQUALS;
    }

    public TableWidget<RuleRestriction> getPropertiesTable(Node node) {
        return (TableWidget)node.getUserData();
    }

    public Object getValue(Node node) {
        TotalPriceTable table = (TotalPriceTable)this.getPropertiesTable(node);
        if (table == null) {
            return null;
        }
        return new TravelSubjectTotalPriceRestrictions(table.totalPriceCondition, table.totalPriceValue, table.travelSubjectCondition, table.travelSubjectValue, table.passengerTypeCategoryCondition, table.passengerTypeCategoryValue);
    }

    public void setValue(Node node, Object value) {
        if (value == null) {
            return;
        }
        TravelSubjectTotalPriceRestrictions rules = (TravelSubjectTotalPriceRestrictions)value;
        TotalPriceTable table = (TotalPriceTable)this.getPropertiesTable(node);
        table.totalPriceCondition = rules.getTotalPriceCondition();
        table.totalPriceValue = rules.getTotalPriceValue();
        table.travelSubjectCondition = rules.getTravelSubjectCondition();
        table.travelSubjectValue = rules.getTravelSubjectValue();
        table.passengerTypeCategoryCondition = rules.getPassengerTypeCategoryCondition();
        table.passengerTypeCategoryValue = rules.getPassengerTypeCategoryValue();
        table.refreshWidgets();
    }

    @Override
    public boolean isValueEmpty(Node node) {
        TotalPriceTable table = (TotalPriceTable)this.getPropertiesTable(node);
        return table.totalPriceValue == null && table.travelSubjectValue == null && table.passengerTypeCategoryValue == null;
    }

    @Override
    public void buildRestrictionsInfo(Consumer<String> out, RuleRestriction ruleRestriction) {
        StringBuilder buf = new StringBuilder();
        TravelSubjectTotalPriceRestrictions value = (TravelSubjectTotalPriceRestrictions)ruleRestriction.getValue();
        value.buildInfo(buf);
        out.accept(buf.toString());
    }

    public void setReadonly(boolean readonly, Node node) {
        this.getPropertiesTable(node).getViewState().setReadonly(readonly);
    }

    static class TotalPriceTable
    extends TableWidget<RuleRestriction> {
        protected static final String PROPERTY_ID = "property";
        private static final String CONDITION_ID = "condition";
        protected static final String VALUE_ID = "value";
        private Conditions totalPriceCondition;
        private Money totalPriceValue;
        private Conditions travelSubjectCondition;
        private TravelSubject travelSubjectValue;
        private Conditions passengerTypeCategoryCondition;
        private DictionaryReference<PassengerTypeCategory> passengerTypeCategoryValue;
        private final Supplier<List<Conditions>> conditions = () -> Arrays.asList(Conditions.EQUALS, Conditions.NOT_EQUALS);

        TotalPriceTable() {
            super(false);
            this.setItemsProvider(RuleRestriction::new);
            this.setColumns(this.createColumns());
            this.setControlButtonsAvailability(ControlsPane.NONE);
            this.fillTable();
        }

        void refreshWidgets() {
            ComboBoxWidgetColumn column2 = (ComboBoxWidgetColumn)this.getColumn(CONDITION_ID);
            RendererWidgetColumn column3 = (RendererWidgetColumn)this.getColumn(VALUE_ID);
            int idx = 0;
            ComboBoxWidget conditionWidget = (ComboBoxWidget)column2.getWidget(idx);
            RendererWidget valueWidget = (RendererWidget)column3.getWidget(idx++);
            conditionWidget.setValue((Object)this.totalPriceCondition);
            valueWidget.setValue((Object)this.totalPriceValue);
            conditionWidget = (ComboBoxWidget)column2.getWidget(idx);
            valueWidget = (RendererWidget)column3.getWidget(idx++);
            conditionWidget.setValue((Object)this.travelSubjectCondition);
            valueWidget.setValue((Object)this.travelSubjectValue);
            conditionWidget = (ComboBoxWidget)column2.getWidget(idx);
            valueWidget = (RendererWidget)column3.getWidget(idx++);
            conditionWidget.setValue((Object)this.passengerTypeCategoryCondition);
            valueWidget.setValue(this.passengerTypeCategoryValue);
        }

        private List<TableWidgetColumn<RuleRestriction, ?>> createColumns() {
            ArrayList tableColumns = new ArrayList();
            TextWidgetColumn column1 = new TextWidgetColumn(rr -> null, (rr, value) -> rr.setProperty(null));
            column1.setId(PROPERTY_ID);
            column1.setCaption(com.gridnine.xtrip.client.fx.standard.l10n.Messages.Property);
            column1.setPrefWidth(Double.valueOf(30.0));
            tableColumns.add((TableWidgetColumn<RuleRestriction, ?>)column1);
            ComboBoxWidgetColumn column2 = new ComboBoxWidgetColumn(RuleRestriction::getCondition, RuleRestriction::setCondition);
            column2.setId(CONDITION_ID);
            column2.setCaption(com.gridnine.xtrip.client.fx.standard.l10n.Messages.Condition);
            column2.setConverter(conditionConverter);
            column2.setPrefWidth(Double.valueOf(30.0));
            tableColumns.add((TableWidgetColumn<RuleRestriction, ?>)column2);
            RendererWidgetColumn column3 = new RendererWidgetColumn(RuleRestriction::getValue, RuleRestriction::setValue);
            column3.setId(VALUE_ID);
            column3.setCaption(com.gridnine.xtrip.client.fx.standard.l10n.Messages.Value_text);
            tableColumns.add((TableWidgetColumn<RuleRestriction, ?>)column3);
            return tableColumns;
        }

        private void fillTable() {
            int row = 0;
            this.moneyValueRow(row++, L10n.get((String)Messages.RuleProperty_TotalPrice), () -> this.totalPriceCondition, v -> {
                this.totalPriceCondition = v;
            }, () -> this.totalPriceValue, v -> {
                this.totalPriceValue = v;
            });
            this.travelSubjectValueRow(row++, L10n.get((String)Messages.RuleProperty_TravelSubject), () -> this.travelSubjectCondition, v -> {
                this.travelSubjectCondition = v;
            }, () -> this.travelSubjectValue, v -> {
                this.travelSubjectValue = v;
            });
            this.passengerTypeCategoryValueRow(row++, L10n.get((String)Messages.RuleProperty_PassengerTypeCategory), () -> this.passengerTypeCategoryCondition, v -> {
                this.passengerTypeCategoryCondition = v;
            }, () -> this.passengerTypeCategoryValue, v -> {
                this.passengerTypeCategoryValue = v;
            });
        }

        private void passengerTypeCategoryValueRow(int idx, String rowCaption, Supplier<Conditions> conditionGetter, Consumer<Conditions> conditionSetter, Supplier<DictionaryReference<PassengerTypeCategory>> valueGetter, final Consumer<DictionaryReference<PassengerTypeCategory>> valueSetter) {
            this.addRow(idx);
            TextWidgetColumn column1 = (TextWidgetColumn)this.getColumn(PROPERTY_ID);
            TextFieldWidget node1 = (TextFieldWidget)column1.getWidget(idx);
            node1.getViewState().setNotEditable(true);
            node1.setValue(rowCaption);
            node1.getStyleClass().add((Object)TravelSubjectTotalPriceValueRenderer.DISABLED_CELL_STYLE);
            ComboBoxWidgetColumn column2 = (ComboBoxWidgetColumn)this.getColumn(CONDITION_ID);
            ComboBoxWidget node2 = (ComboBoxWidget)column2.getWidget(idx);
            node2.setNoNulls(true);
            node2.setItemsSupplier(this.conditions);
            node2.setValue((Object)conditionGetter.get());
            node2.valueProperty().addListener((p, o, v) -> conditionSetter.accept((Conditions)v));
            RendererWidgetColumn column3 = (RendererWidgetColumn)this.getColumn(VALUE_ID);
            RendererWidget node3 = (RendererWidget)column3.getWidget(idx);
            node3.setValue(valueGetter.get());
            node3.setRenderer(new NodeRenderer(){

                public Node createNode(boolean readonly) {
                    DictBoxWidget widget = new DictBoxWidget(PassengerTypeCategory.class, readonly);
                    widget.setFieldName("Passenger type category");
                    return widget;
                }

                public void setValue(Node node, Object value) {
                    DictBoxWidget widget = (DictBoxWidget)node;
                    widget.setValue((DictionaryReference)value);
                    valueSetter.accept((DictionaryReference)value);
                }

                public Object getValue(Node node) {
                    DictBoxWidget widget = (DictBoxWidget)node;
                    return widget.getValue();
                }

                public void setReadonly(boolean readonly, Node node) {
                    DictBoxWidget widget = (DictBoxWidget)node;
                    widget.getViewState().setReadonly(readonly);
                }
            });
            ((DictBoxWidget)node3.getValueNode()).valueProperty().addListener((p, o, v) -> valueSetter.accept((DictionaryReference<PassengerTypeCategory>)v));
        }

        private void moneyValueRow(int idx, String rowCaption, Supplier<Conditions> conditionGetter, Consumer<Conditions> conditionSetter, Supplier<Money> valueGetter, Consumer<Money> valueSetter) {
            this.addRow(idx);
            TextWidgetColumn column1 = (TextWidgetColumn)this.getColumn(PROPERTY_ID);
            TextFieldWidget node1 = (TextFieldWidget)column1.getWidget(idx);
            node1.getViewState().setNotEditable(true);
            node1.setValue(rowCaption);
            node1.getStyleClass().add((Object)TravelSubjectTotalPriceValueRenderer.DISABLED_CELL_STYLE);
            ComboBoxWidgetColumn column2 = (ComboBoxWidgetColumn)this.getColumn(CONDITION_ID);
            ComboBoxWidget node2 = (ComboBoxWidget)column2.getWidget(idx);
            node2.setNoNulls(true);
            node2.setItemsSupplier(() -> Arrays.asList(Conditions.EQUALS, Conditions.NOT_EQUALS, Conditions.GREATER_THAN, Conditions.LESS_THAN, Conditions.GREATER_THAN_OR_EQUALS, Conditions.LESS_THAN_OR_EQUALS));
            node2.setValue((Object)conditionGetter.get());
            node2.valueProperty().addListener((p, o, v) -> conditionSetter.accept((Conditions)v));
            RendererWidgetColumn column3 = (RendererWidgetColumn)this.getColumn(VALUE_ID);
            RendererWidget node3 = (RendererWidget)column3.getWidget(idx);
            node3.setValue((Object)valueGetter.get());
            node3.setRenderer((NodeRenderer)StandardRuleValueRenderers.MONEY);
            ((MoneyValueWidget)node3.getValueNode()).valueProperty().addListener((p, o, v) -> valueSetter.accept((Money)v));
        }

        private void travelSubjectValueRow(int idx, String rowCaption, Supplier<Conditions> conditionGetter, Consumer<Conditions> conditionSetter, Supplier<TravelSubject> valueGetter, final Consumer<TravelSubject> valueSetter) {
            this.addRow(idx);
            TextWidgetColumn column1 = (TextWidgetColumn)this.getColumn(PROPERTY_ID);
            TextFieldWidget node1 = (TextFieldWidget)column1.getWidget(idx);
            node1.getViewState().setNotEditable(true);
            node1.setValue(rowCaption);
            node1.getStyleClass().add((Object)TravelSubjectTotalPriceValueRenderer.DISABLED_CELL_STYLE);
            ComboBoxWidgetColumn column2 = (ComboBoxWidgetColumn)this.getColumn(CONDITION_ID);
            ComboBoxWidget node2 = (ComboBoxWidget)column2.getWidget(idx);
            node2.setNoNulls(true);
            node2.setItemsSupplier(this.conditions);
            node2.setValue((Object)conditionGetter.get());
            node2.valueProperty().addListener((p, o, v) -> conditionSetter.accept((Conditions)v));
            RendererWidgetColumn column3 = (RendererWidgetColumn)this.getColumn(VALUE_ID);
            RendererWidget node3 = (RendererWidget)column3.getWidget(idx);
            node3.setValue((Object)valueGetter.get());
            final List excluded = Stream.of(TravelSubject.ADDITIONAL_SERVICE, TravelSubject.INSURANCE_ACCIDENT, TravelSubject.INSURANCE_TOURISTIC, TravelSubject.OTHER).collect(Collectors.toList());
            node3.setRenderer(new NodeRenderer(){

                public Node createNode(boolean readonly) {
                    ComboBoxWidget widget = new ComboBoxWidget(readonly);
                    widget.setItemsSupplier(Suppliers.createEnumSupplier(TravelSubject.class, (Predicate)Predicates.not(excluded::contains)));
                    widget.valueProperty().addListener((p, o, v) -> valueSetter.accept(v));
                    return widget;
                }

                public void setValue(Node node, Object value) {
                    ComboBoxWidget widget = (ComboBoxWidget)node;
                    widget.setValue((Object)((TravelSubject)value));
                    valueSetter.accept((TravelSubject)value);
                }

                public Object getValue(Node node) {
                    ComboBoxWidget widget = (ComboBoxWidget)node;
                    return widget.getValue();
                }

                public void setReadonly(boolean readonly, Node node) {
                    ComboBoxWidget widget = (ComboBoxWidget)node;
                    widget.getViewState().setReadonly(readonly);
                }
            });
        }
    }
}

