/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.rules.renderers;

import com.gridnine.xtrip.client.fx.core.lib.widgets.NodeRenderer;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors.ControllerInterceptorVatHelper;
import com.gridnine.xtrip.client.fx.standard.rules.renderers.RuleActionRenderer;
import com.gridnine.xtrip.client.fx.standard.rules.renderers.StandardRuleActionRenderers;
import com.gridnine.xtrip.client.fx.standard.rules.renderers.VatRuleResultValueRenderer;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.VatBasisType;
import com.gridnine.xtrip.common.model.booking.VatCalculationData;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.rules.l10n.Messages;
import com.gridnine.xtrip.common.model.rules.standard.RuleResultValue;
import com.gridnine.xtrip.common.rules.RuleResult;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javafx.scene.Node;

public enum VatRuleActionRenderers implements RuleActionRenderer
{
    VAT_CALCULATION_DATA{

        public Node createNode(boolean readonly) {
            return StandardRuleActionRenderers.NULL.createNode(readonly);
        }

        public Object getValue(Node node) {
            RuleResultValue resultValue = new RuleResultValue();
            resultValue.setTarget(null);
            return resultValue;
        }

        public void setValue(Node node, Object value) {
        }

        @Override
        public Object joinValues(Object target, Object value) {
            return value;
        }

        @Override
        public <T extends BaseCommissionProperties> NodeRenderer createValueRenderer(EntityContainer<T> targetValue) {
            return VatRuleResultValueRenderer.VAT_CALCULATION_DATA;
        }

        public void setReadonly(boolean readonly, Node node) {
            StandardRuleActionRenderers.NULL.setReadonly(readonly, node);
        }

        @Override
        public void buildResultsInfo(Consumer<String> out, Object value) {
            RuleResult ruleResult = (RuleResult)value;
            List vatCalculationData = (List)ruleResult.getValue();
            out.accept(L10n.get((String)Messages.VatActions_recalculateProductVatInfo));
            out.accept(": ");
            out.accept(vatCalculationData.stream().map(this::convertVatCalculationDatatoString).collect(Collectors.joining("; ")));
        }

        private String convertVatCalculationDatatoString(VatCalculationData data) {
            StringBuilder builder = new StringBuilder();
            builder.append(data.getBasisType() != null ? data.getBasisType().toString() : null);
            if (data.getBasisType() == VatBasisType.TAXES && !data.getTaxesCodes().isEmpty()) {
                builder.append(" ").append(String.join((CharSequence)", ", data.getTaxesCodes()));
            }
            builder.append(": ").append(ControllerInterceptorVatHelper.vatConverter.toString((Object)data.getVatRate()));
            return builder.toString();
        }
    };


    public String getId() {
        return this.name();
    }

    @Override
    public void buildResultsInfo(Consumer<String> out, Object value) {
        RuleResult ruleResult = (RuleResult)value;
        StringBuilder sb = new StringBuilder();
        ruleResult.getAction().buildInfo(sb, ruleResult.getValue());
        out.accept(sb.toString());
    }
}

