/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.rules.renderers;

import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.widgets.NodeRenderer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.PopupWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableRowEvent;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.ComboBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.TextWidgetColumn;
import com.gridnine.xtrip.client.fx.core.util.HasViewState;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.model.booking.VatCalculationDataContainer;
import com.gridnine.xtrip.client.fx.model.booking.VatCalculationDataTableVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors.ControllerInterceptorVatHelper;
import com.gridnine.xtrip.common.model.booking.VatBasisType;
import com.gridnine.xtrip.common.model.booking.VatCalculationData;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javafx.beans.value.ChangeListener;
import javafx.scene.Node;

public enum VatRuleResultValueRenderer implements NodeRenderer
{
    VAT_CALCULATION_DATA{

        public Node createNode(boolean readonly) {
            VatCalculationDataContainer container = new VatCalculationDataContainer(readonly);
            TableWidget widget = (TableWidget)((GridCell)container.getCells().get(0)).getPayload();
            List<VatBasisType> vatBasisTypes = Arrays.asList(VatBasisType.values());
            ComboBoxWidgetColumn basisTypeColumn = (ComboBoxWidgetColumn)container.getVatCalculationDataNode().getColumn("basisType");
            basisTypeColumn.setItemsSupplier(() -> vatBasisTypes.stream().filter(type -> type == VatBasisType.TAXES || widget.getRowsData().stream().filter(Objects::nonNull).noneMatch(vm -> vm.getBasisType() == type)).collect(Collectors.toList()));
            TextWidgetColumn taxesCodesColumn = (TextWidgetColumn)container.getVatCalculationDataNode().getColumn("taxesCodes");
            ComboBoxWidgetColumn vatRateColumn = (ComboBoxWidgetColumn)container.getVatCalculationDataNode().getColumn("vatRate");
            vatRateColumn.setItemsSupplier(ControllerInterceptorVatHelper.getVatGeneralSupplier());
            vatRateColumn.setConverter(ControllerInterceptorVatHelper.vatConverter);
            PopupWidget popup = new PopupWidget();
            popup.setInfoText(UiUtil.NULL_TEXT);
            popup.setView((Node)container);
            ChangeListener listener = (observable, oldValue, newValue) -> this.updateInfoText((PopupWidget<VatCalculationDataContainer>)popup, (TableWidget<VatCalculationDataTableVM>)widget);
            widget.setOnRowsAction(event -> {
                if (event.getEventType().equals(TableRowEvent.ROW_ADD)) {
                    int idx = event.getRowIndex();
                    ((ComboBoxWidget)basisTypeColumn.getWidget(idx)).valueProperty().addListener(listener);
                    ((TextFieldWidget)taxesCodesColumn.getWidget(idx)).valueProperty().addListener(listener);
                    ((ComboBoxWidget)vatRateColumn.getWidget(idx)).valueProperty().addListener(listener);
                    if (((ComboBoxWidget)basisTypeColumn.getWidget(idx)).getValue() != VatBasisType.TAXES) {
                        ((TextFieldWidget)taxesCodesColumn.getWidget(idx)).setDisable(true);
                        ((TextFieldWidget)taxesCodesColumn.getWidget(idx)).setValue("");
                    } else {
                        ((TextFieldWidget)taxesCodesColumn.getWidget(idx)).setDisable(false);
                    }
                    ((ComboBoxWidget)basisTypeColumn.getWidget(idx)).valueProperty().addListener((observable, oldValue, newValue) -> {
                        if (newValue != VatBasisType.TAXES) {
                            ((TextFieldWidget)taxesCodesColumn.getWidget(idx)).setDisable(true);
                            ((TextFieldWidget)taxesCodesColumn.getWidget(idx)).setValue("");
                        } else {
                            ((TextFieldWidget)taxesCodesColumn.getWidget(idx)).setDisable(false);
                        }
                    });
                }
                if (event.getEventType().equals(TableRowEvent.ROW_REMOVE)) {
                    this.updateInfoText((PopupWidget<VatCalculationDataContainer>)popup, (TableWidget<VatCalculationDataTableVM>)widget);
                }
            });
            return popup;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            ArrayList result = new ArrayList();
            TableWidget widget = (TableWidget)((GridCell)((VatCalculationDataContainer)((PopupWidget)node).getView()).getCells().get(0)).getPayload();
            widget.getRowsData().forEach(vm -> {
                if (vm.getBasisType() != null) {
                    VatCalculationData data = new VatCalculationData();
                    data.setBasisType(vm.getBasisType());
                    data.setVatRate(vm.getVatRate());
                    if (vm.getBasisType() == VatBasisType.TAXES) {
                        data.getTaxesCodes().addAll(this.getTaxesCodes(vm.getTaxesCodes()));
                    }
                    result.add(data);
                }
            });
            return result;
        }

        public void setValue(Node node, Object value) {
            if (node == null || value == null) {
                return;
            }
            PopupWidget popup = (PopupWidget)node;
            TableWidget widget = (TableWidget)((GridCell)((VatCalculationDataContainer)popup.getView()).getCells().get(0)).getPayload();
            List dataList = (List)value;
            dataList.forEach(data -> {
                VatCalculationDataTableVM vm = new VatCalculationDataTableVM();
                vm.setBasisType(data.getBasisType());
                vm.setVatRate(data.getVatRate());
                if (!data.getTaxesCodes().isEmpty()) {
                    vm.setTaxesCodes(String.join((CharSequence)", ", data.getTaxesCodes()));
                }
                widget.addRow((Object)vm);
            });
            if (!widget.getRowsData().isEmpty()) {
                popup.setInfoText(widget.getRowsData().stream().filter(Objects::nonNull).map(this::convertVmToString).collect(Collectors.joining("; ")));
            }
        }

        public void setReadonly(boolean readonly, Node node) {
            ((HasViewState)node).getViewState().setReadonly(readonly);
        }

        List<String> getTaxesCodes(String value) {
            if (TextUtil.isBlank((String)value)) {
                return Collections.emptyList();
            }
            value = value.replaceAll(";", ",");
            String[] codes = value.split(",");
            return Arrays.stream(codes).filter(TextUtil::nonBlank).map(String::trim).collect(Collectors.toList());
        }

        String convertVmToString(VatCalculationDataTableVM vm) {
            StringBuilder builder = new StringBuilder();
            builder.append(vm.getBasisType() != null ? vm.getBasisType().toString() : null);
            if (vm.getBasisType() == VatBasisType.TAXES && TextUtil.nonBlank((String)vm.getTaxesCodes())) {
                builder.append(" ").append(String.join((CharSequence)", ", this.getTaxesCodes(vm.getTaxesCodes())));
            }
            builder.append(": ").append(ControllerInterceptorVatHelper.vatConverter.toString((Object)vm.getVatRate()));
            return builder.toString();
        }

        void updateInfoText(PopupWidget<VatCalculationDataContainer> popup, TableWidget<VatCalculationDataTableVM> widget) {
            String infoText = widget.getRowsData().stream().filter(Objects::nonNull).map(this::convertVmToString).collect(Collectors.joining("; "));
            popup.setInfoText(TextUtil.nonBlank((String)infoText) ? infoText : UiUtil.NULL_TEXT);
        }
    };

}

