/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.settings.general;

import com.gridnine.xtrip.client.fx.core.acl.AppliedAclData;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.DoubleValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.Suppliers;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.CurrencyValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.standard.restriction.resource.StandardUiResource;
import java.util.ArrayList;
import java.util.Locale;
import javafx.scene.Node;

class GeneralSettingsCompactPane
extends GridContainer {
    private final GridCell<ComboBoxWidget<Locale>> uiLocaleCell = new GridCell(Messages.Interface_language, (Node)new ComboBoxWidget(false));
    private final GridCell<CurrencyValueWidget> equivalentCurrencyCell = new GridCell(Messages.Currency_of_payment, (Node)new CurrencyValueWidget(false));
    private final GridCell<DoubleValueWidget> defaultVatCell = new GridCell(Messages.NDS, (Node)new DoubleValueWidget(false));

    GeneralSettingsCompactPane() {
        ((ComboBoxWidget)this.uiLocaleCell.getPayload()).setItemsSupplier(Suppliers.SUPPORTED_LOCALES);
        ((ComboBoxWidget)this.uiLocaleCell.getPayload()).setConverter(StandardRenderers.LOCALE.createConverter());
        ((ComboBoxWidget)this.uiLocaleCell.getPayload()).setNoNulls(true);
        this.getCells().addAll((Object[])new GridCell[]{this.uiLocaleCell, this.equivalentCurrencyCell, this.defaultVatCell});
    }

    ComboBoxWidget<Locale> getUiLocale() {
        return (ComboBoxWidget)this.uiLocaleCell.getPayload();
    }

    CurrencyValueWidget getEquivalentCurrency() {
        return (CurrencyValueWidget)this.equivalentCurrencyCell.getPayload();
    }

    DoubleValueWidget getDefaultVat() {
        return (DoubleValueWidget)this.defaultVatCell.getPayload();
    }

    void enforceAcl(AppliedAclData aclData) {
        ArrayList<Object> forbiddenCells = new ArrayList<Object>();
        String resourceId = StandardUiResource.SETTINGS_MAIN_LANGUAGE.getId();
        if (!aclData.canView(resourceId)) {
            forbiddenCells.add(this.uiLocaleCell);
        } else {
            ((ComboBoxWidget)this.uiLocaleCell.getPayload()).getViewState().setAclNotEditable(!aclData.canEdit(resourceId));
        }
        resourceId = StandardUiResource.SETTINGS_MAIN_PAYMENT_CURRENCY.getId();
        if (!aclData.canView(resourceId)) {
            forbiddenCells.add(this.equivalentCurrencyCell);
        } else {
            ((CurrencyValueWidget)this.equivalentCurrencyCell.getPayload()).getViewState().setAclNotEditable(!aclData.canEdit(resourceId));
        }
        resourceId = StandardUiResource.SETTINGS_MAIN_GLOBAL.getId();
        if (!aclData.canView(resourceId)) {
            forbiddenCells.add(this.defaultVatCell);
        } else {
            ((DoubleValueWidget)this.defaultVatCell.getPayload()).getViewState().setAclNotEditable(!aclData.canEdit(resourceId));
        }
        this.getForbiddenCells().addAll(forbiddenCells);
    }
}

