/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.settings.general;

import com.gridnine.xtrip.client.fx.core.acl.AppliedAclData;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.Tile;
import com.gridnine.xtrip.client.fx.core.settings.SettingsHandler;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ValueHolder;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.settings.general.GeneralSettingsCompactPane;
import com.gridnine.xtrip.client.fx.standard.settings.general.GeneralSettingsFullPane;
import com.gridnine.xtrip.client.fx.standard.settings.general.GeneralSettingsVM;
import com.gridnine.xtrip.common.fx.standard.restriction.resource.StandardUiResource;
import com.gridnine.xtrip.common.model.rpc.ModelService;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javafx.scene.Node;

public class GeneralSettingsHandler
implements SettingsHandler<GeneralSettingsCompactPane, GeneralSettingsFullPane> {
    public String getId() {
        return "settings-general";
    }

    public double getWeight() {
        return 0.0;
    }

    public Tile<GeneralSettingsCompactPane, GeneralSettingsFullPane> createTile(Consumer<List<Message>> validationMessagesConsumer) {
        GeneralSettingsCompactPane compactPane = new GeneralSettingsCompactPane();
        return new Tile(this.getId(), Messages.General_parameters, (Node)compactPane, (Node)new GeneralSettingsFullPane(compactPane));
    }

    public String getAclResourceId() {
        return StandardUiResource.SETTINGS_MAIN.getId();
    }

    public void enforceAcl(Tile<GeneralSettingsCompactPane, GeneralSettingsFullPane> tile, AppliedAclData aclData) {
        ((GeneralSettingsCompactPane)tile.getCompactNode()).enforceAcl(aclData);
        ((GeneralSettingsFullPane)tile.getFullNode()).enforceAcl(aclData);
    }

    public void loadData(Tile<GeneralSettingsCompactPane, GeneralSettingsFullPane> tile) throws Exception {
        GeneralSettingsVM data = GeneralSettingsVM.load();
        FxUtil.waitForFxThread(() -> ((GeneralSettingsFullPane)tile.getFullNode()).readData(data));
    }

    public void saveData(Tile<GeneralSettingsCompactPane, GeneralSettingsFullPane> tile) throws Exception {
        GeneralSettingsVM data = GeneralSettingsVM.load();
        ValueHolder changes = new ValueHolder();
        FxUtil.waitForFxThread(() -> {
            changes.set(((GeneralSettingsFullPane)tile.getFullNode()).getChanges());
            ((GeneralSettingsFullPane)tile.getFullNode()).writeData(data);
        });
        GeneralSettingsVM.save(data, (Set)changes.get());
        if (((Set)changes.get()).contains((Object)GeneralSettingsVM.SettingsProperty.clientSettings)) {
            Notifications.get().showFlashNotification(Messages.Notification_Changes_to_settings_will_not_take_effect_until_the_program_is_restarted, null);
        }
        if (((Set)changes.get()).contains((Object)GeneralSettingsVM.SettingsProperty.anyAgencyProfile)) {
            Notifications.get().submitTask(() -> {
                ModelService modelService = (ModelService)RpcServiceManager.get().getService(ModelService.class);
                modelService.updateTechnicalProviderContractCustomer(ServiceInvocationContext.get());
            }, "");
        }
        FxUtil.waitForFxThread(() -> ((GeneralSettingsFullPane)tile.getFullNode()).readData(data));
    }

    public boolean isDataChanged(Tile<GeneralSettingsCompactPane, GeneralSettingsFullPane> tile) {
        return !((GeneralSettingsFullPane)tile.getFullNode()).getChanges().isEmpty();
    }

    public void setNotEditable(Tile<GeneralSettingsCompactPane, GeneralSettingsFullPane> tile, boolean notEditable) {
        ((GeneralSettingsFullPane)tile.getFullNode()).setNotEditable(notEditable);
    }
}

