/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.settings.general;

import com.gridnine.xtrip.client.fx.core.dicts.DictListParameters;
import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.lib.components.QuickHelp;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.DoubleValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.PasswordFieldWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.DictBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.BooleanValueWidget;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.Converters;
import com.gridnine.xtrip.client.fx.standard.helpers.DictHandlersHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.settings.general.GeneralSettingsVM;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Set;
import javafx.scene.Node;

class SettingsPane4
extends GridContainer {
    private final DoubleValueWidget defaultVat = new DoubleValueWidget(false);
    private final EntityBoxWidget<Organization> retailClientProfile = new EntityBoxWidget(Organization.class, false);
    private final EntityBoxWidget<Organization> anyClientProfile = new EntityBoxWidget(Organization.class, false);
    private final EntityBoxWidget<Organization> anyAgencyProfile = new EntityBoxWidget(Organization.class, false);
    private final DictBoxWidget<Airline> anyAirlineProfile = new DictBoxWidget(Airline.class, false);
    private final EntityBoxWidget<Organization> aeroexpressProfile = new EntityBoxWidget(Organization.class, false);
    private final EntityBoxWidget<Organization> insuranceProfile = new EntityBoxWidget(Organization.class, false);
    private final BooleanValueWidget groupBySubagent = new BooleanValueWidget(false, false);
    private final BooleanValueWidget messagesInReports = new BooleanValueWidget(false, false);
    private final BooleanValueWidget restrictedTextSearch = new BooleanValueWidget(false, false);
    private final BooleanValueWidget worklogEnabled = new BooleanValueWidget(false, false);
    private final BooleanValueWidget fullAccessToAclEditorEnabled = new BooleanValueWidget(false, false);
    private final PasswordFieldWidget excelPassword = new PasswordFieldWidget(false);
    private final BooleanValueWidget notificationsEnabled = new BooleanValueWidget(false, false);
    private final BooleanValueWidget fillDefaultCostCodesFromProfiles = new BooleanValueWidget(false, false);
    private final BooleanValueWidget fillDefaultCostCodesFromProducts = new BooleanValueWidget(false, false);
    private final BooleanValueWidget enabledRemoteFiscalServiceProvider = new BooleanValueWidget(false, false);
    private final BooleanValueWidget checkOrganizationsCodeUniqueness = new BooleanValueWidget(false, false);
    private GeneralSettingsVM data;

    SettingsPane4() {
        super(3);
        this.setAdaptive(true);
        this.retailClientProfile.setListParametersSupplier(() -> this.buildListParameters(OrganizationType.CORPORATE_CLIENT));
        this.retailClientProfile.setValueSelectionListener(val -> {
            if (val == null) {
                return;
            }
            String code = (String)val.getValue(OrganizationIndex.Property.code.name());
            if (TextUtil.isBlank((String)code)) {
                this.retailClientProfile.setValue(null);
                Notifications.get().showFlashNotification(Messages.Settings_invalid_retail_profile, null);
            }
        });
        this.anyClientProfile.setListParametersSupplier(() -> this.buildListParameters(OrganizationType.CORPORATE_CLIENT));
        this.anyAgencyProfile.setListParametersSupplier(() -> this.buildListParameters(OrganizationType.AGENCY));
        this.anyAirlineProfile.setListParametersSupplier(this::buildListParameters);
        this.aeroexpressProfile.setListParametersSupplier(() -> this.buildListParameters(OrganizationType.BLANK_OWNER));
        this.insuranceProfile.setListParametersSupplier(() -> this.buildListParameters(OrganizationType.BLANK_OWNER));
        this.groupBySubagent.setConverter(Converters.boolConverter((String)Messages.Group, (String)Messages.Do_not_Group));
        this.messagesInReports.setConverter(Converters.boolConverter((String)Messages.To_Show, (String)Messages.Do_Not_Show));
        this.restrictedTextSearch.setConverter(Converters.boolConverter((String)Messages.Restricted_Text_True, (String)Messages.Restricted_Text_False));
        this.worklogEnabled.setConverter(Converters.boolConverter((String)Messages.Settings_Worklog_enabled, (String)Messages.Settings_Worklog_disabled));
        this.fullAccessToAclEditorEnabled.setConverter(Converters.boolConverter((String)Messages.Acl_editor_access_full, (String)Messages.Acl_editor_access_restricted));
        this.notificationsEnabled.setConverter(Converters.boolConverter((String)Messages.Settings_Notifications_enabled, (String)Messages.Settings_Notifications_disabled));
        this.fillDefaultCostCodesFromProfiles.setConverter(Converters.boolConverter((String)Messages.FillingDefaultCostCodes_enabled, (String)Messages.FillingDefaultCostCodes_disabled));
        this.fillDefaultCostCodesFromProducts.setConverter(Converters.boolConverter((String)Messages.FillingDefaultCostCodes_enabled, (String)Messages.FillingDefaultCostCodes_disabled));
        this.enabledRemoteFiscalServiceProvider.setConverter(Converters.boolConverter((String)Messages.EnabledRemoteFiscalServiceProvider_enabled, (String)Messages.EnabledRemoteFiscalServiceProvider_disabled));
        this.checkOrganizationsCodeUniqueness.setConverter(Converters.boolConverter((String)Messages.CheckOrganizationsCodeUniqueness_enabled, (String)Messages.CheckOrganizationsCodeUniqueness_disabled));
        ArrayList<GridCell> cells = new ArrayList<GridCell>();
        cells.add(new GridCell(Messages.NDS, (Node)this.defaultVat));
        cells.add(new GridCell(Messages.Retail_Customer_Profile, this.retailClientProfile));
        cells.add(new GridCell(Messages.Profile_Any_Client, this.anyClientProfile));
        cells.add(new GridCell(Messages.Profile_Any_Agency, this.anyAgencyProfile));
        cells.add(new GridCell(Messages.Profile_Any_Airline, this.anyAirlineProfile));
        cells.add(new GridCell(Messages.Profile_Aeroexpress, this.aeroexpressProfile));
        cells.add(new GridCell(Messages.Profile_Insurance_Company, this.insuranceProfile));
        cells.add(new GridCell(Messages.Grouping_of_tickets_for_subagents_in_reports, (Node)this.groupBySubagent));
        cells.add(new GridCell(Messages.Reports_about_forms_in_reports, (Node)this.messagesInReports));
        cells.add(new GridCell(Messages.Password_for_Excel_files, (Node)this.excelPassword));
        GridCell cell = new GridCell(Messages.Restricted_Text_Caption, (Node)this.restrictedTextSearch);
        cell.setHelp(() -> new QuickHelp(Messages.Restricted_Text_Help));
        cells.add(cell);
        cells.add(new GridCell(Messages.Settings_Worklog_option, (Node)this.worklogEnabled));
        cell = new GridCell(Messages.Acl_editor_access_option, (Node)this.fullAccessToAclEditorEnabled);
        cell.setHelp(() -> new QuickHelp(Messages.Acl_editor_access_help));
        cells.add(cell);
        cells.add(new GridCell(Messages.Settings_Notifications_option, (Node)this.notificationsEnabled));
        cells.add(new GridCell(Messages.FillingDefaultCostCodesFromProfiles_option, (Node)this.fillDefaultCostCodesFromProfiles));
        cells.add(GridCell.NEW_ROW_MARKER);
        cells.add(new GridCell(Messages.FillingDefaultCostCodesFromProducts_option, (Node)this.fillDefaultCostCodesFromProducts));
        cells.add(new GridCell(Messages.EnabledRemoteFiscalServiceProvider, (Node)this.enabledRemoteFiscalServiceProvider));
        cells.add(new GridCell(Messages.CheckOrganizationsCodeUniqueness, (Node)this.checkOrganizationsCodeUniqueness));
        this.getCells().addAll(cells);
    }

    DoubleValueWidget getDefaultVat() {
        return this.defaultVat;
    }

    private IndexListParameters<Organization, OrganizationIndex> buildListParameters(OrganizationType type) {
        IndexListParameters result = new IndexListParameters();
        result.setIndexType(OrganizationIndex.class);
        result.getSearchCriterions().add(SearchCriterion.contains((String)OrganizationIndex.Property.types.name(), (Object)type));
        TableColumnSettings col = new TableColumnSettings();
        col.setId(OrganizationIndex.Property.code.name());
        result.getColumns().add(col);
        col = new TableColumnSettings();
        col.setId(OrganizationIndex.Property.name.name());
        result.getColumns().add(col);
        return result;
    }

    private DictListParameters buildListParameters() {
        DictListParameters result = new DictListParameters();
        result.getColumns().add(DictHandlersHelper.COL_CODE);
        result.getColumns().add(DictHandlersHelper.COL_TRANSLATIONS);
        return result;
    }

    void readData(GeneralSettingsVM model) {
        this.data = model;
        this.defaultVat.setValue((Number)model.defaultVat);
        this.retailClientProfile.setValue(model.retailClientProfile);
        this.anyClientProfile.setValue(model.anyClientProfile);
        this.anyAgencyProfile.setValue(model.anyAgencyProfile);
        this.anyAirlineProfile.setValue(model.anyAirlineProfile);
        this.aeroexpressProfile.setValue(model.aeroexpressProfile);
        this.insuranceProfile.setValue(model.insuranceProfile);
        this.groupBySubagent.setValue(model.groupBySubagent);
        this.messagesInReports.setValue(model.messagesInReports);
        this.excelPassword.setValue(model.excelPassword);
        this.restrictedTextSearch.setValue(model.restrictedTextSearch);
        this.worklogEnabled.setValue(model.worklogEnabled);
        this.fullAccessToAclEditorEnabled.setValue(model.fullAccessToAclEditorEnabled);
        this.notificationsEnabled.setValue(model.notificationsEnabled);
        this.fillDefaultCostCodesFromProfiles.setValue(model.fillDefaultCostCodesFromProfiles);
        this.fillDefaultCostCodesFromProducts.setValue(model.fillDefaultCostCodesFromProducts);
        this.enabledRemoteFiscalServiceProvider.setValue(model.enabledRemoteFiscalServiceProvider);
        this.checkOrganizationsCodeUniqueness.setValue(model.checkOrganizationsCodeUniqueness);
        this.enforceNotEditable();
    }

    void enforceNotEditable() {
        this.retailClientProfile.getViewState().setNotEditable(this.retailClientProfile.getValue() != null);
        this.anyClientProfile.getViewState().setNotEditable(this.anyClientProfile.getValue() != null);
        this.anyAgencyProfile.getViewState().setNotEditable(this.anyAgencyProfile.getValue() != null);
    }

    void writeData(GeneralSettingsVM model) {
        model.defaultVat = (Double)this.defaultVat.getValue();
        model.retailClientProfile = this.retailClientProfile.getValue();
        model.anyClientProfile = this.anyClientProfile.getValue();
        model.anyAgencyProfile = this.anyAgencyProfile.getValue();
        model.anyAirlineProfile = this.anyAirlineProfile.getValue();
        model.aeroexpressProfile = this.aeroexpressProfile.getValue();
        model.insuranceProfile = this.insuranceProfile.getValue();
        model.groupBySubagent = this.groupBySubagent.getValue();
        model.messagesInReports = this.messagesInReports.getValue();
        model.excelPassword = this.excelPassword.getValue();
        model.restrictedTextSearch = this.restrictedTextSearch.getValue();
        model.worklogEnabled = this.worklogEnabled.getValue();
        model.fullAccessToAclEditorEnabled = this.fullAccessToAclEditorEnabled.getValue();
        model.notificationsEnabled = this.notificationsEnabled.getValue();
        model.fillDefaultCostCodesFromProfiles = this.fillDefaultCostCodesFromProfiles.getValue();
        model.fillDefaultCostCodesFromProducts = this.fillDefaultCostCodesFromProducts.getValue();
        model.enabledRemoteFiscalServiceProvider = this.enabledRemoteFiscalServiceProvider.getValue();
        model.checkOrganizationsCodeUniqueness = this.checkOrganizationsCodeUniqueness.getValue();
        this.data = model;
    }

    void collectChanges(Set<GeneralSettingsVM.SettingsProperty> changeSet) {
        if (!MiscUtil.equals((Object)(this.data == null ? null : this.data.defaultVat), (Object)this.defaultVat.valueProperty().get())) {
            changeSet.add(GeneralSettingsVM.SettingsProperty.defaultVat);
        }
        if (!MiscUtil.equals(this.data == null ? null : this.data.retailClientProfile, (Object)this.retailClientProfile.valueProperty().get())) {
            changeSet.add(GeneralSettingsVM.SettingsProperty.retailClientProfile);
        }
        if (!MiscUtil.equals(this.data == null ? null : this.data.anyClientProfile, (Object)this.anyClientProfile.valueProperty().get())) {
            changeSet.add(GeneralSettingsVM.SettingsProperty.anyClientProfile);
        }
        if (!MiscUtil.equals(this.data == null ? null : this.data.anyAgencyProfile, (Object)this.anyAgencyProfile.valueProperty().get())) {
            changeSet.add(GeneralSettingsVM.SettingsProperty.anyAgencyProfile);
        }
        if (!MiscUtil.equals(this.data == null ? null : this.data.anyAirlineProfile, (Object)this.anyAirlineProfile.valueProperty().get())) {
            changeSet.add(GeneralSettingsVM.SettingsProperty.anyAirlineProfile);
        }
        if (!MiscUtil.equals(this.data == null ? null : this.data.aeroexpressProfile, (Object)this.aeroexpressProfile.valueProperty().get())) {
            changeSet.add(GeneralSettingsVM.SettingsProperty.aeroexpressProfile);
        }
        if (!MiscUtil.equals(this.data == null ? null : this.data.insuranceProfile, (Object)this.insuranceProfile.valueProperty().get())) {
            changeSet.add(GeneralSettingsVM.SettingsProperty.insuranceProfile);
        }
        if (!MiscUtil.equals((Object)(this.data == null ? null : Boolean.valueOf(this.data.groupBySubagent)), (Object)this.groupBySubagent.valueProperty().get())) {
            changeSet.add(GeneralSettingsVM.SettingsProperty.groupBySubagent);
        }
        if (!MiscUtil.equals((Object)(this.data == null ? null : Boolean.valueOf(this.data.messagesInReports)), (Object)this.messagesInReports.valueProperty().get())) {
            changeSet.add(GeneralSettingsVM.SettingsProperty.messagesInReports);
        }
        if (!MiscUtil.equals((Object)(this.data == null ? null : this.data.excelPassword), (Object)this.excelPassword.getValue())) {
            changeSet.add(GeneralSettingsVM.SettingsProperty.excelPassword);
        }
        if (!MiscUtil.equals((Object)(this.data == null ? null : Boolean.valueOf(this.data.restrictedTextSearch)), (Object)this.restrictedTextSearch.valueProperty().get())) {
            changeSet.add(GeneralSettingsVM.SettingsProperty.restrictedTextSearch);
        }
        if (!MiscUtil.equals((Object)(this.data == null ? null : Boolean.valueOf(this.data.worklogEnabled)), (Object)this.worklogEnabled.valueProperty().get())) {
            changeSet.add(GeneralSettingsVM.SettingsProperty.worklogEnabled);
        }
        if (!MiscUtil.equals((Object)(this.data == null ? null : Boolean.valueOf(this.data.fullAccessToAclEditorEnabled)), (Object)this.fullAccessToAclEditorEnabled.valueProperty().get())) {
            changeSet.add(GeneralSettingsVM.SettingsProperty.fullAccessToAclEditorEnabled);
        }
        if (!MiscUtil.equals((Object)(this.data == null ? null : Boolean.valueOf(this.data.notificationsEnabled)), (Object)this.notificationsEnabled.valueProperty().get())) {
            changeSet.add(GeneralSettingsVM.SettingsProperty.notificationsEnabled);
        }
        if (!MiscUtil.equals((Object)(this.data == null ? null : Boolean.valueOf(this.data.fillDefaultCostCodesFromProfiles)), (Object)this.fillDefaultCostCodesFromProfiles.valueProperty().get())) {
            changeSet.add(GeneralSettingsVM.SettingsProperty.fillDefaultCostCodesFromProfiles);
        }
        if (!MiscUtil.equals((Object)(this.data == null ? null : Boolean.valueOf(this.data.fillDefaultCostCodesFromProducts)), (Object)this.fillDefaultCostCodesFromProducts.valueProperty().get())) {
            changeSet.add(GeneralSettingsVM.SettingsProperty.fillDefaultCostCodesFromProducts);
        }
        if (!MiscUtil.equals((Object)(this.data == null ? null : Boolean.valueOf(this.data.enabledRemoteFiscalServiceProvider)), (Object)this.enabledRemoteFiscalServiceProvider.valueProperty().get())) {
            changeSet.add(GeneralSettingsVM.SettingsProperty.clientSettings);
        }
        if (!MiscUtil.equals((Object)(this.data == null ? null : Boolean.valueOf(this.data.checkOrganizationsCodeUniqueness)), (Object)this.checkOrganizationsCodeUniqueness.valueProperty().get())) {
            changeSet.add(GeneralSettingsVM.SettingsProperty.checkOrganizationsCodeUniqueness);
        }
    }

    void setNotEditable(boolean value) {
        this.defaultVat.getViewState().setNotEditable(value);
        this.retailClientProfile.getViewState().setNotEditable(value);
        this.anyClientProfile.getViewState().setNotEditable(value);
        this.anyAgencyProfile.getViewState().setNotEditable(value);
        this.anyAirlineProfile.getViewState().setNotEditable(value);
        this.aeroexpressProfile.getViewState().setNotEditable(value);
        this.insuranceProfile.getViewState().setNotEditable(value);
        this.groupBySubagent.getViewState().setNotEditable(value);
        this.messagesInReports.getViewState().setNotEditable(value);
        this.excelPassword.getViewState().setNotEditable(value);
        this.restrictedTextSearch.getViewState().setNotEditable(value);
        this.worklogEnabled.getViewState().setNotEditable(value);
        this.fullAccessToAclEditorEnabled.getViewState().setNotEditable(value);
        this.notificationsEnabled.getViewState().setNotEditable(value);
        this.fillDefaultCostCodesFromProfiles.getViewState().setNotEditable(value);
        this.fillDefaultCostCodesFromProducts.getViewState().setNotEditable(value);
        this.enabledRemoteFiscalServiceProvider.getViewState().setNotEditable(value);
        this.checkOrganizationsCodeUniqueness.getViewState().setNotEditable(value);
    }

    void setAclNotEditable(boolean value) {
        this.defaultVat.getViewState().setAclNotEditable(value);
        this.retailClientProfile.getViewState().setAclNotEditable(value);
        this.anyClientProfile.getViewState().setAclNotEditable(value);
        this.anyAgencyProfile.getViewState().setAclNotEditable(value);
        this.anyAirlineProfile.getViewState().setAclNotEditable(value);
        this.aeroexpressProfile.getViewState().setAclNotEditable(value);
        this.insuranceProfile.getViewState().setAclNotEditable(value);
        this.groupBySubagent.getViewState().setAclNotEditable(value);
        this.messagesInReports.getViewState().setAclNotEditable(value);
        this.excelPassword.getViewState().setAclNotEditable(value);
        this.restrictedTextSearch.getViewState().setAclNotEditable(value);
        this.worklogEnabled.getViewState().setAclNotEditable(value);
        this.fullAccessToAclEditorEnabled.getViewState().setAclNotEditable(value);
        this.notificationsEnabled.getViewState().setAclNotEditable(value);
        this.fillDefaultCostCodesFromProfiles.getViewState().setAclNotEditable(value);
        this.fillDefaultCostCodesFromProducts.getViewState().setAclNotEditable(value);
        this.enabledRemoteFiscalServiceProvider.getViewState().setAclNotEditable(value);
        this.checkOrganizationsCodeUniqueness.getViewState().setAclNotEditable(value);
    }
}

