/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.settings.keybindings;

import com.gridnine.xtrip.client.fx.core.kb.KeyBindingAction;
import com.gridnine.xtrip.client.fx.core.kb.KeyBindings;
import com.gridnine.xtrip.client.fx.core.lib.container.SimpleContainer;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.Tile;
import com.gridnine.xtrip.client.fx.core.lib.widgets.InfoLabelWidget;
import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.core.settings.SettingsHandler;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.settings.keybindings.KeyBindingsPane;
import com.gridnine.xtrip.common.fx.standard.restriction.resource.StandardUiResource;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.scene.input.KeyCombination;

public class KeyBindingsSettingsHandler
implements SettingsHandler<SimpleContainer<InfoLabelWidget>, KeyBindingsPane> {
    public String getId() {
        return "settings-keybindings";
    }

    public double getWeight() {
        return 7.0;
    }

    public Tile<SimpleContainer<InfoLabelWidget>, KeyBindingsPane> createTile(Consumer<List<Message>> validationMessagesConsumer) {
        InfoLabelWidget infoCompact = new InfoLabelWidget();
        infoCompact.setText(Messages.Keyboard_shortcuts_description);
        return new Tile(this.getId(), Messages.Keyboard_shortcuts, (Node)SimpleContainer.create((Node)infoCompact), (Node)new KeyBindingsPane());
    }

    public String getAclResourceId() {
        return StandardUiResource.SETTINGS_KEY_BINDINGS.getId();
    }

    public void loadData(Tile<SimpleContainer<InfoLabelWidget>, KeyBindingsPane> tile) throws Exception {
        KeyBindings kb = KeyBindings.get();
        List<MiscUtil.Pair<KeyBindingAction, KeyCombination>> data = ClientRegistry.get().allOf(KeyBindingAction.TYPE).values().stream().sorted((lhs, rhs) -> {
            String rName;
            String lName = lhs.getName();
            if (lName == null) {
                lName = lhs.getId();
            }
            if ((rName = rhs.getName()) == null) {
                rName = rhs.getId();
            }
            return lName.compareTo(rName);
        }).map(action -> new MiscUtil.Pair(action, (Object)kb.getKeyCombination(action))).collect(Collectors.toList());
        ((KeyBindingsPane)tile.getFullNode()).readData(data);
    }

    public void saveData(Tile<SimpleContainer<InfoLabelWidget>, KeyBindingsPane> tile) throws Exception {
        ArrayList<MiscUtil.Pair<KeyBindingAction, KeyCombination>> data = new ArrayList<MiscUtil.Pair<KeyBindingAction, KeyCombination>>();
        ((KeyBindingsPane)tile.getFullNode()).writeData(data);
        KeyBindings kb = KeyBindings.get();
        for (MiscUtil.Pair pair : data) {
            kb.setKeyCombination((KeyBindingAction)pair.getFirst(), (KeyCombination)pair.getSecond());
        }
        kb.save();
    }

    public boolean isDataChanged(Tile<SimpleContainer<InfoLabelWidget>, KeyBindingsPane> tile) {
        return ((KeyBindingsPane)tile.getFullNode()).isDataChanged();
    }

    public void setNotEditable(Tile<SimpleContainer<InfoLabelWidget>, KeyBindingsPane> tile, boolean notEditable) {
        ((KeyBindingsPane)tile.getFullNode()).setNotEditable(notEditable);
    }
}

