/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.settings.paymenttypes;

import com.gridnine.xtrip.client.fx.core.lib.container.SimpleContainer;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.Tile;
import com.gridnine.xtrip.client.fx.core.lib.widgets.InfoLabelWidget;
import com.gridnine.xtrip.client.fx.core.settings.SettingsHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.standard.helpers.RpcDictHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.settings.paymenttypes.PaymentTypesSettingsFullPane;
import com.gridnine.xtrip.common.fx.standard.restriction.resource.StandardUiResource;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javafx.scene.Node;

public class PaymentTypesSettingsHandler
implements SettingsHandler<SimpleContainer<InfoLabelWidget>, PaymentTypesSettingsFullPane> {
    public String getId() {
        return "settings-paymenttypes";
    }

    public double getWeight() {
        return 5.0;
    }

    public Tile<SimpleContainer<InfoLabelWidget>, PaymentTypesSettingsFullPane> createTile(Consumer<List<Message>> validationMessagesConsumer) {
        InfoLabelWidget info = new InfoLabelWidget();
        info.setText(Messages.Configuration_of_payment_types_is_not_loaded);
        Tile result = new Tile(this.getId(), Messages.Available_types_of_payment, (Node)SimpleContainer.create((Node)info), (Node)new PaymentTypesSettingsFullPane());
        result.expandedProperty().addListener((s, o, n) -> {
            if (!n.booleanValue()) {
                this.updateInfoLabel((Tile<SimpleContainer<InfoLabelWidget>, PaymentTypesSettingsFullPane>)result);
            }
        });
        return result;
    }

    public String getAclResourceId() {
        return StandardUiResource.SETTINGS_AVAILABLE_PAYMENT_TYPES.getId();
    }

    public void loadData(Tile<SimpleContainer<InfoLabelWidget>, PaymentTypesSettingsFullPane> tile) throws Exception {
        HashSet<PaymentType> paymentTypes = new HashSet<PaymentType>();
        String value = RpcDictHelper.findPreferenceValue(PreferenceKey.FOP_CHOICE_SETTINGS);
        if (!TextUtil.isBlank((String)value)) {
            for (String code : TextUtil.split((String)value, (String)"\\|", (boolean)true, (boolean)true)) {
                PaymentType pt = (PaymentType)CollectionUtil.findEnumConstant(PaymentType.class, (String)code);
                if (pt == null) continue;
                paymentTypes.add(pt);
            }
        }
        if (paymentTypes.isEmpty()) {
            paymentTypes.addAll(Arrays.asList(PaymentType.values()));
        }
        FxUtil.waitForFxThread(() -> {
            ((PaymentTypesSettingsFullPane)tile.getFullNode()).readData(paymentTypes);
            this.updateInfoLabel(tile);
        });
    }

    public void saveData(Tile<SimpleContainer<InfoLabelWidget>, PaymentTypesSettingsFullPane> tile) throws Exception {
        HashSet paymentTypes = new HashSet();
        FxUtil.waitForFxThread(() -> ((PaymentTypesSettingsFullPane)tile.getFullNode()).writeData(paymentTypes));
        if (paymentTypes.isEmpty()) {
            String str = L10nResourcesManager.getStr((String)Messages.At_least_one_form_of_payment_must_be_selected, (Locale)LocaleHelper.getCurrentLocale(), (Object[])new Object[0]);
            throw Xeption.forEndUser((String)str, (Object[])new Object[0]);
        }
        String value = paymentTypes.size() == PaymentType.values().length ? null : paymentTypes.stream().map(pt -> pt.name()).collect(Collectors.joining("|"));
        RpcDictHelper.updatePreference(PreferenceKey.FOP_CHOICE_SETTINGS, value);
        FxUtil.submitToFxThread(() -> this.updateInfoLabel(tile));
    }

    public boolean isDataChanged(Tile<SimpleContainer<InfoLabelWidget>, PaymentTypesSettingsFullPane> tile) {
        return ((PaymentTypesSettingsFullPane)tile.getFullNode()).isDataChanged();
    }

    public void setNotEditable(Tile<SimpleContainer<InfoLabelWidget>, PaymentTypesSettingsFullPane> tile, boolean notEditable) {
        ((PaymentTypesSettingsFullPane)tile.getFullNode()).setNotEditable(notEditable);
    }

    private void updateInfoLabel(Tile<SimpleContainer<InfoLabelWidget>, PaymentTypesSettingsFullPane> tile) {
        ((InfoLabelWidget)((SimpleContainer)tile.getCompactNode()).getContent()).setText(Messages.getTotal_available_payment_types(Integer.toString(((PaymentTypesSettingsFullPane)tile.getFullNode()).getEnabled()), Integer.toString(((PaymentTypesSettingsFullPane)tile.getFullNode()).getTotal())));
    }
}

