/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.settings.system;

import com.gridnine.xtrip.client.fx.core.acl.FxAclUtil;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevTool;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevToolItem;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.navigator.BaseNavigatorWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.navigator.CompactNavigatorWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.navigator.NavigatorViewType;
import com.gridnine.xtrip.client.fx.core.lib.widgets.navigator.NavigatorWidgetController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.navigator.StandardCompactNavigatorWidgetCoordinator;
import com.gridnine.xtrip.client.fx.core.lib.widgets.navigator.StandardViewTypeProvider;
import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ListItemStringConverter;
import com.gridnine.xtrip.client.fx.core.util.ValueHolder;
import com.gridnine.xtrip.client.fx.standard.helpers.AppConfigHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.settings.system.ProxyData;
import com.gridnine.xtrip.client.fx.standard.settings.system.ProxyPane;
import com.gridnine.xtrip.client.fx.standard.settings.system.SystemSettingsInstanceFactory;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.helper.UniqueSettingsRegistry;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.system.BaseSystemSettings;
import com.gridnine.xtrip.common.model.system.BasicSystemSettingsIndex;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.ScheduledTaskSettings;
import com.gridnine.xtrip.common.model.system.SystemSettingsType;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.scene.layout.StackPane;

class SystemSettingsFullPane
extends StackPane
implements DevTool {
    final ViewController<CompactNavigatorWidget, Collection<Object>> controller;
    private final List<ProxyData<?>> deleted = new ArrayList();
    protected final Consumer<List<Message>> validationMessagesConsumer;

    static <N extends Node> ListItemStringConverter<N> createViewConverter() {
        return (pane, idx) -> {
            String name = pane == null ? null : ((ProxyData)((ProxyPane)((Object)pane)).getData()).getTitle();
            return TextUtil.isBlank((String)name) ? Messages.No_Name : name;
        };
    }

    SystemSettingsFullPane(Consumer<List<Message>> validation) {
        this.validationMessagesConsumer = validation;
        final ArrayList<NavigatorViewType> allTypes = new ArrayList<NavigatorViewType>();
        this.collectTypes(allTypes);
        final ArrayList forbiddenTypeIds = new ArrayList(allTypes.stream().map(type -> ((CustomNavigatorViewType)type).entityType.getId()).collect(Collectors.toList()));
        Notifications.get().submitTask(() -> this.applyACL(allTypes, forbiddenTypeIds), Messages.Loading_data);
        final CompactNavigatorWidget view = new CompactNavigatorWidget(false);
        view.enableSuggestions(true);
        view.getSupportedTypes().addAll(allTypes);
        view.setFieldName(Messages.System_Settings_Type);
        view.setConverter(SystemSettingsFullPane.createViewConverter());
        view.setControlButtonsCoordinator((BiPredicate)new StandardCompactNavigatorWidgetCoordinator(view){

            public boolean test(ControlsPane.ButtonType buttonType, Node view) {
                if (view == null) {
                    return true;
                }
                if (buttonType == ControlsPane.ButtonType.REMOVE) {
                    return UniqueSettingsRegistry.get().getUidByClassName(((ProxyPane)view).getEntityType().getId()) == null;
                }
                return true;
            }
        });
        view.setViewTypeProvider((Consumer)new StandardViewTypeProvider((BaseNavigatorWidget)view){

            protected List<NavigatorViewType> getTypes() {
                String typeId;
                ArrayList<NavigatorViewType> result = new ArrayList<NavigatorViewType>(allTypes.size());
                HashSet<String> excludedTypeIds = new HashSet<String>();
                HashSet existingSettings = new HashSet();
                for (Node node : this.widget.getViews()) {
                    ProxyPane pane = (ProxyPane)node;
                    existingSettings.add(((ProxyData)pane.getData()).reference);
                    if ("true".equals(pane.getEntityType().getParameters().get("multiInstance"))) continue;
                    excludedTypeIds.add(pane.getEntityType().getId());
                }
                for (SystemSettingsInstanceFactory factory : ClientRegistry.get().allOf(SystemSettingsInstanceFactory.TYPE).values()) {
                    typeId = factory.getSettingsType().getName();
                    if (forbiddenTypeIds.contains(typeId)) continue;
                    excludedTypeIds.add(typeId);
                    for (SystemSettingsInstanceFactory.DataFactory dataFactory : factory.getFactories(existingSettings)) {
                        result.add(new CustomNavigatorViewType(MetaRegistryHelper.getEntityType((String)factory.getSettingsType().getName()), dataFactory));
                    }
                }
                for (NavigatorViewType viewType : allTypes) {
                    typeId = ((CustomNavigatorViewType)viewType).entityType.getId();
                    if (excludedTypeIds.contains(typeId) || forbiddenTypeIds.contains(typeId)) continue;
                    result.add(viewType);
                }
                return result;
            }
        });
        view.setCallbackOnCreate((vt, node) -> {
            CustomNavigatorViewType cvt = (CustomNavigatorViewType)vt;
            if (cvt.dataFactory != null) {
                ProxyPane pane = (ProxyPane)((Object)node);
                pane.setDataFactory(cvt.dataFactory::create);
            }
        });
        view.setCallbackOnDelete(node -> Dialog.confirm((Node)node, (String)Messages.Delete_system_setting, null, (String)Messages.Delete, () -> view.getViews().remove(node), null));
        this.controller = new NavigatorWidgetController<CompactNavigatorWidget>(){

            public CompactNavigatorWidget getView() {
                return view;
            }

            protected Object createItem(Node pane) {
                try {
                    EntityContainer ctr = new EntityContainer(((ProxyPane)pane).getEntityClass());
                    ProxyData result = new ProxyData(ctr.toReference());
                    result.ctr = ctr;
                    return result;
                }
                catch (Exception e) {
                    throw Xeption.forDeveloper((String)"failed getting class", (Throwable)e, (Object[])new Object[0]);
                }
            }

            protected ViewController<Node, Object> createController(Node pane) {
                return (ViewController)pane;
            }
        };
        view.getViews().addListener(change -> {
            while (change.next()) {
                if (!change.wasRemoved()) continue;
                for (Node pane : change.getRemoved()) {
                    this.deleted.add((ProxyData<?>)((ProxyPane)pane).getData());
                }
            }
        });
        this.getChildren().add((Object)this.controller.getView());
    }

    private void collectTypes(List<NavigatorViewType> types) {
        EntityType baseEtt = MetaRegistryHelper.getEntityType((String)BaseSystemSettings.class.getName());
        for (EntityType ett : MetaRegistryHelper.getRootEntities()) {
            if (baseEtt.getId().equals(ett.getId()) || ett.isAbstract() || ett.isHidden() || ScheduledTaskSettings.class.getName().equals(ett.getId()) || !MetaRegistryHelper.isAssignableFrom((EntityType)baseEtt, (EntityType)ett) || !AppConfigHelper.isInScope(ett) || "true".equals(ett.getParameters().get("hideInClientFX"))) continue;
            types.add(new CustomNavigatorViewType(ett));
        }
    }

    private void applyACL(List<NavigatorViewType> allTypes, List<String> forbiddenTypeIds) throws Exception {
        HashMap<String, AclQuery> map = new HashMap<String, AclQuery>();
        for (NavigatorViewType viewType : allTypes) {
            String typeId = ((CustomNavigatorViewType)viewType).entityType.getId();
            map.put(typeId, new AclQuery(StandardRestrictionResourceOperations.EDIT.getId(), typeId));
        }
        Set grantedIds = FxAclUtil.applyACL(map);
        forbiddenTypeIds.removeAll(grantedIds);
    }

    void loadData() throws Exception {
        ServiceInvocationContext sic = ServiceInvocationContext.get();
        EntityService entityService = (EntityService)RpcServiceManager.get().getService(EntityService.class);
        SearchQuery sq = new SearchQuery();
        sq.getCriteria().getCriterions().add(SearchCriterion.ne((String)BasicSystemSettingsIndex.Property.type.name(), (Object)SystemSettingsType.SCHEDULED_TASK_SETTINGS));
        sq.getPreferredProperties().add(BasicSystemSettingsIndex.Property.type.name());
        sq.getPreferredProperties().add(BasicSystemSettingsIndex.Property.name.name());
        List list = entityService.search(sic, BasicSystemSettingsIndex.class, sq);
        List data = list.stream().map(idx -> {
            ProxyData result = new ProxyData(idx.getSource());
            result.buildTitle(idx.getType(), idx.getName());
            return result;
        }).sorted((lhs, rhs) -> TextUtil.compare((String)lhs.getTitle(), (String)rhs.getTitle(), (boolean)true, (boolean)false)).collect(Collectors.toList());
        FxUtil.waitForFxThread(() -> this.controller.readData((Object)data));
        this.deleted.clear();
    }

    void saveData() throws Exception {
        ValueHolder changed = new ValueHolder();
        FxUtil.waitForFxThread(() -> changed.set((Object)this.controller.isDataChanged()));
        if (!((Boolean)changed.get()).booleanValue()) {
            this.loadData();
            return;
        }
        ArrayList newData = new ArrayList();
        FxUtil.waitForFxThread(() -> this.controller.writeData((Object)newData));
        for (ProxyData data : newData) {
            data.save();
        }
        if (!this.deleted.isEmpty()) {
            ServiceInvocationContext sic = ServiceInvocationContext.get();
            EntityService entityService = (EntityService)RpcServiceManager.get().getService(EntityService.class);
            for (ProxyData<?> info : this.deleted) {
                if (info.reference == null) continue;
                entityService.delete(sic, info.reference);
            }
            this.deleted.clear();
        }
        this.loadData();
    }

    boolean isDataChanged() {
        return this.controller.isDataChanged();
    }

    EntityReference<? extends BaseSystemSettings> getCurrentReference() {
        ProxyPane pp = (ProxyPane)((CompactNavigatorWidget)this.controller.getView()).getSelectedView();
        return pp == null ? null : ((ProxyData)pp.getData()).reference;
    }

    EntityContainer<? extends BaseSystemSettings> getCurrentContainer() {
        ProxyPane pp = (ProxyPane)((CompactNavigatorWidget)this.controller.getView()).getSelectedView();
        return pp == null ? null : ((ProxyData)pp.getData()).ctr;
    }

    void setNotEditable(boolean value) {
        this.controller.setNotEditable(value);
    }

    public DevToolItem asDevToolItem() {
        return new DevToolItem(){

            public Collection<?> getSubItems() {
                return Collections.singleton(((CompactNavigatorWidget)SystemSettingsFullPane.this.controller.getView()).getSelectedView());
            }

            public String getInfo() {
                return ((Object)((Object)SystemSettingsFullPane.this)).getClass().getSimpleName();
            }
        };
    }

    private class CustomNavigatorViewType
    implements NavigatorViewType {
        final EntityType entityType;
        SystemSettingsInstanceFactory.DataFactory dataFactory;

        CustomNavigatorViewType(EntityType ett) {
            this.entityType = ett;
        }

        CustomNavigatorViewType(EntityType ett, SystemSettingsInstanceFactory.DataFactory factory) {
            this.entityType = ett;
            this.dataFactory = factory;
        }

        public boolean isApplicableTo(Object item) {
            try {
                return ((ProxyData)item).reference.getType().getName().equals(this.entityType.getId());
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        public String getDisplayName() {
            return this.dataFactory != null ? this.dataFactory.getDisplayName() : this.entityType.getDisplayName();
        }

        public Consumer<Consumer<Object>> createConfiguratorForNewObject() {
            return null;
        }

        public Node createViewForNewObject(Object configuration) {
            return new ProxyPane(this.entityType, SystemSettingsFullPane.this.validationMessagesConsumer);
        }

        public Node createViewForExistingObject() {
            return new ProxyPane(this.entityType, SystemSettingsFullPane.this.validationMessagesConsumer);
        }
    }
}

