/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.tasks;

import com.gridnine.xtrip.client.fx.core.service.RootEntityEditingService;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.BaseRefundReceiptProperties;
import com.gridnine.xtrip.common.fx.rpc.BookingFileService;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.XCloneModelHelper;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceException;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrintManager;

public abstract class BaseRefundReceiptTask<T extends BaseRefundReceiptProperties>
extends ClientTask {
    protected final T properties;

    protected BaseRefundReceiptTask(T properties) {
        this.properties = properties;
    }

    protected void execute() throws Exception {
        try {
            ServiceInvocationContext sic = ServiceInvocationContext.get();
            BookingFileService.RefundReceiptRPCResult result = this.createRefundReceipts();
            EntityService entityService = (EntityService)RpcServiceManager.get().getService(EntityService.class);
            result.getDocuments().forEach(doc -> {
                EntityContainer docCont = new EntityContainer(Document.class);
                try {
                    XCloneModelHelper.copy((BaseEntity)doc, (BaseEntity)docCont.getEntity());
                }
                catch (Exception e) {
                    ErrorHandler.handle((Throwable)e);
                }
                try {
                    docCont.getVersionInfo().setDataSource("fx-refund-receipt-task");
                    entityService.save(sic, docCont, null, true);
                }
                catch (ServiceException e) {
                    ErrorHandler.handle((Throwable)e);
                }
                if (this.properties.isPrint()) {
                    try {
                        JasperPrintManager.printReport((InputStream)new ByteArrayInputStream(doc.getContent()), (boolean)true);
                    }
                    catch (JRException e) {
                        ErrorHandler.handle((Throwable)e);
                    }
                } else {
                    RootEntityEditingService.navigateTo((EntityReference)docCont.toReference());
                }
            });
            this.addMessages(result.getResultMessageList());
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
        }
    }

    protected String getTitle() {
        return Messages.Create_a_refund_receipt;
    }

    abstract BookingFileService.RefundReceiptRPCResult createRefundReceipts() throws Exception;
}

