/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.tasks;

import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.assets.ActivityItem;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.fx.rpc.service.AssetService;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceException;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class EntityDeleteTask
extends ClientTask {
    private final List<EntityReference<?>> items;

    public EntityDeleteTask(Collection<EntityReference<?>> itemsToDelete) {
        this.items = new ArrayList(itemsToDelete);
    }

    public EntityDeleteTask(EntityReference<?> ... itemsToDelete) {
        this.items = Arrays.asList(itemsToDelete);
    }

    protected String getTitle() {
        return Messages.Objects_deletion;
    }

    protected void execute() throws Exception {
        ServiceInvocationContext sic = ServiceInvocationContext.get();
        EntityService entityService = (EntityService)RpcServiceManager.get().getService(EntityService.class);
        float progress = 0.0f;
        float step = 100 / this.items.size();
        for (int i = 0; i < this.items.size(); ++i) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            EntityReference<?> item2 = this.items.get(i);
            try {
                String user = sic.getUser();
                Set<String> owners = this.getLockOwners(sic, item2);
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException();
                }
                if (owners.isEmpty() || owners.size() == 1 && owners.contains(user)) {
                    entityService.delete(sic, item2);
                    this.addMessages(new Message[]{SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.Object_deleted, (Object[])new Object[]{item2.getCaption()})});
                } else {
                    this.addMessages(new Message[]{SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.Cannot_delete, (Object[])new Object[]{item2.getCaption(), owners.toString()})});
                }
            }
            catch (ServiceException ex) {
                this.addMessages(new Message[]{SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.Error_delete, (Throwable)ex, (Object[])new Object[]{item2.getCaption()})});
            }
            this.setProgress((byte)(progress += step), "");
        }
        EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, (Collection)this.items.stream().map(item -> new EntityModification(item, EntityModification.ModificationType.DELETE)).collect(Collectors.toList())));
    }

    Set<String> getLockOwners(ServiceInvocationContext sic, EntityReference<? extends BaseEntity> ref) throws Exception {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.like((String)ActivityItem.Property.lockToken.name(), (String)('%' + ref.getUid() + '%')));
        query.getPreferredProperties().add(ActivityItem.Property.owner.name());
        AssetService assetService = (AssetService)RpcServiceManager.get().getService(AssetService.class);
        List lockedItems = assetService.search(sic, ActivityItem.class, query).getData();
        HashSet<String> result = new HashSet<String>();
        for (ActivityItem item : lockedItems) {
            if (item.getOwner() == null) continue;
            result.add(item.getOwner());
        }
        return result;
    }
}

