/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.tasks;

import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.archive.ArchivedBooking;
import com.gridnine.xtrip.common.model.rpc.ModelService;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class EntityUnArchiveTask
extends ClientTask {
    private final List<EntityReference<ArchivedBooking>> items;

    public EntityUnArchiveTask(List<EntityReference<ArchivedBooking>> itemsToUnArchive) {
        this.items = new ArrayList<EntityReference<ArchivedBooking>>(itemsToUnArchive);
    }

    protected String getTitle() {
        return Messages.unarchive_items;
    }

    protected void execute() throws Exception {
        ServiceInvocationContext sic = ServiceInvocationContext.get();
        ModelService service = (ModelService)RpcServiceManager.get().getService(ModelService.class);
        float progress = 0.0f;
        float step = 100 / this.items.size();
        for (int i = 0; i < this.items.size(); ++i) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            EntityReference<ArchivedBooking> item2 = this.items.get(i);
            this.addMessages(service.unArchiveBooking(sic, item2));
            this.setProgress((byte)(progress += step), "");
        }
        EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, (Collection)this.items.stream().map(item -> new EntityModification(item, EntityModification.ModificationType.DELETE)).collect(Collectors.toList())));
    }
}

