/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.tasks;

import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.service.IntegrationBusRpcService;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.profile.IbusReplaceDetailsContextKey;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationReplaceDetailsType;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.CollectionUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class OrganizationReplaceDetailsListTask
extends ClientTask {
    private final List<EntityReference<Organization>> organizations;
    private final Map<OrganizationReplaceDetailsType, Object> values;

    public OrganizationReplaceDetailsListTask(List<EntityReference<Organization>> organizations, Map<OrganizationReplaceDetailsType, Object> values) {
        this.organizations = (List)CollectionUtil.requireNonEmpty(organizations, (String)"organizations not selected");
        this.values = CollectionUtil.requireNonEmpty(values, (String)"values not selected");
    }

    protected void execute() throws Exception {
        try {
            for (int i = 0; i < this.organizations.size(); ++i) {
                EntityReference<Organization> organization2 = this.organizations.get(i);
                Thread.sleep(1L);
                this.setProgress((byte)(100 * i / this.organizations.size()), L10n.replace((String)Messages.ProcessingOrganization, (Object[])new Object[]{organization2}));
                this.addMessages(this.processOrganization(organization2));
            }
        }
        finally {
            EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, (Collection)this.organizations.stream().map(organization -> new EntityModification(organization, EntityModification.ModificationType.CHANGE)).collect(Collectors.toList())));
        }
    }

    protected String getTitle() {
        return Messages.Change_of_requisites;
    }

    private List<Message> processOrganization(EntityReference<Organization> organization) throws Exception {
        HashMap<String, Object> ibusContext = new HashMap<String, Object>();
        ibusContext.put(IbusReplaceDetailsContextKey.ORGANIZATION_REFERENCE.name(), organization);
        ibusContext.put(IbusReplaceDetailsContextKey.VALUES.name(), this.values);
        Set<String> returnValues = Collections.singleton(IbusReplaceDetailsContextKey.MESSAGES.name());
        Map ibusResult = ((IntegrationBusRpcService)RpcServiceManager.get().getService(IntegrationBusRpcService.class)).processRouteSync(ServiceInvocationContext.get(), "replace-details:replace-details-organization", ibusContext, returnValues);
        List messages = (List)ibusResult.get(IbusReplaceDetailsContextKey.MESSAGES.name());
        Objects.requireNonNull(messages, "Messages wasn't returned from server");
        return messages;
    }
}

