/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.tasks.dialog;

import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.BooleanValueWidget;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAirPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductEMDPanel;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.tasks.AirItineraryReceiptTask;
import com.gridnine.xtrip.client.fx.standard.tasks.dialog.BaseItineraryReceiptDialog;
import com.gridnine.xtrip.common.fx.rpc.AirItineraryReceiptProperties;
import com.gridnine.xtrip.common.fx.rpc.BookingFileService;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.AirItineraryReceiptData;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductIndex;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.system.TemplateDocument;
import com.gridnine.xtrip.common.model.system.TemplateDocumentIndex;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AirItineraryReceiptDialog
extends BaseItineraryReceiptDialog<AirItineraryReceiptProperties> {
    private BooleanValueWidget useCyrillicForTravelerName;
    private BooleanValueWidget includePayer;
    private BooleanValueWidget includeVat;
    private BooleanValueWidget includeAgencyFees;
    private BooleanValueWidget includeAgencyFeesIntoTaxes;
    private BooleanValueWidget includeVendorFees;
    private BooleanValueWidget includeVendorFeesIntoTaxes;
    private BooleanValueWidget showTaxesSum;
    private BooleanValueWidget ITTariff;
    private BooleanValueWidget includeLogo;
    private BooleanValueWidget includeVatDetalization;
    private BooleanValueWidget hidePassport;
    private static final Logger log = LoggerFactory.getLogger(AirItineraryReceiptDialog.class);

    private boolean isIncludePayer() {
        return this.includePayer.getValue();
    }

    private boolean isIncludeVat() {
        return this.includeVat.getValue();
    }

    private boolean isShowTaxesSum() {
        return this.showTaxesSum.getValue();
    }

    private boolean isIncludeVatDetalization() {
        return this.includeVatDetalization.getValue();
    }

    private boolean isITTariff() {
        return this.ITTariff.getValue();
    }

    private boolean isIncludeLogo() {
        return this.includeLogo.getValue();
    }

    private boolean isIncludeAgencyFees() {
        return this.includeAgencyFees.getValue();
    }

    private boolean isIncludeAgencyFeesIntoTaxes() {
        return this.includeAgencyFeesIntoTaxes.getValue();
    }

    private boolean isIncludeVendorFees() {
        return this.includeVendorFees.getValue();
    }

    private boolean isIncludeVendorFeesIntoTaxes() {
        return this.includeVendorFeesIntoTaxes.getValue();
    }

    private boolean getUseCyrillicForTravelerName() {
        return this.useCyrillicForTravelerName.getValue();
    }

    public boolean isHidePassport() {
        return this.hidePassport.getValue();
    }

    @Override
    public List<GridCell<?>> createAdditionalPropertiesCells() {
        return Arrays.asList(new GridCell(Messages.Use_Cyrillic_for_the_travelers_name, (Node)this.useCyrillicForTravelerName), new GridCell(Messages.Include_payer, (Node)this.includePayer), new GridCell(Messages.Include_VAT, (Node)this.includeVat), new GridCell(Messages.Include_agency_fees, (Node)this.includeAgencyFees), new GridCell(Messages.Include_agency_fees_in_taxes, (Node)this.includeAgencyFeesIntoTaxes), new GridCell(Messages.Include_vendor_fees, (Node)this.includeVendorFees), new GridCell(Messages.Include_vendor_fees_in_taxes, (Node)this.includeVendorFeesIntoTaxes), new GridCell(Messages.Show_taxes_sum, (Node)this.showTaxesSum), new GridCell(Messages.Show_details_of_VAT_INN_KPP, (Node)this.includeVatDetalization), new GridCell(Messages.Include_logo, (Node)this.includeLogo), new GridCell(Messages.IT_Tariff, (Node)this.ITTariff), new GridCell(Messages.Hide_Passport, (Node)this.hidePassport));
    }

    @Override
    public AirItineraryReceiptProperties createProperties(Map<BaseProduct, EntityReference<BookingFile>> products2Bookings) {
        AirItineraryReceiptData receiptData = AirItineraryReceiptDialog.getAirItineraryReceiptData(products2Bookings);
        if (receiptData != null) {
            return new AirItineraryReceiptProperties(receiptData.isUseCyrillicForTravelerName(), receiptData.isIncludePayer(), receiptData.isIncludeVat(), receiptData.isIncludeAgencyFees(), receiptData.isIncludeAgencyFeesIntoTaxes(), receiptData.isIncludeVendorFees(), receiptData.isIncludeVendorFeesIntoTaxes(), receiptData.isShowTaxesSum(), receiptData.isIncludeVatDetalization(), receiptData.isIncludeLogo(), receiptData.isITTariff(), receiptData.isHidePassport(), this.getProducts2Bookings(), this.getProducts2Templates(products2Bookings), receiptData.getNotes());
        }
        return null;
    }

    @Override
    public AirItineraryReceiptProperties createEmptyProperties() {
        return new AirItineraryReceiptProperties();
    }

    @Override
    public AirItineraryReceiptProperties createAndFillProperties() {
        return new AirItineraryReceiptProperties(this.getUseCyrillicForTravelerName(), this.isIncludePayer(), this.isIncludeVat(), this.isIncludeAgencyFees(), this.isIncludeAgencyFeesIntoTaxes(), this.isIncludeVendorFees(), this.isIncludeVendorFeesIntoTaxes(), this.isShowTaxesSum(), this.isIncludeVatDetalization(), this.isIncludeLogo(), this.isITTariff(), this.isHidePassport(), this.getProducts2Bookings(), this.getProducts2Templates(), this.getInformationNotes());
    }

    @Override
    public void createAdditionalWidgets() {
        this.useCyrillicForTravelerName = new BooleanValueWidget(false, false);
        this.includePayer = new BooleanValueWidget(false, false);
        this.includeVat = new BooleanValueWidget(false, false);
        this.includeVat.setValue(true);
        this.includeAgencyFees = new BooleanValueWidget(false, false);
        this.includeAgencyFees.setValue(true);
        this.includeAgencyFeesIntoTaxes = new BooleanValueWidget(false, false);
        this.includeVendorFees = new BooleanValueWidget(false, false);
        this.includeVendorFees.setValue(true);
        this.includeVendorFeesIntoTaxes = new BooleanValueWidget(false, false);
        this.showTaxesSum = new BooleanValueWidget(false, false);
        this.includeVatDetalization = new BooleanValueWidget(false, false);
        this.includeLogo = new BooleanValueWidget(false, false);
        this.ITTariff = new BooleanValueWidget(false, false);
        this.hidePassport = new BooleanValueWidget(false, false);
    }

    @Override
    public void updateFromProperties(AirItineraryReceiptProperties properties) {
        this.includeLogo.setValue(properties.isIncludeLogo());
        this.includeAgencyFees.setValue(properties.isIncludeAgencyFees());
        this.includeAgencyFeesIntoTaxes.setValue(properties.isIncludeAgencyFeesIntoTaxes());
        this.includeVendorFees.setValue(properties.isIncludeVendorFees());
        this.includeVendorFeesIntoTaxes.setValue(properties.isIncludeVendorFeesIntoTaxes());
        this.showTaxesSum.setValue(properties.isShowTaxesSum());
        this.useCyrillicForTravelerName.setValue(properties.isUseCyrilicForTravelerName());
        this.includePayer.setValue(properties.isIncludePayer());
        this.includeVatDetalization.setValue(properties.isIncludeVatDetalization());
        this.includeVat.setValue(properties.isIncludeVat());
        this.ITTariff.setValue(properties.isITTariff());
        this.hidePassport.setValue(properties.isHidePassport());
    }

    @Override
    public IndexListParameters<TemplateDocument, TemplateDocumentIndex> getTemplateParameters() {
        return ControllerInterceptorsHelper.getItineraryTemplates();
    }

    public AirItineraryReceiptTask createTask(AirItineraryReceiptProperties properties) {
        return new AirItineraryReceiptTask(properties);
    }

    @Override
    public String getPropertiesFileName() {
        return "itinerary-receipt.xml";
    }

    @Override
    public List<Class<? extends Pane>> getPaneClassList() {
        return Arrays.asList(BookingFileProductAirPanel.class, BookingFileProductEMDPanel.class);
    }

    public Class<ProductIndex> getProductIndexClass() {
        return ProductIndex.class;
    }

    public Class<Product> getProductClass() {
        return Product.class;
    }

    @Override
    protected Map<String, Collection<EntityReference<TemplateDocument>>> getProducts2Templates(Map<BaseProduct, EntityReference<BookingFile>> products2Bookings) {
        HashMap<String, Collection<EntityReference<TemplateDocument>>> productUids2TemplateRefs = new HashMap<String, Collection<EntityReference<TemplateDocument>>>();
        for (Map.Entry<BaseProduct, EntityReference<BookingFile>> entry : products2Bookings.entrySet()) {
            if (!(entry.getKey() instanceof Product)) continue;
            NestedEntityReference productReference = new NestedEntityReference(entry.getValue(), (BaseEntity)((Product)entry.getKey()));
            try {
                List templateDocuments = ((BookingFileService)RpcServiceManager.get().getService(BookingFileService.class)).getAirItineraryReceiptData(ServiceInvocationContext.get(), productReference).getTemplates();
                productUids2TemplateRefs.put(entry.getKey().getUid(), templateDocuments);
            }
            catch (Exception e) {
                log.warn("unable to get TemplateDocument", (Throwable)e);
                productUids2TemplateRefs.put(entry.getKey().getUid(), null);
            }
        }
        return productUids2TemplateRefs;
    }

    private static AirItineraryReceiptData getAirItineraryReceiptData(Map<BaseProduct, EntityReference<BookingFile>> products2Bookings) {
        for (Map.Entry<BaseProduct, EntityReference<BookingFile>> entry : products2Bookings.entrySet()) {
            if (!(entry.getKey() instanceof Product)) continue;
            NestedEntityReference productReference = new NestedEntityReference(entry.getValue(), (BaseEntity)((Product)entry.getKey()));
            try {
                return ((BookingFileService)RpcServiceManager.get().getService(BookingFileService.class)).getAirItineraryReceiptData(ServiceInvocationContext.get(), productReference);
            }
            catch (Exception e) {
                log.error("unable to get AirItineraryReceiptData", (Throwable)e);
                return null;
            }
        }
        return null;
    }
}

