/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.tasks.dialog;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.dicts.DictListParameters;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.CardsContainer;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.PriceValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableRowEvent;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.ComboBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.PriceValueWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.TextWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.dialog.CurrencyValueWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.dialog.DictBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.registry.basic.Renderer;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.tasks.ProductExchangeTask;
import com.gridnine.xtrip.client.fx.standard.tasks.dialog.BaseAirProductExchangeRefundDialog;
import com.gridnine.xtrip.client.fx.standard.tasks.dialog.ExchangeEMDDialogVM;
import com.gridnine.xtrip.client.fx.standard.tasks.dialog.ExchangeTaxDialogVM;
import com.gridnine.xtrip.common.fx.rpc.DictQuery;
import com.gridnine.xtrip.common.fx.rpc.ProductExchangeRefundProperties;
import com.gridnine.xtrip.common.meta.ui.UiCardsContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.ReflectionUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;

public class AirProductExchangeDialog
extends BaseAirProductExchangeRefundDialog {
    private final RootEntityPane<BookingFile, ?> rootPane;
    private final Node source;
    private final EntityReference<BookingFile> bookingFileReference;
    private final TableWidget<ExchangeEMDDialogVM> emdsWidget;
    private TableWidgetController<TableWidget<ExchangeEMDDialogVM>, ExchangeEMDDialogVM> emdsController;
    private final PriceValueWidget baseFareAdditionWidget;
    private final PriceValueWidget equivFareAdditionWidget;
    private final PriceValueWidget totalSurchargeWidget;
    private final TableWidget<ExchangeTaxDialogVM> taxesAdditionWidget;
    private TableWidgetController<TableWidget<ExchangeTaxDialogVM>, ExchangeTaxDialogVM> taxesAdditionController;
    private final BigDecimal originalTaxesAmount;

    public AirProductExchangeDialog(Node source, EntityReference<BookingFile> bookingFileReference, Product product, Map<Integer, MiscUtil.Pair<String, String>> segmentsPoints) {
        this(null, source, bookingFileReference, product, segmentsPoints);
    }

    public AirProductExchangeDialog(RootEntityPane<BookingFile, ?> rootPane, Product product, Map<Integer, MiscUtil.Pair<String, String>> segmentsPoints) {
        this(rootPane, (Node)rootPane, null, product, segmentsPoints);
    }

    public AirProductExchangeDialog(RootEntityPane<BookingFile, ?> rootPane, Node source, EntityReference<BookingFile> bookingFileReference, Product product, Map<Integer, MiscUtil.Pair<String, String>> segmentsPoints) {
        super(product, segmentsPoints);
        this.rootPane = rootPane;
        this.source = source;
        this.bookingFileReference = bookingFileReference;
        this.originalTaxesAmount = product.getTaxes().stream().filter(Objects::nonNull).map(Tax::getEquivalentAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        EntityReference blankOwnerRef = product.getBlankOwnerRef();
        this.emdsWidget = this.createEmdsWidget((EntityReference<Organization>)blankOwnerRef);
        this.emdsController = new TableWidgetController<TableWidget<ExchangeEMDDialogVM>, ExchangeEMDDialogVM>(){

            public TableWidget<ExchangeEMDDialogVM> getView() {
                return AirProductExchangeDialog.this.emdsWidget;
            }
        };
        this.baseFareAdditionWidget = new PriceValueWidget(false);
        this.equivFareAdditionWidget = new PriceValueWidget(false);
        this.taxesAdditionWidget = this.createTaxesWidget(false);
        this.taxesAdditionWidget.setControlButtonsAvailability(ControlsPane.ADD_REMOVE);
        this.taxesAdditionWidget.setItemsProvider(() -> new ExchangeTaxDialogVM(new Tax(), true));
        this.totalSurchargeWidget = new PriceValueWidget(true);
        this.taxesAdditionController = new TableWidgetController<TableWidget<ExchangeTaxDialogVM>, ExchangeTaxDialogVM>(){

            public TableWidget<ExchangeTaxDialogVM> getView() {
                return AirProductExchangeDialog.this.taxesAdditionWidget;
            }
        };
        this.taxesAdditionController.readData((Collection)product.getTaxes().stream().map(tax -> new ExchangeTaxDialogVM((Tax)tax, true)).collect(Collectors.toList()));
    }

    @Override
    protected String getCheckedColumnTitle() {
        return Messages.Accept_for_exchange;
    }

    private TableWidget<ExchangeEMDDialogVM> createEmdsWidget(EntityReference<Organization> blankOwnerRef) {
        TableWidget widget = new TableWidget(false);
        widget.setControlButtonsAvailability(ControlsPane.ADD_REMOVE);
        ArrayList<Object> columns = new ArrayList<Object>();
        TextWidgetColumn column = new TextWidgetColumn(ExchangeEMDDialogVM::getNumber, ExchangeEMDDialogVM::setNumber);
        column.setId("number");
        column.setCaption(Messages.Number);
        columns.add(column);
        column = new PriceValueWidgetColumn(ExchangeEMDDialogVM::getBaseAmount, ExchangeEMDDialogVM::setBaseAmount);
        column.setPrefWidth(Double.valueOf(20.0));
        column.setId("baseAmount");
        column.setCaption(Messages.Amount);
        columns.add(column);
        column = new CurrencyValueWidgetColumn(ExchangeEMDDialogVM::getCurrency, ExchangeEMDDialogVM::setCurrency);
        column.setPrefWidth(Double.valueOf(10.0));
        column.setId("currency");
        column.setCaption(Messages.Currency);
        columns.add(column);
        column = new PriceValueWidgetColumn(ExchangeEMDDialogVM::getEquivAmount, ExchangeEMDDialogVM::setEquivAmount);
        column.setPrefWidth(Double.valueOf(20.0));
        column.setId("equivAmount");
        column.setCaption(Messages.Equ_amount);
        columns.add(column);
        column = new ComboBoxWidgetColumn(ExchangeEMDDialogVM::getCategory, ExchangeEMDDialogVM::setCategory);
        column.setItemsSupplier(() -> Arrays.asList(MCOCategory.ADDITIONAL_TARIFF, MCOCategory.REBOOKING));
        column.setPrefWidth(Double.valueOf(20.0));
        column.setId("category");
        column.setCaption(Messages.Category);
        columns.add(column);
        DictBoxWidgetColumn dictBoxWidgetColumn = new DictBoxWidgetColumn(BlankType.class, exchangeEMDDialogVM -> exchangeEMDDialogVM == null ? null : ReflectionUtil.getValue(exchangeEMDDialogVM.getClass(), (Object)exchangeEMDDialogVM, (String)"blankTypeRef"), (exchangeEMDDialogVM, blankTypeRef) -> ReflectionUtil.setValue(exchangeEMDDialogVM.getClass(), (Object)exchangeEMDDialogVM, (String)"blankTypeRef", (Object)blankTypeRef));
        dictBoxWidgetColumn.setCaption(Messages.Type_of_blank);
        dictBoxWidgetColumn.setListParametersSupplier(() -> {
            DictListParameters dictListParameters = new DictListParameters();
            TableColumnSettings blankType = new TableColumnSettings();
            blankType.setId(BaseDictionary.Property.code.name());
            blankType.setDisplayName(Messages.Type_of_blank);
            blankType.setRenderer((Renderer)StandardRenderers.DICT_CODE);
            dictListParameters.getColumns().add(blankType);
            dictListParameters.getFilters().add(blankType);
            if (blankOwnerRef != null) {
                dictListParameters.getSearchCriterions().add(new DictQuery.SearchCriterion(BlankType.Property.blankOwner.name(), new Object[]{blankOwnerRef}));
            }
            dictListParameters.getSearchCriterions().add(new DictQuery.SearchCriterion(BlankType.Property.productCategory.name(), new Object[]{ProductCategory.MCO}));
            return dictListParameters;
        });
        columns.add(dictBoxWidgetColumn);
        widget.setColumns(columns);
        widget.setItemsProvider(() -> new ExchangeEMDDialogVM());
        return widget;
    }

    public void showDialog() {
        GridContainer taxesContainer = new GridContainer();
        taxesContainer.getCells().add((Object)new GridCell("", (Node)this.taxesWidget));
        GridContainer taxesAdditionContainer = new GridContainer();
        taxesAdditionContainer.getCells().add((Object)new GridCell("", this.taxesAdditionWidget));
        GridContainer totalSurchargeContainer = new GridContainer();
        totalSurchargeContainer.getCells().add((Object)new GridCell("", (Node)this.totalSurchargeWidget));
        GridContainer emdsContainer = new GridContainer();
        emdsContainer.getCells().add((Object)new GridCell("", this.emdsWidget));
        CardsContainer cardsContainer = this.createBaseParametersCard(true);
        cardsContainer.getCards().add((Object)new Card("retention", UiCardsContainer.Style.COLLAPSED, Messages.AirProduct_Retentions, (Node)this.createProductRetentionContainer()));
        cardsContainer.getCards().add((Object)new Card("taxes", UiCardsContainer.Style.COLLAPSED, Messages.Tax_Retentions, (Node)taxesContainer));
        cardsContainer.getCards().add((Object)new Card("addition", UiCardsContainer.Style.STATIC, Messages.AirProduct_Addition, (Node)this.createProductAdditionContainer()));
        cardsContainer.getCards().add((Object)new Card("taxesAddition", UiCardsContainer.Style.EXPANDED, Messages.Tax_Addition, (Node)taxesAdditionContainer));
        cardsContainer.getCards().add((Object)new Card("totalSurcharge", UiCardsContainer.Style.STATIC, Messages.Total_Surcharge, (Node)totalSurchargeContainer));
        FxUtil.addListener((ObservableValue)this.usedEquivFareWidget.valueProperty(), (s, o, n) -> this.updateTotalSurcharge());
        FxUtil.addListener((ObservableValue)this.equivFareAdditionWidget.valueProperty(), (s, o, n) -> this.updateTotalSurcharge());
        FxUtil.addListener((ObservableValue)this.penaltyWidget.valueProperty(), (s, o, n) -> this.updateTotalSurcharge());
        this.addTaxesEqAmountListener((TableWidget<ExchangeTaxDialogVM>)this.taxesWidget);
        this.addTaxesEqAmountListener(this.taxesAdditionWidget);
        cardsContainer.getCards().add((Object)new Card("emds", UiCardsContainer.Style.STATIC, "EMD", (Node)emdsContainer));
        Dialog dialog = new Dialog();
        dialog.setTitle(Messages.Air_ticket_exchange).setAutoClose(false).setExpandToParent().setBody((Node)cardsContainer).addButton(DialogButtonStyle.DECLINE, () -> ((Dialog)dialog).close()).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Exchange, () -> {
            List<String> segmentDescriptions = this.getSegmentDescriptions();
            if (segmentDescriptions.size() == 0 && this.product.getMcoCategory() != MCOCategory.VOUCHER) {
                Dialog.info((String)Messages.One_segment);
                return;
            }
            ProductExchangeRefundProperties props = new ProductExchangeRefundProperties(this.getOperationDate(), this.getAgent(), this.getMcoCategory(), this.isForced(), this.getUsedBaseFare(), this.getUsedEquivFare(), this.getBaseFareAddition(), this.getEquivFareAddition(), this.getPenalty(), segmentDescriptions, this.getTaxes(), this.getTaxesAddition(), this.getEmds());
            ProductExchangeTask task = this.rootPane != null ? new ProductExchangeTask(this.product.getUid(), props, this.rootPane) : new ProductExchangeTask(this.product.getUid(), props, this.bookingFileReference);
            Notifications.get().enqueueAsyncTask((ClientTask)task);
            dialog.close();
        }).setOnCloseRequest(() -> ((Dialog)dialog).close()).show(this.source);
    }

    private void addTaxesEqAmountListener(TableWidget<ExchangeTaxDialogVM> taxesTableWidget) {
        PriceValueWidgetColumn column = (PriceValueWidgetColumn)taxesTableWidget.getColumn("equivAmount");
        for (int row = 0; row < taxesTableWidget.getRowsCount(); ++row) {
            PriceValueWidget widget = (PriceValueWidget)column.getWidget(row);
            FxUtil.addListener((ObservableValue)widget.valueProperty(), (s, o, n) -> this.updateTotalSurcharge());
        }
        taxesTableWidget.setOnRowsAction(event -> {
            if (event.getEventType() == TableRowEvent.ROW_ADD) {
                PriceValueWidget widget = (PriceValueWidget)column.getWidget(event.getRowIndex().intValue());
                FxUtil.addListener((ObservableValue)widget.valueProperty(), (s, o, n) -> this.updateTotalSurcharge());
            }
            if (event.getEventType() == TableRowEvent.ROW_REMOVE) {
                this.updateTotalSurcharge();
            }
        });
    }

    private void updateTotalSurcharge() {
        BigDecimal taxesAmount = this.taxesWidget.getRowsData().stream().filter(Objects::nonNull).map(ExchangeTaxDialogVM::getEquivAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal taxesSubtraction = this.originalTaxesAmount.subtract(taxesAmount);
        BigDecimal taxesAdditionAmount = this.taxesAdditionWidget.getRowsData().stream().filter(Objects::nonNull).map(ExchangeTaxDialogVM::getEquivAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        this.totalSurchargeWidget.setValue((Number)MiscUtil.sum((BigDecimal[])new BigDecimal[]{(BigDecimal)this.usedEquivFareWidget.getValue(), (BigDecimal)this.equivFareAdditionWidget.getValue(), (BigDecimal)this.penaltyWidget.getValue(), taxesSubtraction, taxesAdditionAmount}));
    }

    private List<ProductExchangeRefundProperties.ExchangeRefundEMD> getEmds() {
        ArrayList emds = new ArrayList();
        this.emdsController.writeData(emds);
        List<ProductExchangeRefundProperties.ExchangeRefundEMD> res = emds.stream().map(emd -> {
            ProductExchangeRefundProperties.ExchangeRefundEMD exchangeRefundEMD = new ProductExchangeRefundProperties.ExchangeRefundEMD(emd.getNumber(), emd.getBaseAmount(), emd.getCurrency(), emd.getEquivAmount(), emd.getCategory(), emd.getBlankTypeRef());
            return exchangeRefundEMD;
        }).collect(Collectors.toList());
        return res;
    }

    private GridContainer createProductRetentionContainer() {
        GridContainer gridContainer = new GridContainer(3);
        ArrayList<GridCell> cells = new ArrayList<GridCell>();
        GridCell cell = new GridCell(Messages.Basic_Rate_Retention, (Node)this.usedBaseFareWidget);
        cells.add(cell);
        cell = new GridCell(Messages.Retention_at_the_equivalent_tariff, (Node)this.usedEquivFareWidget);
        cells.add(cell);
        gridContainer.getCells().addAll(cells);
        return gridContainer;
    }

    private GridContainer createProductAdditionContainer() {
        GridContainer gridContainer = new GridContainer(3);
        ArrayList<GridCell> cells = new ArrayList<GridCell>();
        GridCell cell = new GridCell(Messages.Basic_Rate_Addition, (Node)this.baseFareAdditionWidget);
        cells.add(cell);
        cell = new GridCell(Messages.Addition_at_the_equivalent_tariff, (Node)this.equivFareAdditionWidget);
        cells.add(cell);
        cell = new GridCell(Messages.Fine, (Node)this.penaltyWidget);
        cells.add(cell);
        gridContainer.getCells().addAll(cells);
        return gridContainer;
    }

    protected BigDecimal getBaseFareAddition() {
        return (BigDecimal)this.baseFareAdditionWidget.getValue();
    }

    protected BigDecimal getEquivFareAddition() {
        return (BigDecimal)this.equivFareAdditionWidget.getValue();
    }

    protected List<Tax> getTaxesAddition() {
        return this.getTaxes(this.taxesAdditionController);
    }
}

