/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.tasks.dialog;

import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.CardsContainer;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.CheckBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.DateTimeValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.IntValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.PriceValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.Suppliers;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.BooleanValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableRowEvent;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.BooleanValueWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.InfoWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.IntValueWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.PriceValueWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.TextWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.dialog.CurrencyValueWidgetColumn;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.client.fx.standard.tasks.dialog.ExchangeSegmentDialogVM;
import com.gridnine.xtrip.client.fx.standard.tasks.dialog.ExchangeTaxDialogVM;
import com.gridnine.xtrip.common.meta.ui.UiCardsContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.scene.Node;

public abstract class BaseAirProductExchangeRefundDialog {
    protected final Product product;
    private final DateTimeValueWidget operationDateWidget;
    private final EntityBoxWidget<Person> agentWidget;
    private final ComboBoxWidget<MCOCategory> mcoCategoryWidget;
    private final CheckBoxWidget forcedWidget;
    protected final PriceValueWidget usedBaseFareWidget;
    protected final PriceValueWidget usedEquivFareWidget;
    protected final PriceValueWidget penaltyWidget;
    private final TableWidget<ExchangeSegmentDialogVM> segmentsWidget;
    private TableWidgetController<TableWidget<ExchangeSegmentDialogVM>, ExchangeSegmentDialogVM> segmentsController;
    protected final String TAXES_COLUMN_EQUIV_AMOUNT = "equivAmount";
    protected final TableWidget<ExchangeTaxDialogVM> taxesWidget;
    private TableWidgetController<TableWidget<ExchangeTaxDialogVM>, ExchangeTaxDialogVM> taxesController;

    public BaseAirProductExchangeRefundDialog(Product product, Map<Integer, MiscUtil.Pair<String, String>> segmentsPoints) {
        this.product = product;
        this.operationDateWidget = new DateTimeValueWidget(false);
        this.operationDateWidget.setValue(DateUtils.asLocalDateTime((Date)new Date()));
        this.agentWidget = new EntityBoxWidget(Person.class, false);
        this.agentWidget.setListParametersSupplier(ControllerInterceptorsHelper::getEmployees);
        this.agentWidget.setValue(Prefetched.getData().getCurrentAgentData().getAgent());
        this.mcoCategoryWidget = new ComboBoxWidget(false);
        this.mcoCategoryWidget.setItemsSupplier(Suppliers.createEnumSupplier(MCOCategory.class, mco -> mco != MCOCategory.VOUCHER));
        this.forcedWidget = new CheckBoxWidget(false);
        this.forcedWidget.setText(Messages.Compelled);
        this.usedBaseFareWidget = new PriceValueWidget(false);
        this.usedEquivFareWidget = new PriceValueWidget(false);
        this.penaltyWidget = new PriceValueWidget(false);
        this.segmentsWidget = this.createSegmentsWidget();
        this.taxesWidget = this.createTaxesWidget(true);
        this.segmentsController = new TableWidgetController<TableWidget<ExchangeSegmentDialogVM>, ExchangeSegmentDialogVM>(){

            public TableWidget<ExchangeSegmentDialogVM> getView() {
                return BaseAirProductExchangeRefundDialog.this.segmentsWidget;
            }
        };
        this.taxesController = new TableWidgetController<TableWidget<ExchangeTaxDialogVM>, ExchangeTaxDialogVM>(){

            public TableWidget<ExchangeTaxDialogVM> getView() {
                return BaseAirProductExchangeRefundDialog.this.taxesWidget;
            }
        };
        ((TableWidget)this.segmentsController.getView()).setOnRowsAction(event -> {
            if (TableRowEvent.ROW_ADD.equals(event.getEventType())) {
                int idx = event.getRowIndex();
                Integer segNumber = (Integer)((IntValueWidget)((TableWidget)this.segmentsController.getView()).getColumn("recordNumber").getHiddenWidget(idx)).getValue();
                BooleanValueWidgetColumn column = (BooleanValueWidgetColumn)((TableWidget)this.segmentsController.getView()).getColumn("inAction");
                ((BooleanValueWidget)column.getHiddenWidget(idx)).valueProperty().addListener((obj, oldValue, newValue) -> this.updateTaxesSelection(segNumber, (boolean)newValue));
            }
        });
        this.forcedWidget.selectedProperty().addListener((obj, oldValue, newValue) -> this.updateTaxesSelectionWithForced((boolean)newValue));
        this.segmentsController.readData((Collection)product.getSegmentTariffs().stream().flatMap(st -> st.getSegments().stream()).map(seg -> new ExchangeSegmentDialogVM((Segment)seg, segmentsPoints)).collect(Collectors.toList()));
        this.taxesController.readData((Collection)product.getTaxes().stream().map(tax -> new ExchangeTaxDialogVM((Tax)tax, false)).collect(Collectors.toList()));
    }

    protected abstract String getCheckedColumnTitle();

    private GridContainer createGeneralParamsContainer(boolean forExchange) {
        GridContainer gridContainer = new GridContainer(forExchange ? 4 : 3);
        ArrayList<GridCell> cells = new ArrayList<GridCell>();
        GridCell cell = new GridCell(Messages.Date_of_operation, (Node)this.operationDateWidget);
        cells.add(cell);
        cell = new GridCell(Messages.Dimension_agent, this.agentWidget);
        cells.add(cell);
        if (forExchange) {
            cell = new GridCell(Messages.Category_MSO, this.mcoCategoryWidget);
            cells.add(cell);
        }
        cell = new GridCell("", (Node)this.forcedWidget);
        cells.add(cell);
        if (!forExchange) {
            cell = new GridCell(Messages.Basic_Rate_Retention, (Node)this.usedBaseFareWidget);
            cells.add(cell);
            cell = new GridCell(Messages.Retention_at_the_equivalent_tariff, (Node)this.usedEquivFareWidget);
            cells.add(cell);
            cell = new GridCell(Messages.Fine, (Node)this.penaltyWidget);
            cells.add(cell);
        }
        gridContainer.getCells().addAll(cells);
        return gridContainer;
    }

    protected CardsContainer createBaseParametersCard(boolean forExchange) {
        GridContainer segmentsContainer = new GridContainer();
        segmentsContainer.getCells().add((Object)new GridCell("", this.segmentsWidget));
        CardsContainer cardsContainer = new CardsContainer();
        cardsContainer.getCards().add((Object)new Card("parameters", UiCardsContainer.Style.STATIC, Messages.Sharing_Options, (Node)this.createGeneralParamsContainer(forExchange)));
        cardsContainer.getCards().add((Object)new Card("segments", UiCardsContainer.Style.STATIC, Messages.Segments, (Node)segmentsContainer));
        if (!forExchange) {
            GridContainer taxesContainer = new GridContainer();
            taxesContainer.getCells().add((Object)new GridCell("", this.taxesWidget));
            cardsContainer.getCards().add((Object)new Card("taxes", UiCardsContainer.Style.STATIC, Messages.Taxes, (Node)taxesContainer));
        }
        return cardsContainer;
    }

    protected Date getOperationDate() {
        return DateUtils.asDate((LocalDateTime)this.operationDateWidget.getValue());
    }

    protected EntityReference<Person> getAgent() {
        return this.agentWidget.getValue();
    }

    protected MCOCategory getMcoCategory() {
        return (MCOCategory)this.mcoCategoryWidget.getValue();
    }

    protected boolean isForced() {
        return this.forcedWidget.isSelected();
    }

    protected BigDecimal getUsedBaseFare() {
        return (BigDecimal)this.usedBaseFareWidget.getValue();
    }

    protected BigDecimal getUsedEquivFare() {
        return (BigDecimal)this.usedEquivFareWidget.getValue();
    }

    protected BigDecimal getPenalty() {
        return (BigDecimal)this.penaltyWidget.getValue();
    }

    protected List<String> getSegmentDescriptions() {
        ArrayList segments = new ArrayList();
        this.segmentsController.writeData(segments);
        return segments.stream().filter(obj -> obj.isInAction()).map(obj -> obj.getDescription()).collect(Collectors.toList());
    }

    protected List<Tax> getTaxes() {
        return this.getTaxes(this.taxesController);
    }

    protected List<Tax> getTaxes(TableWidgetController<TableWidget<ExchangeTaxDialogVM>, ExchangeTaxDialogVM> controller) {
        ArrayList taxesVMs = new ArrayList();
        controller.writeData(taxesVMs);
        return taxesVMs.stream().filter(taxVM -> taxVM.isInAction()).map(taxVM -> {
            Tax tax = new Tax();
            tax.setCode(taxVM.getCode());
            tax.setAmount(MoneyHelper.buildMoney((BigDecimal)taxVM.getBaseAmount(), (String)taxVM.getCurrency()));
            tax.setEquivalentAmount(taxVM.getEquivAmount());
            return tax;
        }).collect(Collectors.toList());
    }

    private TableWidget<ExchangeSegmentDialogVM> createSegmentsWidget() {
        TableWidget widget = new TableWidget(false);
        widget.setControlButtonsAvailability(ControlsPane.NONE);
        ArrayList<InfoWidgetColumn> columns = new ArrayList<InfoWidgetColumn>();
        InfoWidgetColumn column = new InfoWidgetColumn(ExchangeSegmentDialogVM::getDescription, ExchangeSegmentDialogVM::setDescription);
        column.setId("Description");
        column.setCaption("Description");
        column.setHidden(true);
        columns.add(column);
        column = new IntValueWidgetColumn(ExchangeSegmentDialogVM::getNumber, ExchangeSegmentDialogVM::setNumber);
        column.setId("recordNumber");
        column.setCaption(Messages.Number);
        column.setNotEditable(Boolean.valueOf(true));
        columns.add(column);
        column = new TextWidgetColumn(ExchangeSegmentDialogVM::getDeparturePoint, ExchangeSegmentDialogVM::setDeparturePoint);
        column.setPrefWidth(Double.valueOf(30.0));
        column.setId("departurePoint");
        column.setCaption(Messages.Point_of_departure);
        column.setNotEditable(Boolean.valueOf(true));
        columns.add(column);
        column = new TextWidgetColumn(ExchangeSegmentDialogVM::getArrivalPoint, ExchangeSegmentDialogVM::setArrivalPoint);
        column.setPrefWidth(Double.valueOf(30.0));
        column.setId("arrivalPoint");
        column.setCaption(Messages.Arrival_Point);
        column.setNotEditable(Boolean.valueOf(true));
        columns.add(column);
        column = new BooleanValueWidgetColumn(ExchangeSegmentDialogVM::isInAction, ExchangeSegmentDialogVM::setInAction);
        column.setPrefWidth(Double.valueOf(15.0));
        column.setId("inAction");
        column.setCaption(this.getCheckedColumnTitle());
        columns.add(column);
        widget.setColumns(columns);
        return widget;
    }

    protected TableWidget<ExchangeTaxDialogVM> createTaxesWidget(boolean withInExchange) {
        TableWidget widget = new TableWidget(false);
        widget.setControlButtonsAvailability(ControlsPane.NONE);
        ArrayList<TextWidgetColumn> columns = new ArrayList<TextWidgetColumn>();
        TextWidgetColumn column = new TextWidgetColumn(ExchangeTaxDialogVM::getSegNumbersString, ExchangeTaxDialogVM::setSegNumbersString);
        column.setId("segNumbers");
        column.setCaption(Messages.Segment);
        columns.add(column);
        column = new TextWidgetColumn(ExchangeTaxDialogVM::getCode, ExchangeTaxDialogVM::setCode);
        column.setId("code");
        column.setCaption(Messages.Code);
        columns.add(column);
        column = new PriceValueWidgetColumn(ExchangeTaxDialogVM::getBaseAmount, ExchangeTaxDialogVM::setBaseAmount);
        column.setPrefWidth(Double.valueOf(20.0));
        column.setId("baseAmount");
        column.setCaption(Messages.Amount);
        columns.add(column);
        column = new CurrencyValueWidgetColumn(ExchangeTaxDialogVM::getCurrency, ExchangeTaxDialogVM::setCurrency);
        column.setPrefWidth(Double.valueOf(10.0));
        column.setId("currency");
        column.setCaption(Messages.Currency);
        columns.add(column);
        column = new PriceValueWidgetColumn(ExchangeTaxDialogVM::getEquivAmount, ExchangeTaxDialogVM::setEquivAmount);
        column.setPrefWidth(Double.valueOf(20.0));
        column.setId("equivAmount");
        column.setCaption(Messages.Equ_amount);
        columns.add(column);
        if (withInExchange) {
            column = new BooleanValueWidgetColumn(ExchangeTaxDialogVM::isInAction, ExchangeTaxDialogVM::setInAction);
            column.setPrefWidth(Double.valueOf(15.0));
            column.setId("inAction");
            column.setCaption(this.getCheckedColumnTitle());
            columns.add(column);
        }
        widget.setColumns(columns);
        return widget;
    }

    private void updateTaxesSelection(Integer segNumber, boolean newValue) {
        Iterator taxesIter = ((TableWidget)this.taxesController.getView()).getRowsData().iterator();
        BooleanValueWidgetColumn column = (BooleanValueWidgetColumn)((TableWidget)this.taxesController.getView()).getColumn("inAction");
        for (int idx = 0; idx < ((TableWidget)this.taxesController.getView()).getRowsCount(); ++idx) {
            ExchangeTaxDialogVM tax = (ExchangeTaxDialogVM)taxesIter.next();
            if (!tax.getSegNumbers().contains(segNumber)) continue;
            BooleanValueWidget widget = (BooleanValueWidget)column.getHiddenWidget(idx);
            widget.valueProperty().set((Object)newValue);
            if (!newValue) {
                widget.setDisable(true);
                continue;
            }
            widget.setDisable(false);
        }
    }

    private void updateTaxesSelectionWithForced(boolean newValue) {
        BooleanValueWidgetColumn column = (BooleanValueWidgetColumn)((TableWidget)this.taxesController.getView()).getColumn("inAction");
        Iterator taxesIter = ((TableWidget)this.taxesController.getView()).getRowsData().iterator();
        for (int idx = 0; idx < ((TableWidget)this.taxesController.getView()).getRowsCount(); ++idx) {
            ExchangeTaxDialogVM tax = (ExchangeTaxDialogVM)taxesIter.next();
            BooleanValueWidget exchangeWidget = (BooleanValueWidget)column.getHiddenWidget(idx);
            PriceValueWidget equivAmountWidget = (PriceValueWidget)((TableWidget)this.taxesController.getView()).getColumn("equivAmount").getHiddenWidget(idx);
            PriceValueWidget baseAmountWidget = (PriceValueWidget)((TableWidget)this.taxesController.getView()).getColumn("baseAmount").getHiddenWidget(idx);
            if (newValue) {
                if (!this.isSpecialTax(tax)) {
                    exchangeWidget.valueProperty().set((Object)true);
                }
                equivAmountWidget.setValue((Number)tax.getEquivAmountOriginal());
                baseAmountWidget.setValue((Number)tax.getBaseAmountOriginal());
            }
            if (!this.isSpecialTax(tax)) continue;
            exchangeWidget.valueProperty().set((Object)newValue);
        }
    }

    private boolean isSpecialTax(ExchangeTaxDialogVM tax) {
        return "RU".equalsIgnoreCase(tax.getCode()) || "ZZ".equalsIgnoreCase(tax.getCode());
    }
}

