/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.tasks.dialog;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.CardsContainer;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.BooleanValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.BooleanValueWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.InfoWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.dialog.MultiEntityWidgetColumn;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.tasks.BaseItineraryReceiptTask;
import com.gridnine.xtrip.client.fx.standard.tasks.dialog.ItineraryReceiptDialog;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.fx.rpc.BaseItineraryReceiptProperties;
import com.gridnine.xtrip.common.fx.rpc.BookingFileService;
import com.gridnine.xtrip.common.fx.rpc.DictItem;
import com.gridnine.xtrip.common.meta.ui.UiCardsContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.InformationNote;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.system.TemplateDocument;
import com.gridnine.xtrip.common.model.system.TemplateDocumentIndex;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class BaseItineraryReceiptDialog<T extends BaseItineraryReceiptProperties>
implements ItineraryReceiptDialog {
    public Logger log = LoggerFactory.getLogger(this.getClass());
    private Control source;
    private TableWidget<ProductTableVM> productsWidget;
    private TableWidgetController<TableWidget<ProductTableVM>, ProductTableVM> productsController;
    private TableWidget<NotesTableVM> notesWidget;
    private TableWidgetController<TableWidget<NotesTableVM>, NotesTableVM> notesController;

    @Override
    public void initDialog(Control src, Map<BaseProduct, EntityReference<BookingFile>> products2Bookings, List<DictItem<InformationNote>> notes, String selectedProductUid) {
        this.source = src;
        this.productsWidget = this.createProductsWidget();
        this.productsController = new TableWidgetController<TableWidget<ProductTableVM>, ProductTableVM>(){

            public TableWidget<ProductTableVM> getView() {
                return BaseItineraryReceiptDialog.this.productsWidget;
            }
        };
        T properties = this.createProperties(products2Bookings);
        if (properties == null) {
            properties = this.createEmptyProperties();
            this.loadParams(properties);
        }
        Map products2Templates = properties.getProductsWithTemplates();
        List productsVM = products2Bookings.entrySet().stream().map(item -> {
            BaseProduct prod = (BaseProduct)item.getKey();
            ProductTableVM productVM = new ProductTableVM();
            productVM.setProduct(BookingHelper.generateShortProductName((BaseProduct)prod));
            productVM.setProductUID(prod.getUid());
            productVM.setBfRef((EntityReference<BookingFile>)((EntityReference)item.getValue()));
            Collection templateRefs = (Collection)products2Templates.get(prod.getUid());
            if (templateRefs != null) {
                productVM.getTemplateRefs().addAll(templateRefs);
            }
            if (products2Bookings.entrySet().size() == 1) {
                productVM.setChecked(true);
            } else {
                productVM.setChecked(prod.getUid().equals(selectedProductUid));
            }
            return productVM;
        }).collect(Collectors.toList());
        this.productsController.readData(productsVM);
        this.notesWidget = this.createNotesWidget();
        this.notesController = new TableWidgetController<TableWidget<NotesTableVM>, NotesTableVM>(){

            public TableWidget<NotesTableVM> getView() {
                return BaseItineraryReceiptDialog.this.notesWidget;
            }
        };
        List notesCodes = properties.getNotes().stream().map(DictionaryReference::getCode).collect(Collectors.toList());
        this.createAdditionalWidgets();
        this.updateFromProperties(properties);
        List notesVM = notes.stream().map(dict -> {
            NotesTableVM noteVM = new NotesTableVM();
            noteVM.setInformationNoteReference((DictionaryReference<InformationNote>)dict.getReference());
            noteVM.setCode((String)dict.getFields().get(BaseDictionary.Property.code.name()));
            if (dict.getReference() != null) {
                noteVM.setText(dict.getReference().toString());
            }
            noteVM.setChecked(notesCodes.contains(noteVM.getCode()));
            noteVM.setPersistent((Boolean)dict.getFields().get("persistent"));
            if (((Boolean)dict.getFields().get("persistent")).booleanValue()) {
                noteVM.setChecked(true);
            }
            return noteVM;
        }).collect(Collectors.toList());
        this.notesController.readData(notesVM);
        BooleanValueWidgetColumn column = (BooleanValueWidgetColumn)((TableWidget)this.notesController.getView()).getColumn("checked");
        for (int i = 0; i < notesVM.size(); ++i) {
            ((BooleanValueWidget)column.getWidget(i)).getViewState().setNotEditable(((NotesTableVM)notesVM.get(i)).isPersistent());
        }
    }

    @Override
    public void showDialog() {
        CardsContainer cardsContainer = this.createParametersCard();
        Dialog dialog = new Dialog();
        dialog.setTitle(Messages.Route_receipt_options).setAutoClose(false).setExpandToParent(true).setBody((Node)cardsContainer).addButton(DialogButtonStyle.DECLINE, () -> ((Dialog)dialog).close()).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Form, () -> this.runnable(dialog, false)).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Print, () -> this.runnable(dialog, true)).setOnCloseRequest(() -> ((Dialog)dialog).close()).show((Node)this.source);
    }

    private void runnable(Dialog dialog, boolean isPrint) {
        Map<String, EntityReference<BookingFile>> products = this.getProducts2Bookings();
        if (products.size() == 0) {
            Dialog.info((String)Messages.Need_at_least_one_ticket);
            return;
        }
        if (this.getProducts2Templates().values().stream().anyMatch(Objects::isNull)) {
            Dialog.info((String)Messages.Must_select_a_template);
            return;
        }
        T properties = this.createAndFillProperties();
        properties.setPrint(isPrint);
        this.saveParams(properties);
        Notifications.get().enqueueAsyncTask(this.createTask(properties));
        dialog.close();
    }

    private TableWidget<ProductTableVM> createProductsWidget() {
        TableWidget widget = new TableWidget(false);
        widget.setControlButtonsAvailability(ControlsPane.NONE);
        ArrayList<InfoWidgetColumn> columns = new ArrayList<InfoWidgetColumn>();
        InfoWidgetColumn column = new InfoWidgetColumn(ProductTableVM::getProduct, ProductTableVM::setProduct);
        column.setId("product");
        column.setCaption(Messages.Name);
        columns.add(column);
        column = new MultiEntityWidgetColumn(TemplateDocument.class, ProductTableVM::getTemplateRefs);
        column.setListParametersSupplier(this::getTemplateParameters);
        column.setId("templates");
        column.setCaption(Messages.Templates);
        column.setPrefWidth(Double.valueOf(20.0));
        columns.add(column);
        column = new BooleanValueWidgetColumn(ProductTableVM::isChecked, ProductTableVM::setChecked);
        column.setId("checked");
        column.setCaption(Messages.Add_to_itinerary_receipt);
        column.setPrefWidth(Double.valueOf(20.0));
        columns.add(column);
        widget.setColumns(columns);
        return widget;
    }

    private TableWidget<NotesTableVM> createNotesWidget() {
        TableWidget widget = new TableWidget(false);
        widget.setControlButtonsAvailability(ControlsPane.NONE);
        ArrayList<InfoWidgetColumn> columns = new ArrayList<InfoWidgetColumn>();
        InfoWidgetColumn column = new InfoWidgetColumn(NotesTableVM::getText, NotesTableVM::setText);
        column.setId("product");
        column.setCaption(Messages.Message);
        columns.add(column);
        column = new BooleanValueWidgetColumn(NotesTableVM::isChecked, NotesTableVM::setChecked);
        column.setId("checked");
        column.setCaption(Messages.Add_to_itinerary_receipt);
        column.setPrefWidth(Double.valueOf(30.0));
        columns.add(column);
        widget.setColumns(columns);
        return widget;
    }

    private CardsContainer createParametersCard() {
        GridContainer productsContainer = new GridContainer();
        productsContainer.getCells().add((Object)new GridCell("", this.productsWidget));
        GridContainer notesContainer = new GridContainer();
        notesContainer.getCells().add((Object)new GridCell("", this.notesWidget));
        CardsContainer cardsContainer = new CardsContainer();
        cardsContainer.getCards().add((Object)new Card("parameters", UiCardsContainer.Style.STATIC, Messages.Parameters, (Node)this.createGeneralParamsContainer()));
        cardsContainer.getCards().add((Object)new Card("products", UiCardsContainer.Style.STATIC, Messages.Tickets, (Node)productsContainer));
        cardsContainer.getCards().add((Object)new Card("notes", UiCardsContainer.Style.STATIC, Messages.Info_messages, (Node)notesContainer));
        return cardsContainer;
    }

    private GridContainer createGeneralParamsContainer() {
        GridContainer gridContainer = new GridContainer(3);
        gridContainer.getCells().addAll(this.createAdditionalPropertiesCells());
        return gridContainer;
    }

    protected Map<String, Collection<EntityReference<TemplateDocument>>> getProducts2Templates() {
        ArrayList products = new ArrayList();
        this.productsController.writeData(products);
        return products.stream().filter(ProductTableVM::isChecked).collect(HashMap::new, (m, e) -> m.put(e.getProductUID(), e.getTemplateRefs()), HashMap::putAll);
    }

    protected Map<String, Collection<EntityReference<TemplateDocument>>> getProducts2Templates(Map<BaseProduct, EntityReference<BookingFile>> products2Bookings) {
        HashMap<String, Collection<EntityReference<TemplateDocument>>> productUids2TemplateRefs = new HashMap<String, Collection<EntityReference<TemplateDocument>>>();
        for (Map.Entry<BaseProduct, EntityReference<BookingFile>> entry : products2Bookings.entrySet()) {
            try {
                Collection templateDocuments = ((BookingFileService)RpcServiceManager.get().getService(BookingFileService.class)).getTemplateDocuments(ServiceInvocationContext.get(), entry.getKey(), entry.getValue());
                productUids2TemplateRefs.put(entry.getKey().getUid(), templateDocuments);
            }
            catch (Exception e) {
                this.log.warn("unable to get TemplateDocument", (Throwable)e);
                productUids2TemplateRefs.put(entry.getKey().getUid(), null);
            }
        }
        return productUids2TemplateRefs;
    }

    protected Map<String, EntityReference<BookingFile>> getProducts2Bookings() {
        ArrayList products = new ArrayList();
        this.productsController.writeData(products);
        return products.stream().filter(ProductTableVM::isChecked).collect(Collectors.toMap(ProductTableVM::getProductUID, ProductTableVM::getBfRef));
    }

    protected List<DictionaryReference<InformationNote>> getInformationNotes() {
        ArrayList notes = new ArrayList();
        this.notesController.writeData(notes);
        return notes.stream().filter(NotesTableVM::isChecked).map(NotesTableVM::getInformationNoteReference).collect(Collectors.toList());
    }

    private void loadParams(T params) {
        File file = new File(Environment.getDataFolder(), "settings/" + this.getPropertiesFileName());
        if (file.isFile()) {
            try {
                params.fromXML(DocumentBuilderHelper.parse((File)file).getDocumentElement());
            }
            catch (Exception e) {
                this.log.warn("failed loading itinerary receipt parameters from " + file, (Throwable)e);
            }
        }
    }

    private void saveParams(T params) {
        File file = new File(Environment.getDataFolder(), "settings/" + this.getPropertiesFileName());
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));){
            Document doc = DocumentBuilderHelper.newDocument();
            Element root = doc.createElement("object");
            root.setAttribute("class", params.getClass().getName());
            params.toXML(root);
            doc.appendChild(root);
            XUtil.newTransformer().transform(new DOMSource(doc), new StreamResult(out));
        }
        catch (Exception e) {
            this.log.warn("failed saving itinerary receipt parameters to " + file, (Throwable)e);
        }
    }

    public abstract T createProperties(Map<BaseProduct, EntityReference<BookingFile>> var1);

    public abstract T createEmptyProperties();

    public abstract T createAndFillProperties();

    public abstract void createAdditionalWidgets();

    public abstract void updateFromProperties(T var1);

    public abstract List<GridCell<?>> createAdditionalPropertiesCells();

    public abstract IndexListParameters<TemplateDocument, TemplateDocumentIndex> getTemplateParameters();

    public abstract BaseItineraryReceiptTask<T> createTask(T var1);

    public abstract String getPropertiesFileName();

    public static class NotesTableVM {
        private String code;
        private String text;
        private DictionaryReference<InformationNote> noteReference;
        private boolean checked;
        private boolean persistent;

        public String getCode() {
            return this.code;
        }

        public void setCode(String value) {
            this.code = value;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String value) {
            this.text = value;
        }

        public DictionaryReference<InformationNote> getInformationNoteReference() {
            return this.noteReference;
        }

        public void setInformationNoteReference(DictionaryReference<InformationNote> value) {
            this.noteReference = value;
        }

        public boolean isChecked() {
            return this.checked;
        }

        public void setChecked(boolean value) {
            this.checked = value;
        }

        public boolean isPersistent() {
            return this.persistent;
        }

        public void setPersistent(boolean persistent) {
            this.persistent = persistent;
        }
    }

    public static class ProductTableVM {
        private String product;
        private String productUID;
        private boolean checked;
        private EntityReference<BookingFile> bfRef;
        private final Collection<EntityReference<TemplateDocument>> templateRefs = new HashSet<EntityReference<TemplateDocument>>();

        public String getProduct() {
            return this.product;
        }

        public void setProduct(String value) {
            this.product = value;
        }

        public String getProductUID() {
            return this.productUID;
        }

        public void setProductUID(String value) {
            this.productUID = value;
        }

        public boolean isChecked() {
            return this.checked;
        }

        public void setChecked(boolean value) {
            this.checked = value;
        }

        public EntityReference<BookingFile> getBfRef() {
            return this.bfRef;
        }

        public void setBfRef(EntityReference<BookingFile> bfRef) {
            this.bfRef = bfRef;
        }

        public Collection<EntityReference<TemplateDocument>> getTemplateRefs() {
            return this.templateRefs;
        }
    }
}

