/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.tasks.dialog;

import com.gridnine.xtrip.client.fx.core.entity.EntityIndexHandler;
import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.CardsContainer;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.CheckBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.multi.MultiEntityWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.BooleanValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableRowEvent;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.CheckBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.InfoWidgetColumn;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.Converters;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.BookingFileService;
import com.gridnine.xtrip.common.meta.ui.UiCardsContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchCriterion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;

public class CorrectionParametersPane
extends CardsContainer {
    private GridCell<EntityBoxWidget<Organization>> currentClientCell;
    private GridCell<MultiEntityWidget<Organization>> currentPayersCell;
    private GridCell<EntityBoxWidget<Organization>> newClientCell;
    private GridCell<EntityBoxWidget<Organization>> newPayerCell;
    private TableWidgetController<TableWidget<ProductDataWrapper>, ProductDataWrapper> controller;
    private final List<ProductDataWrapper> wrappers = new ArrayList<ProductDataWrapper>();
    private final Map<BaseProduct, List<BaseProduct>> relatedProductsMap = new HashMap<BaseProduct, List<BaseProduct>>();
    private final BooleanProperty atLeastOneSelected = new SimpleBooleanProperty();
    private final ReadOnlyBooleanWrapper valid = new ReadOnlyBooleanWrapper(false);

    public CorrectionParametersPane() {
        this.createGUI();
        this.createBindings();
        this.createListeners();
    }

    private void createGUI() {
        Card<Node> generalPane = this.createGeneralPane();
        Card<Node> productsPane = this.createProductsPane();
        this.getCards().addAll((Object[])new Card[]{generalPane, productsPane});
    }

    private Card<Node> createGeneralPane() {
        this.currentClientCell = new GridCell(Messages.CurrentClient, (Node)new EntityBoxWidget(Organization.class, true));
        this.currentPayersCell = new GridCell(Messages.CurrentPayers, (Node)new MultiEntityWidget(Organization.class, true));
        this.newClientCell = new GridCell(Messages.NewClient, (Node)new EntityBoxWidget(Organization.class, false));
        this.newPayerCell = new GridCell(Messages.NewPayer, (Node)new EntityBoxWidget(Organization.class, false));
        BooleanValueWidget changeRetailPayer = new BooleanValueWidget(true, false);
        changeRetailPayer.setConverter(Converters.boolConverter((String)Messages.Change, (String)Messages.Dont_Change));
        changeRetailPayer.setValue(true);
        GridContainer pane = new GridContainer(3);
        pane.getCells().addAll((Object[])new GridCell[]{this.currentClientCell, this.currentPayersCell});
        pane.getCells().add((Object)GridCell.NEW_ROW_MARKER);
        pane.getCells().addAll((Object[])new GridCell[]{this.newClientCell, this.newPayerCell});
        return new Card("parameters", UiCardsContainer.Style.STATIC, Messages.General_parameters, (Node)pane);
    }

    private Card<Node> createProductsPane() {
        this.controller = new TableWidgetController<TableWidget<ProductDataWrapper>, ProductDataWrapper>(){
            private final TableWidget<ProductDataWrapper> view = new TableWidget(false);
            {
                this.view.setPlaceholder(Messages.No_data);
                this.view.setControlButtonsAvailability(ControlsPane.NONE);
            }

            public TableWidget<ProductDataWrapper> getView() {
                return this.view;
            }
        };
        ArrayList<Object> columns = new ArrayList<Object>();
        InfoWidgetColumn nameColumn = new InfoWidgetColumn(item -> item != null ? BookingHelper.generateShortProductName((BaseProduct)item.product) : null, (a, b) -> {});
        nameColumn.setCaption(Messages.Name);
        nameColumn.setId("name");
        columns.add(nameColumn);
        CheckBoxWidgetColumn selectedColumn = new CheckBoxWidgetColumn(item -> item.selected, (item, selected) -> {
            item.selected = selected;
        });
        selectedColumn.setCaption(Messages.correctionInclude);
        selectedColumn.setId("selected");
        selectedColumn.setPrefWidth(Double.valueOf(30.0));
        columns.add(selectedColumn);
        ((TableWidget)this.controller.getView()).setColumns(columns);
        Card productsPane = new Card("products", UiCardsContainer.Style.STATIC, Messages.Products, this.controller.getView());
        productsPane.setAdaptiveHeight(true);
        return productsPane;
    }

    private void createBindings() {
        this.valid.bind((ObservableValue)this.atLeastOneSelected);
    }

    private void createListeners() {
        ((EntityBoxWidget)this.newClientCell.getPayload()).valueProperty().addListener((s, o, n) -> Notifications.get().submitTask(() -> {
            Collection availablePayersUids = ((BookingFileService)RpcServiceManager.get().getService(BookingFileService.class)).getAvailablePayersUids(ServiceInvocationContext.get(), n, true);
            FxUtil.submitToFxThread(() -> {
                ((EntityBoxWidget)this.newPayerCell.getPayload()).setListParametersSupplier(() -> ControllerInterceptorsHelper.getPayers(new ArrayList<String>(availablePayersUids)));
                ((EntityBoxWidget)this.newPayerCell.getPayload()).setValue(n);
            });
        }, Messages.Loading_data));
        ((TableWidget)this.controller.getView()).setOnRowsAction(event -> {
            this.checkSelectedCount();
            if (event.getEventType().equals(TableRowEvent.ROW_ADD)) {
                int rowIndex = event.getRowIndex() != null ? event.getRowIndex() : 0;
                ProductDataWrapper wrapper = (ProductDataWrapper)((TableWidget)this.controller.getView()).getData(rowIndex);
                CheckBoxWidget checkBoxWidget = (CheckBoxWidget)((TableWidget)this.controller.getView()).getColumn("selected").getWidget(rowIndex);
                if (wrapper != null && checkBoxWidget != null) {
                    checkBoxWidget.selectedProperty().addListener((observable, oldValue, newValue) -> {
                        wrapper.selected = newValue;
                        List<BaseProduct> relatedProducts = this.relatedProductsMap.get(wrapper.product);
                        if (relatedProducts != null) {
                            this.wrappers.stream().filter(item -> relatedProducts.contains(item.product)).forEach(item -> {
                                item.selected = true;
                                this.checkSelectedCount();
                            });
                        }
                        this.wrappers.stream().filter(item -> this.relatedProductsMap.containsKey(item.product)).filter(item -> this.relatedProductsMap.get(item.product).contains(wrapper.product)).forEach(item -> {
                            item.selected = false;
                            this.checkSelectedCount();
                        });
                        this.controller.readData(this.wrappers);
                    });
                }
            }
        });
    }

    private void checkSelectedCount() {
        this.atLeastOneSelected.set(IntStream.range(0, ((TableWidget)this.controller.getView()).getRowsCount()).mapToObj(i -> (CheckBoxWidget)((TableWidget)this.controller.getView()).getColumn("selected").getWidget(i)).anyMatch(CheckBox::isSelected));
    }

    private static IndexListParameters<Organization, ?> getClients() {
        IndexListParameters result = EntityIndexHandler.forIndexClass(OrganizationIndex.class).createListParameters();
        result.getSearchCriterions().add(SearchCriterion.contains((String)OrganizationIndex.Property.types.name(), (Object)OrganizationType.CORPORATE_CLIENT));
        return result;
    }

    public void readData(CorrectionCreateParametersPaneVM model) {
        ((EntityBoxWidget)this.currentClientCell.getPayload()).setValue(model.getCurrentClient());
        ((MultiEntityWidget)this.currentPayersCell.getPayload()).getValues().addAll(model.getCurrentPayers());
        ((EntityBoxWidget)this.newClientCell.getPayload()).setListParametersSupplier(CorrectionParametersPane::getClients);
        ((EntityBoxWidget)this.newClientCell.getPayload()).setValue(model.getNewClient() != null ? model.getNewClient() : model.getCurrentClient());
        ((EntityBoxWidget)this.newPayerCell.getPayload()).setValue(model.getCurrentPayers().isEmpty() ? null : (model.getNewPayer() != null ? model.getNewPayer() : model.getCurrentClient()));
        this.relatedProductsMap.putAll(model.getRelatedProductsMap());
        this.wrappers.clear();
        for (Map.Entry<BaseProduct, Boolean> product : model.getProducts().entrySet()) {
            ProductDataWrapper wrapper = new ProductDataWrapper();
            wrapper.product = product.getKey();
            wrapper.selected = product.getValue();
            this.wrappers.add(wrapper);
        }
        this.controller.readData(this.wrappers);
    }

    public void writeData(CorrectionCreateParametersPaneVM model) {
        model.setCurrentClient((EntityReference<Organization>)((EntityBoxWidget)this.currentClientCell.getPayload()).getValue());
        model.getCurrentPayers().addAll((Collection<EntityReference<Organization>>)((MultiEntityWidget)this.currentPayersCell.getPayload()).getValues());
        model.setNewClient((EntityReference<Organization>)((EntityBoxWidget)this.newClientCell.getPayload()).getValue());
        model.setNewPayer((EntityReference<Organization>)((EntityBoxWidget)this.newPayerCell.getPayload()).getValue());
        model.getRelatedProductsMap().putAll(this.relatedProductsMap);
        model.getProducts().clear();
        ArrayList wrappers = new ArrayList();
        this.controller.writeData(wrappers);
        for (ProductDataWrapper wrapper : wrappers) {
            model.getProducts().put(wrapper.product, wrapper.selected);
        }
    }

    public final ReadOnlyBooleanProperty validProperty() {
        return this.valid.getReadOnlyProperty();
    }

    private static class ProductDataWrapper {
        BaseProduct product;
        Boolean selected;

        private ProductDataWrapper() {
        }
    }

    public static class CorrectionCreateParametersPaneVM {
        private EntityReference<Organization> currentClient;
        private final List<EntityReference<Organization>> currentPayers = new ArrayList<EntityReference<Organization>>();
        private EntityReference<Organization> newClient;
        private EntityReference<Organization> newPayer;
        private final Map<BaseProduct, Boolean> products = new LinkedHashMap<BaseProduct, Boolean>();
        private final Map<BaseProduct, List<BaseProduct>> relatedProductsMap = new HashMap<BaseProduct, List<BaseProduct>>();

        public EntityReference<Organization> getCurrentClient() {
            return this.currentClient;
        }

        public void setCurrentClient(EntityReference<Organization> currentClient) {
            this.currentClient = currentClient;
        }

        public List<EntityReference<Organization>> getCurrentPayers() {
            return this.currentPayers;
        }

        public EntityReference<Organization> getNewClient() {
            return this.newClient;
        }

        public void setNewClient(EntityReference<Organization> newClient) {
            this.newClient = newClient;
        }

        public EntityReference<Organization> getNewPayer() {
            return this.newPayer;
        }

        public void setNewPayer(EntityReference<Organization> newPayer) {
            this.newPayer = newPayer;
        }

        public Map<BaseProduct, Boolean> getProducts() {
            return this.products;
        }

        public Map<BaseProduct, List<BaseProduct>> getRelatedProductsMap() {
            return this.relatedProductsMap;
        }
    }
}

