/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.tasks.dialog;

import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ExchangeTaxDialogVM {
    private List<Integer> segNumbers = new ArrayList<Integer>();
    private String code;
    private BigDecimal baseAmount;
    private BigDecimal baseAmountOriginal;
    private String currency;
    private BigDecimal equivAmount;
    private final BigDecimal equivAmountOriginal;
    private boolean inAction;

    ExchangeTaxDialogVM(Tax t, boolean zeroPrices) {
        this.code = t.getCode();
        if (t.getSegmentTariff() != null) {
            this.segNumbers = t.getSegmentTariff().getSegments().stream().filter(Objects::nonNull).map(seg -> seg.getRecordNumber()).collect(Collectors.toList());
        }
        if (t.getAmount() != null) {
            if (zeroPrices) {
                this.baseAmount = BigDecimal.ZERO;
                this.baseAmountOriginal = BigDecimal.ZERO;
            } else {
                this.baseAmount = t.getAmount().getValue();
                this.baseAmountOriginal = t.getAmount().getValue();
            }
            this.currency = t.getAmount().getCurrency();
        }
        if (zeroPrices) {
            this.equivAmount = BigDecimal.ZERO;
            this.equivAmountOriginal = BigDecimal.ZERO;
        } else {
            this.equivAmount = t.getEquivalentAmount();
            this.equivAmountOriginal = t.getEquivalentAmount();
        }
        this.inAction = true;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public BigDecimal getBaseAmount() {
        return this.baseAmount;
    }

    public void setBaseAmount(BigDecimal baseAmount) {
        this.baseAmount = baseAmount;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public BigDecimal getEquivAmount() {
        return this.equivAmount;
    }

    public void setEquivAmount(BigDecimal equivAmount) {
        this.equivAmount = equivAmount;
    }

    public boolean isInAction() {
        return this.inAction;
    }

    public void setInAction(boolean inExchange) {
        this.inAction = inExchange;
    }

    public List<Integer> getSegNumbers() {
        return this.segNumbers;
    }

    public String getSegNumbersString() {
        if (this.segNumbers.isEmpty()) {
            return "";
        }
        String res = String.valueOf(Collections.min(this.segNumbers));
        if (this.segNumbers.size() > 1 && !TextUtil.isSame((String)String.valueOf(Collections.max(this.segNumbers)), (String)res)) {
            res = res + "-" + String.valueOf(Collections.max(this.segNumbers));
        }
        return res;
    }

    public void setSegNumbersString(String value) {
    }

    public BigDecimal getBaseAmountOriginal() {
        return this.baseAmountOriginal;
    }

    public BigDecimal getEquivAmountOriginal() {
        return this.equivAmountOriginal;
    }
}

