/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.tasks.dialog;

import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.CardsContainer;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.CheckBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.DateValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.PriceValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.TripleValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableRowEvent;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.CheckBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.InfoWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.PriceValueWidgetColumn;
import com.gridnine.xtrip.client.fx.core.util.Converters;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.meta.ui.UiCardsContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;

public class FinanceConsolidatedDocumentsParametersPane
extends CardsContainer {
    private GridCell<DateValueWidget> dateCell;
    private GridCell<TripleValueWidget> useDelegateCell;
    private GridCell<TripleValueWidget> useFacsimileCell;
    private GridCell<PriceValueWidget> totalAmountCell;
    private TableWidgetController<TableWidget<ShipmentDataWrapper>, ShipmentDataWrapper> controller;
    private final IntegerProperty selectedProductsCount = new SimpleIntegerProperty();
    private final ReadOnlyBooleanWrapper valid = new ReadOnlyBooleanWrapper(false);

    public FinanceConsolidatedDocumentsParametersPane() {
        this.createGUI();
        this.createBindings();
        this.createListeners();
    }

    private void createGUI() {
        Card<Node> generalPane = this.createGeneralPane();
        Card<Node> shipmentsPane = this.createShipmentsPane();
        this.getCards().addAll((Object[])new Card[]{generalPane, shipmentsPane});
    }

    private Card<Node> createGeneralPane() {
        this.dateCell = new GridCell(Messages.Date, (Node)new DateValueWidget(false));
        this.useDelegateCell = new GridCell(Messages.useDelegate, (Node)new TripleValueWidget(false, false));
        ((TripleValueWidget)this.useDelegateCell.getPayload()).setConverter(Converters.boolConverter((String)Messages.Yes, (String)Messages.No, (String)Messages.Auto));
        this.useFacsimileCell = new GridCell(Messages.useFacsimile, (Node)new TripleValueWidget(false, false));
        ((TripleValueWidget)this.useFacsimileCell.getPayload()).setConverter(Converters.boolConverter((String)Messages.Yes, (String)Messages.No, (String)Messages.Auto));
        this.totalAmountCell = new GridCell(Messages.Amount, (Node)new PriceValueWidget(false));
        ((PriceValueWidget)this.totalAmountCell.getPayload()).getViewState().setNotEditable(true);
        GridContainer pane = new GridContainer(4);
        pane.getCells().addAll((Object[])new GridCell[]{this.dateCell, this.useDelegateCell, this.useFacsimileCell, this.totalAmountCell});
        Card generalPane = new Card("parameters", UiCardsContainer.Style.STATIC, Messages.General_parameters, (Node)pane);
        return generalPane;
    }

    private Card<Node> createShipmentsPane() {
        this.controller = new TableWidgetController<TableWidget<ShipmentDataWrapper>, ShipmentDataWrapper>(){
            private final TableWidget<ShipmentDataWrapper> view = new TableWidget(false);
            {
                this.view.setPlaceholder(Messages.No_data);
                this.view.setControlButtonsAvailability(ControlsPane.NONE);
            }

            public TableWidget<ShipmentDataWrapper> getView() {
                return this.view;
            }
        };
        ArrayList<Object> columns = new ArrayList<Object>();
        InfoWidgetColumn numberColumn = new InfoWidgetColumn(item -> item.shipment != null ? TextUtil.buildFullNumber((CompositeNumber)item.shipment) : null, (a, b) -> {});
        numberColumn.setCaption(Messages.Number);
        numberColumn.setId("number");
        columns.add(numberColumn);
        PriceValueWidgetColumn amountColumn = new PriceValueWidgetColumn(item -> item.shipmentTotalAmount, (a, b) -> {});
        amountColumn.setCaption(Messages.Amount);
        amountColumn.setId("amount");
        amountColumn.setNotEditable(Boolean.TRUE);
        columns.add(amountColumn);
        CheckBoxWidgetColumn selectedColumn = new CheckBoxWidgetColumn(item -> (Boolean)item.shipmentReference.getSecond(), (item, selected) -> item.shipmentReference.setSecond(selected));
        selectedColumn.setCaption(Messages.includeToDocument);
        selectedColumn.setId("selected");
        columns.add(selectedColumn);
        ((TableWidget)this.controller.getView()).setColumns(columns);
        Card shipmentsPane = new Card("shipments", UiCardsContainer.Style.STATIC, Messages.Shipments, this.controller.getView());
        shipmentsPane.setAdaptiveHeight(true);
        return shipmentsPane;
    }

    private void createBindings() {
        this.valid.bind((ObservableValue)Bindings.createBooleanBinding(() -> ((DateValueWidget)this.dateCell.getPayload()).getValue() != null && this.selectedProductsCount.get() > 0, (Observable[])new Observable[]{((DateValueWidget)this.dateCell.getPayload()).valueProperty(), this.selectedProductsCount}));
    }

    private void createListeners() {
        ((TableWidget)this.controller.getView()).setOnRowsAction(event -> {
            if (event.getEventType().equals(TableRowEvent.ROW_ADD)) {
                int rowIndex = event.getRowIndex() != null ? event.getRowIndex() : 0;
                ShipmentDataWrapper wrapper = (ShipmentDataWrapper)((TableWidget)this.controller.getView()).getData(rowIndex);
                CheckBoxWidget checkBoxWidget = (CheckBoxWidget)((TableWidget)this.controller.getView()).getColumn("selected").getWidget(rowIndex);
                if (wrapper != null && checkBoxWidget != null) {
                    if (checkBoxWidget.isSelected()) {
                        this.selectedProductsCount.set(this.selectedProductsCount.get() + 1);
                    }
                    checkBoxWidget.selectedProperty().addListener((observable, oldValue, newValue) -> {
                        this.selectedProductsCount.set(this.selectedProductsCount.get() + (newValue != false ? 1 : -1));
                        wrapper.shipmentReference.setSecond(newValue);
                        this.update();
                    });
                }
            }
        });
    }

    private void update() {
        ((PriceValueWidget)this.totalAmountCell.getPayload()).setValue((Number)this.controller.getData().stream().filter(item -> (Boolean)item.shipmentReference.getSecond()).map(item -> item.shipmentTotalAmount).reduce(null, (xva$0, xva$1) -> MiscUtil.sum((BigDecimal[])new BigDecimal[]{xva$0, xva$1})));
    }

    public void readData(FinanceConsolidatedDocumentsParameters model) {
        ((DateValueWidget)this.dateCell.getPayload()).setValue(DateUtils.asLocalDate((Date)model.getDate()));
        ((TripleValueWidget)this.useDelegateCell.getPayload()).setValue(model.getUseDelegate());
        ((TripleValueWidget)this.useFacsimileCell.getPayload()).setValue(model.getUseFacsimile());
        ArrayList<ShipmentDataWrapper> wrappers = new ArrayList<ShipmentDataWrapper>();
        FinanceDocumentsHelper.FinanceConsolidatedDocumentsShipmentsData shipmentsData = model.getShipmentsData();
        ((PriceValueWidget)this.totalAmountCell.getPayload()).setValue((Number)shipmentsData.getTotalAmount());
        for (Map.Entry entry : shipmentsData.getShipmentAmountDatas().entrySet()) {
            ShipmentDataWrapper wrapper = new ShipmentDataWrapper();
            wrapper.shipmentReference = (MiscUtil.Pair)entry.getKey();
            wrapper.shipment = (Shipment)((MiscUtil.Pair)entry.getValue()).getFirst();
            wrapper.shipmentTotalAmount = (BigDecimal)((MiscUtil.Pair)entry.getValue()).getSecond();
            wrappers.add(wrapper);
        }
        this.controller.readData(wrappers);
    }

    public void writeData(FinanceConsolidatedDocumentsParameters model) {
        model.setDate(DateUtils.asDate((LocalDate)((DateValueWidget)this.dateCell.getPayload()).getValue()));
        model.setUseDelegate(((TripleValueWidget)this.useDelegateCell.getPayload()).getValue());
        model.setUseFacsimile(((TripleValueWidget)this.useFacsimileCell.getPayload()).getValue());
        model.getShipments().clear();
        ArrayList wrappers = new ArrayList();
        this.controller.writeData(wrappers);
        for (ShipmentDataWrapper wrapper : wrappers) {
            model.getShipments().add(wrapper.shipmentReference);
        }
    }

    public final ReadOnlyBooleanProperty validProperty() {
        return this.valid.getReadOnlyProperty();
    }

    private static class ShipmentDataWrapper {
        MiscUtil.Pair<EntityReference<Shipment>, Boolean> shipmentReference;
        Shipment shipment;
        BigDecimal shipmentTotalAmount;

        private ShipmentDataWrapper() {
        }
    }

    public static class FinanceConsolidatedDocumentsParameters {
        private Date date;
        private Boolean useDelegate;
        private Boolean useFacsimile;
        private final List<MiscUtil.Pair<EntityReference<Shipment>, Boolean>> shipments = new ArrayList<MiscUtil.Pair<EntityReference<Shipment>, Boolean>>();
        private FinanceDocumentsHelper.FinanceConsolidatedDocumentsShipmentsData shipmentsData;

        public Date getDate() {
            return this.date;
        }

        public void setDate(Date date) {
            this.date = date;
        }

        public Boolean getUseDelegate() {
            return this.useDelegate;
        }

        public void setUseDelegate(Boolean useDelegate) {
            this.useDelegate = useDelegate;
        }

        public Boolean getUseFacsimile() {
            return this.useFacsimile;
        }

        public void setUseFacsimile(Boolean useFacsimile) {
            this.useFacsimile = useFacsimile;
        }

        public List<MiscUtil.Pair<EntityReference<Shipment>, Boolean>> getShipments() {
            return this.shipments;
        }

        public FinanceDocumentsHelper.FinanceConsolidatedDocumentsShipmentsData getShipmentsData() {
            return this.shipmentsData;
        }

        public void setShipmentsData(FinanceDocumentsHelper.FinanceConsolidatedDocumentsShipmentsData shipmentsData) {
            this.shipmentsData = shipmentsData;
        }
    }
}

